/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.dao.hibernate;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.mc.McCandidateAnswersDTO;
import org.lamsfoundation.lams.tool.mc.dao.IMcOptionsContentDAO;
import org.lamsfoundation.lams.tool.mc.pojos.McOptsContent;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class McOptionsContentDAO
extends HibernateDaoSupport
implements IMcOptionsContentDAO {
    static Logger logger = Logger.getLogger((String)McOptionsContentDAO.class.getName());
    private static final String FIND_MC_OPTIONS_CONTENT = "from mcOptsContent in class McOptsContent where mcOptsContent.mcQueContentId=:mcQueContentUid order by mcOptsContent.displayOrder";
    private static final String FIND_MC_OPTIONS_CONTENT_BY_UID = "from mcOptsContent in class McOptsContent where mcOptsContent.uid=:uid";
    private static final String LOAD_OPTION_CONTENT_BY_OPTION_TEXT = "from mcOptsContent in class McOptsContent where mcOptsContent.mcQueOptionText=:option and mcOptsContent.mcQueContentId=:mcQueContentUid";
    private static final String LOAD_PERSISTED_SELECTED_OPTIONS = "from mcOptsContent in class McOptsContent where mcOptsContent.mcQueContentId=:mcQueContentUid and  mcOptsContent.correctOption = 1";
    private static final String LOAD_CORRECT_OPTION = "from mcOptsContent in class McOptsContent where mcOptsContent.mcQueContentId=:mcQueContentUid and  mcOptsContent.correctOption = 1";
    private static final String LOAD_MAX_UID = "from mcOptsContent in class McOptsContent";

    @Override
    public McOptsContent getMcOptionsContentByUID(Long uid) {
        return (McOptsContent)this.getHibernateTemplate().get(McOptsContent.class, (Serializable)uid);
    }

    @Override
    public List findMcOptionsContentByQueId(Long mcQueContentId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        if (mcQueContentId != null) {
            List list = this.getSession().createQuery(FIND_MC_OPTIONS_CONTENT).setLong("mcQueContentUid", mcQueContentId.longValue()).list();
            return list;
        }
        return null;
    }

    @Override
    public McOptsContent findMcOptionsContentByUid(Long uid) {
        List list;
        HibernateTemplate templ = this.getHibernateTemplate();
        if (uid != null && (list = this.getSession().createQuery(FIND_MC_OPTIONS_CONTENT_BY_UID).setLong("uid", uid.longValue()).list()) != null && list.size() > 0) {
            McOptsContent mco = (McOptsContent)list.get(0);
            return mco;
        }
        return null;
    }

    @Override
    public List findMcOptionUidsByQueId(Long mcQueContentId) {
        List list;
        LinkedList<String> listOptionUids = new LinkedList<String>();
        HibernateTemplate templ = this.getHibernateTemplate();
        if (mcQueContentId != null && (list = this.getSession().createQuery(FIND_MC_OPTIONS_CONTENT).setLong("mcQueContentUid", mcQueContentId.longValue()).list()) != null && list.size() > 0) {
            for (McOptsContent mcOptsContent : list) {
                listOptionUids.add(mcOptsContent.getUid().toString());
            }
        }
        return listOptionUids;
    }

    @Override
    public List findMcOptionNamesByQueId(Long mcQueContentId) {
        List list;
        LinkedList<String> listOptionNames = new LinkedList<String>();
        HibernateTemplate templ = this.getHibernateTemplate();
        if (mcQueContentId != null && (list = this.getSession().createQuery(FIND_MC_OPTIONS_CONTENT).setLong("mcQueContentUid", mcQueContentId.longValue()).list()) != null && list.size() > 0) {
            for (McOptsContent mcOptsContent : list) {
                listOptionNames.add(mcOptsContent.getMcQueOptionText());
            }
        }
        return listOptionNames;
    }

    @Override
    public List populateCandidateAnswersDTO(Long mcQueContentId) {
        List list;
        LinkedList<McCandidateAnswersDTO> listCandidateAnswersData = new LinkedList<McCandidateAnswersDTO>();
        HibernateTemplate templ = this.getHibernateTemplate();
        if (mcQueContentId != null && (list = this.getSession().createQuery(FIND_MC_OPTIONS_CONTENT).setLong("mcQueContentUid", mcQueContentId.longValue()).list()) != null && list.size() > 0) {
            for (McOptsContent mcOptsContent : list) {
                McCandidateAnswersDTO mcCandidateAnswersDTO = new McCandidateAnswersDTO();
                mcCandidateAnswersDTO.setCandidateAnswer(mcOptsContent.getMcQueOptionText());
                mcCandidateAnswersDTO.setCorrect(new Boolean(mcOptsContent.isCorrectOption()).toString());
                listCandidateAnswersData.add(mcCandidateAnswersDTO);
            }
        }
        return listCandidateAnswersData;
    }

    @Override
    public List findMcOptionCorrectByQueId(Long mcQueContentId) {
        List list;
        LinkedList<String> listOptionCorrect = new LinkedList<String>();
        HibernateTemplate templ = this.getHibernateTemplate();
        if (mcQueContentId != null && (list = this.getSession().createQuery(FIND_MC_OPTIONS_CONTENT).setLong("mcQueContentUid", mcQueContentId.longValue()).list()) != null && list.size() > 0) {
            for (McOptsContent mcOptsContent : list) {
                listOptionCorrect.add(new Boolean(mcOptsContent.isCorrectOption()).toString());
            }
        }
        return listOptionCorrect;
    }

    @Override
    public McOptsContent getOptionContentByOptionText(String option, Long mcQueContentUid) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(LOAD_OPTION_CONTENT_BY_OPTION_TEXT).setString("option", option).setLong("mcQueContentUid", mcQueContentUid.longValue()).list();
        if (list != null && list.size() > 0) {
            McOptsContent mcq = (McOptsContent)list.get(0);
            return mcq;
        }
        return null;
    }

    @Override
    public List getPersistedSelectedOptions(Long mcQueContentId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcOptsContent in class McOptsContent where mcOptsContent.mcQueContentId=:mcQueContentUid and  mcOptsContent.correctOption = 1").setLong("mcQueContentUid", mcQueContentId.longValue()).list();
        return list;
    }

    @Override
    public List getCorrectOption(Long mcQueContentId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcOptsContent in class McOptsContent where mcOptsContent.mcQueContentId=:mcQueContentUid and  mcOptsContent.correctOption = 1").setLong("mcQueContentUid", mcQueContentId.longValue()).list();
        return list;
    }

    @Override
    public void saveMcOptionsContent(McOptsContent mcOptsContent) {
        this.getHibernateTemplate().save((Object)mcOptsContent);
    }

    @Override
    public void updateMcOptionsContent(McOptsContent mcOptsContent) {
        this.getHibernateTemplate().update((Object)mcOptsContent);
    }

    @Override
    public void removeMcOptionsContentByUID(Long uid) {
        McOptsContent mco = (McOptsContent)this.getHibernateTemplate().get(McOptsContent.class, (Serializable)uid);
        this.getHibernateTemplate().delete((Object)mco);
    }

    @Override
    public void removeMcOptionsContentByQueId(Long mcQueContentId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(FIND_MC_OPTIONS_CONTENT).setLong("mcQueContentUid", mcQueContentId.longValue()).list();
        if (list != null && list.size() > 0) {
            for (McOptsContent mcOptsContent : list) {
                this.getSession().setFlushMode(FlushMode.AUTO);
                templ.delete((Object)mcOptsContent);
            }
        }
    }

    @Override
    public void removeMcOptionsContent(McOptsContent mcOptsContent) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().delete((Object)mcOptsContent);
    }

    public void flush() {
        this.getHibernateTemplate().flush();
    }
}

