/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.mc.dao.IMcQueContentDAO;
import org.lamsfoundation.lams.tool.mc.pojos.McQueContent;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class McQueContentDAO
extends HibernateDaoSupport
implements IMcQueContentDAO {
    static Logger logger = Logger.getLogger((String)McQueContentDAO.class.getName());
    private static final String LOAD_QUESTION_CONTENT_BY_CONTENT_ID = "from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId order by mcQueContent.displayOrder";
    private static final String CLEAN_QUESTION_CONTENT_BY_CONTENT_ID_SIMPLE = "from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId";
    private static final String FIND_QUESTION_CONTENT_BY_UID = "from mcQueContent in class McQueContent where mcQueContent.uid=:uid";
    private static final String CLEAN_QUESTION_CONTENT_BY_CONTENT_ID = "from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId";
    private static final String REFRESH_QUESTION_CONTENT = "from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId order by mcQueContent.displayOrder";
    private static final String LOAD_QUESTION_CONTENT_BY_QUESTION_TEXT = "from mcQueContent in class McQueContent where mcQueContent.question=:question and mcQueContent.mcContentId=:mcContentUid";
    private static final String LOAD_QUESTION_CONTENT_BY_DISPLAY_ORDER = "from mcQueContent in class McQueContent where mcQueContent.displayOrder=:displayOrder and mcQueContent.mcContentId=:mcContentUid";
    private static final String GET_NEXT_AVAILABLE_DISPLAY_ORDER = "from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId";
    private static final String SORT_QUESTION_CONTENT_BY_DISPLAY_ORDER = "from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId order by mcQueContent.displayOrder";

    @Override
    public McQueContent findMcQuestionContentByUid(Long uid) {
        List list;
        HibernateTemplate templ = this.getHibernateTemplate();
        if (uid != null && (list = this.getSession().createQuery(FIND_QUESTION_CONTENT_BY_UID).setLong("uid", uid.longValue()).list()) != null && list.size() > 0) {
            McQueContent mcq = (McQueContent)list.get(0);
            return mcq;
        }
        return null;
    }

    @Override
    public McQueContent getMcQueContentByUID(Long uid) {
        return (McQueContent)this.getHibernateTemplate().get(McQueContent.class, (Serializable)uid);
    }

    @Override
    public McQueContent getToolDefaultQuestionContent(long mcContentId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId order by mcQueContent.displayOrder").setLong("mcContentId", mcContentId).list();
        if (list != null && list.size() > 0) {
            McQueContent mcq = (McQueContent)list.get(0);
            return mcq;
        }
        return null;
    }

    @Override
    public List getAllQuestionEntries(long mcContentId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId order by mcQueContent.displayOrder").setLong("mcContentId", mcContentId).list();
        return list;
    }

    @Override
    public List refreshQuestionContent(Long mcContentId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId order by mcQueContent.displayOrder").setLong("mcContentId", mcContentId.longValue()).list();
        return list;
    }

    @Override
    public McQueContent getQuestionContentByQuestionText(String question, Long mcContentUid) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(LOAD_QUESTION_CONTENT_BY_QUESTION_TEXT).setString("question", question).setLong("mcContentUid", mcContentUid.longValue()).list();
        if (list != null && list.size() > 0) {
            McQueContent mcq = (McQueContent)list.get(0);
            return mcq;
        }
        return null;
    }

    @Override
    public McQueContent getQuestionContentByDisplayOrder(Long displayOrder, Long mcContentUid) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(LOAD_QUESTION_CONTENT_BY_DISPLAY_ORDER).setLong("displayOrder", displayOrder.longValue()).setLong("mcContentUid", mcContentUid.longValue()).list();
        if (list != null && list.size() > 0) {
            McQueContent mcq = (McQueContent)list.get(0);
            return mcq;
        }
        return null;
    }

    @Override
    public void removeQuestionContentByMcUid(Long mcContentUid) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId order by mcQueContent.displayOrder").setLong("mcContentId", mcContentUid.longValue()).list();
        if (list != null && list.size() > 0) {
            for (McQueContent mcQueContent : list) {
                this.getSession().setFlushMode(FlushMode.AUTO);
                templ.delete((Object)mcQueContent);
                templ.flush();
            }
        }
    }

    @Override
    public void resetAllQuestions(Long mcContentUid) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId order by mcQueContent.displayOrder").setLong("mcContentId", mcContentUid.longValue()).list();
        if (list != null && list.size() > 0) {
            for (McQueContent mcQueContent : list) {
                this.getSession().setFlushMode(FlushMode.AUTO);
                templ.update((Object)mcQueContent);
            }
        }
    }

    @Override
    public void cleanAllQuestions(Long mcContentUid) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId").setLong("mcContentId", mcContentUid.longValue()).list();
        if (list != null && list.size() > 0) {
            for (McQueContent mcQueContent : list) {
                this.getSession().setFlushMode(FlushMode.AUTO);
                logger.debug((Object)("deleting mcQueContent: " + mcQueContent));
                templ.delete((Object)mcQueContent);
            }
        }
    }

    @Override
    public void cleanAllQuestionsSimple(Long mcContentUid) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId").setLong("mcContentId", mcContentUid.longValue()).list();
        if (list != null && list.size() > 0) {
            for (McQueContent mcQueContent : list) {
                this.getSession().setFlushMode(FlushMode.AUTO);
                logger.debug((Object)("deleting mcQueContent: " + mcQueContent));
                templ.delete((Object)mcQueContent);
            }
        }
    }

    @Override
    public List getNextAvailableDisplayOrder(long mcContentId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId").setLong("mcContentId", mcContentId).list();
        return list;
    }

    @Override
    public void saveMcQueContent(McQueContent mcQueContent) {
        this.getHibernateTemplate().save((Object)mcQueContent);
    }

    @Override
    public void saveOrUpdateMcQueContent(McQueContent mcQueContent) {
        this.getHibernateTemplate().saveOrUpdate((Object)mcQueContent);
    }

    @Override
    public void removeMcQueContentByUID(Long uid) {
        McQueContent mcq = (McQueContent)this.getHibernateTemplate().get(McQueContent.class, (Serializable)uid);
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().delete((Object)mcq);
    }

    @Override
    public void updateMcQueContent(McQueContent mcQueContent) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().update((Object)mcQueContent);
    }

    @Override
    public List getAllQuestionEntriesSorted(long mcContentId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId order by mcQueContent.displayOrder").setLong("mcContentId", mcContentId).list();
        return list;
    }

    @Override
    public List getMcQueContentsByContentId(long mcContentId) {
        return this.getHibernateTemplate().findByNamedParam("from mcQueContent in class McQueContent where mcQueContent.mcContentId=:mcContentId order by mcQueContent.displayOrder", "mcContentId", (Object)new Long(mcContentId));
    }

    @Override
    public void removeMcQueContent(McQueContent mcQueContent) {
        if (mcQueContent != null && mcQueContent.getUid() != null) {
            this.getSession().setFlushMode(FlushMode.AUTO);
            this.getHibernateTemplate().delete((Object)mcQueContent);
        }
    }

    public void flush() {
        this.getHibernateTemplate().flush();
    }
}

