/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.dao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.mc.dao.IMcUsrAttemptDAO;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McUsrAttempt;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class McUsrAttemptDAO
extends HibernateDaoSupport
implements IMcUsrAttemptDAO {
    static Logger logger = Logger.getLogger((String)McUsrAttemptDAO.class.getName());
    private static final String LOAD_HIGHEST_MARK_BY_USER_ID = "from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.queUsrId=:queUsrId";
    private static final String LOAD_HIGHEST_ATTEMPT_ORDER_BY_USER_ID = "from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.queUsrId=:queUsrId";
    private static final String LOAD_ATTEMPT_FOR_QUE_CONTENT = "from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.queUsrId=:queUsrId and mcUsrAttempt.mcQueContentId=:mcQueContentId";
    private static final String LOAD_ATTEMPT_FOR_USER = "from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.queUsrId=:queUsrId";
    private static final String LOAD_ATTEMPT_FOR_USER_AND_QUESTION_CONTENT = "from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.queUsrId=:queUsrId and mcUsrAttempt.mcQueContentId=:mcQueContentId";
    private static final String LOAD_ATTEMPT_BY_ATTEMPT_ORDER = "from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.queUsrId=:queUsrId and mcUsrAttempt.mcQueContentId=:mcQueContentId and attemptOrder=:attemptOrder";
    private static final String LOAD_ATTEMPT_FOR_QUESTION_CONTENT = "from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.mcQueContentId=:mcQueContentId";
    private static final String LOAD_MARK = "from mcUsrAttempt in class McUsrAttempt";
    private static final String LOAD_ATTEMPTS_ON_HIGHEST_ATTEMPT_ORDER = "from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.attemptOrder=:attemptOrder";
    private static final String LOAD_HIGHEST_MARK = "from mcUsrAttempt in class McUsrAttempt";

    @Override
    public McUsrAttempt getMcUserAttemptByUID(Long uid) {
        return (McUsrAttempt)this.getHibernateTemplate().get(McUsrAttempt.class, (Serializable)uid);
    }

    @Override
    public void saveMcUsrAttempt(McUsrAttempt mcUsrAttempt) {
        this.getHibernateTemplate().save((Object)mcUsrAttempt);
    }

    @Override
    public List getHighestMark(Long queUsrId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.queUsrId=:queUsrId").setLong("queUsrId", queUsrId.longValue()).list();
        return list;
    }

    @Override
    public List getMarks() {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcUsrAttempt in class McUsrAttempt").list();
        return list;
    }

    @Override
    public List getMarksForContent(McContent mcContent) {
        logger.debug((Object)("running getMarksForContent for mcContent:" + mcContent));
        logger.debug((Object)("running getMarksForContent for mcContent uid :" + mcContent.getUid()));
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcUsrAttempt in class McUsrAttempt").list();
        ArrayList<McUsrAttempt> userEntries = new ArrayList<McUsrAttempt>();
        if (list != null && list.size() > 0) {
            for (McUsrAttempt attempt : list) {
                logger.debug((Object)("attempt:" + attempt));
                logger.debug((Object)("attempt content uid:" + attempt.getMcQueContent().getMcContent().getUid()));
                if (attempt.getMcQueContent().getMcContent().getUid() != mcContent.getUid()) continue;
                logger.debug((Object)("same content found:" + mcContent));
                userEntries.add(attempt);
            }
        }
        logger.debug((Object)("returning userEntries:" + userEntries));
        return userEntries;
    }

    @Override
    public List getHighestAttemptOrder(Long queUsrId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.queUsrId=:queUsrId").setLong("queUsrId", queUsrId.longValue()).list();
        return list;
    }

    @Override
    public List getAttemptsForUser(Long queUsrId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.queUsrId=:queUsrId").setLong("queUsrId", queUsrId.longValue()).list();
        return list;
    }

    @Override
    public List getAttemptsForUserAndQuestionContent(Long queUsrId, Long mcQueContentId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.queUsrId=:queUsrId and mcUsrAttempt.mcQueContentId=:mcQueContentId").setLong("queUsrId", queUsrId.longValue()).setLong("mcQueContentId", mcQueContentId.longValue()).list();
        return list;
    }

    @Override
    public List getUserAttemptsForQuestionContentAndSessionUid(Long queUsrUid, Long mcQueContentId, Long mcSessionUid) {
        logger.debug((Object)"starting getUserAttemptsForQuestionContentAndSessionUid:");
        logger.debug((Object)("queUsrUid:" + queUsrUid));
        logger.debug((Object)("mcQueContentId:" + mcQueContentId));
        logger.debug((Object)("mcSessionUid:" + mcSessionUid));
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(LOAD_ATTEMPT_FOR_QUESTION_CONTENT).setLong("mcQueContentId", mcQueContentId.longValue()).list();
        ArrayList<McUsrAttempt> userEntries = new ArrayList<McUsrAttempt>();
        if (list != null && list.size() > 0) {
            for (McUsrAttempt attempt : list) {
                logger.debug((Object)("attempt:" + attempt));
                if (!attempt.getMcQueUsr().getUid().toString().equals(queUsrUid.toString())) continue;
                logger.debug((Object)("queUsrUid equal:" + queUsrUid));
                if (!attempt.getMcQueUsr().getMcSession().getUid().toString().equals(mcSessionUid.toString())) continue;
                logger.debug((Object)("user belong to this session:" + mcSessionUid));
                userEntries.add(attempt);
            }
        }
        logger.debug((Object)("userEntries:" + userEntries));
        return userEntries;
    }

    @Override
    public List getAttemptsOnHighestAttemptOrder(Long queUsrUid, Long mcQueContentId, Long mcSessionUid, Integer attemptOrder) {
        logger.debug((Object)"starting getUserAttemptsForQuestionContentAndSessionUid:");
        logger.debug((Object)("queUsrUid:" + queUsrUid));
        logger.debug((Object)("mcQueContentId:" + mcQueContentId));
        logger.debug((Object)("mcSessionUid:" + mcSessionUid));
        logger.debug((Object)("attemptOrder:" + attemptOrder));
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(LOAD_ATTEMPT_FOR_QUESTION_CONTENT).setLong("mcQueContentId", mcQueContentId.longValue()).list();
        ArrayList<McUsrAttempt> userEntries = new ArrayList<McUsrAttempt>();
        if (list != null && list.size() > 0) {
            for (McUsrAttempt attempt : list) {
                logger.debug((Object)("attempt:" + attempt));
                if (!attempt.getMcQueUsr().getUid().toString().equals(queUsrUid.toString())) continue;
                logger.debug((Object)("queUsrUid equal:" + queUsrUid));
                if (!attempt.getMcQueUsr().getMcSession().getUid().toString().equals(mcSessionUid.toString())) continue;
                logger.debug((Object)("user belongs to this session:" + mcSessionUid));
                if (attempt.getAttemptOrder().intValue() != attemptOrder.intValue()) continue;
                userEntries.add(attempt);
            }
        }
        logger.debug((Object)("userEntries:" + userEntries));
        return userEntries;
    }

    @Override
    public List getAttemptsForUserInSession(Long queUsrUid, Long mcSessionUid) {
        logger.debug((Object)"starting getAttemptsForUserInSession:");
        logger.debug((Object)("queUsrUid:" + queUsrUid));
        logger.debug((Object)("mcSessionUid:" + mcSessionUid));
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcUsrAttempt in class McUsrAttempt").list();
        ArrayList<McUsrAttempt> userEntries = new ArrayList<McUsrAttempt>();
        if (list != null && list.size() > 0) {
            for (McUsrAttempt attempt : list) {
                logger.debug((Object)("attempt:" + attempt));
                if (!attempt.getMcQueUsr().getUid().toString().equals(queUsrUid.toString())) continue;
                logger.debug((Object)("queUsrUid equal:" + queUsrUid));
                if (!attempt.getMcQueUsr().getMcSession().getUid().toString().equals(mcSessionUid.toString())) continue;
                logger.debug((Object)("user belong to this session:" + mcSessionUid));
                userEntries.add(attempt);
            }
        }
        logger.debug((Object)("userEntries:" + userEntries));
        return userEntries;
    }

    @Override
    public List getAttemptsForUserOnHighestAttemptOrderInSession(Long queUsrUid, Long mcSessionUid, Integer attemptOrder) {
        logger.debug((Object)"starting getAttemptsForUserOnHighestAttemptOrderInSession:");
        logger.debug((Object)("queUsrUid:" + queUsrUid));
        logger.debug((Object)("mcSessionUid:" + mcSessionUid));
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(LOAD_ATTEMPTS_ON_HIGHEST_ATTEMPT_ORDER).setInteger("attemptOrder", attemptOrder.intValue()).list();
        ArrayList<McUsrAttempt> userEntries = new ArrayList<McUsrAttempt>();
        if (list != null && list.size() > 0) {
            for (McUsrAttempt attempt : list) {
                logger.debug((Object)("attempt:" + attempt));
                if (!attempt.getMcQueUsr().getUid().toString().equals(queUsrUid.toString())) continue;
                logger.debug((Object)("queUsrUid equal:" + queUsrUid));
                if (!attempt.getMcQueUsr().getMcSession().getUid().toString().equals(mcSessionUid.toString())) continue;
                logger.debug((Object)("user belong to this session:" + mcSessionUid));
                userEntries.add(attempt);
            }
        }
        logger.debug((Object)("userEntries:" + userEntries));
        return userEntries;
    }

    @Override
    public boolean getUserAttemptCorrectForQuestionContentAndSessionUid(Long queUsrUid, Long mcQueContentId, Long mcSessionUid, Integer attemptOrder) {
        logger.debug((Object)"starting getUserAttemptsForQuestionContentAndSessionUid:");
        logger.debug((Object)("queUsrUid:" + queUsrUid));
        logger.debug((Object)("mcQueContentId:" + mcQueContentId));
        logger.debug((Object)("mcSessionUid:" + mcSessionUid));
        logger.debug((Object)("attemptOrder:" + attemptOrder));
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(LOAD_ATTEMPT_FOR_QUESTION_CONTENT).setLong("mcQueContentId", mcQueContentId.longValue()).list();
        if (list != null && list.size() > 0) {
            for (McUsrAttempt attempt : list) {
                logger.debug((Object)("attempt:" + attempt));
                if (!attempt.getMcQueUsr().getUid().toString().equals(queUsrUid.toString())) continue;
                logger.debug((Object)("queUsrUid equal:" + queUsrUid));
                if (!attempt.getMcQueUsr().getMcSession().getUid().toString().equals(mcSessionUid.toString())) continue;
                logger.debug((Object)("user belong to this session:" + mcSessionUid));
                logger.debug((Object)("isAttemptCorrect:" + attempt.isAttemptCorrect()));
                if (attempt.getAttemptOrder().intValue() != attemptOrder.intValue()) continue;
                return attempt.isAttemptCorrect();
            }
        }
        return false;
    }

    @Override
    public McUsrAttempt getUserAttemptForQuestionContentAndSessionUid(Long queUsrUid, Long mcQueContentId, Long mcSessionUid, Integer attemptOrder) {
        logger.debug((Object)"starting getUserAttemptsForQuestionContentAndSessionUid:");
        logger.debug((Object)("queUsrUid:" + queUsrUid));
        logger.debug((Object)("mcQueContentId:" + mcQueContentId));
        logger.debug((Object)("mcSessionUid:" + mcSessionUid));
        logger.debug((Object)("attemptOrder:" + attemptOrder));
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(LOAD_ATTEMPT_FOR_QUESTION_CONTENT).setLong("mcQueContentId", mcQueContentId.longValue()).list();
        if (list != null && list.size() > 0) {
            for (McUsrAttempt attempt : list) {
                logger.debug((Object)("attempt:" + attempt));
                if (!attempt.getMcQueUsr().getUid().toString().equals(queUsrUid.toString())) continue;
                logger.debug((Object)("queUsrUid equal:" + queUsrUid));
                if (!attempt.getMcQueUsr().getMcSession().getUid().toString().equals(mcSessionUid.toString())) continue;
                logger.debug((Object)("user belong to this session:" + mcSessionUid));
                logger.debug((Object)("isAttemptCorrect:" + attempt.isAttemptCorrect()));
                if (attempt.getAttemptOrder().intValue() != attemptOrder.intValue()) continue;
                return attempt;
            }
        }
        return null;
    }

    @Override
    public McUsrAttempt getAttemptWithLastAttemptOrderForUserInSession(Long queUsrUid, Long mcSessionUid) {
        logger.debug((Object)"starting getLastAttemptOrderForUserInSession:");
        logger.debug((Object)("queUsrUid:" + queUsrUid));
        logger.debug((Object)("mcSessionUid:" + mcSessionUid));
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcUsrAttempt in class McUsrAttempt").list();
        logger.debug((Object)("list:" + list));
        ArrayList<McUsrAttempt> userEntries = new ArrayList<McUsrAttempt>();
        if (list != null && list.size() > 0) {
            for (McUsrAttempt attempt : list) {
                logger.debug((Object)("attempt:" + attempt));
                if (!attempt.getMcQueUsr().getUid().toString().equals(queUsrUid.toString())) continue;
                logger.debug((Object)("queUsrUid equal:" + queUsrUid));
                if (!attempt.getMcQueUsr().getMcSession().getUid().toString().equals(mcSessionUid.toString())) continue;
                logger.debug((Object)("user belong to this session:" + mcSessionUid));
                userEntries.add(attempt);
            }
        }
        logger.debug((Object)("userEntries:" + userEntries));
        Iterator itAttempts = userEntries.iterator();
        int highestOrder = 0;
        McUsrAttempt mcHighestUsrAttempt = null;
        while (itAttempts.hasNext()) {
            McUsrAttempt mcUsrAttempt = (McUsrAttempt)itAttempts.next();
            logger.debug((Object)("mcUsrAttempt: " + mcUsrAttempt));
            int currentOrder = mcUsrAttempt.getAttemptOrder();
            logger.debug((Object)("currentOrder: " + currentOrder));
            if (currentOrder <= highestOrder) continue;
            mcHighestUsrAttempt = mcUsrAttempt;
            highestOrder = currentOrder;
            logger.debug((Object)("highestOrder is updated to: " + highestOrder));
        }
        logger.debug((Object)("returning mcHighestUsrAttempt: " + mcHighestUsrAttempt));
        logger.debug((Object)("highestOrder has become: " + highestOrder));
        logger.debug((Object)("returning mcHighestUsrAttempt: " + mcHighestUsrAttempt));
        return mcHighestUsrAttempt;
    }

    @Override
    public List getAttemptForQueContent(Long queUsrId, Long mcQueContentId) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery("from mcUsrAttempt in class McUsrAttempt where mcUsrAttempt.queUsrId=:queUsrId and mcUsrAttempt.mcQueContentId=:mcQueContentId").setLong("queUsrId", queUsrId.longValue()).setLong("mcQueContentId", mcQueContentId.longValue()).list();
        return list;
    }

    @Override
    public List getAttemptByAttemptOrder(Long queUsrId, Long mcQueContentId, Integer attemptOrder) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(LOAD_ATTEMPT_BY_ATTEMPT_ORDER).setLong("queUsrId", queUsrId.longValue()).setLong("mcQueContentId", mcQueContentId.longValue()).setInteger("attemptOrder", attemptOrder.intValue()).list();
        return list;
    }

    @Override
    public void updateMcUsrAttempt(McUsrAttempt mcUsrAttempt) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().update((Object)mcUsrAttempt);
    }

    @Override
    public void removeMcUsrAttemptByUID(Long uid) {
        McUsrAttempt mca = (McUsrAttempt)this.getHibernateTemplate().get(McUsrAttempt.class, (Serializable)uid);
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().delete((Object)mca);
    }

    @Override
    public void removeMcUsrAttempt(McUsrAttempt mcUsrAttempt) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().delete((Object)mcUsrAttempt);
    }
}

