/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.pojos;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;

public class McUploadedFile
implements Serializable,
Comparable {
    static Logger logger = Logger.getLogger((String)McUploadedFile.class.getName());
    private Long submissionId;
    private String uuid;
    private boolean fileOnline;
    private String fileName;
    private McContent mcContent;

    public McUploadedFile() {
    }

    public McUploadedFile(Long submissionId, String uuid, boolean fileOnline, String fileName, McContent mcContent) {
        this.submissionId = submissionId;
        this.uuid = uuid;
        this.fileOnline = fileOnline;
        this.fileName = fileName;
        this.mcContent = mcContent;
    }

    public static McUploadedFile newInstance(IToolContentHandler toolContentHandler, McUploadedFile mcUploadedFile, McContent newMcContent) throws ItemNotFoundException, RepositoryCheckedException {
        McUploadedFile newMcUploadedFile = null;
        newMcUploadedFile = new McUploadedFile(mcUploadedFile.getUuid(), mcUploadedFile.isFileOnline(), mcUploadedFile.getFileName(), newMcContent);
        return newMcUploadedFile;
    }

    public McUploadedFile(String uuid, boolean fileOnline, String fileName, McContent mcContent) {
        logger.debug((Object)"constructor gets called.");
        this.uuid = uuid;
        this.fileOnline = fileOnline;
        this.fileName = fileName;
        this.mcContent = mcContent;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("uuid: ", (Object)this.getUuid()).append("fileName: ", (Object)this.getFileName()).toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof McUploadedFile)) {
            return false;
        }
        McUploadedFile castOther = (McUploadedFile)other;
        return new EqualsBuilder().append((Object)this.getUuid(), (Object)castOther.getUuid()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getUuid()).toHashCode();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public McContent getMcContent() {
        return this.mcContent;
    }

    public void setMcContent(McContent mcContent) {
        this.mcContent = mcContent;
    }

    public Long getSubmissionId() {
        return this.submissionId;
    }

    public void setSubmissionId(Long submissionId) {
        this.submissionId = submissionId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean isFileOnline() {
        return this.fileOnline;
    }

    public void setFileOnline(boolean fileOnline) {
        this.fileOnline = fileOnline;
    }

    public int compareTo(Object o) {
        McUploadedFile file = (McUploadedFile)o;
        if (this.submissionId == null) {
            return 1;
        }
        return (int)(this.submissionId - file.submissionId);
    }

    public String getFileProperty() {
        if (this.isFileOnline()) {
            return "ONLINE";
        }
        return "OFFLINE";
    }

    public void setFileProperty(String fileProperty) {
        this.fileOnline = StringUtils.equals((String)"ONLINE", (String)fileProperty);
    }
}

