/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.web;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McApplicationException;
import org.lamsfoundation.lams.tool.mc.McComparator;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueUsr;
import org.lamsfoundation.lams.tool.mc.pojos.McSession;
import org.lamsfoundation.lams.tool.mc.pojos.McUsrAttempt;
import org.lamsfoundation.lams.tool.mc.service.IMcService;
import org.lamsfoundation.lams.tool.mc.service.McServiceProxy;
import org.lamsfoundation.lams.tool.mc.web.McMonitoringAction;
import org.lamsfoundation.lams.tool.mc.web.MonitoringUtil;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;

public class ExportServlet
extends AbstractExportPortfolioServlet
implements McAppConstants {
    static Logger logger = Logger.getLogger((String)ExportServlet.class.getName());
    private static final long serialVersionUID = -17790L;
    private final String FILENAME = "mcq_main.html";

    public String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        logger.debug((Object)"dispathcing doExport");
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        logger.debug((Object)("basePath:" + basePath));
        if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
            this.learner(request, response, directoryName, cookies);
        } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
            this.teacher(request, response, directoryName, cookies);
        }
        this.writeResponseToFile(basePath + "/export/exportportfolio.jsp", directoryName, "mcq_main.html", cookies);
        return "mcq_main.html";
    }

    public void learner(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        logger.debug((Object)"starting learner mode...");
        IMcService mcService = McServiceProxy.getMcService(this.getServletContext());
        logger.debug((Object)("mcService:" + mcService));
        logger.debug((Object)("userID:" + this.userID));
        logger.debug((Object)("toolSessionID:" + this.toolSessionID));
        if (this.userID == null || this.toolSessionID == null) {
            String error = "Tool session Id or user Id is null. Unable to continue";
            logger.error((Object)error);
            throw new McApplicationException(error);
        }
        McSession mcSession = mcService.retrieveMcSession(this.toolSessionID);
        McQueUsr learner = mcService.getMcUserBySession(this.userID, mcSession.getUid());
        logger.debug((Object)("learner: " + learner));
        if (learner == null) {
            String error = "The user with user id " + this.userID + " does not exist in this session or session may not exist.";
            logger.error((Object)error);
            throw new McApplicationException(error);
        }
        McContent content = mcSession.getMcContent();
        logger.debug((Object)("content: " + content));
        logger.debug((Object)("content id: " + content.getMcContentId()));
        if (content == null) {
            String error = "The content for this activity has not been defined yet.";
            logger.error((Object)error);
            throw new McApplicationException(error);
        }
        McMonitoringAction mcMonitoringAction = new McMonitoringAction();
        List listMonitoredAnswersContainerDTO = MonitoringUtil.buildGroupsQuestionDataForExportLearner(request, content, mcService, mcSession, learner);
        request.getSession().setAttribute("listMonitoredAnswersContainerDto", (Object)listMonitoredAnswersContainerDTO);
        logger.debug((Object)("LIST_MONITORED_ANSWERS_CONTAINER_DTO: " + request.getSession().getAttribute("listMonitoredAnswersContainerDto")));
        String intTotalMark = this.viewAnswers(request, content, learner, mcSession, mcService);
        logger.debug((Object)("intTotalMark: " + intTotalMark));
        request.getSession().setAttribute("learnerMark", (Object)intTotalMark);
        request.getSession().setAttribute("learnerName", (Object)learner.getFullname());
        request.getSession().setAttribute("passMark", (Object)content.getPassMark().toString());
        request.getSession().setAttribute("portfolioExportMode", (Object)"learner");
        mcMonitoringAction.prepareReflectionData(request, content, mcService, this.userID.toString(), true);
        logger.debug((Object)"ending learner mode: ");
    }

    public String viewAnswers(HttpServletRequest request, McContent content, McQueUsr mcQueUsr, McSession mcSession, IMcService mcService) {
        logger.debug((Object)"starting viewAnswers...");
        int intTotalMark = 0;
        McUsrAttempt mcUsrAttempt = mcService.getAttemptWithLastAttemptOrderForUserInSession(mcQueUsr.getUid(), mcSession.getUid());
        logger.debug((Object)("mcUsrAttempt with highest attempt order: " + mcUsrAttempt));
        int totalQuestionCount = content.getMcQueContents().size();
        logger.debug((Object)("totalQuestionCount: " + totalQuestionCount));
        Long toolContentUID = content.getUid();
        logger.debug((Object)("toolContentUID: " + toolContentUID));
        logger.debug((Object)("mcQueUsr: " + mcQueUsr));
        Long queUsrId = mcQueUsr.getUid();
        logger.debug((Object)("queUsrId: " + queUsrId));
        TreeMap<String, String> mapResponses = new TreeMap<String, String>(new McComparator());
        TreeMap mapQueAttempts = new TreeMap(new McComparator());
        TreeMap mapQueCorrectAttempts = new TreeMap(new McComparator());
        TreeMap mapQueIncorrectAttempts = new TreeMap(new McComparator());
        for (int i = 1; i <= new Integer(totalQuestionCount); ++i) {
            logger.debug((Object)("doing question with display order: " + i));
            McQueContent mcQueContent = mcService.getQuestionContentByDisplayOrder(new Long(i), toolContentUID);
            logger.debug((Object)("mcQueContent uid: " + mcQueContent.getUid()));
            int intCurrentMark = 0;
            if (mcUsrAttempt != null) {
                String currentMark;
                boolean isAttemptCorrect;
                String highestAttemptOrder = mcUsrAttempt.getAttemptOrder().toString();
                logger.debug((Object)("highestAttemptOrder: " + highestAttemptOrder));
                List listUserAttempts = mcService.getAttemptsOnHighestAttemptOrder(mcQueUsr.getUid(), mcQueContent.getUid(), mcSession.getUid(), new Integer(highestAttemptOrder));
                logger.debug((Object)("listUserAttempts: " + listUserAttempts));
                Iterator itAttempts = listUserAttempts.iterator();
                if (!mcSession.getMcContent().isRetries()) {
                    logger.debug((Object)"retries is OFF.");
                    isAttemptCorrect = false;
                    McUsrAttempt mcUsrAttemptUser = null;
                    while (itAttempts.hasNext()) {
                        mcUsrAttempt = (McUsrAttempt)itAttempts.next();
                        logger.debug((Object)("mcUsrAttempt: " + mcUsrAttempt));
                        mcUsrAttemptUser = mcUsrAttempt;
                        if (mcUsrAttempt == null || !mcUsrAttempt.isAttemptCorrect()) continue;
                        isAttemptCorrect = true;
                    }
                    logger.debug((Object)("final isAttemptCorrect: " + isAttemptCorrect));
                    logger.debug((Object)("mcUsrAttemptUser: " + mcUsrAttemptUser));
                    currentMark = "";
                    currentMark = isAttemptCorrect ? mcUsrAttemptUser.getMcQueContent().getMark().toString() : "0";
                    mapResponses.put(new Integer(i).toString(), currentMark);
                    intCurrentMark = new Integer(currentMark);
                    logger.debug((Object)("intCurrentMark: " + intCurrentMark));
                } else {
                    logger.debug((Object)"retries is ON. User had to PASS. Print the final attempt's data");
                    isAttemptCorrect = false;
                    McUsrAttempt mcUsrAttemptGeneral = null;
                    while (itAttempts.hasNext()) {
                        mcUsrAttempt = (McUsrAttempt)itAttempts.next();
                        logger.debug((Object)("mcUsrAttempt: " + mcUsrAttempt));
                        mcUsrAttemptGeneral = mcUsrAttempt;
                        if (mcUsrAttempt == null || !mcUsrAttempt.isFinished() || !mcUsrAttempt.isPassed()) continue;
                        logger.debug((Object)("this is a individual question attempt that is finished and passed: " + mcUsrAttempt));
                        isAttemptCorrect = mcService.getUserAttemptCorrectForQuestionContentAndSessionUid(mcQueUsr.getUid(), mcQueContent.getUid(), mcSession.getUid(), new Integer(highestAttemptOrder));
                        logger.debug((Object)("isAttemptCorrect: " + isAttemptCorrect));
                        break;
                    }
                    logger.debug((Object)("final isAttemptCorrect: " + isAttemptCorrect));
                    currentMark = "";
                    currentMark = isAttemptCorrect ? mcUsrAttempt.getMcQueContent().getMark().toString() : "0";
                    mapResponses.put(new Integer(i).toString(), currentMark);
                    intCurrentMark = new Integer(currentMark);
                    logger.debug((Object)("intCurrentMark: " + intCurrentMark));
                }
            } else {
                intCurrentMark = 0;
                mapResponses.put(new Integer(i).toString(), "0");
            }
            logger.debug((Object)("intTotalMark: " + (intTotalMark += intCurrentMark)));
            TreeMap mapAttemptOrderCorrectAttempts = new TreeMap(new McComparator());
            TreeMap mapAttemptOrderIncorrectAttempts = new TreeMap(new McComparator());
            TreeMap mapAttemptOrderAttempts = new TreeMap(new McComparator());
            for (int j = 1; j <= 30; ++j) {
                logger.debug((Object)("getting list for queUsrId: " + queUsrId));
                List attemptsByAttemptOrder = mcService.getAttemptByAttemptOrder(queUsrId, mcQueContent.getUid(), new Integer(j));
                logger.debug((Object)("attemptsByAttemptOrder: " + j + " is: " + attemptsByAttemptOrder));
                TreeMap<String, String> mapAttempts = new TreeMap<String, String>(new McComparator());
                TreeMap mapAttemptsIncorrect = new TreeMap(new McComparator());
                TreeMap mapAttemptsCorrect = new TreeMap(new McComparator());
                Iterator attemptIterator = attemptsByAttemptOrder.iterator();
                Long mapIndex = new Long(1L);
                while (attemptIterator.hasNext()) {
                    McUsrAttempt localMcUsrAttempt = (McUsrAttempt)attemptIterator.next();
                    logger.debug((Object)("localMcUsrAttempt: " + localMcUsrAttempt));
                    mapAttempts.put(mapIndex.toString(), localMcUsrAttempt.getMcOptionsContent().getMcQueOptionText());
                    logger.debug((Object)("added attempt with order: " + localMcUsrAttempt.getAttemptOrder() + " , option text is: " + localMcUsrAttempt.getMcOptionsContent().getMcQueOptionText()));
                    mapIndex = new Long(mapIndex + 1L);
                }
                logger.debug((Object)("final mapAttempts is: " + mapAttempts));
                if (mapAttempts.size() > 0) {
                    mapAttemptOrderAttempts.put(new Integer(j).toString(), mapAttempts);
                }
                if (mapAttemptsCorrect.size() > 0) {
                    mapAttemptOrderCorrectAttempts.put(new Integer(j).toString(), mapAttemptsCorrect);
                }
                if (mapAttemptsIncorrect.size() <= 0) continue;
                mapAttemptOrderIncorrectAttempts.put(new Integer(j).toString(), mapAttemptsIncorrect);
            }
            logger.debug((Object)("final mapAttemptOrderAttempts is: " + mapAttemptOrderAttempts));
            if (mapAttemptOrderAttempts.size() > 0) {
                mapQueAttempts.put(new Integer(i).toString(), mapAttemptOrderAttempts);
            }
            if (mapAttemptOrderCorrectAttempts.size() > 0) {
                mapQueCorrectAttempts.put(new Integer(i).toString(), mapAttemptOrderCorrectAttempts);
            }
            if (mapAttemptOrderIncorrectAttempts.size() <= 0) continue;
            mapQueIncorrectAttempts.put(new Integer(i).toString(), mapAttemptOrderIncorrectAttempts);
        }
        request.getSession().setAttribute("mapQueAttempts", mapQueAttempts);
        logger.debug((Object)("final mapQueAttempts is: " + mapQueAttempts));
        request.getSession().setAttribute("mapQueCorrectAttempts", mapQueCorrectAttempts);
        request.getSession().setAttribute("mapQueIncorrectAttempts", mapQueIncorrectAttempts);
        request.getSession().setAttribute("mapResponses", mapResponses);
        logger.debug((Object)("final MAP_RESPONSES is: " + mapResponses));
        logger.debug((Object)("final intTotalMark is: " + intTotalMark));
        return new Integer(intTotalMark).toString();
    }

    public void teacher(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        logger.debug((Object)"starting teacher mode...");
        IMcService mcService = McServiceProxy.getMcService(this.getServletContext());
        if (this.toolContentID == null) {
            String error = "Tool Content Id is missing. Unable to continue";
            logger.error((Object)error);
            throw new McApplicationException(error);
        }
        McContent content = mcService.retrieveMc(this.toolContentID);
        logger.debug((Object)("content: " + content));
        if (content == null) {
            String error = "Data is missing from the database. Unable to Continue";
            logger.error((Object)error);
            throw new McApplicationException(error);
        }
        logger.debug((Object)"starting teacher mode: ");
        McMonitoringAction mcMonitoringAction = new McMonitoringAction();
        List listMonitoredAnswersContainerDTO = MonitoringUtil.buildGroupsQuestionData(request, content, mcService);
        request.getSession().setAttribute("listMonitoredAnswersContainerDto", (Object)listMonitoredAnswersContainerDTO);
        logger.debug((Object)("LIST_MONITORED_ANSWERS_CONTAINER_DTO: " + request.getSession().getAttribute("listMonitoredAnswersContainerDto")));
        List listMonitoredMarksContainerDTO = MonitoringUtil.buildGroupsMarkData(request, content, mcService);
        request.getSession().setAttribute("listMonitoredMarksContainerDto", (Object)listMonitoredMarksContainerDTO);
        logger.debug((Object)("LIST_MONITORED_MARKS_CONTAINER_DTO: " + request.getSession().getAttribute("listMonitoredMarksContainerDto")));
        request.getSession().setAttribute("passMark", (Object)content.getPassMark().toString());
        request.getSession().setAttribute("portfolioExportMode", (Object)"teacher");
        mcMonitoringAction.prepareReflectionData(request, content, mcService, null, true);
        logger.debug((Object)"ending teacher mode: ");
    }
}

