/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.web;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McComparator;
import org.lamsfoundation.lams.tool.mc.McGeneralLearnerFlowDTO;
import org.lamsfoundation.lams.tool.mc.McLearnerAnswersDTO;
import org.lamsfoundation.lams.tool.mc.McRandomizedListsDTO;
import org.lamsfoundation.lams.tool.mc.McUtils;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McOptsContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueUsr;
import org.lamsfoundation.lams.tool.mc.pojos.McSession;
import org.lamsfoundation.lams.tool.mc.pojos.McUsrAttempt;
import org.lamsfoundation.lams.tool.mc.service.IMcService;
import org.lamsfoundation.lams.tool.mc.web.McLearningForm;

public class LearningUtil
implements McAppConstants {
    static Logger logger = Logger.getLogger((String)LearningUtil.class.getName());

    public static void saveFormRequestData(HttpServletRequest request, McLearningForm mcLearningForm, boolean prepareViewAnswersDataMode) {
        logger.debug((Object)"starting saveFormRequestData:");
        String httpSessionID = request.getParameter("httpSessionID");
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        mcLearningForm.setHttpSessionID(httpSessionID);
        String userID = request.getParameter("userID");
        logger.debug((Object)("userID: " + userID));
        mcLearningForm.setUserID(userID);
        String passMarkApplicable = request.getParameter("passMarkApplicable");
        logger.debug((Object)("passMarkApplicable: " + passMarkApplicable));
        mcLearningForm.setPassMarkApplicable(passMarkApplicable);
        String userOverPassMark = request.getParameter("userOverPassMark");
        logger.debug((Object)("userOverPassMark: " + userOverPassMark));
        mcLearningForm.setUserOverPassMark(userOverPassMark);
        if (!prepareViewAnswersDataMode) {
            String learnerProgress = request.getParameter("learnerProgress");
            logger.debug((Object)("learnerProgress: " + learnerProgress));
            mcLearningForm.setLearnerProgress(learnerProgress);
            logger.debug((Object)"form is populated with learnerProgress");
            String learnerProgressUserId = request.getParameter("learnerProgressUserId");
            logger.debug((Object)("learnerProgressUserId: " + learnerProgressUserId));
            mcLearningForm.setLearnerProgressUserId(learnerProgressUserId);
        }
        String questionListingMode = request.getParameter("questionListingMode");
        logger.debug((Object)("questionListingMode: " + questionListingMode));
        mcLearningForm.setQuestionListingMode(questionListingMode);
        logger.debug((Object)"ending saveFormRequestData:");
    }

    public static int calculateWeights(Map mapLeanerAssessmentResults, Map mapQuestionWeights) {
        logger.debug((Object)"starting calculate weights...");
        logger.debug((Object)("mapLeanerAssessmentResults : " + mapLeanerAssessmentResults));
        logger.debug((Object)("mapQuestionWeights : " + mapQuestionWeights));
        int totalUserWeight = 0;
        for (Map.Entry pairs : mapLeanerAssessmentResults.entrySet()) {
            logger.debug((Object)("using the  pair: " + pairs.getKey() + " = " + pairs.getValue()));
            for (Map.Entry pairsWeight : mapQuestionWeights.entrySet()) {
                logger.debug((Object)("using the  weight pair: " + pairsWeight.getKey() + " = " + pairsWeight.getValue()));
                if (!pairs.getKey().toString().equals(pairsWeight.getKey().toString())) continue;
                logger.debug((Object)("equal question found " + pairsWeight.getKey() + " = " + pairsWeight.getValue() + " and " + pairs.getValue()));
                if (!pairs.getValue().toString().equalsIgnoreCase("true")) continue;
                logger.debug((Object)("equal question found " + pairsWeight.getKey() + " is a correct answer."));
                int weight = new Integer(pairsWeight.getValue().toString());
                logger.debug((Object)("weight: " + weight));
                totalUserWeight += weight;
            }
        }
        logger.debug((Object)("totalUserWeight: " + totalUserWeight));
        return totalUserWeight;
    }

    public static String getTotalMarksPossible(McContent mcContent) {
        logger.debug((Object)("starting getTotalMarksPossible: " + mcContent));
        int totalMarksPossible = 0;
        for (McQueContent mcQueContent : mcContent.getMcQueContents()) {
            logger.debug((Object)("mcQueContent: " + mcQueContent));
            Integer mark = mcQueContent.getMark();
            logger.debug((Object)("mark: " + mark));
            int intMark = 0;
            if (mark != null) {
                intMark = mark;
            }
            logger.debug((Object)("intMark: " + intMark));
            totalMarksPossible += intMark;
        }
        logger.debug((Object)("totalMarksPossible: " + totalMarksPossible));
        String strTotalMarksPossible = new Integer(totalMarksPossible).toString();
        return strTotalMarksPossible;
    }

    public static int getMark(Map mapLeanerAssessmentResults) {
        boolean totalUserWeight = false;
        Iterator itLearnerAssessmentMap = mapLeanerAssessmentResults.entrySet().iterator();
        int correctAnswerCount = 0;
        while (itLearnerAssessmentMap.hasNext()) {
            Map.Entry pairs = itLearnerAssessmentMap.next();
            if (!pairs.getValue().toString().equalsIgnoreCase("true")) continue;
            ++correctAnswerCount;
        }
        return correctAnswerCount;
    }

    public static int getHighestAttemptOrder(HttpServletRequest request, Long queUsrId, IMcService mcService) {
        logger.debug((Object)("mcService: " + mcService));
        List listMarks = mcService.getHighestAttemptOrder(queUsrId);
        Iterator itMarks = listMarks.iterator();
        int highestAO = 0;
        while (itMarks.hasNext()) {
            McUsrAttempt mcUsrAttempt = (McUsrAttempt)itMarks.next();
            int currentAO = mcUsrAttempt.getAttemptOrder();
            if (currentAO <= highestAO) continue;
            highestAO = currentAO;
        }
        return highestAO;
    }

    public static int getHighestMark(HttpServletRequest request, Long queUsrId, IMcService mcService) {
        List listMarks = mcService.getHighestMark(queUsrId);
        Iterator itMarks = listMarks.iterator();
        int highestMark = 0;
        while (itMarks.hasNext()) {
            McUsrAttempt mcUsrAttempt = (McUsrAttempt)itMarks.next();
            int currentMark = mcUsrAttempt.getMark();
            if (currentMark <= highestMark) continue;
            highestMark = currentMark;
        }
        return highestMark;
    }

    public static int getTopMark(HttpServletRequest request, IMcService mcService, McContent mcContent) {
        logger.debug((Object)("performing getTopMark on mcContent: " + mcContent));
        List listMarks = mcService.getMarksForContent(mcContent);
        logger.debug((Object)("listMarks: " + listMarks));
        Iterator itMarks = listMarks.iterator();
        int highestMark = 0;
        while (itMarks.hasNext()) {
            McUsrAttempt mcUsrAttempt = (McUsrAttempt)itMarks.next();
            int currentMark = mcUsrAttempt.getMark();
            if (currentMark <= highestMark) continue;
            highestMark = currentMark;
        }
        return highestMark;
    }

    public static int getLowestMark(HttpServletRequest request, IMcService mcService, McContent mcContent) {
        logger.debug((Object)("performing getLowestMark on mcContent: " + mcContent));
        List listMarks = mcService.getMarksForContent(mcContent);
        logger.debug((Object)("listMarks: " + listMarks));
        Iterator itMarks = listMarks.iterator();
        int lowestMark = 100;
        while (itMarks.hasNext()) {
            McUsrAttempt mcUsrAttempt = (McUsrAttempt)itMarks.next();
            int currentMark = mcUsrAttempt.getMark();
            if (currentMark >= lowestMark) continue;
            lowestMark = currentMark;
        }
        if (lowestMark == 100) {
            lowestMark = 0;
        }
        return lowestMark;
    }

    public static int getAverageMark(HttpServletRequest request, IMcService mcService, McContent mcContent) {
        logger.debug((Object)("performing getAverageMark on mcContent: " + mcContent));
        List listMarks = mcService.getMarksForContent(mcContent);
        logger.debug((Object)("listMarks: " + listMarks));
        Iterator itMarks = listMarks.iterator();
        int marksTotal = 0;
        int count = 0;
        while (itMarks.hasNext()) {
            McUsrAttempt mcUsrAttempt = (McUsrAttempt)itMarks.next();
            int currentMark = mcUsrAttempt.getMark();
            marksTotal += currentMark;
            ++count;
        }
        logger.debug((Object)("marksTotal: " + marksTotal));
        logger.debug((Object)("count: " + count));
        int averageMark = 0;
        if (count > 0) {
            averageMark = marksTotal / count;
        }
        logger.debug((Object)("averageMark: " + averageMark));
        return averageMark;
    }

    public static Map buildMapCorrectOptions(List correctOptions) {
        TreeMap<String, String> mapCorrectOptions = new TreeMap<String, String>(new McComparator());
        Iterator correctOptionsIterator = correctOptions.iterator();
        Long mapIndex = new Long(1L);
        while (correctOptionsIterator.hasNext()) {
            McOptsContent mcOptsContent = (McOptsContent)correctOptionsIterator.next();
            if (mcOptsContent == null) continue;
            mapCorrectOptions.put(mapIndex.toString(), mcOptsContent.getMcQueOptionText());
            mapIndex = new Long(mapIndex + 1L);
        }
        logger.debug((Object)("mapCorrectOptions : " + mapCorrectOptions));
        return mapCorrectOptions;
    }

    public static Map buildMapCorrectOptionUids(List correctOptions) {
        TreeMap<String, String> mapCorrectOptionUids = new TreeMap<String, String>(new McComparator());
        Iterator correctOptionsIterator = correctOptions.iterator();
        Long mapIndex = new Long(1L);
        while (correctOptionsIterator.hasNext()) {
            McOptsContent mcOptsContent = (McOptsContent)correctOptionsIterator.next();
            if (mcOptsContent == null) continue;
            mapCorrectOptionUids.put(mapIndex.toString(), mcOptsContent.getUid().toString());
            mapIndex = new Long(mapIndex + 1L);
        }
        logger.debug((Object)("mapCorrectOptionUids : " + mapCorrectOptionUids));
        return mapCorrectOptionUids;
    }

    public static Map compare(Map mapGeneralCorrectOptions, Map mapGeneralCheckedOptionsContent) {
        logger.debug((Object)("incoming mapGeneralCorrectOptions : " + mapGeneralCorrectOptions));
        logger.debug((Object)("incoming mapGeneralCheckedOptionsContent : " + mapGeneralCheckedOptionsContent));
        TreeMap mapLeanerAssessmentResults = new TreeMap(new McComparator());
        if (mapGeneralCheckedOptionsContent == null) {
            return mapLeanerAssessmentResults;
        }
        Iterator itMap = mapGeneralCorrectOptions.entrySet().iterator();
        boolean compareResult = false;
        while (itMap.hasNext()) {
            compareResult = false;
            Map.Entry pairs = itMap.next();
            Iterator itCheckedMap = mapGeneralCheckedOptionsContent.entrySet().iterator();
            while (itCheckedMap.hasNext()) {
                compareResult = false;
                Map.Entry checkedPairs = itCheckedMap.next();
                if (!pairs.getKey().toString().equals(checkedPairs.getKey().toString())) continue;
                Map mapCorrectOptions = (Map)pairs.getValue();
                Map mapCheckedOptions = (Map)checkedPairs.getValue();
                boolean isEqual = LearningUtil.compareMapItems(mapCorrectOptions, mapCheckedOptions);
                boolean isEqualCross = LearningUtil.compareMapsItemsCross(mapCorrectOptions, mapCheckedOptions);
                compareResult = isEqual && isEqualCross;
                mapLeanerAssessmentResults.put(pairs.getKey(), new Boolean(compareResult).toString());
            }
        }
        logger.debug((Object)("constructed mapLeanerAssessmentResults: " + mapLeanerAssessmentResults));
        return mapLeanerAssessmentResults;
    }

    public static boolean compareMapItems(Map mapCorrectOptions, Map mapCheckedOptions) {
        logger.debug((Object)"performing compareMaps");
        logger.debug((Object)("mapCorrectOptions: " + mapCorrectOptions));
        logger.debug((Object)("mapCheckedOptions: " + mapCheckedOptions));
        Iterator itMap = mapCorrectOptions.entrySet().iterator();
        boolean response = false;
        while (itMap.hasNext()) {
            Map.Entry pairs = itMap.next();
            logger.debug((Object)("pairs.getValue(): " + pairs.getValue()));
            boolean optionExists = LearningUtil.optionExists(pairs.getValue().toString(), mapCheckedOptions);
            logger.debug((Object)("optionExists: " + optionExists));
            if (optionExists) continue;
            return false;
        }
        return true;
    }

    public static boolean compareMapsItemsCross(Map mapCorrectOptions, Map mapCheckedOptions) {
        logger.debug((Object)"performing compareMapsCross");
        logger.debug((Object)("mapCorrectOptions: " + mapCorrectOptions));
        logger.debug((Object)("mapCheckedOptions: " + mapCheckedOptions));
        Iterator itMap = mapCheckedOptions.entrySet().iterator();
        boolean response = false;
        while (itMap.hasNext()) {
            Map.Entry pairs = itMap.next();
            logger.debug((Object)("pairs.getValue(): " + pairs.getValue()));
            boolean optionExists = LearningUtil.optionExists(pairs.getValue().toString(), mapCorrectOptions);
            logger.debug((Object)("optionExists: " + optionExists));
            if (optionExists) continue;
            return false;
        }
        return true;
    }

    public static boolean optionExists(String optionValue, Map generalMap) {
        logger.debug((Object)("performing optionExists: " + optionValue));
        logger.debug((Object)("generalMap: " + generalMap));
        for (Map.Entry pairsChecked : generalMap.entrySet()) {
            logger.debug((Object)("pairsChecked: " + pairsChecked));
            if (!pairsChecked.getValue().toString().equals(optionValue.toString())) continue;
            return true;
        }
        return false;
    }

    public static McQueUsr getUser(HttpServletRequest request, IMcService mcService, String toolSessionId) {
        logger.debug((Object)("getUser:: " + toolSessionId));
        Long queUsrId = McUtils.getUserId();
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionId));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        McQueUsr mcQueUsr = mcService.getMcUserBySession(queUsrId, mcSession.getUid());
        logger.debug((Object)("retrieving mcQueUsr: " + mcQueUsr));
        return mcQueUsr;
    }

    public static McQueUsr createUser(HttpServletRequest request, IMcService mcService, Long toolSessionId) {
        logger.debug((Object)("createUser: using toolSessionId: " + toolSessionId));
        Long queUsrId = McUtils.getUserId();
        String username = McUtils.getUserName();
        String fullname = McUtils.getUserFullName();
        McSession mcSession = mcService.retrieveMcSession(toolSessionId);
        McQueUsr mcQueUsr = new McQueUsr(queUsrId, username, fullname, mcSession, new TreeSet());
        mcService.createMcQueUsr(mcQueUsr);
        logger.debug((Object)("created mcQueUsr in the db: " + mcQueUsr));
        return mcQueUsr;
    }

    public static void createLearnerAttempt(HttpServletRequest request, McQueUsr mcQueUsr, List selectedQuestionAndCandidateAnswersDTO, int mark, boolean passed, int highestAttemptOrder, Map mapLeanerAssessmentResults, IMcService mcService) {
        logger.debug((Object)"starting createLearnerAttempt: ");
        Date attempTime = McUtils.getGMTDateTime();
        for (McLearnerAnswersDTO mcLearnerAnswersDTO : selectedQuestionAndCandidateAnswersDTO) {
            logger.debug((Object)("mcLearnerAnswersDTO: " + mcLearnerAnswersDTO));
            String questionUid = mcLearnerAnswersDTO.getQuestionUid();
            logger.debug((Object)("questionUid: " + questionUid));
            McQueContent mcQueContent = mcService.findMcQuestionContentByUid(new Long(questionUid));
            logger.debug((Object)("mcQueContent: " + mcQueContent));
            Map candidateAnswers = mcLearnerAnswersDTO.getCandidateAnswers();
            logger.debug((Object)("candidateAnswers: " + candidateAnswers));
            String isAttemptCorrect = mcLearnerAnswersDTO.getAttemptCorrect();
            logger.debug((Object)("isAttemptCorrect: " + isAttemptCorrect));
            logger.debug((Object)"requesting  createIndividualOptions");
            LearningUtil.createIndividualOptions(request, candidateAnswers, mcQueContent, mcQueUsr, attempTime, mark, passed, new Integer(highestAttemptOrder), isAttemptCorrect, mcService);
        }
    }

    public static void createIndividualOptions(HttpServletRequest request, Map candidateAnswers, McQueContent mcQueContent, McQueUsr mcQueUsr, Date attempTime, int mark, boolean passed, Integer highestAttemptOrder, String isAttemptCorrect, IMcService mcService) {
        logger.debug((Object)"starting createIndividualOptions");
        Integer IntegerMark = new Integer(mark);
        logger.debug((Object)("createIndividualOptions-> isAttemptCorrect: " + isAttemptCorrect));
        logger.debug((Object)("mcQueContent: " + mcQueContent));
        logger.debug((Object)("candidateAnswers: " + candidateAnswers));
        logger.debug((Object)("highestAttemptOrder used : " + highestAttemptOrder));
        if (mcQueContent != null && candidateAnswers != null) {
            for (Map.Entry checkedPairs : candidateAnswers.entrySet()) {
                McOptsContent mcOptsContent = mcService.getOptionContentByOptionText(checkedPairs.getValue().toString(), mcQueContent.getUid());
                logger.debug((Object)("mcOptsContent: " + mcOptsContent));
                if (mcOptsContent == null) continue;
                McUsrAttempt mcUsrAttempt = new McUsrAttempt(attempTime, mcQueContent, mcQueUsr, mcOptsContent, IntegerMark, passed, highestAttemptOrder, new Boolean(isAttemptCorrect));
                mcService.createMcUsrAttempt(mcUsrAttempt);
                logger.debug((Object)("created mcUsrAttempt in the db :" + mcUsrAttempt));
            }
        }
    }

    public static Map buildMarksMap(HttpServletRequest request, Long toolContentId, IMcService mcService) {
        logger.debug((Object)("starting buildMarksMap : " + toolContentId));
        TreeMap<String, String> mapMarks = new TreeMap<String, String>(new McComparator());
        McContent mcContent = mcService.retrieveMc(toolContentId);
        logger.debug((Object)("mcContent : " + mcContent));
        List questionsContent = mcService.refreshQuestionContent(mcContent.getUid());
        logger.debug((Object)("questionsContent : " + questionsContent));
        Iterator listIterator = questionsContent.iterator();
        Long mapIndex = new Long(1L);
        while (listIterator.hasNext()) {
            McQueContent mcQueContent = (McQueContent)listIterator.next();
            logger.debug((Object)("mcQueContent : " + mcQueContent));
            mapMarks.put(mapIndex.toString(), mcQueContent.getMark().toString());
            mapIndex = new Long(mapIndex + 1L);
        }
        logger.debug((Object)("mapMarks : " + mapMarks));
        return mapMarks;
    }

    public static McGeneralLearnerFlowDTO buildMcGeneralLearnerFlowDTO(McContent mcContent) {
        logger.debug((Object)("starting buildMcGeneralLearnerFlowDTO: " + mcContent));
        McGeneralLearnerFlowDTO mcGeneralLearnerFlowDTO = new McGeneralLearnerFlowDTO();
        mcGeneralLearnerFlowDTO.setRetries(new Boolean(mcContent.isRetries()).toString());
        mcGeneralLearnerFlowDTO.setActivityTitle(mcContent.getTitle());
        mcGeneralLearnerFlowDTO.setActivityInstructions(mcContent.getInstructions());
        mcGeneralLearnerFlowDTO.setPassMark(mcContent.getPassMark().toString());
        mcGeneralLearnerFlowDTO.setReportTitleLearner("Report");
        mcGeneralLearnerFlowDTO.setLearnerProgress(new Boolean(false).toString());
        if (mcContent.isQuestionsSequenced()) {
            mcGeneralLearnerFlowDTO.setQuestionListingMode("questionListingModeSequential");
        } else {
            mcGeneralLearnerFlowDTO.setQuestionListingMode("questionListingModeCombined");
        }
        logger.debug((Object)("continue buildMcGeneralLearnerFlowDTO: " + mcContent));
        mcGeneralLearnerFlowDTO.setTotalQuestionCount(new Integer(mcContent.getMcQueContents().size()).toString());
        logger.debug((Object)("final mcGeneralLearnerFlowDTO: " + mcGeneralLearnerFlowDTO));
        return mcGeneralLearnerFlowDTO;
    }

    public static McRandomizedListsDTO randomizeList(List listCandidateAnswers, List listCandidateAnswerUids) {
        logger.debug((Object)("starting randomizeList: " + listCandidateAnswers));
        logger.debug((Object)("using listCandidateAnswerUids: " + listCandidateAnswerUids));
        McRandomizedListsDTO mcRandomizedListsDTO = new McRandomizedListsDTO();
        int caCount = listCandidateAnswers.size();
        logger.debug((Object)("caCount: " + caCount));
        Random generator = new Random();
        boolean listNotComplete = true;
        int randomInt = 0;
        LinkedList<String> randomList = new LinkedList<String>();
        LinkedList<String> randomUidList = new LinkedList<String>();
        while (listNotComplete) {
            randomInt = generator.nextInt(caCount);
            logger.debug((Object)("randomInt: " + randomInt));
            String ca = (String)listCandidateAnswers.get(randomInt);
            logger.debug((Object)("ca: " + ca));
            String caUid = (String)listCandidateAnswerUids.get(randomInt);
            if (LearningUtil.isEntryStored(ca, randomList)) continue;
            logger.debug((Object)("adding ca, since it is a new candidate, ca: " + ca));
            randomList.add(ca);
            randomUidList.add(caUid);
            logger.debug((Object)("randomList size: " + randomList.size()));
            if (randomList.size() != listCandidateAnswers.size()) continue;
            logger.debug((Object)("the list is populated completely, randomList: " + randomList));
            listNotComplete = false;
        }
        listCandidateAnswerUids = randomUidList;
        logger.debug((Object)("modified listCandidateAnswerUids as: " + listCandidateAnswerUids));
        mcRandomizedListsDTO.setListCandidateAnswers(randomList);
        mcRandomizedListsDTO.setListCandidateAnswerUids(listCandidateAnswerUids);
        logger.debug((Object)("returning mcRandomizedListsDTO: " + mcRandomizedListsDTO));
        return mcRandomizedListsDTO;
    }

    public static boolean isEntryStored(String ca, List randomList) {
        logger.debug((Object)("isEntryStored, randomList: " + randomList));
        logger.debug((Object)("isEntryStored, ca: " + ca));
        for (String caStored : randomList) {
            logger.debug((Object)("caStored: " + caStored));
            if (!caStored.equals(ca)) continue;
            logger.debug((Object)("this ca already is stored: " + ca));
            return true;
        }
        return false;
    }

    public static List buildQuestionAndCandidateAnswersDTO(HttpServletRequest request, McContent mcContent, boolean randomize, IMcService mcService) {
        logger.debug((Object)("starting buildQuestionAndCandidateAnswersDTO, randomize: " + randomize));
        LinkedList<McLearnerAnswersDTO> questionAndCandidateAnswersList = new LinkedList<McLearnerAnswersDTO>();
        logger.debug((Object)("mcContent uid : " + mcContent.getUid()));
        List listQuestionEntries = mcService.getAllQuestionEntries(mcContent.getUid());
        logger.debug((Object)("listQuestionEntries : " + listQuestionEntries));
        for (McQueContent mcQueContent : listQuestionEntries) {
            logger.debug((Object)("mcQueContent : " + mcQueContent));
            McLearnerAnswersDTO mcLearnerAnswersDTO = new McLearnerAnswersDTO();
            logger.debug((Object)("mcQueContent uid: " + mcQueContent.getUid()));
            List listCandidateAnswers = mcService.findMcOptionNamesByQueId(mcQueContent.getUid());
            logger.debug((Object)("pre randomize check, listCandidateAnswers: " + listCandidateAnswers));
            List listCandidateAnswerUids = mcService.findMcOptionUidsByQueId(mcQueContent.getUid());
            logger.debug((Object)("listCandidateAnswerUids: " + listCandidateAnswerUids));
            logger.debug((Object)("randomize check: " + randomize));
            if (randomize) {
                logger.debug((Object)"since randomize is on randomizing the list");
                McRandomizedListsDTO mcRandomizedListsDTO = LearningUtil.randomizeList(listCandidateAnswers, listCandidateAnswerUids);
                logger.debug((Object)("mcRandomizedListsDTO: " + mcRandomizedListsDTO));
                listCandidateAnswers = mcRandomizedListsDTO.getListCandidateAnswers();
                listCandidateAnswerUids = mcRandomizedListsDTO.getListCandidateAnswerUids();
            }
            logger.debug((Object)("post randomize check, listCandidateAnswers: " + listCandidateAnswers));
            logger.debug((Object)("post randomize check, listCandidateAnswerUids: " + listCandidateAnswerUids));
            logger.debug((Object)("listCandidateAnswers: " + listCandidateAnswers));
            Map mapCandidateAnswers = LearningUtil.convertToStringMap(listCandidateAnswers);
            logger.debug((Object)("mapCandidateAnswers: " + mapCandidateAnswers));
            Map mapCandidateAnswerUids = LearningUtil.convertToStringMap(listCandidateAnswerUids);
            logger.debug((Object)("mapCandidateAnswerUids: " + mapCandidateAnswerUids));
            String question = mcQueContent.getQuestion();
            logger.debug((Object)("question: " + question));
            mcLearnerAnswersDTO.setQuestion(question);
            mcLearnerAnswersDTO.setDisplayOrder(mcQueContent.getDisplayOrder().toString());
            mcLearnerAnswersDTO.setQuestionUid(mcQueContent.getUid().toString());
            mcLearnerAnswersDTO.setMark(mcQueContent.getMark().toString());
            mcLearnerAnswersDTO.setCandidateAnswerUids(mapCandidateAnswerUids);
            mcLearnerAnswersDTO.setCandidateAnswers(mapCandidateAnswers);
            logger.debug((Object)("current mcLearnerAnswersDTO: " + mcLearnerAnswersDTO));
            logger.debug((Object)("current mcLearnerAnswersDTO: " + mcLearnerAnswersDTO));
            questionAndCandidateAnswersList.add(mcLearnerAnswersDTO);
        }
        logger.debug((Object)("final questionAndCandidateAnswersList: " + questionAndCandidateAnswersList));
        return questionAndCandidateAnswersList;
    }

    public static Map convertToStringMap(List list) {
        logger.debug((Object)("using convertToStringMap: " + list));
        TreeMap<String, String> map = new TreeMap<String, String>(new McComparator());
        Iterator listIterator = list.iterator();
        Long mapIndex = new Long(1L);
        while (listIterator.hasNext()) {
            String data = (String)listIterator.next();
            map.put(mapIndex.toString(), data);
            mapIndex = new Long(mapIndex + 1L);
        }
        return map;
    }

    public static int getLearnerMarkAtLeast(Integer passMark, Map mapQuestionWeights) {
        logger.debug((Object)"doing getLearnerMarkAtLeast");
        logger.debug((Object)("passMark:" + passMark));
        logger.debug((Object)("mapQuestionWeights:" + mapQuestionWeights));
        if (passMark == null || passMark == 0) {
            logger.debug((Object)"no passMark..");
            return 0;
        }
        if (passMark != null && passMark != 0) {
            int minimumQuestionCountToPass = LearningUtil.calculateMinimumQuestionCountToPass(passMark, mapQuestionWeights);
            logger.debug((Object)("minimumQuestionCountToPass: " + minimumQuestionCountToPass));
            return minimumQuestionCountToPass;
        }
        return 0;
    }

    public static int getMarksBasedLearnerMarkAtLeast(Integer passMark, Map mapQuestionMarks) {
        logger.debug((Object)("doing getMarksBasedLearnerMarkAtLeast: " + mapQuestionMarks));
        logger.debug((Object)("passMark:" + passMark));
        logger.debug((Object)("mapQuestionMarks:" + mapQuestionMarks));
        if (passMark == null || passMark == 0) {
            logger.debug((Object)"no passMark..");
            return 0;
        }
        if (passMark != null && passMark != 0) {
            int minimumQuestionCountToPass = LearningUtil.calculateMarksBasedMinimumQuestionCountToPass(passMark, mapQuestionMarks);
            logger.debug((Object)("minimumQuestionCountToPass: " + minimumQuestionCountToPass));
            return minimumQuestionCountToPass;
        }
        return 0;
    }

    public static int calculateMinimumQuestionCountToPass(Integer passMark, Map mapQuestionWeights) {
        logger.debug((Object)("calculating minimumQuestionCountToPass: mapQuestionWeights: " + mapQuestionWeights + " passmark: " + passMark));
        logger.debug((Object)("passMark: " + passMark));
        logger.debug((Object)("original mapQuestionWeights: " + mapQuestionWeights));
        boolean mapExcluded = false;
        int minimumQuestionCount = 0;
        int totalHighestWeights = 0;
        while (totalHighestWeights <= passMark) {
            logger.debug((Object)("totalHighestWeights versus passMark: " + totalHighestWeights + " versus" + passMark));
            int highestWeight = LearningUtil.getHighestWeight(mapQuestionWeights, mapExcluded);
            logger.debug((Object)("highestWeight: " + highestWeight));
            logger.debug((Object)("totalHighestWeights: " + (totalHighestWeights += highestWeight)));
            mapQuestionWeights = LearningUtil.rebuildWeightsMapExcludeHighestWeight(mapQuestionWeights, highestWeight);
            mapExcluded = true;
            logger.debug((Object)("mapQuestionWeights: " + mapQuestionWeights));
            ++minimumQuestionCount;
            if (mapQuestionWeights.size() != 0) continue;
            logger.debug((Object)"no more weights: ");
            break;
        }
        logger.debug((Object)("returning minimumQuestionCount: " + minimumQuestionCount));
        return minimumQuestionCount;
    }

    public static int calculateMarksBasedMinimumQuestionCountToPass(Integer passMark, Map mapQuestionMarks) {
        logger.debug((Object)("calculating minimumQuestionCountToPass: mapQuestionMarks: " + mapQuestionMarks + " passmark: " + passMark));
        logger.debug((Object)("passMark: " + passMark));
        logger.debug((Object)("original mapQuestionMarks: " + mapQuestionMarks));
        boolean mapExcluded = false;
        int minimumQuestionCount = 0;
        int totalHighestMarks = 0;
        while (totalHighestMarks <= passMark) {
            logger.debug((Object)("totalHighestMarks versus passMark: " + totalHighestMarks + " versus" + passMark));
            int highestWeight = LearningUtil.getHighestMark(mapQuestionMarks, mapExcluded);
            logger.debug((Object)("highestWeight: " + highestWeight));
            logger.debug((Object)("totalHighestMarks: " + (totalHighestMarks += highestWeight)));
            mapQuestionMarks = LearningUtil.rebuildWeightsMapExcludeHighestWeight(mapQuestionMarks, highestWeight);
            mapExcluded = true;
            logger.debug((Object)("mapQuestionMarks: " + mapQuestionMarks));
            ++minimumQuestionCount;
            if (mapQuestionMarks.size() != 0) continue;
            logger.debug((Object)"no more marks: ");
            break;
        }
        logger.debug((Object)("returning minimumQuestionCount: " + minimumQuestionCount));
        return minimumQuestionCount;
    }

    public static int getHighestMark(Map mapQuestionMarks, boolean mapExcluded) {
        logger.debug((Object)("mapExcluded: " + mapExcluded));
        if (mapQuestionMarks.size() == 1 && !mapExcluded) {
            logger.debug((Object)"using map with 1 question only");
            return 100;
        }
        logger.debug((Object)"continue excluding map");
        Iterator itMap = mapQuestionMarks.entrySet().iterator();
        int highestMark = 0;
        while (itMap.hasNext()) {
            Map.Entry pair = itMap.next();
            String mark = pair.getValue().toString();
            int intMark = new Integer(mark);
            if (intMark <= highestMark) continue;
            highestMark = intMark;
        }
        return highestMark;
    }

    public static int getHighestWeight(Map mapQuestionWeights, boolean mapExcluded) {
        logger.debug((Object)("mapExcluded: " + mapExcluded));
        if (mapQuestionWeights.size() == 1 && !mapExcluded) {
            logger.debug((Object)"using map with 1 question only");
            return 100;
        }
        logger.debug((Object)"continue excluding map");
        Iterator itMap = mapQuestionWeights.entrySet().iterator();
        int highestWeight = 0;
        while (itMap.hasNext()) {
            Map.Entry pair = itMap.next();
            String weight = pair.getValue().toString();
            int intWeight = new Integer(weight);
            if (intWeight <= highestWeight) continue;
            highestWeight = intWeight;
        }
        return highestWeight;
    }

    public static Map rebuildWeightsMapExcludeHighestWeight(Map mapQuestionWeights, int highestWeight) {
        logger.debug((Object)("doing rebuildWeightsMapExcludeHighestWeight: " + mapQuestionWeights));
        logger.debug((Object)("doing highestWeight: " + highestWeight));
        TreeMap<String, String> mapWeightsExcludeHighestWeight = new TreeMap<String, String>(new McComparator());
        Iterator itMap = mapQuestionWeights.entrySet().iterator();
        Long mapIndex = new Long(1L);
        while (itMap.hasNext()) {
            Map.Entry pair = itMap.next();
            String weight = pair.getValue().toString();
            int intWeight = new Integer(weight);
            logger.debug((Object)("intWeight: " + intWeight));
            logger.debug((Object)("intWeight versus highestWeight:" + intWeight + " versus" + highestWeight));
            if (intWeight != highestWeight) {
                mapWeightsExcludeHighestWeight.put(mapIndex.toString(), weight);
                mapIndex = new Long(mapIndex + 1L);
                continue;
            }
            logger.debug((Object)("excluding highest weight from the reconstructed map: " + intWeight));
        }
        logger.debug((Object)("returning mapWeightsExcludeHighestWeight: " + mapWeightsExcludeHighestWeight));
        return mapWeightsExcludeHighestWeight;
    }

    public static Map rebuildMarksMapExcludeHighestMark(Map mapQuestionMarks, int highestMark) {
        logger.debug((Object)("doing rebuildMarksMapExcludeHighestMark: " + mapQuestionMarks));
        logger.debug((Object)("using highestMark: " + highestMark));
        TreeMap<String, String> mapMarksExcludeHighestMark = new TreeMap<String, String>(new McComparator());
        Iterator itMap = mapQuestionMarks.entrySet().iterator();
        Long mapIndex = new Long(1L);
        while (itMap.hasNext()) {
            Map.Entry pair = itMap.next();
            String mark = pair.getValue().toString();
            int intMark = new Integer(mark);
            logger.debug((Object)("intMark: " + intMark));
            logger.debug((Object)("intMark versus highestMark:" + intMark + " versus" + highestMark));
            if (intMark != highestMark) {
                mapMarksExcludeHighestMark.put(mapIndex.toString(), mark);
                mapIndex = new Long(mapIndex + 1L);
                continue;
            }
            logger.debug((Object)("excluding highest weight from the reconstructed map: " + intMark));
        }
        logger.debug((Object)("returning mapWeightsExcludeHighestWeight: " + mapMarksExcludeHighestMark));
        return mapMarksExcludeHighestMark;
    }

    public static boolean isTextMarkup(String text) {
        logger.debug((Object)("starting isTextMarkup: " + text));
        int markupSignPos = text.indexOf("<");
        logger.debug((Object)("markupSignPos: " + markupSignPos));
        int markupSignPos2 = text.indexOf(">");
        logger.debug((Object)("markupSignPos2: " + markupSignPos2));
        if (markupSignPos != -1 && markupSignPos2 != -1) {
            logger.debug((Object)("text has markup in it: " + text));
            return true;
        }
        return false;
    }
}

