/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.web;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.mc.EditActivityDTO;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McCandidateAnswersDTO;
import org.lamsfoundation.lams.tool.mc.McComparator;
import org.lamsfoundation.lams.tool.mc.McGeneralAuthoringDTO;
import org.lamsfoundation.lams.tool.mc.McQuestionContentDTO;
import org.lamsfoundation.lams.tool.mc.McUtils;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McUploadedFile;
import org.lamsfoundation.lams.tool.mc.service.IMcService;
import org.lamsfoundation.lams.tool.mc.service.McServiceProxy;
import org.lamsfoundation.lams.tool.mc.util.McToolContentHandler;
import org.lamsfoundation.lams.tool.mc.web.AuthoringUtil;
import org.lamsfoundation.lams.tool.mc.web.McAuthoringForm;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class McAction
extends LamsDispatchAction
implements McAppConstants {
    static Logger logger = Logger.getLogger((String)McAction.class.getName());
    private McToolContentHandler toolContentHandler;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("load");
    }

    public ActionForward submitAllContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)("dispathcing submitAllContent :" + form));
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        Map mapQuestionContent = AuthoringUtil.extractMapQuestionContent(listQuestionContentDTO);
        logger.debug((Object)("extracted mapQuestionContent: " + mapQuestionContent));
        Map mapFeedback = AuthoringUtil.extractMapFeedback(listQuestionContentDTO);
        logger.debug((Object)("extracted mapFeedback: " + mapFeedback));
        TreeMap mapWeights = new TreeMap(new McComparator());
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        Map mapMarks = AuthoringUtil.extractMapMarks(listQuestionContentDTO);
        logger.debug((Object)("extracted mapMarks: " + mapMarks));
        Map mapCandidatesList = AuthoringUtil.extractMapCandidatesList(listQuestionContentDTO);
        logger.debug((Object)("extracted mapCandidatesList: " + mapCandidatesList));
        ActionMessages errors = new ActionMessages();
        logger.debug((Object)("mapQuestionContent size: " + mapQuestionContent.size()));
        if (mapQuestionContent.size() == 0) {
            ActionMessage error = new ActionMessage("questions.none.submitted");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        logger.debug((Object)("errors: " + errors));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            List attachmentListBackup = new ArrayList();
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            attachmentListBackup = attachmentList;
            List deletedAttachmentListBackup = new ArrayList();
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            deletedAttachmentListBackup = deletedAttachmentList;
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOfflineInstructions));
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
        }
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        mcGeneralAuthoringDTO.setMapQuestionContent(mapQuestionContent);
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        logger.debug((Object)("mcGeneralAuthoringDTO now: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        logger.debug((Object)"there are no issues with input, continue and submit data");
        McContent mcContentTest = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContentTest: " + mcContentTest));
        logger.debug((Object)("errors: " + errors));
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        McContent mcContent = mcContentTest;
        if (errors.isEmpty()) {
            logger.debug((Object)("errors is empty: " + errors));
            authoringUtil.removeRedundantQuestions(mapQuestionContent, mcService, mcAuthoringForm, request, strToolContentID);
            logger.debug((Object)"end of removing unused entries... ");
            mcContent = authoringUtil.saveOrUpdateMcContent(mapQuestionContent, mapFeedback, mapWeights, mapMarks, mapCandidatesList, mcService, mcAuthoringForm, request, mcContentTest, strToolContentID);
            logger.debug((Object)("mcContent: " + mcContent));
            long defaultContentID = 0L;
            logger.debug((Object)"attempt retrieving tool with signatute : lamc11");
            defaultContentID = mcService.getToolDefaultContentIdBySignature("lamc11");
            logger.debug((Object)("retrieved tool default contentId: " + defaultContentID));
            if (mcContent != null) {
                mcGeneralAuthoringDTO.setDefaultContentIdStr(new Long(defaultContentID).toString());
            }
            logger.debug((Object)("updated mcGeneralAuthoringDTO to: " + mcGeneralAuthoringDTO));
            authoringUtil.reOrganizeDisplayOrder(mapQuestionContent, mcService, mcAuthoringForm, mcContent);
            logger.debug((Object)("post reOrganizeDisplayOrder: " + mcContent));
            logger.debug((Object)("activeModule: " + activeModule));
            if (activeModule.equals("authoring")) {
                List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
                logger.debug((Object)("attachmentList: " + attachmentList));
                List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
                List attachments = this.saveAttachments(mcContent, attachmentList, deletedAttachmentList, mapping, request);
                logger.debug((Object)("attachments: " + attachments));
            }
            logger.debug((Object)("strToolContentID: " + strToolContentID));
            McUtils.setDefineLater(request, false, strToolContentID, mcService);
            logger.debug((Object)"define later set to false");
            McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
            if (activeModule.equals("authoring")) {
                logger.debug((Object)"standard authoring close");
                request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
                mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
            } else {
                logger.debug((Object)"go back to view only screen");
                mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(false).toString());
            }
        } else {
            logger.debug((Object)("errors is not empty: " + errors));
            if (mcContent != null) {
                long defaultContentID = 0L;
                logger.debug((Object)"attempt retrieving tool with signatute : lamc11");
                defaultContentID = mcService.getToolDefaultContentIdBySignature("lamc11");
                logger.debug((Object)("retrieved tool default contentId: " + defaultContentID));
                if (mcContent != null) {
                    mcGeneralAuthoringDTO.setDefaultContentIdStr(new Long(defaultContentID).toString());
                }
                McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
            }
        }
        mcGeneralAuthoringDTO.setSbmtSuccess(new Integer(1).toString());
        mcAuthoringForm.resetUserAction();
        mcGeneralAuthoringDTO.setMapQuestionContent(mapQuestionContent);
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        logger.debug((Object)"forwarding to :load");
        return mapping.findForward("load");
    }

    public ActionForward saveSingleQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionMessage error;
        logger.debug((Object)"dispathcing saveSingleQuestion");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        String passmark = request.getParameter("passmark");
        logger.debug((Object)("passmark: " + passmark));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        boolean validateCandidateAnswersNotBlank = authoringUtil.validateCandidateAnswersNotBlank(request);
        logger.debug((Object)("validateCandidateAnswersNotBlank: " + validateCandidateAnswersNotBlank));
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        caList = AuthoringUtil.removeBlankEntries(caList);
        logger.debug((Object)("caList after removing blank entries: " + caList));
        boolean validateSingleCorrectCandidate = authoringUtil.validateSingleCorrectCandidate(caList);
        logger.debug((Object)("validateSingleCorrectCandidate: " + validateSingleCorrectCandidate));
        boolean validateOnlyOneCorrectCandidate = authoringUtil.validateOnlyOneCorrectCandidate(caList);
        logger.debug((Object)("validateOnlyOneCorrectCandidate: " + validateOnlyOneCorrectCandidate));
        ActionMessages errors = new ActionMessages();
        if (!validateCandidateAnswersNotBlank) {
            error = new ActionMessage("candidates.blank");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!validateSingleCorrectCandidate) {
            error = new ActionMessage("candidates.none.correct");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!validateOnlyOneCorrectCandidate) {
            error = new ActionMessage("candidates.duplicate.correct");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        logger.debug((Object)("errors: " + errors));
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("entry using mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        mcGeneralAuthoringDTO.setPassMarkValue(passmark);
        if (errors.isEmpty()) {
            logger.debug((Object)("errors is empty: " + errors));
            McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
            logger.debug((Object)("mcContent: " + mcContent));
            logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
            mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
            mcGeneralAuthoringDTO.setSbmtSuccess(new Integer(0).toString());
            String newQuestion = request.getParameter("newQuestion");
            logger.debug((Object)("newQuestion: " + newQuestion));
            String feedback = request.getParameter("feedback");
            logger.debug((Object)("feedback: " + feedback));
            String editableQuestionIndex = request.getParameter("editableQuestionIndex");
            logger.debug((Object)("editableQuestionIndex: " + editableQuestionIndex));
            mcAuthoringForm.setQuestionIndex(editableQuestionIndex);
            if (newQuestion != null && newQuestion.length() > 0) {
                if (editQuestionBoxRequest != null && editQuestionBoxRequest.equals("false")) {
                    logger.debug((Object)"request for add and save");
                    boolean duplicates = AuthoringUtil.checkDuplicateQuestions(listQuestionContentDTO, newQuestion);
                    logger.debug((Object)("duplicates: " + duplicates));
                    if (!duplicates) {
                        McQuestionContentDTO mcQuestionContentDTO2 = null;
                        for (McQuestionContentDTO mcQuestionContentDTO2 : listQuestionContentDTO) {
                            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO2));
                            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO2.getQuestion()));
                            String question = mcQuestionContentDTO2.getQuestion();
                            String displayOrder = mcQuestionContentDTO2.getDisplayOrder();
                            logger.debug((Object)("displayOrder:" + displayOrder));
                            if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(editableQuestionIndex)) continue;
                            break;
                        }
                        logger.debug((Object)("mcQuestionContentDTO found:" + mcQuestionContentDTO2));
                        mcQuestionContentDTO2.setQuestion(newQuestion);
                        mcQuestionContentDTO2.setFeedback(feedback);
                        mcQuestionContentDTO2.setDisplayOrder(editableQuestionIndex);
                        mcQuestionContentDTO2.setListCandidateAnswersDTO(caList);
                        mcQuestionContentDTO2.setMark(mark);
                        logger.debug((Object)("caList size:" + mcQuestionContentDTO2.getListCandidateAnswersDTO().size()));
                        mcQuestionContentDTO2.setCaCount(new Integer(mcQuestionContentDTO2.getListCandidateAnswersDTO().size()).toString());
                        listQuestionContentDTO = AuthoringUtil.reorderUpdateListQuestionContentDTO(listQuestionContentDTO, mcQuestionContentDTO2, editableQuestionIndex);
                        logger.debug((Object)("post reorderUpdateListQuestionContentDTO listQuestionContentDTO: " + listQuestionContentDTO));
                    } else {
                        logger.debug((Object)"duplicate question entry, not adding");
                    }
                } else {
                    logger.debug((Object)"request for edit and save.");
                    McQuestionContentDTO mcQuestionContentDTO3 = null;
                    for (McQuestionContentDTO mcQuestionContentDTO3 : listQuestionContentDTO) {
                        logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO3));
                        logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO3.getQuestion()));
                        String question = mcQuestionContentDTO3.getQuestion();
                        String displayOrder = mcQuestionContentDTO3.getDisplayOrder();
                        logger.debug((Object)("displayOrder:" + displayOrder));
                        if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(editableQuestionIndex)) continue;
                        break;
                    }
                    logger.debug((Object)("mcQuestionContentDTO found:" + mcQuestionContentDTO3));
                    mcQuestionContentDTO3.setQuestion(newQuestion);
                    mcQuestionContentDTO3.setFeedback(feedback);
                    mcQuestionContentDTO3.setDisplayOrder(editableQuestionIndex);
                    mcQuestionContentDTO3.setListCandidateAnswersDTO(caList);
                    mcQuestionContentDTO3.setMark(mark);
                    logger.debug((Object)("caList size:" + mcQuestionContentDTO3.getListCandidateAnswersDTO().size()));
                    mcQuestionContentDTO3.setCaCount(new Integer(mcQuestionContentDTO3.getListCandidateAnswersDTO().size()).toString());
                    listQuestionContentDTO = AuthoringUtil.reorderUpdateListQuestionContentDTO(listQuestionContentDTO, mcQuestionContentDTO3, editableQuestionIndex);
                    logger.debug((Object)("post reorderUpdateListQuestionContentDTO listQuestionContentDTO: " + listQuestionContentDTO));
                }
            } else {
                logger.debug((Object)"entry blank, not adding");
            }
            logger.debug((Object)("entryusing mark: " + mark));
            mcGeneralAuthoringDTO.setMarkValue(mark);
            request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
            sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
            logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
            this.commonSaveCode(request, mcGeneralAuthoringDTO, mcAuthoringForm, sessionMap, activeModule, strToolContentID, defaultContentIdStr, mcService, httpSessionID, listQuestionContentDTO);
            request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
            logger.debug((Object)"fwd ing to LOAD_QUESTIONS: load");
            return mapping.findForward("load");
        }
        logger.debug((Object)("errors is not empty: " + errors));
        this.commonSaveCode(request, mcGeneralAuthoringDTO, mcAuthoringForm, sessionMap, activeModule, strToolContentID, defaultContentIdStr, mcService, httpSessionID, listQuestionContentDTO);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        request.setAttribute("requestNewEditableQuestionBox", (Object)new Boolean(true).toString());
        logger.debug((Object)"forwarding using newEditableQuestionBox");
        return this.newEditableQuestionBox(mapping, form, request, response);
    }

    protected void commonSaveCode(HttpServletRequest request, McGeneralAuthoringDTO mcGeneralAuthoringDTO, McAuthoringForm mcAuthoringForm, SessionMap sessionMap, String activeModule, String strToolContentID, String defaultContentIdStr, IMcService mcService, String httpSessionID, List listQuestionContentDTO) {
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOfflineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        AuthoringUtil authoringUtil = new AuthoringUtil();
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("mcGeneralAuthoringDTO now: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        logger.debug((Object)("sessionMap: " + sessionMap));
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        logger.debug((Object)("mcGeneralAuthoringDTO.getMapQuestionContent(); " + mcGeneralAuthoringDTO.getMapQuestionContent()));
    }

    public ActionForward addSingleQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionMessage error;
        logger.debug((Object)"dispathcing addSingleQuestion");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setSbmtSuccess(new Integer(0).toString());
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        Object mcQuestionContentDTONew = null;
        int listSize = listQuestionContentDTO.size();
        logger.debug((Object)("listSize: " + listSize));
        logger.debug((Object)("listAddableQuestionContentDTO now: " + listAddableQuestionContentDTO));
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        String passmark = request.getParameter("passmark");
        logger.debug((Object)("passmark: " + passmark));
        mcGeneralAuthoringDTO.setPassMarkValue(passmark);
        boolean validateCandidateAnswersNotBlank = authoringUtil.validateCandidateAnswersNotBlank(request);
        logger.debug((Object)("validateCandidateAnswersNotBlank: " + validateCandidateAnswersNotBlank));
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        caList = AuthoringUtil.removeBlankEntries(caList);
        logger.debug((Object)("caList after removing blank entries: " + caList));
        boolean validateSingleCorrectCandidate = authoringUtil.validateSingleCorrectCandidate(caList);
        logger.debug((Object)("validateSingleCorrectCandidate: " + validateSingleCorrectCandidate));
        boolean validateOnlyOneCorrectCandidate = authoringUtil.validateOnlyOneCorrectCandidate(caList);
        logger.debug((Object)("validateOnlyOneCorrectCandidate: " + validateOnlyOneCorrectCandidate));
        ActionMessages errors = new ActionMessages();
        if (!validateCandidateAnswersNotBlank) {
            error = new ActionMessage("candidates.blank");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!validateSingleCorrectCandidate) {
            error = new ActionMessage("candidates.none.correct");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!validateOnlyOneCorrectCandidate) {
            error = new ActionMessage("candidates.duplicate.correct");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        logger.debug((Object)("errors: " + errors));
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        logger.debug((Object)("errors saved: " + errors));
        if (errors.isEmpty()) {
            if (newQuestion != null && newQuestion.length() > 0) {
                boolean duplicates = AuthoringUtil.checkDuplicateQuestions(listQuestionContentDTO, newQuestion);
                logger.debug((Object)("duplicates: " + duplicates));
                if (!duplicates) {
                    McQuestionContentDTO mcQuestionContentDTO = new McQuestionContentDTO();
                    mcQuestionContentDTO.setDisplayOrder(new Long(listSize + 1).toString());
                    mcQuestionContentDTO.setFeedback(feedback);
                    mcQuestionContentDTO.setQuestion(newQuestion);
                    mcQuestionContentDTO.setMark(mark);
                    mcQuestionContentDTO.setListCandidateAnswersDTO(caList);
                    logger.debug((Object)("caList size:" + mcQuestionContentDTO.getListCandidateAnswersDTO().size()));
                    mcQuestionContentDTO.setCaCount(new Integer(mcQuestionContentDTO.getListCandidateAnswersDTO().size()).toString());
                    listQuestionContentDTO.add(mcQuestionContentDTO);
                    logger.debug((Object)("updated listQuestionContentDTO: " + listQuestionContentDTO));
                } else {
                    logger.debug((Object)"entry duplicate, not adding");
                }
            } else {
                logger.debug((Object)"entry blank, not adding");
            }
        } else {
            logger.debug((Object)"errors, not adding");
            logger.debug((Object)("errors is not empty: " + errors));
            this.commonSaveCode(request, mcGeneralAuthoringDTO, mcAuthoringForm, sessionMap, activeModule, strToolContentID, defaultContentIdStr, mcService, httpSessionID, listQuestionContentDTO);
            logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
            Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
            logger.debug((Object)("passMarksMap: " + passMarksMap));
            mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
            String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
            logger.debug((Object)("totalMark: " + totalMark));
            mcAuthoringForm.setTotalMarks(totalMark);
            mcGeneralAuthoringDTO.setTotalMarks(totalMark);
            logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
            request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
            request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
            sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
            logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
            logger.debug((Object)"forwarding using newQuestionBox");
            return this.newQuestionBox(mapping, form, request, response);
        }
        logger.debug((Object)("entry using mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        this.commonSaveCode(request, mcGeneralAuthoringDTO, mcAuthoringForm, sessionMap, activeModule, strToolContentID, defaultContentIdStr, mcService, httpSessionID, listQuestionContentDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("before forwarding mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        logger.debug((Object)"fwd LOAD_QUESTIONS");
        return mapping.findForward("load");
    }

    public ActionForward newQuestionBox(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispathcing newQuestionBox");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(defaultContentIdStr));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        AuthoringUtil authoringUtil = new AuthoringUtil();
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("mcGeneralAuthoringDTO now: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        String requestType = request.getParameter("requestType");
        logger.debug((Object)("requestType: " + requestType));
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        if (requestType != null && requestType.equals("direct")) {
            logger.debug((Object)"requestType is direct");
            listAddableQuestionContentDTO = authoringUtil.buildDefaultQuestionContent(mcContent, mcService);
            logger.debug((Object)("listAddableQuestionContentDTO from db: " + listAddableQuestionContentDTO));
        }
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        sessionMap.put((Object)"newAddableQuestionContentKey", (Object)listAddableQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        logger.debug((Object)("final listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        logger.debug((Object)"fwd ing to newQuestionBox: ");
        return mapping.findForward("newQuestionBox");
    }

    public ActionForward newEditableQuestionBox(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispathcing newEditableQuestionBox");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        request.setAttribute("currentEditableQuestionIndex", (Object)questionIndex);
        mcAuthoringForm.setEditableQuestionIndex(questionIndex);
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        String editableQuestion = "";
        String editableFeedback = "";
        String editableMark = "";
        for (McQuestionContentDTO mcQuestionContentDTO : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
            String question = mcQuestionContentDTO.getQuestion();
            String displayOrder = mcQuestionContentDTO.getDisplayOrder();
            if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
            editableFeedback = mcQuestionContentDTO.getFeedback();
            editableQuestion = mcQuestionContentDTO.getQuestion();
            editableMark = mcQuestionContentDTO.getMark();
            logger.debug((Object)("editableFeedback found :" + editableFeedback));
            List candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
            logger.debug((Object)("candidates found :" + candidates));
            break;
        }
        logger.debug((Object)("editableFeedback found :" + editableFeedback));
        logger.debug((Object)("editableQuestion found :" + editableQuestion));
        logger.debug((Object)("editableMark found :" + editableMark));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = (McGeneralAuthoringDTO)request.getAttribute("mcGeneralAuthoringDTO");
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        if (mcGeneralAuthoringDTO == null) {
            mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        }
        mcGeneralAuthoringDTO.setMarkValue(editableMark);
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setEditableQuestionText(editableQuestion);
        mcGeneralAuthoringDTO.setEditableQuestionFeedback(editableFeedback);
        mcAuthoringForm.setFeedback(editableFeedback);
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        AuthoringUtil authoringUtil = new AuthoringUtil();
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("mcGeneralAuthoringDTO now: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        String requestNewEditableQuestionBox = (String)request.getAttribute("requestNewEditableQuestionBox");
        logger.debug((Object)("requestNewEditableQuestionBox: " + requestNewEditableQuestionBox));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        if (requestNewEditableQuestionBox != null && requestNewEditableQuestionBox.equals("true")) {
            mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
            String feedback = request.getParameter("feedback");
            logger.debug((Object)("feedback: " + feedback));
            mcAuthoringForm.setFeedback(feedback);
        }
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        logger.debug((Object)("final listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        logger.debug((Object)"fwd ing to editQuestionBox: ");
        return mapping.findForward("editQuestionBox");
    }

    public ActionForward removeQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching removeQuestion");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        McQuestionContentDTO mcQuestionContentDTO2 = null;
        for (McQuestionContentDTO mcQuestionContentDTO2 : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO2));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO2.getQuestion()));
            String question = mcQuestionContentDTO2.getQuestion();
            String displayOrder = mcQuestionContentDTO2.getDisplayOrder();
            logger.debug((Object)("displayOrder:" + displayOrder));
            if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
            break;
        }
        logger.debug((Object)("mcQuestionContentDTO found:" + mcQuestionContentDTO2));
        mcQuestionContentDTO2.setQuestion("");
        logger.debug((Object)("listQuestionContentDTO after remove:" + listQuestionContentDTO));
        listQuestionContentDTO = AuthoringUtil.reorderListQuestionContentDTO(listQuestionContentDTO, questionIndex);
        logger.debug((Object)("listQuestionContentDTO reordered:" + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        if (mcContent == null) {
            logger.debug((Object)("using defaultContentIdStr: " + defaultContentIdStr));
            mcContent = mcService.retrieveMc(new Long(defaultContentIdStr));
        }
        logger.debug((Object)("final mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        AuthoringUtil authoringUtil = new AuthoringUtil();
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("mcQuestionContentDTO now: " + mcQuestionContentDTO2));
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)"fwd ing to LOAD_QUESTIONS: load");
        return mapping.findForward("load");
    }

    public ActionForward moveQuestionDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveQuestionDown");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        listQuestionContentDTO = AuthoringUtil.swapNodes(listQuestionContentDTO, questionIndex, "down");
        logger.debug((Object)("listQuestionContentDTO after swap: " + listQuestionContentDTO));
        listQuestionContentDTO = AuthoringUtil.reorderSimpleListQuestionContentDTO(listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO after reordersimple: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        AuthoringUtil authoringUtil = new AuthoringUtil();
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)"fwd ing to LOAD_QUESTIONS: load");
        return mapping.findForward("load");
    }

    public ActionForward moveQuestionUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveQuestionUp");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        listQuestionContentDTO = AuthoringUtil.swapNodes(listQuestionContentDTO, questionIndex, "up");
        logger.debug((Object)("listQuestionContentDTO after swap: " + listQuestionContentDTO));
        listQuestionContentDTO = AuthoringUtil.reorderSimpleListQuestionContentDTO(listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO after reordersimple: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        AuthoringUtil authoringUtil = new AuthoringUtil();
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)"fwd ing to LOAD_QUESTIONS: load");
        return mapping.findForward("load");
    }

    public ActionForward addNewFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispathching addNewFile");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String onlineInstructions = request.getParameter("onlineInstructions");
        logger.debug((Object)("onlineInstructions: " + onlineInstructions));
        String offlineInstructions = request.getParameter("offlineInstructions");
        logger.debug((Object)("offlineInstructions: " + offlineInstructions));
        sessionMap.put((Object)"onlineInstructionsKey", (Object)onlineInstructions);
        sessionMap.put((Object)"offlineInstructions", (Object)offlineInstructions);
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
        mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
        mcGeneralAuthoringDTO.setSbmtSuccess(new Integer(0).toString());
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
        logger.debug((Object)("attachmentList: " + attachmentList));
        List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
        logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
        this.addFileToContentRepository(request, mcAuthoringForm, attachmentList, deletedAttachmentList, sessionMap, mcGeneralAuthoringDTO);
        logger.debug((Object)("post addFileToContentRepository, attachmentList: " + attachmentList));
        logger.debug((Object)("post addFileToContentRepository, deletedAttachmentList: " + deletedAttachmentList));
        sessionMap.put((Object)"attachmentListKey", (Object)attachmentList);
        sessionMap.put((Object)"deletedAttachmentListKey", (Object)deletedAttachmentList);
        mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        AuthoringUtil authoringUtil = new AuthoringUtil();
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        mcAuthoringForm.resetUserAction();
        String strOnlineInstructions = request.getParameter("onlineInstructions");
        String strOfflineInstructions = request.getParameter("offlineInstructions");
        logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
        logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
        mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
        mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)"fwd ing to LOAD_QUESTIONS: load");
        return mapping.findForward("load");
    }

    public ActionForward deleteFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching deleteFile");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setSbmtSuccess(new Integer(0).toString());
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
        logger.debug((Object)("onlineInstructions: " + onlineInstructions));
        String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
        logger.debug((Object)("offlineInstructions: " + offlineInstructions));
        mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
        mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
        mcAuthoringForm.setOnlineInstructions(onlineInstructions);
        mcAuthoringForm.setOfflineInstructions(offlineInstructions);
        String richTextTitle = (String)sessionMap.get((Object)"activityTitleKey");
        String richTextInstructions = (String)sessionMap.get((Object)"activityInstructionsKey");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        long uuid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uuid");
        ArrayList attachmentList = (ArrayList)sessionMap.get((Object)"attachmentListKey");
        logger.debug((Object)("attachmentList: " + attachmentList));
        if (attachmentList == null) {
            attachmentList = new ArrayList();
        }
        List deletedAttachmentList = (ArrayList)sessionMap.get((Object)"deletedAttachmentListKey");
        logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
        if (deletedAttachmentList == null) {
            deletedAttachmentList = new ArrayList();
        }
        deletedAttachmentList = McUtils.moveToDelete(Long.toString(uuid), attachmentList, deletedAttachmentList);
        sessionMap.put((Object)"attachmentListKey", attachmentList);
        sessionMap.put((Object)"deletedAttachmentListKey", deletedAttachmentList);
        mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        AuthoringUtil authoringUtil = new AuthoringUtil();
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        mcAuthoringForm.resetUserAction();
        logger.debug((Object)"fwd ing to LOAD_QUESTIONS: load");
        return mapping.findForward("load");
    }

    public void persistError(HttpServletRequest request, String message) {
        ActionMessages errors = new ActionMessages();
        errors.add("org.apache.struts.action.ERROR", new ActionMessage(message));
        logger.debug((Object)("add " + message + "  to ActionMessages:"));
        this.saveErrors(request, errors);
    }

    public void addFileToContentRepository(HttpServletRequest request, McAuthoringForm mcAuthoringForm, List attachmentList, List deletedAttachmentList, SessionMap sessionMap, McGeneralAuthoringDTO mcGeneralAuthoringDTO) {
        logger.debug((Object)"attempt addFileToContentRepository");
        logger.debug((Object)("attachmentList: " + attachmentList));
        logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        if (attachmentList == null) {
            attachmentList = new ArrayList<McUploadedFile>();
        }
        if (deletedAttachmentList == null) {
            deletedAttachmentList = new ArrayList();
        }
        FormFile uploadedFile = null;
        boolean isOnlineFile = false;
        String fileType = null;
        if (mcAuthoringForm.getTheOfflineFile() != null && mcAuthoringForm.getTheOfflineFile().getFileSize() > 0) {
            logger.debug((Object)"theOfflineFile is available: ");
            uploadedFile = mcAuthoringForm.getTheOfflineFile();
            logger.debug((Object)("uploadedFile: " + uploadedFile));
            fileType = "OFFLINE";
        } else if (mcAuthoringForm.getTheOnlineFile() != null && mcAuthoringForm.getTheOnlineFile().getFileSize() > 0) {
            logger.debug((Object)"theOnlineFile is available: ");
            uploadedFile = mcAuthoringForm.getTheOnlineFile();
            logger.debug((Object)("uploadedFile: " + uploadedFile));
            isOnlineFile = true;
            fileType = "ONLINE";
        } else {
            return;
        }
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)uploadedFile, (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return;
        }
        logger.debug((Object)("uploadedFile.getFileName(): " + uploadedFile.getFileName()));
        deletedAttachmentList = McUtils.moveToDelete(uploadedFile.getFileName(), isOnlineFile, attachmentList, deletedAttachmentList);
        logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
        try {
            NodeKey node = this.getToolContentHandler().uploadFile(uploadedFile.getInputStream(), uploadedFile.getFileName(), uploadedFile.getContentType(), fileType);
            McUploadedFile file = new McUploadedFile();
            String fileName = uploadedFile.getFileName();
            logger.debug((Object)("fileName: " + fileName));
            logger.debug((Object)("fileName length: " + fileName.length()));
            if (fileName != null && fileName.length() > 30) {
                fileName = fileName.substring(0, 31);
                logger.debug((Object)("shortened fileName: " + fileName));
            }
            file.setFileName(fileName);
            file.setFileOnline(isOnlineFile);
            file.setUuid(node.getUuid().toString());
            attachmentList.add(file);
            mcAuthoringForm.setTheOfflineFile(null);
            mcAuthoringForm.setTheOnlineFile(null);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Unable to uploadfile", (Throwable)e);
            throw new RuntimeException("Unable to upload file, exception was " + e.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)"Unable to uploadfile", (Throwable)e);
            throw new RuntimeException("Unable to upload file, exception was " + e.getMessage());
        }
        catch (RepositoryCheckedException e) {
            logger.error((Object)"Unable to uploadfile", (Throwable)e);
            throw new RuntimeException("Unable to upload file, exception was " + e.getMessage());
        }
    }

    private McToolContentHandler getToolContentHandler() {
        if (this.toolContentHandler == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            this.toolContentHandler = (McToolContentHandler)((Object)wac.getBean("mcToolContentHandler"));
        }
        return this.toolContentHandler;
    }

    private List saveAttachments(McContent mcContent, List attachmentList, List deletedAttachmentList, ActionMapping mapping, HttpServletRequest request) {
        logger.debug((Object)("start saveAttachments, mcContent " + mcContent));
        logger.debug((Object)("start saveAttachments, attachmentList " + attachmentList));
        logger.debug((Object)("start deletedAttachmentList, deletedAttachmentList " + deletedAttachmentList));
        if (attachmentList == null || deletedAttachmentList == null) {
            return null;
        }
        IMcService voteService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("voteService: " + voteService));
        if (deletedAttachmentList != null) {
            logger.debug((Object)"deletedAttachmentList is iterated...");
            for (McUploadedFile attachment : deletedAttachmentList) {
                logger.debug((Object)("attachment: " + attachment));
                if (attachment.getSubmissionId() == null) continue;
                voteService.removeFile(attachment.getSubmissionId());
            }
            deletedAttachmentList.clear();
            logger.error((Object)"cleared attachment list.");
        }
        if (attachmentList != null) {
            logger.debug((Object)"attachmentList is iterated...");
            for (McUploadedFile attachment : attachmentList) {
                logger.debug((Object)("attachment: " + attachment));
                logger.debug((Object)("attachment submission id: " + attachment.getSubmissionId()));
                if (attachment.getSubmissionId() != null) continue;
                logger.debug((Object)("calling persistFile with  attachment: " + attachment));
                voteService.persistFile(mcContent, attachment);
            }
        }
        return deletedAttachmentList;
    }

    public ActionForward editActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching proxy editActivity...");
        return null;
    }

    public ActionForward editActivityQuestions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException {
        logger.debug((Object)"dispatching editActivityQuestions...");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        logger.debug((Object)("mcAuthoringForm: " + mcAuthoringForm));
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        logger.debug((Object)("title: " + mcContent.getTitle()));
        logger.debug((Object)("instructions: " + mcContent.getInstructions()));
        mcGeneralAuthoringDTO.setActivityTitle(mcContent.getTitle());
        mcAuthoringForm.setTitle(mcContent.getTitle());
        mcGeneralAuthoringDTO.setActivityInstructions(mcContent.getInstructions());
        sessionMap.put((Object)"activityTitleKey", (Object)mcContent.getTitle());
        sessionMap.put((Object)"activityInstructionsKey", (Object)mcContent.getInstructions());
        String sourceMcStarter = (String)request.getAttribute("sourceMcStarter");
        logger.debug((Object)("sourceMcStarter: " + sourceMcStarter));
        mcAuthoringForm.setDefineLaterInEditMode(new Boolean(true).toString());
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        boolean isContentInUse = McUtils.isContentInUse(mcContent);
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        mcGeneralAuthoringDTO.setMonitoredContentInUse(new Boolean(false).toString());
        if (isContentInUse) {
            logger.debug((Object)"monitoring url does not allow editActivity since the content is in use.");
            this.persistError(request, "error.content.inUse");
            mcGeneralAuthoringDTO.setMonitoredContentInUse(new Boolean(true).toString());
        }
        EditActivityDTO editActivityDTO = new EditActivityDTO();
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        if (isContentInUse) {
            editActivityDTO.setMonitoredContentInUse(new Boolean(true).toString());
        }
        request.setAttribute("editActivityDTO", (Object)editActivityDTO);
        McUtils.setDefineLater(request, true, strToolContentID, mcService);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List listQuestionContentDTO = authoringUtil.buildDefaultQuestionContent(mcContent, mcService);
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before fwding to jsp, mcAuthoringForm: " + mcAuthoringForm));
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        logger.debug((Object)"forwarding to : load");
        return mapping.findForward("load");
    }

    public ActionForward newEditableCaBox(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching newEditableCaBox");
        return null;
    }

    public ActionForward moveCandidateDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveCandidateDown");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        boolean validateCandidateAnswersNotBlank = authoringUtil.validateCandidateAnswersNotBlank(request);
        logger.debug((Object)("validateCandidateAnswersNotBlank: " + validateCandidateAnswersNotBlank));
        ActionMessages errors = new ActionMessages();
        if (!validateCandidateAnswersNotBlank) {
            ActionMessage error = new ActionMessage("candidates.blank");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        if (errors.isEmpty()) {
            List candidates = new LinkedList();
            List listCandidates = new LinkedList();
            String editableQuestion = "";
            for (McQuestionContentDTO mcQuestionContentDTO : listQuestionContentDTO) {
                logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
                logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
                String question = mcQuestionContentDTO.getQuestion();
                String displayOrder = mcQuestionContentDTO.getDisplayOrder();
                if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
                logger.debug((Object)("displayOrder equals questionIndex :" + questionIndex));
                editableQuestion = mcQuestionContentDTO.getQuestion();
                candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
                logger.debug((Object)("candidates found :" + candidates));
                logger.debug((Object)("but we are using the repopulated caList here: " + caList));
                listCandidates = AuthoringUtil.swapCandidateNodes(caList, candidateIndex, "down");
                logger.debug((Object)("swapped candidates :" + listCandidates));
                mcQuestionContentDTO.setListCandidateAnswersDTO(listCandidates);
                break;
            }
            logger.debug((Object)("candidates found :" + candidates));
            logger.debug((Object)("swapped candidates is :" + listCandidates));
        }
        logger.debug((Object)("listQuestionContentDTO after swapped candidates :" + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        request.setAttribute("requestNewEditableQuestionBox", (Object)new Boolean(true).toString());
        return this.newEditableQuestionBox(mapping, form, request, response);
    }

    public ActionForward moveCandidateUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveCandidateUp");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        AuthoringUtil authoringUtil = new AuthoringUtil();
        boolean validateCandidateAnswersNotBlank = authoringUtil.validateCandidateAnswersNotBlank(request);
        logger.debug((Object)("validateCandidateAnswersNotBlank: " + validateCandidateAnswersNotBlank));
        ActionMessages errors = new ActionMessages();
        if (!validateCandidateAnswersNotBlank) {
            ActionMessage error = new ActionMessage("candidates.blank");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        if (errors.isEmpty()) {
            List candidates = new LinkedList();
            List listCandidates = new LinkedList();
            String editableQuestion = "";
            for (McQuestionContentDTO mcQuestionContentDTO : listQuestionContentDTO) {
                logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
                logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
                String question = mcQuestionContentDTO.getQuestion();
                String displayOrder = mcQuestionContentDTO.getDisplayOrder();
                if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
                logger.debug((Object)("displayOrder equals questionIndex :" + questionIndex));
                editableQuestion = mcQuestionContentDTO.getQuestion();
                candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
                logger.debug((Object)("candidates found :" + candidates));
                logger.debug((Object)("using repopulated caList:" + caList));
                listCandidates = AuthoringUtil.swapCandidateNodes(caList, candidateIndex, "up");
                logger.debug((Object)("swapped candidates :" + listCandidates));
                mcQuestionContentDTO.setListCandidateAnswersDTO(listCandidates);
                mcQuestionContentDTO.setCaCount(new Integer(listCandidates.size()).toString());
                break;
            }
            logger.debug((Object)("candidates found :" + candidates));
            logger.debug((Object)("swapped candidates is :" + listCandidates));
        }
        logger.debug((Object)("listQuestionContentDTO after swapped candidates :" + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        request.setAttribute("requestNewEditableQuestionBox", (Object)new Boolean(true).toString());
        return this.newEditableQuestionBox(mapping, form, request, response);
    }

    public ActionForward removeCandidate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching removeCandidate");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        McQuestionContentDTO mcQuestionContentDTO2 = null;
        for (McQuestionContentDTO mcQuestionContentDTO2 : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO2));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO2.getQuestion()));
            String question = mcQuestionContentDTO2.getQuestion();
            String displayOrder = mcQuestionContentDTO2.getDisplayOrder();
            logger.debug((Object)("displayOrder:" + displayOrder));
            if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
            break;
        }
        logger.debug((Object)("mcQuestionContentDTO found:" + mcQuestionContentDTO2));
        logger.debug((Object)"setting caList for the content:");
        mcQuestionContentDTO2.setListCandidateAnswersDTO(caList);
        List candidateAnswers = mcQuestionContentDTO2.getListCandidateAnswersDTO();
        logger.debug((Object)("candidateAnswers:" + candidateAnswers));
        McCandidateAnswersDTO mcCandidateAnswersDTO = null;
        Iterator listCaIterator = candidateAnswers.iterator();
        int caIndex = 0;
        while (listCaIterator.hasNext()) {
            logger.debug((Object)("caIndex:" + ++caIndex));
            mcCandidateAnswersDTO = (McCandidateAnswersDTO)listCaIterator.next();
            logger.debug((Object)("mcCandidateAnswersDTO:" + mcCandidateAnswersDTO));
            logger.debug((Object)("mcCandidateAnswersDTO question:" + mcCandidateAnswersDTO.getCandidateAnswer()));
            if (caIndex != new Integer(candidateIndex)) continue;
            logger.debug((Object)"candidateIndex found");
            mcCandidateAnswersDTO.setCandidateAnswer("");
            break;
        }
        logger.debug((Object)("candidateAnswers after resetting answer" + candidateAnswers));
        candidateAnswers = AuthoringUtil.reorderListCandidatesDTO(candidateAnswers);
        logger.debug((Object)("candidateAnswers after reordering candidate nodes" + candidateAnswers));
        mcQuestionContentDTO2.setListCandidateAnswersDTO(candidateAnswers);
        mcQuestionContentDTO2.setCaCount(new Integer(candidateAnswers.size()).toString());
        logger.debug((Object)("listQuestionContentDTO after remove: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        if (mcContent == null) {
            logger.debug((Object)("using defaultContentIdStr: " + defaultContentIdStr));
            mcContent = mcService.retrieveMc(new Long(defaultContentIdStr));
        }
        logger.debug((Object)("final mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("mcQuestionContentDTO now: " + mcQuestionContentDTO2));
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        request.setAttribute("requestNewEditableQuestionBox", (Object)new Boolean(true).toString());
        return this.newEditableQuestionBox(mapping, form, request, response);
    }

    public ActionForward newCandidateBox(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching newCandidateBox");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, true);
        logger.debug((Object)("repopulated caList: " + caList));
        int caCount = caList.size();
        logger.debug((Object)("caCount: " + caCount));
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        String passmark = request.getParameter("passmark");
        logger.debug((Object)("passmark: " + passmark));
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        int currentQuestionCount = listQuestionContentDTO.size();
        logger.debug((Object)("currentQuestionCount: " + currentQuestionCount));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        McQuestionContentDTO mcQuestionContentDTOLocal2 = null;
        for (McQuestionContentDTO mcQuestionContentDTOLocal2 : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTOLocal:" + mcQuestionContentDTOLocal2));
            logger.debug((Object)("mcQuestionContentDTOLocal question:" + mcQuestionContentDTOLocal2.getQuestion()));
            String question = mcQuestionContentDTOLocal2.getQuestion();
            String displayOrder = mcQuestionContentDTOLocal2.getDisplayOrder();
            logger.debug((Object)("displayOrder:" + displayOrder));
            if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
            break;
        }
        logger.debug((Object)("mcQuestionContentDTOLocal found:" + mcQuestionContentDTOLocal2));
        if (mcQuestionContentDTOLocal2 != null) {
            mcQuestionContentDTOLocal2.setListCandidateAnswersDTO(caList);
            mcQuestionContentDTOLocal2.setCaCount(new Integer(caList.size()).toString());
        }
        logger.debug((Object)("listQuestionContentDTO after repopulating data: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("mcQuestionContentDTOLocal now: " + mcQuestionContentDTOLocal2));
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        request.setAttribute("requestNewEditableQuestionBox", (Object)new Boolean(true).toString());
        return this.newEditableQuestionBox(mapping, form, request, response);
    }

    public ActionForward updateMarksList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching updateMarksList");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        AuthoringUtil authoringUtil = new AuthoringUtil();
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("2");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)"fwd ing to LOAD_QUESTIONS: load");
        return mapping.findForward("load");
    }

    public ActionForward moveAddedCandidateUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveAddedCandidateUp");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        AuthoringUtil authoringUtil = new AuthoringUtil();
        boolean validateCandidateAnswersNotBlank = authoringUtil.validateCandidateAnswersNotBlank(request);
        logger.debug((Object)("validateCandidateAnswersNotBlank: " + validateCandidateAnswersNotBlank));
        ActionMessages errors = new ActionMessages();
        if (!validateCandidateAnswersNotBlank) {
            ActionMessage error = new ActionMessage("candidates.blank");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        if (errors.isEmpty()) {
            List candidates = new LinkedList();
            List listCandidates = new LinkedList();
            for (McQuestionContentDTO mcQuestionContentDTO : listAddableQuestionContentDTO) {
                logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
                candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
                logger.debug((Object)("candidates found :" + candidates));
                logger.debug((Object)("but we are using the repopulated caList here: " + caList));
                listCandidates = AuthoringUtil.swapCandidateNodes(caList, candidateIndex, "up");
                logger.debug((Object)("swapped candidates :" + listCandidates));
                mcQuestionContentDTO.setListCandidateAnswersDTO(listCandidates);
            }
        }
        logger.debug((Object)("listAddableQuestionContentDTO after swapping (up) candidates: " + listAddableQuestionContentDTO));
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        sessionMap.put((Object)"newAddableQuestionContentKey", (Object)listAddableQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        return this.newQuestionBox(mapping, form, request, response);
    }

    public ActionForward moveAddedCandidateDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveAddedCandidateDown");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        boolean validateCandidateAnswersNotBlank = authoringUtil.validateCandidateAnswersNotBlank(request);
        logger.debug((Object)("validateCandidateAnswersNotBlank: " + validateCandidateAnswersNotBlank));
        ActionMessages errors = new ActionMessages();
        if (!validateCandidateAnswersNotBlank) {
            ActionMessage error = new ActionMessage("candidates.blank");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        if (errors.isEmpty()) {
            List candidates = new LinkedList();
            List listCandidates = new LinkedList();
            for (McQuestionContentDTO mcQuestionContentDTO : listAddableQuestionContentDTO) {
                logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
                candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
                logger.debug((Object)("candidates found :" + candidates));
                logger.debug((Object)("but we are using the repopulated caList here: " + caList));
                listCandidates = AuthoringUtil.swapCandidateNodes(caList, candidateIndex, "down");
                logger.debug((Object)("swapped candidates :" + listCandidates));
                mcQuestionContentDTO.setListCandidateAnswersDTO(listCandidates);
            }
        }
        logger.debug((Object)"listAddableQuestionContentDTO after moving down candidates: ");
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        sessionMap.put((Object)"newAddableQuestionContentKey", (Object)listAddableQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        return this.newQuestionBox(mapping, form, request, response);
    }

    public ActionForward removeAddedCandidate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching removeAddedCandidate");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        List candidates = new LinkedList();
        LinkedList listCandidates = new LinkedList();
        for (McQuestionContentDTO mcQuestionContentDTO : listAddableQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
            logger.debug((Object)("candidates found :" + candidates));
            logger.debug((Object)("mcQuestionContentDTO found:" + mcQuestionContentDTO));
            logger.debug((Object)"setting caList for the content:");
            mcQuestionContentDTO.setListCandidateAnswersDTO(caList);
            List candidateAnswers = mcQuestionContentDTO.getListCandidateAnswersDTO();
            logger.debug((Object)("candidateAnswers:" + candidateAnswers));
            McCandidateAnswersDTO mcCandidateAnswersDTO = null;
            Iterator listCaIterator = candidateAnswers.iterator();
            int caIndex = 0;
            while (listCaIterator.hasNext()) {
                logger.debug((Object)("caIndex:" + ++caIndex));
                mcCandidateAnswersDTO = (McCandidateAnswersDTO)listCaIterator.next();
                logger.debug((Object)("mcCandidateAnswersDTO:" + mcCandidateAnswersDTO));
                logger.debug((Object)("mcCandidateAnswersDTO question:" + mcCandidateAnswersDTO.getCandidateAnswer()));
                if (caIndex != new Integer(candidateIndex)) continue;
                logger.debug((Object)"candidateIndex found");
                mcCandidateAnswersDTO.setCandidateAnswer("");
                break;
            }
            logger.debug((Object)("candidateAnswers after resetting answer" + candidateAnswers));
            candidateAnswers = AuthoringUtil.reorderListCandidatesDTO(candidateAnswers);
            logger.debug((Object)("candidateAnswers after reordering candidate nodes" + candidateAnswers));
            mcQuestionContentDTO.setListCandidateAnswersDTO(candidateAnswers);
            mcQuestionContentDTO.setCaCount(new Integer(candidateAnswers.size()).toString());
            logger.debug((Object)("listQuestionContentDTO after remove: " + listQuestionContentDTO));
        }
        logger.debug((Object)("listAddableQuestionContentDTO : " + listAddableQuestionContentDTO));
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        sessionMap.put((Object)"newAddableQuestionContentKey", (Object)listAddableQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        if (mcContent == null) {
            logger.debug((Object)("using defaultContentIdStr: " + defaultContentIdStr));
            mcContent = mcService.retrieveMc(new Long(defaultContentIdStr));
        }
        logger.debug((Object)("final mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        return this.newQuestionBox(mapping, form, request, response);
    }

    public ActionForward newAddedCandidateBox(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching newAddedCandidateBox");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, true);
        logger.debug((Object)("repopulated caList: " + caList));
        int caCount = caList.size();
        logger.debug((Object)("caCount: " + caCount));
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        String passmark = request.getParameter("passmark");
        logger.debug((Object)("passmark: " + passmark));
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        int currentQuestionCount = listQuestionContentDTO.size();
        logger.debug((Object)("currentQuestionCount: " + currentQuestionCount));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        LinkedList candidates = new LinkedList();
        LinkedList listCandidates = new LinkedList();
        for (McQuestionContentDTO mcQuestionContentDTO : listAddableQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("caList:" + caList));
            logger.debug((Object)("caList size:" + caList.size()));
            mcQuestionContentDTO.setListCandidateAnswersDTO(caList);
            mcQuestionContentDTO.setCaCount(new Integer(caList.size()).toString());
        }
        logger.debug((Object)"listAddableQuestionContentDTO after swapping (up) candidates: ");
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        sessionMap.put((Object)"newAddableQuestionContentKey", (Object)listAddableQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO after repopulating data: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOnlineInstructions));
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
        }
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        mcAuthoringForm.setFeedback(feedback);
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        return this.newQuestionBox(mapping, form, request, response);
    }

    protected boolean existsContent(long toolContentID, IMcService mcService) {
        McContent mcContent = mcService.retrieveMc(new Long(toolContentID));
        return mcContent != null;
    }
}

