/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.web;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McComparator;
import org.lamsfoundation.lams.tool.mc.McGeneralLearnerFlowDTO;
import org.lamsfoundation.lams.tool.mc.McLearnerAnswersDTO;
import org.lamsfoundation.lams.tool.mc.McStringComparator;
import org.lamsfoundation.lams.tool.mc.McTempDataHolderDTO;
import org.lamsfoundation.lams.tool.mc.McUtils;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McOptsContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueUsr;
import org.lamsfoundation.lams.tool.mc.pojos.McSession;
import org.lamsfoundation.lams.tool.mc.pojos.McUsrAttempt;
import org.lamsfoundation.lams.tool.mc.service.IMcService;
import org.lamsfoundation.lams.tool.mc.service.McServiceProxy;
import org.lamsfoundation.lams.tool.mc.web.AuthoringUtil;
import org.lamsfoundation.lams.tool.mc.web.LearningUtil;
import org.lamsfoundation.lams.tool.mc.web.McLearningForm;
import org.lamsfoundation.lams.tool.mc.web.McLearningStarterAction;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;

public class McLearningAction
extends LamsDispatchAction
implements McAppConstants {
    static Logger logger = Logger.getLogger((String)McLearningAction.class.getName());

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        McLearningForm mcLearningForm = (McLearningForm)form;
        LearningUtil.saveFormRequestData(request, mcLearningForm, false);
        return null;
    }

    public ActionForward displayMc(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        McLearningForm mcLearningForm = (McLearningForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        String toolSessionID = request.getParameter("toolSessionID");
        logger.debug((Object)("toolSessionID: " + toolSessionID));
        mcLearningForm.setToolSessionID(toolSessionID);
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionID));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        String toolContentId = mcSession.getMcContent().getMcContentId().toString();
        logger.debug((Object)("toolContentId: " + toolContentId));
        mcLearningForm.setToolContentID(toolContentId);
        logger.debug((Object)("mcLearningForm nextQuestionSelected : " + mcLearningForm.getNextQuestionSelected()));
        if (mcLearningForm.getNextQuestionSelected() != null && !mcLearningForm.getNextQuestionSelected().equals("")) {
            logger.debug((Object)"processing getNextQuestionSelected...");
            LearningUtil.saveFormRequestData(request, mcLearningForm, false);
            mcLearningForm.resetParameters();
            this.setContentInUse(request, toolContentId, mcService);
            return this.getNextOptions(mapping, form, request, response);
        }
        if (mcLearningForm.getContinueOptionsCombined() != null) {
            logger.debug((Object)"processing getContinueOptionsCombined...");
            LearningUtil.saveFormRequestData(request, mcLearningForm, false);
            this.setContentInUse(request, toolContentId, mcService);
            return this.continueOptionsCombined(mapping, form, request, response);
        }
        if (mcLearningForm.getNextOptions() != null) {
            logger.debug((Object)"processing getNextOptions...");
            LearningUtil.saveFormRequestData(request, mcLearningForm, false);
            this.setContentInUse(request, toolContentId, mcService);
            return this.getNextOptions(mapping, form, request, response);
        }
        if (mcLearningForm.getRedoQuestions() != null) {
            logger.debug((Object)"processing getRedoQuestions...");
            LearningUtil.saveFormRequestData(request, mcLearningForm, false);
            this.setContentInUse(request, toolContentId, mcService);
            return this.redoQuestions(mapping, form, request, response);
        }
        if (mcLearningForm.getRedoQuestionsOk() != null) {
            logger.debug((Object)"processing getRedoQuestionsOk...");
            LearningUtil.saveFormRequestData(request, mcLearningForm, false);
            this.setContentInUse(request, toolContentId, mcService);
            logger.debug((Object)"requested redoQuestionsOk, user is sure to redo the questions.");
            return this.redoQuestions(request, mcLearningForm, mapping);
        }
        if (mcLearningForm.getViewAnswers() != null) {
            logger.debug((Object)"processing getViewAnswers...");
            LearningUtil.saveFormRequestData(request, mcLearningForm, false);
            this.setContentInUse(request, toolContentId, mcService);
            mcLearningForm.setLearnerProgress(new Boolean(false).toString());
            return this.viewAnswers(mapping, mcLearningForm, request, response);
        }
        if (mcLearningForm.getViewSummary() != null) {
            logger.debug((Object)"processing getViewSummary...");
            LearningUtil.saveFormRequestData(request, mcLearningForm, false);
            this.setContentInUse(request, toolContentId, mcService);
            return this.viewSummary(mapping, form, request, response);
        }
        if (mcLearningForm.getSubmitReflection() != null) {
            logger.debug((Object)"processing getSubmitReflection...");
            LearningUtil.saveFormRequestData(request, mcLearningForm, false);
            this.setContentInUse(request, toolContentId, mcService);
            return this.submitReflection(mapping, form, request, response);
        }
        if (mcLearningForm.getForwardtoReflection() != null) {
            logger.debug((Object)"processing getForwardtoReflection...");
            LearningUtil.saveFormRequestData(request, mcLearningForm, false);
            this.setContentInUse(request, toolContentId, mcService);
            return this.forwardtoReflection(mapping, form, request, response);
        }
        if (mcLearningForm.getLearnerFinished() != null) {
            logger.debug((Object)"processing getLearnerFinished...");
            LearningUtil.saveFormRequestData(request, mcLearningForm, false);
            this.setContentInUse(request, toolContentId, mcService);
            return this.endLearning(mapping, form, request, response);
        }
        return mapping.findForward("loadLearner");
    }

    public ActionForward endLearning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserDTO user;
        logger.debug((Object)"dispatching endLearning ");
        McLearningForm mcLearningForm = (McLearningForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        String toolSessionID = request.getParameter("toolSessionID");
        logger.debug((Object)("toolSessionID: " + toolSessionID));
        mcLearningForm.setToolSessionID(toolSessionID);
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionID));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        String toolContentId = mcSession.getMcContent().getMcContentId().toString();
        logger.debug((Object)("toolContentId: " + toolContentId));
        mcLearningForm.setToolContentID(toolContentId);
        logger.debug((Object)("mcLearningForm nextQuestionSelected : " + mcLearningForm.getNextQuestionSelected()));
        LearningUtil.saveFormRequestData(request, mcLearningForm, false);
        logger.debug((Object)"requested learner finished, the learner should be directed to next activity.");
        logger.debug((Object)("toolSessionID: " + toolSessionID));
        String userID = "";
        HttpSession ss = SessionManager.getSession();
        logger.debug((Object)("ss: " + ss));
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null && user.getUserID() != null) {
            userID = user.getUserID().toString();
            logger.debug((Object)("retrieved userId: " + userID));
        }
        logger.debug((Object)("attempting to leave/complete session with toolSessionId:" + toolSessionID + " and userID:" + userID));
        McUtils.cleanUpSessionAbsolute(request);
        String nextUrl = null;
        try {
            nextUrl = mcService.leaveToolSession(new Long(toolSessionID), new Long(userID));
            logger.debug((Object)("nextUrl: " + nextUrl));
        }
        catch (DataMissingException e) {
            logger.debug((Object)("failure getting nextUrl: " + (Object)((Object)e)));
            return mapping.findForward("learningStarter");
        }
        catch (ToolException e) {
            logger.debug((Object)("failure getting nextUrl: " + (Object)((Object)e)));
            return mapping.findForward("learningStarter");
        }
        catch (Exception e) {
            logger.debug((Object)("unknown exception getting nextUrl: " + e));
            return mapping.findForward("learningStarter");
        }
        logger.debug((Object)("success getting nextUrl: " + nextUrl));
        McQueUsr mcQueUsr = mcService.getMcUserBySession(new Long(userID), mcSession.getUid());
        logger.debug((Object)("mcQueUsr:" + mcQueUsr));
        if (mcQueUsr == null) {
            logger.debug((Object)"attempt creating  user record since it must exist for the runOffline + reflection screens");
            UserDTO toolUser = (UserDTO)ss.getAttribute("user");
            logger.debug((Object)("retrieving toolUser: " + toolUser));
            logger.debug((Object)("retrieving toolUser userId: " + toolUser.getUserID()));
            logger.debug((Object)("retrieving toolUser username: " + toolUser.getLogin()));
            String userName = toolUser.getLogin();
            String fullName = toolUser.getFirstName() + " " + toolUser.getLastName();
            logger.debug((Object)("retrieving toolUser fullname: " + fullName));
            Long userId = new Long(toolUser.getUserID().longValue());
            logger.debug((Object)("userId: " + userId));
            logger.debug((Object)("retrieving toolUser fullname: " + fullName));
            mcQueUsr = new McQueUsr(userId, userName, fullName, mcSession, new TreeSet());
            mcService.createMcQueUsr(mcQueUsr);
            logger.debug((Object)("createMcQueUsr - mcQueUsr: " + mcQueUsr));
            logger.debug((Object)("session uid: " + mcSession.getUid()));
            logger.debug((Object)("mcQueUsr: " + mcQueUsr));
            mcService.createMcQueUsr(mcQueUsr);
            logger.debug((Object)("created mcQueUsr in the db: " + mcQueUsr));
        }
        mcQueUsr.setResponseFinalised(true);
        mcService.updateMcQueUsr(mcQueUsr);
        logger.debug((Object)("response finalised for user:" + mcQueUsr));
        mcQueUsr.setViewSummaryRequested(true);
        mcService.updateMcQueUsr(mcQueUsr);
        logger.debug((Object)("view summary requested by mcQueUsr: " + mcQueUsr));
        McUsrAttempt mcUsrAttempt2 = mcService.getAttemptWithLastAttemptOrderForUserInSession(mcQueUsr.getUid(), mcSession.getUid());
        logger.debug((Object)("mcUsrAttempt with highest attempt order: " + mcUsrAttempt2));
        String highestAttemptOrder = "";
        if (mcUsrAttempt2 != null) {
            highestAttemptOrder = mcUsrAttempt2.getAttemptOrder().toString();
            logger.debug((Object)("highestAttemptOrder: " + highestAttemptOrder));
            List userAttempts = mcService.getAttemptsForUserOnHighestAttemptOrderInSession(mcQueUsr.getUid(), mcSession.getUid(), new Integer(highestAttemptOrder));
            logger.debug((Object)("userAttempts:" + userAttempts));
            for (McUsrAttempt mcUsrAttempt2 : userAttempts) {
                logger.debug((Object)("mcUsrAttempt: " + mcUsrAttempt2));
                mcUsrAttempt2.setFinished(true);
                mcService.updateMcUsrAttempt(mcUsrAttempt2);
            }
            logger.debug((Object)"updated user records to finished");
        }
        logger.debug((Object)("redirecting to the nextUrl: " + nextUrl));
        response.sendRedirect(nextUrl);
        return null;
    }

    protected Set parseLearnerInput(List learnerInput, McContent mcContent, IMcService mcService) {
        logger.debug((Object)("starting parseLearnerInput: " + learnerInput));
        logger.debug((Object)("mcContent: " + mcContent));
        logger.debug((Object)("mcContent uid: " + mcContent.getUid()));
        HashSet<String> questionUids = new HashSet<String>();
        for (String input : learnerInput) {
            logger.debug((Object)("input: " + input));
            int pos = input.indexOf("-");
            logger.debug((Object)("pos: " + pos));
            String questionUid = input.substring(0, pos);
            logger.debug((Object)("questionUid: " + questionUid));
            questionUids.add(questionUid);
        }
        logger.debug((Object)("final set questionUid: " + questionUids));
        List questionEntriesOrdered = mcService.getAllQuestionEntries(mcContent.getUid());
        logger.debug((Object)("questionEntriesOrdered: " + questionEntriesOrdered));
        TreeSet<String> questionOrderedUids = new TreeSet<String>(new McComparator());
        for (McQueContent mcQueContent : questionEntriesOrdered) {
            logger.debug((Object)("mcQueContent: " + mcQueContent));
            logger.debug((Object)("mcQueContent text: " + mcQueContent.getQuestion()));
            for (String questionUid : questionUids) {
                logger.debug((Object)("questionUid: " + questionUid));
                logger.debug((Object)("questionUid versus objects uid : " + questionUid + " versus " + mcQueContent.getUid()));
                if (!questionUid.equals(mcQueContent.getUid().toString())) continue;
                questionOrderedUids.add(questionUid);
            }
        }
        logger.debug((Object)("questionOrderedUids: " + questionOrderedUids));
        return questionOrderedUids;
    }

    protected List buildSelectedQuestionAndCandidateAnswersDTO(List allQuestionUidsList, List learnerInput, McTempDataHolderDTO mcTempDataHolderDTO, IMcService mcService, McContent mcContent) {
        logger.debug((Object)("starting buildSelectedQuestionAndCandidateAnswersDTO using allQuestionUidsList: " + allQuestionUidsList));
        logger.debug((Object)("buildSelectedQuestionAndCandidateAnswersDTO: " + learnerInput));
        logger.debug((Object)("mcContent: " + mcContent));
        logger.debug((Object)("learnerInput: " + learnerInput));
        int mark = 0;
        boolean userWeight = false;
        int userMarks = 0;
        int totalMarksPossible = 0;
        Set questionUids = this.parseLearnerInput(learnerInput, mcContent, mcService);
        logger.debug((Object)("set questionUids: " + questionUids));
        LinkedList<McLearnerAnswersDTO> questionAndCandidateAnswersList = new LinkedList<McLearnerAnswersDTO>();
        int totalUserMarks = 0;
        if (questionUids.size() == 0) {
            logger.debug((Object)("there are no selected answers for any questions: " + questionUids));
        }
        Iterator allQuestionUidsListIterator = allQuestionUidsList.iterator();
        while (allQuestionUidsListIterator.hasNext()) {
            logger.debug((Object)"started testing all uids");
            String currentQuestionUid = (String)allQuestionUidsListIterator.next();
            logger.debug((Object)("currentQuestionUid: " + currentQuestionUid));
            boolean selectedQuestionFound = false;
            for (String questionUid : questionUids) {
                logger.debug((Object)("questionUid: " + questionUid));
                McQueContent mcQueContent = mcService.findMcQuestionContentByUid(new Long(questionUid));
                logger.debug((Object)("mcQueContent: " + mcQueContent));
                logger.debug((Object)("mcQueContent text: " + mcQueContent.getQuestion()));
                String question = mcQueContent.getQuestion();
                logger.debug((Object)("question: " + question));
                logger.debug((Object)("question uid: " + mcQueContent.getUid()));
                logger.debug((Object)("testing for comparison currentQuestionUid and  mcQueContent.getUid(): " + currentQuestionUid + " and " + mcQueContent.getUid()));
                if (!currentQuestionUid.equals(mcQueContent.getUid().toString())) continue;
                selectedQuestionFound = true;
                McLearnerAnswersDTO mcLearnerAnswersDTO = new McLearnerAnswersDTO();
                logger.debug((Object)("this is a selected question with uid: " + mcQueContent.getUid()));
                mcLearnerAnswersDTO.setQuestion(question);
                mcLearnerAnswersDTO.setDisplayOrder(mcQueContent.getDisplayOrder().toString());
                mcLearnerAnswersDTO.setQuestionUid(mcQueContent.getUid().toString());
                mcLearnerAnswersDTO.setMark(mcQueContent.getMark().toString());
                int currentMark = mcQueContent.getMark();
                logger.debug((Object)("currentMark: " + currentMark));
                totalMarksPossible += currentMark;
                String feedback = mcQueContent.getFeedback();
                if (feedback == null) {
                    feedback = "";
                }
                logger.debug((Object)("feedback: " + feedback));
                mcLearnerAnswersDTO.setFeedback(feedback);
                TreeMap<String, String> caMap = new TreeMap<String, String>(new McStringComparator());
                TreeMap<String, String> caIdsMap = new TreeMap<String, String>(new McStringComparator());
                Long mapIndex = new Long(1L);
                for (String input : learnerInput) {
                    logger.debug((Object)("input: " + input));
                    int pos = input.indexOf("-");
                    logger.debug((Object)("pos: " + pos));
                    String localQuestionUid = input.substring(0, pos);
                    logger.debug((Object)("localQuestionUid: " + localQuestionUid));
                    if (!questionUid.equals(localQuestionUid)) continue;
                    logger.debug((Object)("equal uids found : " + localQuestionUid));
                    String caUid = input.substring(pos + 1);
                    logger.debug((Object)("caUid: " + caUid));
                    McOptsContent mcOptsContent = mcService.findMcOptionsContentByUid(new Long(caUid));
                    logger.debug((Object)("mcOptsContent: " + mcOptsContent));
                    logger.debug((Object)("mcOptsContent text: " + mcOptsContent.getMcQueOptionText()));
                    caMap.put(mapIndex.toString(), mcOptsContent.getMcQueOptionText());
                    caIdsMap.put(mapIndex.toString(), mcOptsContent.getUid().toString());
                    mapIndex = new Long(mapIndex + 1L);
                }
                logger.debug((Object)("current caMap: " + caMap));
                logger.debug((Object)("current caIdsMap: " + caIdsMap));
                mcLearnerAnswersDTO.setCandidateAnswers(caMap);
                Long mcQueContentUid = mcQueContent.getUid();
                logger.debug((Object)("mcQueContentUid: " + mcQueContentUid));
                List correctOptions = mcService.getPersistedSelectedOptions(mcQueContentUid);
                logger.debug((Object)("correctOptions: " + correctOptions));
                Map mapCorrectOptionUids = LearningUtil.buildMapCorrectOptionUids(correctOptions);
                logger.debug((Object)("mapCorrectOptionUids: " + mapCorrectOptionUids));
                boolean isEqual = LearningUtil.compareMapItems(mapCorrectOptionUids, caIdsMap);
                logger.debug((Object)("isEqual: " + isEqual));
                boolean isEqualCross = LearningUtil.compareMapsItemsCross(mapCorrectOptionUids, caIdsMap);
                logger.debug((Object)("isEqualCross: " + isEqualCross));
                boolean compareResult = isEqual && isEqualCross;
                logger.debug((Object)("compareResult: " + compareResult));
                mcLearnerAnswersDTO.setAttemptCorrect(new Boolean(compareResult).toString());
                if (compareResult) {
                    mcLearnerAnswersDTO.setFeedbackCorrect(mcQueContent.getFeedback());
                    ++mark;
                    totalUserMarks += currentMark;
                    userMarks += currentMark;
                } else {
                    mcLearnerAnswersDTO.setFeedbackIncorrect(mcQueContent.getFeedback());
                }
                logger.debug((Object)"assesment complete");
                logger.debug((Object)("mark:: " + mark));
                logger.debug((Object)("totalUserMarks: " + totalUserMarks));
                logger.debug((Object)("current mcLearnerAnswersDTO: " + mcLearnerAnswersDTO));
                questionAndCandidateAnswersList.add(mcLearnerAnswersDTO);
            }
            if (selectedQuestionFound) continue;
            logger.debug((Object)("this is a not selected question, its uid: " + currentQuestionUid));
            McQueContent mcQueContentOrig = mcService.findMcQuestionContentByUid(new Long(currentQuestionUid));
            logger.debug((Object)("mcQueContentOrig: " + mcQueContentOrig));
            McLearnerAnswersDTO mcLearnerAnswersDTO = new McLearnerAnswersDTO();
            mcLearnerAnswersDTO.setQuestion(mcQueContentOrig.getQuestion());
            mcLearnerAnswersDTO.setDisplayOrder(mcQueContentOrig.getDisplayOrder().toString());
            mcLearnerAnswersDTO.setQuestionUid(mcQueContentOrig.getUid().toString());
            mcLearnerAnswersDTO.setMark(mcQueContentOrig.getMark().toString());
            int currentMark = mcQueContentOrig.getMark();
            logger.debug((Object)("currentMark: " + currentMark));
            totalMarksPossible += currentMark;
            String feedback = mcQueContentOrig.getFeedback();
            if (feedback == null) {
                feedback = "";
            }
            logger.debug((Object)("feedback: " + feedback));
            mcLearnerAnswersDTO.setFeedback(feedback);
            TreeMap caMap = new TreeMap(new McStringComparator());
            mcLearnerAnswersDTO.setCandidateAnswers(caMap);
            mcLearnerAnswersDTO.setAttemptCorrect(new Boolean(false).toString());
            mcLearnerAnswersDTO.setFeedbackIncorrect(mcQueContentOrig.getFeedback());
            logger.debug((Object)("current mcLearnerAnswersDTO: " + mcLearnerAnswersDTO));
            questionAndCandidateAnswersList.add(mcLearnerAnswersDTO);
        }
        logger.debug((Object)("final questionAndCandidateAnswersList: " + questionAndCandidateAnswersList));
        logger.debug((Object)("final mark: " + mark));
        logger.debug((Object)("final userMarks: " + userMarks));
        logger.debug((Object)("totalUserMarks: " + totalUserMarks));
        logger.debug((Object)("totalMarksPossible: " + totalMarksPossible));
        mcTempDataHolderDTO.setLearnerMark(new Integer(mark).toString());
        mcTempDataHolderDTO.setTotalUserMark(new Integer(userMarks).toString());
        mcTempDataHolderDTO.setTotalReportableUserMark(new Integer(totalUserMarks).toString());
        mcTempDataHolderDTO.setTotalMarksPossible(new Integer(totalMarksPossible).toString());
        logger.debug((Object)("mcTempDataHolderDTO before return : " + mcTempDataHolderDTO));
        return questionAndCandidateAnswersList;
    }

    public ActionForward continueOptionsCombined(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserDTO user;
        logger.debug((Object)"dispatching continueOptionsCombined...");
        McLearningForm mcLearningForm = (McLearningForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("retrieving mcService: " + mcService));
        String httpSessionID = mcLearningForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionListingMode = mcLearningForm.getQuestionListingMode();
        logger.debug((Object)("questionListingMode: " + questionListingMode));
        List<String> learnerInput = new LinkedList<String>();
        if (questionListingMode.equals("questionListingModeSequential")) {
            logger.debug((Object)"listing mode is : questionListingModeSequential");
            List sequentialCheckedCa = (List)sessionMap.get((Object)"questionAndCandidateAnswersKey");
            logger.debug((Object)("pre sequentialCheckedCa: " + sequentialCheckedCa));
            for (String input : sequentialCheckedCa) {
                logger.debug((Object)("input: " + input));
            }
            String[] checkedCa = mcLearningForm.getCheckedCa();
            logger.debug((Object)("checkedCa: " + checkedCa));
            if (checkedCa != null) {
                mcLearningForm.resetCa(mapping, request);
                for (int i = 0; i < checkedCa.length; ++i) {
                    String currentCa = checkedCa[i];
                    logger.debug((Object)("currentCa: " + currentCa));
                    sequentialCheckedCa.add(currentCa);
                }
            }
            logger.debug((Object)("post sequentialCheckedCa: " + sequentialCheckedCa));
            for (String input : sequentialCheckedCa) {
                logger.debug((Object)("input: " + input));
            }
            sessionMap.put((Object)"questionAndCandidateAnswersKey", (Object)sequentialCheckedCa);
            request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
            learnerInput = sequentialCheckedCa;
            logger.debug((Object)"end processing for mode : questionListingModeSequential");
        } else {
            Map parameters = request.getParameterMap();
            for (String key : parameters.keySet()) {
                if (!key.startsWith("checkedCa")) continue;
                String currentCheckedCa = request.getParameter(key);
                logger.debug((Object)("Found matching checkedCa: key " + key + " value " + currentCheckedCa + "."));
                if (currentCheckedCa == null) continue;
                learnerInput.add(currentCheckedCa);
            }
            mcLearningForm.resetCa(mapping, request);
        }
        logger.debug((Object)("final learnerInput: " + learnerInput));
        String toolSessionID = request.getParameter("toolSessionID");
        logger.debug((Object)("toolSessionID: " + toolSessionID));
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionID));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        String toolContentId = mcSession.getMcContent().getMcContentId().toString();
        logger.debug((Object)("toolContentId: " + toolContentId));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentId));
        logger.debug((Object)("mcContent: " + mcContent));
        List allQuestionUidsList = this.getAllQuestionUids(mcContent);
        logger.debug((Object)("allQuestionUidsList: " + allQuestionUidsList));
        McGeneralLearnerFlowDTO mcGeneralLearnerFlowDTO = LearningUtil.buildMcGeneralLearnerFlowDTO(mcContent);
        logger.debug((Object)"constructed a new mcGeneralLearnerFlowDTO");
        McTempDataHolderDTO mcTempDataHolderDTO = new McTempDataHolderDTO();
        boolean allQuestionsChecked = this.allQuestionsChecked(mcService, learnerInput, allQuestionUidsList, mcTempDataHolderDTO);
        logger.debug((Object)("allQuestionsChecked: " + allQuestionsChecked));
        logger.debug((Object)("mcTempDataHolderDTO displayOrder: " + mcTempDataHolderDTO.getDisplayOrder()));
        if (!allQuestionsChecked) {
            logger.debug((Object)("there are no selected answers for any questions: " + learnerInput));
            ActionMessages errors = new ActionMessages();
            ActionMessage error = new ActionMessage("answers.submitted.none");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
            logger.debug((Object)("errors: " + errors));
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
            McLearningStarterAction mcLearningStarterAction = new McLearningStarterAction();
            mcLearningStarterAction.commonContentSetup(request, mcContent, mcService, mcLearningForm, toolSessionID);
            mcGeneralLearnerFlowDTO.setQuestionIndex(mcTempDataHolderDTO.getDisplayOrder());
            request.setAttribute("mcGeneralLearnerFlowDTO", (Object)mcGeneralLearnerFlowDTO);
            logger.debug((Object)("MC_GENERAL_LEARNER_FLOW_DTO: " + request.getAttribute("mcGeneralLearnerFlowDTO")));
            logger.debug((Object)"returning to LOAD_LEARNER: loadLearner");
            return mapping.findForward("loadLearner");
        }
        List selectedQuestionAndCandidateAnswersDTO = this.buildSelectedQuestionAndCandidateAnswersDTO(allQuestionUidsList, learnerInput, mcTempDataHolderDTO, mcService, mcContent);
        logger.debug((Object)("selectedQuestionAndCandidateAnswersDTO: " + selectedQuestionAndCandidateAnswersDTO));
        request.setAttribute("listSelectedQuestionCandidateAnswersDto", (Object)selectedQuestionAndCandidateAnswersDTO);
        logger.debug((Object)("LIST_SELECTED_QUESTION_CANDIDATEANSWERS_DTO: " + request.getAttribute("listSelectedQuestionCandidateAnswersDto")));
        logger.debug((Object)("mcTempDataHolderDTO becomes: " + mcTempDataHolderDTO));
        String learnerMark = mcTempDataHolderDTO.getLearnerMark();
        logger.debug((Object)("learnerMark: " + learnerMark));
        String totalUserWeight = mcTempDataHolderDTO.getTotalUserWeight();
        logger.debug((Object)("totalUserWeight: " + totalUserWeight));
        String totalUserMark = mcTempDataHolderDTO.getTotalUserMark();
        logger.debug((Object)("totalUserMark: " + totalUserMark));
        String totalMarksPossible = mcTempDataHolderDTO.getTotalMarksPossible();
        logger.debug((Object)("totalMarksPossible: " + totalMarksPossible));
        mcGeneralLearnerFlowDTO.setQuestionListingMode("questionListingModeCombined");
        int totalQuestionCount = mcContent.getMcQueContents().size();
        logger.debug((Object)("totalQuestionCount: " + totalQuestionCount));
        mcGeneralLearnerFlowDTO.setTotalQuestionCount(new Integer(totalQuestionCount).toString());
        mcGeneralLearnerFlowDTO.setTotalUserMark(totalUserMark);
        mcGeneralLearnerFlowDTO.setTotalMarksPossible(totalMarksPossible);
        mcGeneralLearnerFlowDTO.setLearnerMark(learnerMark.toString());
        Integer passMark = mcContent.getPassMark();
        logger.debug((Object)("passMark: " + passMark));
        mcGeneralLearnerFlowDTO.setUserOverPassMark(new Boolean(false).toString());
        mcGeneralLearnerFlowDTO.setPassMarkApplicable(new Boolean(false).toString());
        boolean passed = false;
        if (passMark != null) {
            mcGeneralLearnerFlowDTO.setPassMarkApplicable(new Boolean(true).toString());
            logger.debug((Object)("totalUserMark versus passMark: " + totalUserMark + " versus " + passMark));
            if (new Integer(totalUserMark) < passMark) {
                logger.debug((Object)"USER FAILED");
                logger.debug((Object)("totalUserMark is less than passmark: " + totalUserMark + " < " + passMark));
                passed = false;
            } else {
                logger.debug((Object)"USER PASSED");
                passed = true;
                mcGeneralLearnerFlowDTO.setUserOverPassMark(new Boolean(true).toString());
            }
        }
        if (passMark == null) {
            mcGeneralLearnerFlowDTO.setPassMarkApplicable(new Boolean(false).toString());
        }
        String passMarkApplicable = mcGeneralLearnerFlowDTO.getPassMarkApplicable();
        logger.debug((Object)("passMarkApplicable: " + passMarkApplicable));
        sessionMap.put((Object)"passMarkApplicable", (Object)passMarkApplicable);
        String userOverPassMark = mcGeneralLearnerFlowDTO.getUserOverPassMark();
        logger.debug((Object)("userOverPassMark: " + userOverPassMark));
        sessionMap.put((Object)"userOverPassMark", (Object)userOverPassMark);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        Long toolSessionUid = mcSession.getUid();
        logger.debug((Object)("toolSessionUid: " + toolSessionUid));
        boolean isUserDefined = false;
        String userID = "";
        HttpSession ss = SessionManager.getSession();
        logger.debug((Object)("ss: " + ss));
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null && user.getUserID() != null) {
            userID = user.getUserID().toString();
            logger.debug((Object)("retrieved userId: " + userID));
        }
        logger.debug((Object)("userID: " + userID));
        McQueUsr existingMcQueUsr = mcService.getMcUserBySession(new Long(userID), mcSession.getUid());
        logger.debug((Object)("existingMcQueUsr: " + existingMcQueUsr));
        if (existingMcQueUsr != null) {
            isUserDefined = true;
        }
        logger.debug((Object)("isUserDefined: " + isUserDefined));
        McQueUsr mcQueUsr = null;
        if (!isUserDefined) {
            mcQueUsr = LearningUtil.createUser(request, mcService, new Long(toolSessionID));
            logger.debug((Object)("created user in the db: " + mcQueUsr));
        } else {
            mcQueUsr = existingMcQueUsr;
            logger.debug((Object)"assign");
        }
        logger.debug((Object)("final mcQueUsr: " + mcQueUsr));
        String highestAttemptOrder = "0";
        McUsrAttempt mcUsrAttempt = mcService.getAttemptWithLastAttemptOrderForUserInSession(mcQueUsr.getUid(), toolSessionUid);
        logger.debug((Object)("mcUsrAttempt with highest attempt order: " + mcUsrAttempt));
        if (mcUsrAttempt != null) {
            highestAttemptOrder = mcUsrAttempt.getAttemptOrder().toString();
        }
        logger.debug((Object)("highestAttemptOrder: " + highestAttemptOrder));
        int intHighestAttemptOrder = 0;
        intHighestAttemptOrder = new Integer(highestAttemptOrder);
        logger.debug((Object)("intHighestAttemptOrder: " + intHighestAttemptOrder));
        logger.debug((Object)("new intHighestAttemptOrder: " + ++intHighestAttemptOrder));
        highestAttemptOrder = new Integer(intHighestAttemptOrder).toString();
        logger.debug((Object)("new highestAttemptOrder: " + highestAttemptOrder));
        LearningUtil.createLearnerAttempt(request, mcQueUsr, selectedQuestionAndCandidateAnswersDTO, new Integer(learnerMark), passed, new Integer(highestAttemptOrder), null, mcService);
        logger.debug((Object)"created user attempt in the db");
        Map mapQuestionMarks = LearningUtil.buildMarksMap(request, mcContent.getMcContentId(), mcService);
        logger.debug((Object)("mapQuestionMarks:" + mapQuestionMarks));
        int learnerMarkAtLeast = LearningUtil.getMarksBasedLearnerMarkAtLeast(passMark, mapQuestionMarks);
        logger.debug((Object)("learnerMarkAtLeast:" + learnerMarkAtLeast));
        mcGeneralLearnerFlowDTO.setLearnerMarkAtLeast(new Integer(learnerMarkAtLeast).toString());
        logger.debug((Object)("user over passmark:" + mcGeneralLearnerFlowDTO.getUserOverPassMark()));
        logger.debug((Object)("is passmark applicable:" + mcGeneralLearnerFlowDTO.getPassMarkApplicable()));
        logger.debug((Object)("is tool reflective: " + mcContent.isReflect()));
        mcGeneralLearnerFlowDTO.setReflection(new Boolean(mcContent.isReflect()).toString());
        logger.debug((Object)("reflection subject: " + mcContent.getReflectionSubject()));
        String reflectionSubject = McUtils.replaceNewLines(mcContent.getReflectionSubject());
        mcGeneralLearnerFlowDTO.setReflectionSubject(reflectionSubject);
        logger.debug((Object)("mcGeneralLearnerFlowDTO for jsp: " + mcGeneralLearnerFlowDTO));
        totalMarksPossible = LearningUtil.getTotalMarksPossible(mcContent);
        logger.debug((Object)("totalMarksPossible: " + totalMarksPossible));
        mcGeneralLearnerFlowDTO.setTotalMarksPossible(totalMarksPossible);
        int topMark = LearningUtil.getTopMark(request, mcService, mcContent);
        int lowestMark = LearningUtil.getLowestMark(request, mcService, mcContent);
        int averageMark = LearningUtil.getAverageMark(request, mcService, mcContent);
        mcGeneralLearnerFlowDTO.setTopMark(new Integer(topMark).toString());
        mcGeneralLearnerFlowDTO.setLowestMark(new Integer(lowestMark).toString());
        mcGeneralLearnerFlowDTO.setAverageMark(new Integer(averageMark).toString());
        boolean showMarks = mcContent.isShowMarks();
        logger.debug((Object)("showMarks: " + showMarks));
        mcGeneralLearnerFlowDTO.setShowMarks(new Boolean(showMarks).toString());
        request.setAttribute("mcGeneralLearnerFlowDTO", (Object)mcGeneralLearnerFlowDTO);
        logger.debug((Object)("MC_GENERAL_LEARNER_FLOW_DTO: " + request.getAttribute("mcGeneralLearnerFlowDTO")));
        return mapping.findForward("individualReport");
    }

    public boolean allQuestionsChecked(IMcService mcService, List learnerInput, List allQuestionUidsList, McTempDataHolderDTO mcTempDataHolderDTO) {
        logger.debug((Object)("starting allQuestionsChecked learnerInput: " + learnerInput));
        logger.debug((Object)("using  allQuestionUidsList: " + allQuestionUidsList));
        boolean questionSelected = false;
        for (String uid : allQuestionUidsList) {
            logger.debug((Object)("using uid: " + uid));
            questionSelected = false;
            for (String learnerInputLine : learnerInput) {
                logger.debug((Object)("using learnerInputLine: " + learnerInputLine));
                int sepIndex = learnerInputLine.indexOf("-");
                logger.debug((Object)("having sepIndex: " + sepIndex));
                String selectedUid = learnerInputLine.substring(0, sepIndex);
                logger.debug((Object)("selectedUid: " + selectedUid));
                if (!uid.equals(selectedUid)) continue;
                logger.debug((Object)("equal uids found: " + selectedUid));
                questionSelected = true;
                break;
            }
            logger.debug((Object)("iterated loop questionSelected: " + questionSelected));
            if (questionSelected) continue;
            logger.debug((Object)("mcTempDataHolderDTO displayOrder:" + uid));
            String unselectedQuestionUid = uid;
            McQueContent mcQueContent = mcService.findMcQuestionContentByUid(new Long(unselectedQuestionUid));
            logger.debug((Object)("mcQueContent :" + mcQueContent));
            logger.debug((Object)("mcQueContent displayorder:" + mcQueContent.getDisplayOrder()));
            mcTempDataHolderDTO.setDisplayOrder(mcQueContent.getDisplayOrder().toString());
            return false;
        }
        return true;
    }

    public ActionForward getNextOptions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching getNextOptions...");
        McLearningForm mcLearningForm = (McLearningForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String questionIndex = mcLearningForm.getQuestionIndex();
        logger.debug((Object)("questionIndex: " + questionIndex));
        String httpSessionID = mcLearningForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        List sequentialCheckedCa = (List)sessionMap.get((Object)"questionAndCandidateAnswersKey");
        logger.debug((Object)("pre sequentialCheckedCa: " + sequentialCheckedCa));
        for (String input : sequentialCheckedCa) {
            logger.debug((Object)("input: " + input));
        }
        String[] checkedCa = mcLearningForm.getCheckedCa();
        logger.debug((Object)("checkedCa: " + checkedCa));
        if (checkedCa != null) {
            mcLearningForm.resetCa(mapping, request);
            for (int i = 0; i < checkedCa.length; ++i) {
                String currentCa = checkedCa[i];
                logger.debug((Object)("currentCa: " + currentCa));
                sequentialCheckedCa.add(currentCa);
            }
        }
        logger.debug((Object)("post sequentialCheckedCa: " + sequentialCheckedCa));
        for (String input : sequentialCheckedCa) {
            logger.debug((Object)("input: " + input));
        }
        sessionMap.put((Object)"questionAndCandidateAnswersKey", (Object)sequentialCheckedCa);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        logger.debug((Object)("updated sessionMap : " + sessionMap));
        String toolSessionID = request.getParameter("toolSessionID");
        logger.debug((Object)("toolSessionID: " + toolSessionID));
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionID));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        String toolContentId = mcSession.getMcContent().getMcContentId().toString();
        logger.debug((Object)("toolContentId: " + toolContentId));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentId));
        logger.debug((Object)("mcContent: " + mcContent));
        boolean randomize = mcContent.isRandomize();
        logger.debug((Object)("randomize: " + randomize));
        List listQuestionAndCandidateAnswersDTO = LearningUtil.buildQuestionAndCandidateAnswersDTO(request, mcContent, randomize, mcService);
        logger.debug((Object)("listQuestionAndCandidateAnswersDTO: " + listQuestionAndCandidateAnswersDTO));
        request.setAttribute("listQuestionCandidateAnswersDto", (Object)listQuestionAndCandidateAnswersDTO);
        logger.debug((Object)("LIST_QUESTION_CANDIDATEANSWERS_DTO: " + request.getAttribute("listQuestionCandidateAnswersDto")));
        McGeneralLearnerFlowDTO mcGeneralLearnerFlowDTO = LearningUtil.buildMcGeneralLearnerFlowDTO(mcContent);
        String totalQuestionCount = mcGeneralLearnerFlowDTO.getTotalQuestionCount();
        logger.debug((Object)("totalQuestionCount: " + totalQuestionCount));
        int intTotalQuestionCount = new Integer(totalQuestionCount);
        int intQuestionIndex = new Integer(questionIndex);
        logger.debug((Object)("intTotalQuestionCount versus intCurrentQuestionIndex: " + intTotalQuestionCount + " versus " + intQuestionIndex));
        if (intTotalQuestionCount == intQuestionIndex) {
            logger.debug((Object)("totalQuestionCount has been reached :" + totalQuestionCount));
            mcGeneralLearnerFlowDTO.setTotalCountReached(new Boolean(true).toString());
        }
        logger.debug((Object)("is tool reflective: " + mcContent.isReflect()));
        mcGeneralLearnerFlowDTO.setReflection(new Boolean(mcContent.isReflect()).toString());
        logger.debug((Object)("reflection subject: " + mcContent.getReflectionSubject()));
        String reflectionSubject = McUtils.replaceNewLines(mcContent.getReflectionSubject());
        mcGeneralLearnerFlowDTO.setReflectionSubject(reflectionSubject);
        mcGeneralLearnerFlowDTO.setRetries(new Boolean(mcContent.isRetries()).toString());
        String totalMarksPossible = LearningUtil.getTotalMarksPossible(mcContent);
        logger.debug((Object)("totalMarksPossible: " + totalMarksPossible));
        mcGeneralLearnerFlowDTO.setTotalMarksPossible(totalMarksPossible);
        logger.debug((Object)("mcGeneralLearnerFlowDTO for jsp: " + mcGeneralLearnerFlowDTO));
        mcGeneralLearnerFlowDTO.setQuestionIndex(new Integer(questionIndex).toString());
        request.setAttribute("mcGeneralLearnerFlowDTO", (Object)mcGeneralLearnerFlowDTO);
        return mapping.findForward("loadLearner");
    }

    public ActionForward redoQuestions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserDTO user;
        logger.debug((Object)"dispatching redoQuestions...");
        McLearningForm mcLearningForm = (McLearningForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        String toolSessionID = request.getParameter("toolSessionID");
        logger.debug((Object)("toolSessionID: " + toolSessionID));
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionID));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        String toolContentId = mcSession.getMcContent().getMcContentId().toString();
        logger.debug((Object)("toolContentId: " + toolContentId));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentId));
        logger.debug((Object)("mcContent: " + mcContent));
        boolean randomize = mcContent.isRandomize();
        logger.debug((Object)("randomize: " + randomize));
        List listQuestionAndCandidateAnswersDTO = LearningUtil.buildQuestionAndCandidateAnswersDTO(request, mcContent, randomize, mcService);
        logger.debug((Object)("listQuestionAndCandidateAnswersDTO: " + listQuestionAndCandidateAnswersDTO));
        request.setAttribute("listQuestionCandidateAnswersDto", (Object)listQuestionAndCandidateAnswersDTO);
        logger.debug((Object)("LIST_QUESTION_CANDIDATEANSWERS_DTO: " + request.getAttribute("listQuestionCandidateAnswersDto")));
        McGeneralLearnerFlowDTO mcGeneralLearnerFlowDTO = LearningUtil.buildMcGeneralLearnerFlowDTO(mcContent);
        mcGeneralLearnerFlowDTO.setCurrentQuestionIndex(new Integer(1).toString());
        mcGeneralLearnerFlowDTO.setTotalCountReached(new Boolean(false).toString());
        String httpSessionID = mcLearningForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String passMarkApplicable = (String)sessionMap.get((Object)"passMarkApplicable");
        logger.debug((Object)("passMarkApplicable: " + passMarkApplicable));
        mcGeneralLearnerFlowDTO.setPassMarkApplicable(passMarkApplicable);
        mcLearningForm.setPassMarkApplicable(passMarkApplicable);
        String userOverPassMark = (String)sessionMap.get((Object)"userOverPassMark");
        logger.debug((Object)("userOverPassMark: " + userOverPassMark));
        mcGeneralLearnerFlowDTO.setUserOverPassMark(userOverPassMark);
        mcLearningForm.setUserOverPassMark(userOverPassMark);
        sessionMap = new SessionMap();
        LinkedList sequentialCheckedCa = new LinkedList();
        sessionMap.put((Object)"questionAndCandidateAnswersKey", sequentialCheckedCa);
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        mcLearningForm.setHttpSessionID(sessionMap.getSessionID());
        String userID = "";
        HttpSession ss = SessionManager.getSession();
        logger.debug((Object)("ss: " + ss));
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null && user.getUserID() != null) {
            userID = user.getUserID().toString();
            logger.debug((Object)("retrieved userId: " + userID));
        }
        McQueUsr mcQueUsr = mcService.getMcUserBySession(new Long(userID), mcSession.getUid());
        logger.debug((Object)("mcQueUsr: " + mcQueUsr));
        Long queUsrId = mcQueUsr.getUid();
        logger.debug((Object)("queUsrId: " + queUsrId));
        int learnerBestMark = LearningUtil.getHighestMark(request, queUsrId, mcService);
        logger.debug((Object)("learnerBestMark: " + learnerBestMark));
        mcGeneralLearnerFlowDTO.setLearnerBestMark(new Integer(learnerBestMark).toString());
        logger.debug((Object)("is tool reflective: " + mcContent.isReflect()));
        mcGeneralLearnerFlowDTO.setReflection(new Boolean(mcContent.isReflect()).toString());
        logger.debug((Object)("reflection subject: " + mcContent.getReflectionSubject()));
        String reflectionSubject = McUtils.replaceNewLines(mcContent.getReflectionSubject());
        mcGeneralLearnerFlowDTO.setReflectionSubject(reflectionSubject);
        logger.debug((Object)("mcContent.isRetries(): " + mcContent.isRetries()));
        mcGeneralLearnerFlowDTO.setRetries(new Boolean(mcContent.isRetries()).toString());
        String totalMarksPossible = LearningUtil.getTotalMarksPossible(mcContent);
        logger.debug((Object)("totalMarksPossible: " + totalMarksPossible));
        mcGeneralLearnerFlowDTO.setTotalMarksPossible(totalMarksPossible);
        logger.debug((Object)("mcGeneralLearnerFlowDTO for jsp: " + mcGeneralLearnerFlowDTO));
        request.setAttribute("mcGeneralLearnerFlowDTO", (Object)mcGeneralLearnerFlowDTO);
        logger.debug((Object)("MC_GENERAL_LEARNER_FLOW_DTO: " + request.getAttribute("mcGeneralLearnerFlowDTO")));
        return mapping.findForward("redoQuestions");
    }

    public void prepareViewAnswersData(ActionMapping mapping, McLearningForm mcLearningForm, HttpServletRequest request, HttpServletResponse response) {
        UserDTO user;
        logger.debug((Object)("running  prepareViewAnswersData..." + mcLearningForm));
        logger.debug((Object)("getServlet() :" + this.getServlet()));
        IMcService mcService = null;
        if (this.getServlet() != null) {
            mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        } else {
            logger.debug((Object)"getting service from the form :");
            mcService = mcLearningForm.getMcService();
        }
        logger.debug((Object)("mcService :" + mcService));
        String toolSessionID = request.getParameter("toolSessionID");
        logger.debug((Object)("toolSessionID: " + toolSessionID));
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionID));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        String toolContentId = mcSession.getMcContent().getMcContentId().toString();
        logger.debug((Object)("toolContentId: " + toolContentId));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentId));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralLearnerFlowDTO mcGeneralLearnerFlowDTO = LearningUtil.buildMcGeneralLearnerFlowDTO(mcContent);
        String learnerProgress = mcLearningForm.getLearnerProgress();
        logger.debug((Object)("learnerProgress in prepareViewAnswersData: " + learnerProgress));
        mcGeneralLearnerFlowDTO.setLearnerProgress(learnerProgress);
        String learnerProgressUserId = mcLearningForm.getLearnerProgressUserId();
        logger.debug((Object)("learnerProgressUserId: " + learnerProgressUserId));
        mcGeneralLearnerFlowDTO.setLearnerProgressUserId(learnerProgressUserId);
        mcGeneralLearnerFlowDTO.setLearnerProgress(learnerProgress);
        request.setAttribute("mcGeneralLearnerFlowDTO", (Object)mcGeneralLearnerFlowDTO);
        logger.debug((Object)("MC_GENERAL_LEARNER_FLOW_DTO: " + request.getAttribute("mcGeneralLearnerFlowDTO")));
        int intTotalQuestionCount = mcContent.getMcQueContents().size();
        String totalQuestionCount = new Integer(intTotalQuestionCount).toString();
        logger.debug((Object)("totalQuestionCount: " + totalQuestionCount));
        Map mapQuestionsUidContent = AuthoringUtil.rebuildQuestionUidMapfromDB(request, new Long(toolContentId), mcService);
        logger.debug((Object)("mapQuestionsUidContent:" + mapQuestionsUidContent));
        Map mapStartupGeneralOptionsContent = AuthoringUtil.rebuildStartupGeneralOptionsContentMapfromDB(request, mapQuestionsUidContent, mcService);
        logger.debug((Object)("mapStartupGeneralOptionsContent:" + mapStartupGeneralOptionsContent));
        mcGeneralLearnerFlowDTO.setMapGeneralOptionsContent(mapStartupGeneralOptionsContent);
        Map mapQuestionsContent = AuthoringUtil.rebuildQuestionMapfromDB(request, new Long(toolContentId), mcService);
        logger.debug((Object)("mapQuestionsContent:" + mapQuestionsContent));
        mcGeneralLearnerFlowDTO.setMapQuestionsContent(mapQuestionsContent);
        Map mapFeedbackContent = AuthoringUtil.rebuildFeedbackMapfromDB(request, new Long(toolContentId), mcService);
        logger.debug((Object)("mapFeedbackContent:" + mapFeedbackContent));
        mcGeneralLearnerFlowDTO.setMapFeedbackContent(mapFeedbackContent);
        boolean learnerProgressOn = false;
        if (learnerProgressUserId != null && learnerProgress.equalsIgnoreCase("true") && learnerProgressUserId.length() > 0) {
            logger.debug((Object)("request is for learner progress: learnerProgress: " + learnerProgress));
            logger.debug((Object)("request is for learner progress: learnerProgressUserId: " + learnerProgressUserId));
            learnerProgressOn = true;
        }
        logger.debug((Object)("final learnerProgressOn:" + learnerProgressOn));
        McQueUsr mcQueUsr = null;
        Long queUsrId = null;
        if (!learnerProgressOn) {
            mcQueUsr = LearningUtil.getUser(request, mcService, toolSessionID);
            logger.debug((Object)("mcQueUsr: " + mcQueUsr));
            queUsrId = mcQueUsr.getUid();
            logger.debug((Object)("queUsrId: " + queUsrId));
        } else {
            logger.debug((Object)("using mcSession: " + mcSession));
            logger.debug((Object)("using learnerProgressUserId: " + learnerProgressUserId));
            mcQueUsr = mcService.getMcUserBySession(new Long(learnerProgressUserId), mcSession.getUid());
            logger.debug((Object)("mcQueUsr: " + mcQueUsr));
            queUsrId = mcQueUsr.getUid();
            logger.debug((Object)("queUsrId: " + queUsrId));
        }
        logger.debug((Object)("final mcQueUsr: " + mcQueUsr));
        logger.debug((Object)("final queUsrId: " + queUsrId));
        Long toolContentUID = mcContent.getUid();
        logger.debug((Object)("toolContentUID: " + toolContentUID));
        TreeMap<String, String> mapFinalAnswersIsContent = new TreeMap<String, String>(new McComparator());
        TreeMap<String, String> mapFinalAnswersContent = new TreeMap<String, String>(new McComparator());
        McUsrAttempt mcUsrAttemptLocal = mcService.getAttemptWithLastAttemptOrderForUserInSession(mcQueUsr.getUid(), mcSession.getUid());
        logger.debug((Object)("obtain mcUsrAttemptLocal with highest attempt order: " + mcUsrAttemptLocal));
        String highestAttemptOrder = "";
        Object listUserAttempts = null;
        if (mcUsrAttemptLocal != null) {
            highestAttemptOrder = mcUsrAttemptLocal.getAttemptOrder().toString();
            logger.debug((Object)("found highestAttemptOrder: " + highestAttemptOrder));
        }
        request.setAttribute("highestAttempOrder", (Object)highestAttemptOrder);
        TreeMap mapQueAttempts = new TreeMap(new McComparator());
        TreeMap mapQueCorrectAttempts = new TreeMap(new McComparator());
        TreeMap mapQueIncorrectAttempts = new TreeMap(new McComparator());
        for (int i = 1; i <= new Integer(totalQuestionCount); ++i) {
            logger.debug((Object)("doing question with display order: " + i));
            McQueContent mcQueContent = mcService.getQuestionContentByDisplayOrder(new Long(i), toolContentUID);
            logger.debug((Object)("mcQueContent uid: " + mcQueContent.getUid()));
            McUsrAttempt mcUsrAttemptFinal = mcService.getUserAttemptForQuestionContentAndSessionUid(mcQueUsr.getUid(), mcQueContent.getUid(), mcSession.getUid(), new Integer(highestAttemptOrder));
            logger.debug((Object)("mcUsrAttemptFinal: " + mcUsrAttemptFinal));
            logger.debug((Object)("mcUsrAttemptFinal is Correct?: " + mcUsrAttemptFinal.isAttemptCorrect()));
            mapFinalAnswersIsContent.put(new Integer(i).toString(), new Boolean(mcUsrAttemptFinal.isAttemptCorrect()).toString());
            mapFinalAnswersContent.put(new Integer(i).toString(), mcUsrAttemptFinal.getMcOptionsContent().getMcQueOptionText().toString());
            TreeMap mapAttemptOrderAttempts = new TreeMap(new McComparator());
            TreeMap mapAttemptOrderCorrectAttempts = new TreeMap(new McComparator());
            TreeMap mapAttemptOrderIncorrectAttempts = new TreeMap(new McComparator());
            for (int j = 1; j <= 30; ++j) {
                logger.debug((Object)("getting list for queUsrId: " + queUsrId));
                List attemptsByAttemptOrder = mcService.getAttemptByAttemptOrder(queUsrId, mcQueContent.getUid(), new Integer(j));
                logger.debug((Object)("attemptsByAttemptOrder: " + j + " is: " + attemptsByAttemptOrder));
                TreeMap<String, String> mapAttempts = new TreeMap<String, String>(new McComparator());
                TreeMap<String, String> mapAttemptsIncorrect = new TreeMap<String, String>(new McComparator());
                TreeMap<String, String> mapAttemptsCorrect = new TreeMap<String, String>(new McComparator());
                Iterator attemptIterator = attemptsByAttemptOrder.iterator();
                Long mapIndex = new Long(1L);
                while (attemptIterator.hasNext()) {
                    McUsrAttempt mcUsrAttempt = (McUsrAttempt)attemptIterator.next();
                    if (!learnerProgressOn) {
                        logger.debug((Object)"learnerProgressOn is false, populating map based on all the learners");
                        if (mcUsrAttempt.isAttemptCorrect()) {
                            mapAttemptsCorrect.put(mapIndex.toString(), mcUsrAttempt.getMcOptionsContent().getMcQueOptionText());
                        } else {
                            mapAttemptsIncorrect.put(mapIndex.toString(), mcUsrAttempt.getMcOptionsContent().getMcQueOptionText());
                        }
                        mapAttempts.put(mapIndex.toString(), mcUsrAttempt.getMcOptionsContent().getMcQueOptionText());
                        logger.debug((Object)("added attempt with order: " + mcUsrAttempt.getAttemptOrder() + " , option text is: " + mcUsrAttempt.getMcOptionsContent().getMcQueOptionText()));
                        mapIndex = new Long(mapIndex + 1L);
                        continue;
                    }
                    logger.debug((Object)("learnerProgressOn is true, populating map based on the learner id: " + learnerProgressUserId));
                    logger.debug((Object)("retrieve user based on uid in the attempt: " + mcUsrAttempt.getQueUsrId()));
                    McQueUsr mcQueUsrLocal = mcService.getMcUserByUID(mcUsrAttempt.getQueUsrId());
                    logger.debug((Object)("mcQueUsrLocal: " + mcQueUsrLocal));
                    if (!mcQueUsrLocal.getQueUsrId().toString().equals(learnerProgressUserId)) continue;
                    logger.debug((Object)("found learner progress user: " + learnerProgressUserId));
                    if (mcUsrAttempt.isAttemptCorrect()) {
                        mapAttemptsCorrect.put(mapIndex.toString(), mcUsrAttempt.getMcOptionsContent().getMcQueOptionText());
                    } else {
                        mapAttemptsIncorrect.put(mapIndex.toString(), mcUsrAttempt.getMcOptionsContent().getMcQueOptionText());
                    }
                    mapAttempts.put(mapIndex.toString(), mcUsrAttempt.getMcOptionsContent().getMcQueOptionText());
                    logger.debug((Object)("added attempt with order: " + mcUsrAttempt.getAttemptOrder() + " , option text is: " + mcUsrAttempt.getMcOptionsContent().getMcQueOptionText()));
                    mapIndex = new Long(mapIndex + 1L);
                }
                logger.debug((Object)("final mapAttempts is: " + mapAttempts));
                if (mapAttempts.size() > 0) {
                    mapAttemptOrderAttempts.put(new Integer(j).toString(), mapAttempts);
                }
                if (mapAttemptsCorrect.size() > 0) {
                    mapAttemptOrderCorrectAttempts.put(new Integer(j).toString(), mapAttemptsCorrect);
                }
                if (mapAttemptsIncorrect.size() <= 0) continue;
                mapAttemptOrderIncorrectAttempts.put(new Integer(j).toString(), mapAttemptsIncorrect);
            }
            logger.debug((Object)("final mapAttemptOrderAttempts is: " + mapAttemptOrderAttempts));
            if (mapAttemptOrderAttempts.size() > 0) {
                mapQueAttempts.put(new Integer(i).toString(), mapAttemptOrderAttempts);
            }
            if (mapAttemptOrderCorrectAttempts.size() > 0) {
                mapQueCorrectAttempts.put(new Integer(i).toString(), mapAttemptOrderCorrectAttempts);
            }
            if (mapAttemptOrderIncorrectAttempts.size() <= 0) continue;
            mapQueIncorrectAttempts.put(new Integer(i).toString(), mapAttemptOrderIncorrectAttempts);
        }
        logger.debug((Object)("final mapFinalAnswersContent is: " + mapFinalAnswersContent));
        logger.debug((Object)("final mapFinalAnswersIsContent is: " + mapFinalAnswersIsContent));
        mcGeneralLearnerFlowDTO.setMapFinalAnswersIsContent(mapFinalAnswersIsContent);
        mcGeneralLearnerFlowDTO.setMapFinalAnswersContent(mapFinalAnswersContent);
        logger.debug((Object)("final mapQueAttempts is: " + mapQueAttempts));
        logger.debug((Object)("final mapQueCorrectAttempts is: " + mapQueCorrectAttempts));
        logger.debug((Object)("final mapQueIncorrectAttempts is: " + mapQueIncorrectAttempts));
        mcGeneralLearnerFlowDTO.setMapQueAttempts(mapQueAttempts);
        mcGeneralLearnerFlowDTO.setMapQueCorrectAttempts(mapQueCorrectAttempts);
        mcGeneralLearnerFlowDTO.setMapQueIncorrectAttempts(mapQueIncorrectAttempts);
        logger.debug((Object)("is tool reflective: " + mcContent.isReflect()));
        mcGeneralLearnerFlowDTO.setReflection(new Boolean(mcContent.isReflect()).toString());
        logger.debug((Object)("reflection subject: " + mcContent.getReflectionSubject()));
        String reflectionSubject = McUtils.replaceNewLines(mcContent.getReflectionSubject());
        mcGeneralLearnerFlowDTO.setReflectionSubject(reflectionSubject);
        logger.debug((Object)("mcContent.isRetries(): " + mcContent.isRetries()));
        mcGeneralLearnerFlowDTO.setRetries(new Boolean(mcContent.isRetries()).toString());
        String userID = "";
        HttpSession ss = SessionManager.getSession();
        logger.debug((Object)("ss: " + ss));
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null && user.getUserID() != null) {
            userID = user.getUserID().toString();
            logger.debug((Object)("retrieved userId: " + userID));
        }
        logger.debug((Object)"attempt getting notebookEntry: ");
        NotebookEntry notebookEntry = mcService.getEntry(new Long(toolSessionID), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(userID));
        logger.debug((Object)("notebookEntry: " + notebookEntry));
        if (notebookEntry != null) {
            String notebookEntryPresentable = notebookEntry.getEntry();
            notebookEntryPresentable = McUtils.replaceNewLines(notebookEntryPresentable);
            mcGeneralLearnerFlowDTO.setNotebookEntry(notebookEntryPresentable);
        }
        String reportViewOnly = mcLearningForm.getReportViewOnly();
        logger.debug((Object)("reportViewOnly: " + reportViewOnly));
        mcGeneralLearnerFlowDTO.setReportViewOnly(reportViewOnly);
        logger.debug((Object)("mcContent.isRetries(): " + mcContent.isRetries()));
        mcGeneralLearnerFlowDTO.setRetries(new Boolean(mcContent.isRetries()).toString());
        String httpSessionID = mcLearningForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String requestByStarter = (String)request.getAttribute("requestByStarter");
        logger.debug((Object)("requestByStarter: " + requestByStarter));
        String passMarkApplicable = null;
        String userOverPassMark = null;
        if (sessionMap != null) {
            passMarkApplicable = (String)sessionMap.get((Object)"passMarkApplicable");
        }
        logger.debug((Object)("passMarkApplicable: " + passMarkApplicable));
        if (passMarkApplicable == null) {
            logger.debug((Object)"reading request parameters");
            passMarkApplicable = request.getParameter("passMarkApplicable");
            logger.debug((Object)("passMarkApplicable: " + passMarkApplicable));
        }
        if (sessionMap != null) {
            userOverPassMark = (String)sessionMap.get((Object)"userOverPassMark");
        }
        logger.debug((Object)("userOverPassMark: " + userOverPassMark));
        if (userOverPassMark == null) {
            userOverPassMark = request.getParameter("userOverPassMark");
            logger.debug((Object)("userOverPassMark: " + userOverPassMark));
        }
        if (passMarkApplicable != null) {
            mcGeneralLearnerFlowDTO.setPassMarkApplicable(passMarkApplicable);
            mcLearningForm.setPassMarkApplicable(passMarkApplicable);
        }
        if (userOverPassMark != null) {
            mcGeneralLearnerFlowDTO.setUserOverPassMark(userOverPassMark);
            mcLearningForm.setUserOverPassMark(userOverPassMark);
        }
        if (sessionMap != null) {
            if (passMarkApplicable != null) {
                sessionMap.put((Object)"passMarkApplicable", (Object)passMarkApplicable);
            }
            if (userOverPassMark != null) {
                sessionMap.put((Object)"userOverPassMark", (Object)userOverPassMark);
            }
            request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        }
        String totalMarksPossible = LearningUtil.getTotalMarksPossible(mcContent);
        logger.debug((Object)("totalMarksPossible: " + totalMarksPossible));
        mcGeneralLearnerFlowDTO.setTotalMarksPossible(totalMarksPossible);
        boolean showMarks = mcContent.isShowMarks();
        logger.debug((Object)("showMarks: " + showMarks));
        mcGeneralLearnerFlowDTO.setShowMarks(new Boolean(showMarks).toString());
        logger.debug((Object)("mcGeneralLearnerFlowDTO for jsp: " + mcGeneralLearnerFlowDTO));
        request.setAttribute("mcGeneralLearnerFlowDTO", (Object)mcGeneralLearnerFlowDTO);
        logger.debug((Object)("MC_GENERAL_LEARNER_FLOW_DTO: " + request.getAttribute("mcGeneralLearnerFlowDTO")));
        logger.debug((Object)"end of prepareViewAnswersData.");
    }

    public ActionForward viewAnswers(ActionMapping mapping, McLearningForm mcLearningForm, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)("dispatching viewLearnerProgress..." + mcLearningForm));
        logger.debug((Object)("mcLearningForm :" + mcLearningForm));
        this.prepareViewAnswersData(mapping, mcLearningForm, request, response);
        logger.debug((Object)"post prepareViewAnswersData");
        return mapping.findForward("viewAnswers");
    }

    public ActionForward viewSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching viewSummary...");
        McLearningForm mcLearningForm = (McLearningForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String userID = request.getParameter("userID");
        logger.debug((Object)("userID: " + userID));
        String toolSessionID = request.getParameter("toolSessionID");
        logger.debug((Object)("toolSessionID: " + toolSessionID));
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionID));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        McQueUsr mcQueUsr = mcService.getMcUserBySession(new Long(userID), mcSession.getUid());
        logger.debug((Object)("mcQueUsr: " + mcQueUsr));
        mcQueUsr.setViewSummaryRequested(true);
        mcService.updateMcQueUsr(mcQueUsr);
        logger.debug((Object)("view summary requested by mcQueUsr: " + mcQueUsr));
        String toolContentId = mcSession.getMcContent().getMcContentId().toString();
        logger.debug((Object)("toolContentId: " + toolContentId));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentId));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralLearnerFlowDTO mcGeneralLearnerFlowDTO = LearningUtil.buildMcGeneralLearnerFlowDTO(mcContent);
        mcGeneralLearnerFlowDTO.setReflection(new Boolean(mcContent.isReflect()).toString());
        mcGeneralLearnerFlowDTO.setNotebookEntriesVisible(new Boolean(false).toString());
        int countSessionComplete = 0;
        for (McSession mcSessionLocal : mcContent.getMcSessions()) {
            if (mcSession == null) continue;
            logger.debug((Object)("mcSessionLocal: " + mcSessionLocal));
            if (!mcSessionLocal.getSessionStatus().equals("COMPLETED")) continue;
            logger.debug((Object)("COMPLETED session found: " + mcSessionLocal));
            ++countSessionComplete;
        }
        logger.debug((Object)("countSessionComplete: " + countSessionComplete));
        int topMark = LearningUtil.getTopMark(request, mcService, mcContent);
        int lowestMark = LearningUtil.getLowestMark(request, mcService, mcContent);
        int averageMark = LearningUtil.getAverageMark(request, mcService, mcContent);
        logger.debug((Object)("countSessionComplete: " + countSessionComplete));
        logger.debug((Object)("topMark: " + topMark));
        logger.debug((Object)("lowestMark: " + lowestMark));
        logger.debug((Object)("averageMark: " + averageMark));
        mcGeneralLearnerFlowDTO.setCountSessionComplete(new Integer(countSessionComplete).toString());
        mcGeneralLearnerFlowDTO.setTopMark(new Integer(topMark).toString());
        mcGeneralLearnerFlowDTO.setLowestMark(new Integer(lowestMark).toString());
        mcGeneralLearnerFlowDTO.setAverageMark(new Integer(averageMark).toString());
        logger.debug((Object)("is tool reflective: " + mcContent.isReflect()));
        mcGeneralLearnerFlowDTO.setReflection(new Boolean(mcContent.isReflect()).toString());
        logger.debug((Object)("reflection subject: " + mcContent.getReflectionSubject()));
        String reflectionSubject = McUtils.replaceNewLines(mcContent.getReflectionSubject());
        mcGeneralLearnerFlowDTO.setReflectionSubject(reflectionSubject);
        logger.debug((Object)("mcContent.isRetries(): " + mcContent.isRetries()));
        mcGeneralLearnerFlowDTO.setRetries(new Boolean(mcContent.isRetries()).toString());
        String httpSessionID = mcLearningForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String passMarkApplicable = (String)sessionMap.get((Object)"passMarkApplicable");
        logger.debug((Object)("passMarkApplicable: " + passMarkApplicable));
        String userOverPassMark = (String)sessionMap.get((Object)"userOverPassMark");
        logger.debug((Object)("userOverPassMark: " + userOverPassMark));
        if (passMarkApplicable == null) {
            passMarkApplicable = request.getParameter("passMarkApplicable");
        }
        logger.debug((Object)("passMarkApplicable: " + passMarkApplicable));
        mcLearningForm.setPassMarkApplicable(passMarkApplicable);
        mcGeneralLearnerFlowDTO.setPassMarkApplicable(passMarkApplicable);
        if (userOverPassMark == null) {
            userOverPassMark = request.getParameter("userOverPassMark");
        }
        logger.debug((Object)("userOverPassMark: " + userOverPassMark));
        mcLearningForm.setUserOverPassMark(userOverPassMark);
        mcGeneralLearnerFlowDTO.setUserOverPassMark(userOverPassMark);
        sessionMap.put((Object)"passMarkApplicable", (Object)passMarkApplicable);
        sessionMap.put((Object)"userOverPassMark", (Object)userOverPassMark);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        String totalMarksPossible = LearningUtil.getTotalMarksPossible(mcContent);
        logger.debug((Object)("totalMarksPossible: " + totalMarksPossible));
        mcGeneralLearnerFlowDTO.setTotalMarksPossible(totalMarksPossible);
        logger.debug((Object)("mcGeneralLearnerFlowDTO for jsp: " + mcGeneralLearnerFlowDTO));
        request.setAttribute("mcGeneralLearnerFlowDTO", (Object)mcGeneralLearnerFlowDTO);
        logger.debug((Object)("MC_GENERAL_LEARNER_FLOW_DTO: " + request.getAttribute("mcGeneralLearnerFlowDTO")));
        return mapping.findForward("resultsSummary");
    }

    protected void setContentInUse(HttpServletRequest request, String toolContentId, IMcService mcService) {
        logger.debug((Object)"starting setContentInUse");
        logger.debug((Object)("toolContentId:" + toolContentId));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentId));
        logger.debug((Object)("mcContent:" + mcContent));
        mcContent.setContentInUse(true);
        logger.debug((Object)"content has been set to inuse");
        mcService.saveMcContent(mcContent);
    }

    public ActionForward redoQuestions(HttpServletRequest request, McLearningForm mcLearningForm, ActionMapping mapping) {
        logger.debug((Object)"requested redoQuestions...");
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        TreeMap mapGeneralCheckedOptionsContent = new TreeMap(new McComparator());
        String toolSessionID = request.getParameter("toolSessionID");
        logger.debug((Object)("toolSessionID: " + toolSessionID));
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionID));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        String toolContentId = mcSession.getMcContent().getMcContentId().toString();
        logger.debug((Object)("toolContentId: " + toolContentId));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentId));
        logger.debug((Object)("mcContent: " + mcContent));
        boolean randomize = mcContent.isRandomize();
        logger.debug((Object)("randomize: " + randomize));
        List listQuestionAndCandidateAnswersDTO = LearningUtil.buildQuestionAndCandidateAnswersDTO(request, mcContent, randomize, mcService);
        logger.debug((Object)("listQuestionAndCandidateAnswersDTO: " + listQuestionAndCandidateAnswersDTO));
        request.setAttribute("listQuestionCandidateAnswersDto", (Object)listQuestionAndCandidateAnswersDTO);
        logger.debug((Object)("LIST_QUESTION_CANDIDATEANSWERS_DTO: " + request.getAttribute("listQuestionCandidateAnswersDto")));
        McGeneralLearnerFlowDTO mcGeneralLearnerFlowDTO = LearningUtil.buildMcGeneralLearnerFlowDTO(mcContent);
        mcGeneralLearnerFlowDTO.setQuestionIndex(new Integer(1).toString());
        logger.debug((Object)("is tool reflective: " + mcContent.isReflect()));
        mcGeneralLearnerFlowDTO.setReflection(new Boolean(mcContent.isReflect()).toString());
        logger.debug((Object)("reflection subject: " + mcContent.getReflectionSubject()));
        String reflectionSubject = McUtils.replaceNewLines(mcContent.getReflectionSubject());
        mcGeneralLearnerFlowDTO.setReflectionSubject(reflectionSubject);
        logger.debug((Object)("mcContent.isRetries(): " + mcContent.isRetries()));
        mcGeneralLearnerFlowDTO.setRetries(new Boolean(mcContent.isRetries()).toString());
        String httpSessionID = mcLearningForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String passMarkApplicable = (String)sessionMap.get((Object)"passMarkApplicable");
        logger.debug((Object)("passMarkApplicable: " + passMarkApplicable));
        mcGeneralLearnerFlowDTO.setPassMarkApplicable(passMarkApplicable);
        mcLearningForm.setPassMarkApplicable(passMarkApplicable);
        String userOverPassMark = (String)sessionMap.get((Object)"userOverPassMark");
        logger.debug((Object)("userOverPassMark: " + userOverPassMark));
        mcGeneralLearnerFlowDTO.setUserOverPassMark(userOverPassMark);
        mcLearningForm.setUserOverPassMark(userOverPassMark);
        String totalMarksPossible = LearningUtil.getTotalMarksPossible(mcContent);
        logger.debug((Object)("totalMarksPossible: " + totalMarksPossible));
        mcGeneralLearnerFlowDTO.setTotalMarksPossible(totalMarksPossible);
        logger.debug((Object)("mcGeneralLearnerFlowDTO for jsp: " + mcGeneralLearnerFlowDTO));
        request.setAttribute("mcGeneralLearnerFlowDTO", (Object)mcGeneralLearnerFlowDTO);
        logger.debug((Object)("MC_GENERAL_LEARNER_FLOW_DTO: " + request.getAttribute("mcGeneralLearnerFlowDTO")));
        logger.debug((Object)"fwding to LOAD_LEARNER: loadLearner");
        return mapping.findForward("loadLearner");
    }

    public void persistError(HttpServletRequest request, String message) {
        ActionMessages errors = new ActionMessages();
        errors.add("org.apache.struts.action.ERROR", new ActionMessage(message));
        logger.debug((Object)("add " + message + "  to ActionMessages:"));
        this.saveErrors(request, errors);
    }

    public ActionForward submitReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException {
        logger.debug((Object)"dispatching submitReflection...");
        McLearningForm mcLearningForm = (McLearningForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String toolSessionID = request.getParameter("toolSessionID");
        logger.debug((Object)("toolSessionID: " + toolSessionID));
        mcLearningForm.setToolSessionID(toolSessionID);
        String userID = request.getParameter("userID");
        logger.debug((Object)("userID: " + userID));
        mcLearningForm.setUserID(userID);
        String reflectionEntry = request.getParameter("entryText");
        logger.debug((Object)("reflectionEntry: " + reflectionEntry));
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionID));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        McQueUsr mcQueUsr = mcService.getMcUserBySession(new Long(userID), mcSession.getUid());
        logger.debug((Object)("McQueUsr:" + mcQueUsr));
        if (mcQueUsr == null) {
            logger.debug((Object)"attempt creating  user record since it must exist for the runOffline + reflection screens");
            HttpSession ss = SessionManager.getSession();
            UserDTO toolUser = (UserDTO)ss.getAttribute("user");
            logger.debug((Object)("retrieving toolUser: " + toolUser));
            logger.debug((Object)("retrieving toolUser userId: " + toolUser.getUserID()));
            logger.debug((Object)("retrieving toolUser username: " + toolUser.getLogin()));
            String userName = toolUser.getLogin();
            String fullName = toolUser.getFirstName() + " " + toolUser.getLastName();
            logger.debug((Object)("retrieving toolUser fullname: " + fullName));
            Long userId = new Long(toolUser.getUserID().longValue());
            logger.debug((Object)("userId: " + userId));
            logger.debug((Object)("retrieving toolUser fullname: " + fullName));
            mcQueUsr = new McQueUsr(userId, userName, fullName, mcSession, new TreeSet());
            mcService.createMcQueUsr(mcQueUsr);
            logger.debug((Object)("createMcQueUsr - mcQueUsr: " + mcQueUsr));
            logger.debug((Object)("session uid: " + mcSession.getUid()));
            logger.debug((Object)("mcQueUsr: " + mcQueUsr));
            mcService.createMcQueUsr(mcQueUsr);
            logger.debug((Object)("created mcQueUsr in the db: " + mcQueUsr));
        }
        logger.debug((Object)("McQueUsr:" + mcQueUsr));
        logger.debug((Object)("toolSessionID:" + toolSessionID));
        logger.debug((Object)("CoreNotebookConstants.NOTEBOOK_TOOL:" + CoreNotebookConstants.NOTEBOOK_TOOL));
        logger.debug((Object)"MY_SIGNATURE:lamc11");
        logger.debug((Object)("userID:" + userID));
        logger.debug((Object)("reflectionEntry:" + reflectionEntry));
        logger.debug((Object)"attempt getting notebookEntry: ");
        NotebookEntry notebookEntry = mcService.getEntry(new Long(toolSessionID), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(userID));
        logger.debug((Object)("notebookEntry: " + notebookEntry));
        if (notebookEntry != null) {
            notebookEntry.setEntry(reflectionEntry);
            mcService.updateEntry(notebookEntry);
        } else {
            mcService.createNotebookEntry(new Long(toolSessionID), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(userID), reflectionEntry);
        }
        return this.endLearning(mapping, form, request, response);
    }

    public ActionForward forwardtoReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException {
        UserDTO user;
        logger.debug((Object)"dispatching forwardtoReflection...");
        McLearningForm mcLearningForm = (McLearningForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String toolSessionID = request.getParameter("toolSessionID");
        logger.debug((Object)("toolSessionID: " + toolSessionID));
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionID));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        McContent mcContent = mcSession.getMcContent();
        logger.debug((Object)("using mcContent: " + mcContent));
        McGeneralLearnerFlowDTO mcGeneralLearnerFlowDTO = new McGeneralLearnerFlowDTO();
        mcGeneralLearnerFlowDTO.setActivityTitle(mcContent.getTitle());
        String reflectionSubject = mcContent.getReflectionSubject();
        reflectionSubject = McUtils.replaceNewLines(reflectionSubject);
        mcGeneralLearnerFlowDTO.setReflectionSubject(reflectionSubject);
        String userID = "";
        HttpSession ss = SessionManager.getSession();
        logger.debug((Object)("ss: " + ss));
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null && user.getUserID() != null) {
            userID = user.getUserID().toString();
            logger.debug((Object)("retrieved userId: " + userID));
        }
        logger.debug((Object)"attempt getting notebookEntry: ");
        NotebookEntry notebookEntry = mcService.getEntry(new Long(toolSessionID), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(userID));
        logger.debug((Object)("notebookEntry: " + notebookEntry));
        if (notebookEntry != null) {
            String notebookEntryPresentable = notebookEntry.getEntry();
            mcLearningForm.setEntryText(notebookEntryPresentable);
        }
        request.setAttribute("mcGeneralLearnerFlowDTO", (Object)mcGeneralLearnerFlowDTO);
        logger.debug((Object)("final mcGeneralLearnerFlowDTO: " + mcGeneralLearnerFlowDTO));
        logger.debug((Object)"fwd'ing to: notebook");
        return mapping.findForward("notebook");
    }

    public List getAllQuestionUids(McContent mcContent) {
        logger.debug((Object)("getAllQuestionsUids: " + mcContent));
        Iterator listIterator = mcContent.getMcQueContents().iterator();
        LinkedList<String> uidList = new LinkedList<String>();
        while (listIterator.hasNext()) {
            McQueContent mcQueContent = (McQueContent)listIterator.next();
            logger.debug((Object)("mcQueContent: " + mcQueContent));
            logger.debug((Object)("mcQueContent uid: " + mcQueContent.getUid()));
            uidList.add(mcQueContent.getUid().toString());
        }
        logger.debug((Object)("uidList: " + uidList));
        return uidList;
    }
}

