/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.mc.EditActivityDTO;
import org.lamsfoundation.lams.tool.mc.ExportPortfolioDTO;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McCandidateAnswersDTO;
import org.lamsfoundation.lams.tool.mc.McComparator;
import org.lamsfoundation.lams.tool.mc.McGeneralAuthoringDTO;
import org.lamsfoundation.lams.tool.mc.McGeneralLearnerFlowDTO;
import org.lamsfoundation.lams.tool.mc.McGeneralMonitoringDTO;
import org.lamsfoundation.lams.tool.mc.McQuestionContentDTO;
import org.lamsfoundation.lams.tool.mc.McUtils;
import org.lamsfoundation.lams.tool.mc.ReflectionDTO;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueUsr;
import org.lamsfoundation.lams.tool.mc.pojos.McSession;
import org.lamsfoundation.lams.tool.mc.service.IMcService;
import org.lamsfoundation.lams.tool.mc.service.McServiceProxy;
import org.lamsfoundation.lams.tool.mc.web.AuthoringUtil;
import org.lamsfoundation.lams.tool.mc.web.McAuthoringForm;
import org.lamsfoundation.lams.tool.mc.web.McMonitoringForm;
import org.lamsfoundation.lams.tool.mc.web.MonitoringUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.util.SessionMap;

public class McMonitoringAction
extends LamsDispatchAction
implements McAppConstants {
    static Logger logger = Logger.getLogger((String)McMonitoringAction.class.getName());

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching unspecified...");
        return null;
    }

    public ActionForward submitSession(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, IMcService mcService, McGeneralMonitoringDTO mcGeneralMonitoringDTO) throws IOException, ServletException {
        logger.debug((Object)("calling submitSession...mcGeneralMonitoringDTO:" + mcGeneralMonitoringDTO));
        this.commonSubmitSessionCode(form, request, mcService, mcGeneralMonitoringDTO);
        logger.debug((Object)("post commonSubmitSessionCode: " + mcGeneralMonitoringDTO));
        return mapping.findForward("refreshMonitoring");
    }

    protected void commonSubmitSessionCode(ActionForm form, HttpServletRequest request, IMcService mcService, McGeneralMonitoringDTO mcGeneralMonitoringDTO) throws IOException, ServletException {
        logger.debug((Object)("starting  commonSubmitSessionCode...mcGeneralMonitoringDTO:" + mcGeneralMonitoringDTO));
        logger.debug((Object)("mcService:" + mcService));
        McMonitoringForm mcMonitoringForm = (McMonitoringForm)form;
        this.repopulateRequestParameters(request, mcMonitoringForm, mcGeneralMonitoringDTO);
        logger.debug((Object)"done repopulateRequestParameters");
        String currentMonitoredToolSession = request.getParameter("monitoredToolSessionId");
        logger.debug((Object)("currentMonitoredToolSession: " + currentMonitoredToolSession));
        if (currentMonitoredToolSession == null) {
            logger.debug((Object)"default to All");
            currentMonitoredToolSession = "All";
        }
        String toolContentID = mcMonitoringForm.getToolContentID();
        logger.debug((Object)("toolContentID: " + toolContentID));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentID));
        logger.debug((Object)("existing mcContent:" + mcContent));
        if (currentMonitoredToolSession.equals("All")) {
            LinkedList listMcAllSessionsDTO = new LinkedList();
            logger.debug((Object)"generate DTO for All sessions: ");
            MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
            mcGeneralMonitoringDTO.setSelectionCase(new Long(2L));
            request.setAttribute("selectionCase", (Object)new Long(2L));
        } else {
            McSession mcSession = mcService.retrieveMcSession(new Long(currentMonitoredToolSession));
            logger.debug((Object)("mcSession uid:" + mcSession.getUid()));
            MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
            logger.debug((Object)("session_name: " + mcSession.getSession_name()));
            mcGeneralMonitoringDTO.setGroupName(mcSession.getSession_name());
            mcGeneralMonitoringDTO.setSelectionCase(new Long(1L));
            request.setAttribute("selectionCase", (Object)new Long(1L));
        }
        logger.debug((Object)("SELECTION_CASE: " + mcGeneralMonitoringDTO.getSelectionCase()));
        logger.debug((Object)("SELECTION_CASE: " + request.getAttribute("selectionCase")));
        request.setAttribute("currentMonitoredToolSession", (Object)currentMonitoredToolSession);
        mcGeneralMonitoringDTO.setCurrentMonitoredToolSession(currentMonitoredToolSession);
        mcGeneralMonitoringDTO.setSbmtSuccess(new Boolean(false).toString());
        mcGeneralMonitoringDTO.setRequestLearningReport(new Boolean(false).toString());
        Map summaryToolSessions = MonitoringUtil.populateToolSessions(request, mcContent, mcService);
        logger.debug((Object)("summaryToolSessions: " + summaryToolSessions));
        mcGeneralMonitoringDTO.setSummaryToolSessions(summaryToolSessions);
        Map summaryToolSessionsId = MonitoringUtil.populateToolSessionsId(request, mcContent, mcService);
        logger.debug((Object)("summaryToolSessionsId: " + summaryToolSessionsId));
        mcGeneralMonitoringDTO.setSummaryToolSessionsId(summaryToolSessionsId);
        logger.debug((Object)"calling initStatsContent.");
        this.initStatsContent(toolContentID, request, mcService, mcGeneralMonitoringDTO);
        logger.debug((Object)("post initStatsContent, mcGeneralMonitoringDTO: " + mcGeneralMonitoringDTO));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        mcGeneralAuthoringDTO.setActivityTitle(mcContent.getTitle());
        mcGeneralAuthoringDTO.setActivityInstructions(mcContent.getInstructions());
        TreeMap<String, String> mapOptionsContent = new TreeMap<String, String>(new McComparator());
        Iterator queIterator = mcContent.getMcQueContents().iterator();
        Long mapIndex = new Long(1L);
        logger.debug((Object)("mapOptionsContent: " + mapOptionsContent));
        while (queIterator.hasNext()) {
            McQueContent mcQueContent = (McQueContent)queIterator.next();
            if (mcQueContent == null) continue;
            logger.debug((Object)("question: " + mcQueContent.getQuestion()));
            mapOptionsContent.put(mapIndex.toString(), mcQueContent.getQuestion());
            mapIndex = new Long(mapIndex + 1L);
        }
        logger.debug((Object)("mapOptionsContent: " + mapOptionsContent));
        int maxIndex = mapOptionsContent.size();
        logger.debug((Object)("maxIndex: " + maxIndex));
        boolean isContentInUse = McUtils.isContentInUse(mcContent);
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        mcGeneralMonitoringDTO.setIsMonitoredContentInUse(new Boolean(false).toString());
        if (isContentInUse) {
            logger.debug((Object)"monitoring url does not allow editActivity since the content is in use.");
            mcGeneralMonitoringDTO.setIsMonitoredContentInUse(new Boolean(true).toString());
        }
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        this.prepareReflectionData(request, mcContent, mcService, null, false, "All");
        if (mcService.studentActivityOccurredGlobal(mcContent)) {
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to false");
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(false).toString());
        } else {
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to true");
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
        }
        mcGeneralMonitoringDTO.setOnlineInstructions(mcContent.getOnlineInstructions());
        mcGeneralMonitoringDTO.setOfflineInstructions(mcContent.getOfflineInstructions());
        List attachmentList = mcService.retrieveMcUploadedFiles(mcContent);
        logger.debug((Object)("attachmentList: " + attachmentList));
        mcGeneralMonitoringDTO.setAttachmentList(attachmentList);
        mcGeneralMonitoringDTO.setDeletedAttachmentList(new ArrayList());
        logger.debug((Object)("end of commonSubmitSessionCode, mcGeneralMonitoringDTO: " + mcGeneralMonitoringDTO));
        request.setAttribute("mcGeneralMonitoringDTO", (Object)mcGeneralMonitoringDTO);
        EditActivityDTO editActivityDTO = new EditActivityDTO();
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        if (isContentInUse) {
            editActivityDTO.setMonitoredContentInUse(new Boolean(true).toString());
        }
        request.setAttribute("editActivityDTO", (Object)editActivityDTO);
        boolean notebookEntriesExist = MonitoringUtil.notebookEntriesExist(mcService, mcContent);
        logger.debug((Object)("notebookEntriesExist : " + notebookEntriesExist));
        if (notebookEntriesExist) {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(true).toString());
            String userExceptionNoToolSessions = mcGeneralMonitoringDTO.getUserExceptionNoToolSessions();
            logger.debug((Object)("userExceptionNoToolSessions : " + userExceptionNoToolSessions));
            if (userExceptionNoToolSessions.equals("true")) {
                logger.debug((Object)"there are no online student activity but there are reflections : ");
                request.setAttribute("noSessionsNotebookEntriesExist", (Object)new Boolean(true).toString());
            }
        } else {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(false).toString());
        }
        MonitoringUtil.buildMcStatsDTO(request, mcService, mcContent);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)"dumping jsp controllers: ");
        logger.debug((Object)("dumping jsp controlllers, mcGeneralMonitoringDTO, mcGeneralMonitoringDTO.getIsMonitoredContentInUse():" + mcGeneralMonitoringDTO.getIsMonitoredContentInUse()));
        logger.debug((Object)("dumping jsp controlllers, mcGeneralMonitoringDTO, mcGeneralMonitoringDTO.getUserExceptionNoToolSessions():" + mcGeneralMonitoringDTO.getUserExceptionNoToolSessions()));
        logger.debug((Object)("dumping jsp controlllers, mcGeneralMonitoringDTO, mcGeneralMonitoringDTO.getCurrentMonitoredToolSession():" + mcGeneralMonitoringDTO.getCurrentMonitoredToolSession()));
        logger.debug((Object)("dumping jsp controlllers, mcGeneralMonitoringDTO, mcGeneralMonitoringDTO.getSelectionCase(): " + mcGeneralMonitoringDTO.getSelectionCase()));
        logger.debug((Object)("dumping request level  controlllers, REQUEST selectionCase: " + request.getAttribute("selectionCase")));
    }

    public void refreshSummaryData(HttpServletRequest request, McContent mcContent, IMcService mcService, boolean isUserNamesVisible, boolean isLearnerRequest, String currentSessionId, String userId, boolean showUserEntriesBySession, McGeneralLearnerFlowDTO mcGeneralLearnerFlowDTO, McGeneralMonitoringDTO mcGeneralMonitoringDTO, ExportPortfolioDTO exportPortfolioDTO) {
        logger.debug((Object)("doing refreshSummaryData." + mcGeneralLearnerFlowDTO));
        logger.debug((Object)("mcGeneralMonitoringDTO:" + mcGeneralMonitoringDTO));
        logger.debug((Object)("exportPortfolioDTO:" + exportPortfolioDTO));
        if (mcService == null) {
            logger.debug((Object)"will retrieve mcService");
            mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
            logger.debug((Object)("retrieving mcService from session: " + mcService));
        }
        logger.debug((Object)("mcService: " + mcService));
        logger.debug((Object)("isUserNamesVisible: " + isUserNamesVisible));
        logger.debug((Object)("isLearnerRequest: " + isLearnerRequest));
        Map summaryToolSessions = MonitoringUtil.populateToolSessions(request, mcContent, mcService);
        logger.debug((Object)("summaryToolSessions: " + summaryToolSessions));
        if (mcService.studentActivityOccurredGlobal(mcContent)) {
            if (mcGeneralMonitoringDTO != null) {
                mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(false).toString());
            }
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to false");
        } else {
            if (mcGeneralMonitoringDTO != null) {
                mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
            }
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to true");
        }
        String userExceptionNoToolSessions = mcGeneralMonitoringDTO.getUserExceptionNoToolSessions();
        logger.debug((Object)("userExceptionNoToolSessions: " + userExceptionNoToolSessions));
        if (exportPortfolioDTO != null) {
            exportPortfolioDTO.setUserExceptionNoToolSessions(userExceptionNoToolSessions);
        }
        Map summaryToolSessionsId = MonitoringUtil.populateToolSessionsId(request, mcContent, mcService);
        logger.debug((Object)("summaryToolSessionsId: " + summaryToolSessionsId));
        logger.debug((Object)("currentSessionId: " + currentSessionId));
        if (currentSessionId != null && !currentSessionId.equals("All")) {
            McSession mcSession = mcService.retrieveMcSession(new Long(currentSessionId));
            logger.debug((Object)("mcSession:" + mcSession));
            if (mcGeneralMonitoringDTO != null) {
                mcGeneralMonitoringDTO.setGroupName(mcSession.getSession_name());
            }
        } else {
            mcGeneralMonitoringDTO.setGroupName("All Groups");
        }
        logger.debug((Object)("using allUsersData to retrieve data: " + isUserNamesVisible));
        LinkedList listMonitoredAnswersContainerDTO = new LinkedList();
        logger.debug((Object)("listMonitoredAnswersContainerDTO: " + listMonitoredAnswersContainerDTO));
        logger.debug((Object)("decide processing user entered values based on isLearnerRequest: " + isLearnerRequest));
        if (exportPortfolioDTO != null) {
            logger.debug((Object)"placing dtos within the exportPortfolioDTO: ");
            exportPortfolioDTO.setListMonitoredAnswersContainerDto(listMonitoredAnswersContainerDTO);
        }
        if (mcGeneralMonitoringDTO != null) {
            mcGeneralMonitoringDTO.setSummaryToolSessions(summaryToolSessions);
            mcGeneralMonitoringDTO.setSummaryToolSessionsId(summaryToolSessionsId);
            mcGeneralMonitoringDTO.setSelectionCase(new Long(2L));
            mcGeneralMonitoringDTO.setCurrentMonitoredToolSession("All");
            mcGeneralMonitoringDTO.setListMonitoredAnswersContainerDto(listMonitoredAnswersContainerDTO);
            mcGeneralMonitoringDTO.setExistsOpenMcs(new Boolean(false).toString());
        }
        logger.debug((Object)("final mcGeneralLearnerFlowDTO: " + mcGeneralLearnerFlowDTO));
        logger.debug((Object)("final mcGeneralMonitoringDTO: " + mcGeneralMonitoringDTO));
        boolean isContentInUse = McUtils.isContentInUse(mcContent);
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        mcGeneralMonitoringDTO.setIsMonitoredContentInUse(new Boolean(false).toString());
        if (isContentInUse) {
            logger.debug((Object)"monitoring url does not allow editActivity since the content is in use.");
            mcGeneralMonitoringDTO.setIsMonitoredContentInUse(new Boolean(true).toString());
        }
        this.prepareReflectionData(request, mcContent, mcService, null, false, "All");
        if (mcService.studentActivityOccurredGlobal(mcContent)) {
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to false");
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(false).toString());
        } else {
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to true");
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
        }
        mcGeneralMonitoringDTO.setOnlineInstructions(mcContent.getOnlineInstructions());
        mcGeneralMonitoringDTO.setOfflineInstructions(mcContent.getOfflineInstructions());
        List attachmentList = mcService.retrieveMcUploadedFiles(mcContent);
        logger.debug((Object)("attachmentList: " + attachmentList));
        mcGeneralMonitoringDTO.setAttachmentList(attachmentList);
        mcGeneralMonitoringDTO.setDeletedAttachmentList(new ArrayList());
        logger.debug((Object)("end of refreshSummaryData, mcGeneralMonitoringDTO" + mcGeneralMonitoringDTO));
        request.setAttribute("mcGeneralMonitoringDTO", (Object)mcGeneralMonitoringDTO);
        EditActivityDTO editActivityDTO = new EditActivityDTO();
        isContentInUse = McUtils.isContentInUse(mcContent);
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        if (isContentInUse) {
            editActivityDTO.setMonitoredContentInUse(new Boolean(true).toString());
        }
        request.setAttribute("editActivityDTO", (Object)editActivityDTO);
        boolean notebookEntriesExist = MonitoringUtil.notebookEntriesExist(mcService, mcContent);
        logger.debug((Object)("notebookEntriesExist : " + notebookEntriesExist));
        if (notebookEntriesExist) {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(true).toString());
            userExceptionNoToolSessions = mcGeneralMonitoringDTO.getUserExceptionNoToolSessions();
            logger.debug((Object)("userExceptionNoToolSessions : " + userExceptionNoToolSessions));
            if (userExceptionNoToolSessions.equals("true")) {
                logger.debug((Object)"there are no online student activity but there are reflections : ");
                request.setAttribute("noSessionsNotebookEntriesExist", (Object)new Boolean(true).toString());
            }
        } else {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(false).toString());
        }
        MonitoringUtil.buildMcStatsDTO(request, mcService, mcContent);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
    }

    public ActionForward submitSession(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispathcing submitSession..");
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        McGeneralMonitoringDTO mcGeneralMonitoringDTO = new McGeneralMonitoringDTO();
        this.commonSubmitSessionCode(form, request, mcService, mcGeneralMonitoringDTO);
        logger.debug((Object)("post commonSubmitSessionCode: " + mcGeneralMonitoringDTO));
        return mapping.findForward("loadMonitoring");
    }

    public ActionForward editActivityQuestions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException {
        logger.debug((Object)"dispatching editActivityQuestions...");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        logger.debug((Object)("mcAuthoringForm: " + mcAuthoringForm));
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        logger.debug((Object)("title: " + mcContent.getTitle()));
        logger.debug((Object)("instructions: " + mcContent.getInstructions()));
        mcGeneralAuthoringDTO.setActivityTitle(mcContent.getTitle());
        mcAuthoringForm.setTitle(mcContent.getTitle());
        mcGeneralAuthoringDTO.setActivityInstructions(mcContent.getInstructions());
        sessionMap.put((Object)"activityTitleKey", (Object)mcContent.getTitle());
        sessionMap.put((Object)"activityInstructionsKey", (Object)mcContent.getInstructions());
        String sourceMcStarter = (String)request.getAttribute("sourceMcStarter");
        logger.debug((Object)("sourceMcStarter: " + sourceMcStarter));
        mcAuthoringForm.setDefineLaterInEditMode(new Boolean(true).toString());
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        boolean isContentInUse = McUtils.isContentInUse(mcContent);
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        mcGeneralAuthoringDTO.setMonitoredContentInUse(new Boolean(false).toString());
        if (isContentInUse) {
            logger.debug((Object)"monitoring url does not allow editActivity since the content is in use.");
            this.persistError(request, "error.content.inUse");
            mcGeneralAuthoringDTO.setMonitoredContentInUse(new Boolean(true).toString());
        }
        EditActivityDTO editActivityDTO = new EditActivityDTO();
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        if (isContentInUse) {
            editActivityDTO.setMonitoredContentInUse(new Boolean(true).toString());
        }
        request.setAttribute("editActivityDTO", (Object)editActivityDTO);
        McUtils.setDefineLater(request, true, strToolContentID, mcService);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List listQuestionContentDTO = authoringUtil.buildDefaultQuestionContent(mcContent, mcService);
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before fwding to jsp, mcAuthoringForm: " + mcAuthoringForm));
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        McGeneralMonitoringDTO mcGeneralMonitoringDTO = new McGeneralMonitoringDTO();
        mcGeneralMonitoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        if (mcService.studentActivityOccurredGlobal(mcContent)) {
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to false");
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(false).toString());
        } else {
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to true");
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
        }
        mcGeneralMonitoringDTO.setOnlineInstructions(mcContent.getOnlineInstructions());
        mcGeneralMonitoringDTO.setOfflineInstructions(mcContent.getOfflineInstructions());
        List attachmentList = mcService.retrieveMcUploadedFiles(mcContent);
        logger.debug((Object)("attachmentList: " + attachmentList));
        mcGeneralMonitoringDTO.setAttachmentList(attachmentList);
        mcGeneralMonitoringDTO.setDeletedAttachmentList(new ArrayList());
        logger.debug((Object)("end of refreshSummaryData, mcGeneralMonitoringDTO" + mcGeneralMonitoringDTO));
        request.setAttribute("mcGeneralMonitoringDTO", (Object)mcGeneralMonitoringDTO);
        boolean notebookEntriesExist = MonitoringUtil.notebookEntriesExist(mcService, mcContent);
        logger.debug((Object)("notebookEntriesExist : " + notebookEntriesExist));
        if (notebookEntriesExist) {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(true).toString());
            String userExceptionNoToolSessions = mcGeneralMonitoringDTO.getUserExceptionNoToolSessions();
            logger.debug((Object)(": " + userExceptionNoToolSessions));
            if (userExceptionNoToolSessions.equals("true")) {
                logger.debug((Object)"there are no online student activity but there are reflections : ");
                request.setAttribute("noSessionsNotebookEntriesExist", (Object)new Boolean(true).toString());
            }
        } else {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(false).toString());
        }
        MonitoringUtil.buildMcStatsDTO(request, mcService, mcContent);
        MonitoringUtil.generateGroupsSessionData(request, mcService, mcContent);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)"forwarding to LOAD_MONITORING_CONTENT: loadMonitoring");
        return mapping.findForward("loadMonitoring");
    }

    public void persistError(HttpServletRequest request, String message) {
        ActionMessages errors = new ActionMessages();
        errors.add("org.apache.struts.action.ERROR", new ActionMessage(message));
        logger.debug((Object)("add " + message + "  to ActionMessages:"));
        this.saveErrors(request, errors);
    }

    public ActionForward submitAllContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)("dispathcing submitAllContent :" + form));
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        Map mapQuestionContent = AuthoringUtil.extractMapQuestionContent(listQuestionContentDTO);
        logger.debug((Object)("extracted mapQuestionContent: " + mapQuestionContent));
        Map mapFeedback = AuthoringUtil.extractMapFeedback(listQuestionContentDTO);
        logger.debug((Object)("extracted mapFeedback: " + mapFeedback));
        TreeMap mapWeights = new TreeMap(new McComparator());
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        Map mapMarks = AuthoringUtil.extractMapMarks(listQuestionContentDTO);
        logger.debug((Object)("extracted mapMarks: " + mapMarks));
        Map mapCandidatesList = AuthoringUtil.extractMapCandidatesList(listQuestionContentDTO);
        logger.debug((Object)("extracted mapCandidatesList: " + mapCandidatesList));
        ActionMessages errors = new ActionMessages();
        logger.debug((Object)("mapQuestionContent size: " + mapQuestionContent.size()));
        if (mapQuestionContent.size() == 0) {
            ActionMessage error = new ActionMessage("questions.none.submitted");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        logger.debug((Object)("errors: " + errors));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("activeModule: " + activeModule));
        if (activeModule.equals("authoring")) {
            List attachmentListBackup = new ArrayList();
            List attachmentList = (List)sessionMap.get((Object)"attachmentListKey");
            logger.debug((Object)("attachmentList: " + attachmentList));
            attachmentListBackup = attachmentList;
            List deletedAttachmentListBackup = new ArrayList();
            List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentListKey");
            logger.debug((Object)("deletedAttachmentList: " + deletedAttachmentList));
            deletedAttachmentListBackup = deletedAttachmentList;
            String onlineInstructions = (String)sessionMap.get((Object)"onlineInstructionsKey");
            logger.debug((Object)("onlineInstructions: " + onlineInstructions));
            mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
            String offlineInstructions = (String)sessionMap.get((Object)"offlineInstructionsKey");
            logger.debug((Object)("offlineInstructions: " + offlineInstructions));
            mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
            mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
            mcGeneralAuthoringDTO.setDeletedAttachmentList(deletedAttachmentList);
            String strOnlineInstructions = request.getParameter("onlineInstructions");
            String strOfflineInstructions = request.getParameter("offlineInstructions");
            logger.debug((Object)("onlineInstructions: " + strOnlineInstructions));
            logger.debug((Object)("offlineInstructions: " + strOfflineInstructions));
            mcAuthoringForm.setOfflineInstructions(strOfflineInstructions);
            mcAuthoringForm.setOnlineInstructions(strOnlineInstructions);
        }
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        mcGeneralAuthoringDTO.setMapQuestionContent(mapQuestionContent);
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        logger.debug((Object)("mcGeneralAuthoringDTO now: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        logger.debug((Object)"there are no issues with input, continue and submit data");
        McContent mcContentTest = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContentTest: " + mcContentTest));
        logger.debug((Object)("errors: " + errors));
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        McGeneralMonitoringDTO mcGeneralMonitoringDTO = new McGeneralMonitoringDTO();
        McContent mcContent = mcContentTest;
        if (errors.isEmpty()) {
            logger.debug((Object)("errors is empty: " + errors));
            authoringUtil.removeRedundantQuestions(mapQuestionContent, mcService, mcAuthoringForm, request, strToolContentID);
            logger.debug((Object)"end of removing unused entries... ");
            mcContent = authoringUtil.saveOrUpdateMcContent(mapQuestionContent, mapFeedback, mapWeights, mapMarks, mapCandidatesList, mcService, mcAuthoringForm, request, mcContentTest, strToolContentID);
            logger.debug((Object)("mcContent: " + mcContent));
            long defaultContentID = 0L;
            logger.debug((Object)"attempt retrieving tool with signatute : lamc11");
            defaultContentID = mcService.getToolDefaultContentIdBySignature("lamc11");
            logger.debug((Object)("retrieved tool default contentId: " + defaultContentID));
            if (mcContent != null) {
                mcGeneralAuthoringDTO.setDefaultContentIdStr(new Long(defaultContentID).toString());
            }
            logger.debug((Object)("updated mcGeneralAuthoringDTO to: " + mcGeneralAuthoringDTO));
            authoringUtil.reOrganizeDisplayOrder(mapQuestionContent, mcService, mcAuthoringForm, mcContent);
            logger.debug((Object)("post reOrganizeDisplayOrder: " + mcContent));
            logger.debug((Object)("strToolContentID: " + strToolContentID));
            McUtils.setDefineLater(request, false, strToolContentID, mcService);
            logger.debug((Object)"define later set to false");
            McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
            logger.debug((Object)"go back to view only screen");
            mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(false).toString());
            mcGeneralMonitoringDTO.setDefineLaterInEditMode(new Boolean(false).toString());
        } else {
            logger.debug((Object)("errors is not empty: " + errors));
            if (mcContent != null) {
                long defaultContentID = 0L;
                logger.debug((Object)"attempt retrieving tool with signatute : lamc11");
                defaultContentID = mcService.getToolDefaultContentIdBySignature("lamc11");
                logger.debug((Object)("retrieved tool default contentId: " + defaultContentID));
                if (mcContent != null) {
                    mcGeneralAuthoringDTO.setDefaultContentIdStr(new Long(defaultContentID).toString());
                }
                McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
                mcGeneralMonitoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
            }
        }
        logger.debug((Object)("end of refreshSummaryData, mcGeneralMonitoringDTO" + mcGeneralMonitoringDTO));
        request.setAttribute("mcGeneralMonitoringDTO", (Object)mcGeneralMonitoringDTO);
        mcGeneralAuthoringDTO.setSbmtSuccess(new Integer(1).toString());
        mcAuthoringForm.resetUserAction();
        mcGeneralAuthoringDTO.setMapQuestionContent(mapQuestionContent);
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        if (mcService.studentActivityOccurredGlobal(mcContent)) {
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to false");
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(false).toString());
        } else {
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to true");
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
        }
        mcGeneralMonitoringDTO.setOnlineInstructions(mcContent.getOnlineInstructions());
        mcGeneralMonitoringDTO.setOfflineInstructions(mcContent.getOfflineInstructions());
        List attachmentList = mcService.retrieveMcUploadedFiles(mcContent);
        logger.debug((Object)("attachmentList: " + attachmentList));
        mcGeneralMonitoringDTO.setAttachmentList(attachmentList);
        mcGeneralMonitoringDTO.setDeletedAttachmentList(new ArrayList());
        boolean notebookEntriesExist = MonitoringUtil.notebookEntriesExist(mcService, mcContent);
        logger.debug((Object)("notebookEntriesExist : " + notebookEntriesExist));
        if (notebookEntriesExist) {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(true).toString());
            String userExceptionNoToolSessions = mcGeneralMonitoringDTO.getUserExceptionNoToolSessions();
            logger.debug((Object)(": " + userExceptionNoToolSessions));
            if (userExceptionNoToolSessions.equals("true")) {
                logger.debug((Object)"there are no online student activity but there are reflections : ");
                request.setAttribute("noSessionsNotebookEntriesExist", (Object)new Boolean(true).toString());
            }
        } else {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(false).toString());
        }
        MonitoringUtil.buildMcStatsDTO(request, mcService, mcContent);
        MonitoringUtil.generateGroupsSessionData(request, mcService, mcContent);
        logger.debug((Object)("ending setupCommonScreenData, mcContent " + mcContent));
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)"forwarding to :refreshMonitoring");
        return mapping.findForward("refreshMonitoring");
    }

    public ActionForward saveSingleQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionMessage error;
        logger.debug((Object)"dispathcing saveSingleQuestion");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        String passmark = request.getParameter("passmark");
        logger.debug((Object)("passmark: " + passmark));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        caList = AuthoringUtil.removeBlankEntries(caList);
        logger.debug((Object)("caList after removing blank entries: " + caList));
        boolean validateSingleCorrectCandidate = authoringUtil.validateSingleCorrectCandidate(caList);
        logger.debug((Object)("validateSingleCorrectCandidate: " + validateSingleCorrectCandidate));
        boolean validateOnlyOneCorrectCandidate = authoringUtil.validateOnlyOneCorrectCandidate(caList);
        logger.debug((Object)("validateOnlyOneCorrectCandidate: " + validateOnlyOneCorrectCandidate));
        ActionMessages errors = new ActionMessages();
        if (!validateSingleCorrectCandidate) {
            error = new ActionMessage("candidates.none.correct");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!validateOnlyOneCorrectCandidate) {
            error = new ActionMessage("candidates.duplicate.correct");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        logger.debug((Object)("errors: " + errors));
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("entry using mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        mcGeneralAuthoringDTO.setPassMarkValue(passmark);
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        if (errors.isEmpty()) {
            logger.debug((Object)("errors is empty: " + errors));
            logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
            mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
            mcGeneralAuthoringDTO.setSbmtSuccess(new Integer(0).toString());
            String newQuestion = request.getParameter("newQuestion");
            logger.debug((Object)("newQuestion: " + newQuestion));
            String feedback = request.getParameter("feedback");
            logger.debug((Object)("feedback: " + feedback));
            String editableQuestionIndex = request.getParameter("editableQuestionIndex");
            logger.debug((Object)("editableQuestionIndex: " + editableQuestionIndex));
            mcAuthoringForm.setQuestionIndex(editableQuestionIndex);
            if (newQuestion != null && newQuestion.length() > 0) {
                if (editQuestionBoxRequest != null && editQuestionBoxRequest.equals("false")) {
                    logger.debug((Object)"request for add and save");
                    boolean duplicates = AuthoringUtil.checkDuplicateQuestions(listQuestionContentDTO, newQuestion);
                    logger.debug((Object)("duplicates: " + duplicates));
                    if (!duplicates) {
                        McQuestionContentDTO mcQuestionContentDTO2 = null;
                        for (McQuestionContentDTO mcQuestionContentDTO2 : listQuestionContentDTO) {
                            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO2));
                            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO2.getQuestion()));
                            String question = mcQuestionContentDTO2.getQuestion();
                            String displayOrder = mcQuestionContentDTO2.getDisplayOrder();
                            logger.debug((Object)("displayOrder:" + displayOrder));
                            if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(editableQuestionIndex)) continue;
                            break;
                        }
                        logger.debug((Object)("mcQuestionContentDTO found:" + mcQuestionContentDTO2));
                        mcQuestionContentDTO2.setQuestion(newQuestion);
                        mcQuestionContentDTO2.setFeedback(feedback);
                        mcQuestionContentDTO2.setDisplayOrder(editableQuestionIndex);
                        mcQuestionContentDTO2.setListCandidateAnswersDTO(caList);
                        mcQuestionContentDTO2.setMark(mark);
                        logger.debug((Object)("caList size:" + mcQuestionContentDTO2.getListCandidateAnswersDTO().size()));
                        mcQuestionContentDTO2.setCaCount(new Integer(mcQuestionContentDTO2.getListCandidateAnswersDTO().size()).toString());
                        listQuestionContentDTO = AuthoringUtil.reorderUpdateListQuestionContentDTO(listQuestionContentDTO, mcQuestionContentDTO2, editableQuestionIndex);
                        logger.debug((Object)("post reorderUpdateListQuestionContentDTO listQuestionContentDTO: " + listQuestionContentDTO));
                    } else {
                        logger.debug((Object)"duplicate question entry, not adding");
                    }
                } else {
                    logger.debug((Object)"request for edit and save.");
                    McQuestionContentDTO mcQuestionContentDTO3 = null;
                    for (McQuestionContentDTO mcQuestionContentDTO3 : listQuestionContentDTO) {
                        logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO3));
                        logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO3.getQuestion()));
                        String question = mcQuestionContentDTO3.getQuestion();
                        String displayOrder = mcQuestionContentDTO3.getDisplayOrder();
                        logger.debug((Object)("displayOrder:" + displayOrder));
                        if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(editableQuestionIndex)) continue;
                        break;
                    }
                    logger.debug((Object)("mcQuestionContentDTO found:" + mcQuestionContentDTO3));
                    mcQuestionContentDTO3.setQuestion(newQuestion);
                    mcQuestionContentDTO3.setFeedback(feedback);
                    mcQuestionContentDTO3.setDisplayOrder(editableQuestionIndex);
                    mcQuestionContentDTO3.setListCandidateAnswersDTO(caList);
                    mcQuestionContentDTO3.setMark(mark);
                    logger.debug((Object)("caList size:" + mcQuestionContentDTO3.getListCandidateAnswersDTO().size()));
                    mcQuestionContentDTO3.setCaCount(new Integer(mcQuestionContentDTO3.getListCandidateAnswersDTO().size()).toString());
                    listQuestionContentDTO = AuthoringUtil.reorderUpdateListQuestionContentDTO(listQuestionContentDTO, mcQuestionContentDTO3, editableQuestionIndex);
                    logger.debug((Object)("post reorderUpdateListQuestionContentDTO listQuestionContentDTO: " + listQuestionContentDTO));
                }
            } else {
                logger.debug((Object)"entry blank, not adding");
            }
            logger.debug((Object)("entryusing mark: " + mark));
            mcGeneralAuthoringDTO.setMarkValue(mark);
            request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
            sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
            logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
            this.commonSaveCode(request, mcGeneralAuthoringDTO, mcAuthoringForm, sessionMap, activeModule, strToolContentID, defaultContentIdStr, mcService, httpSessionID, listQuestionContentDTO);
            request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
            this.setupCommonScreenData(mcContent, mcService, request);
            MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
            logger.debug((Object)"fwd ing to LOAD_MONITORING: refreshMonitoring");
            return mapping.findForward("refreshMonitoring");
        }
        logger.debug((Object)("errors is not empty: " + errors));
        this.commonSaveCode(request, mcGeneralAuthoringDTO, mcAuthoringForm, sessionMap, activeModule, strToolContentID, defaultContentIdStr, mcService, httpSessionID, listQuestionContentDTO);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        request.setAttribute("requestNewEditableQuestionBox", (Object)new Boolean(true).toString());
        logger.debug((Object)"forwarding using newEditableQuestionBox");
        return this.newEditableQuestionBox(mapping, form, request, response);
    }

    protected void commonSaveCode(HttpServletRequest request, McGeneralAuthoringDTO mcGeneralAuthoringDTO, McAuthoringForm mcAuthoringForm, SessionMap sessionMap, String activeModule, String strToolContentID, String defaultContentIdStr, IMcService mcService, String httpSessionID, List listQuestionContentDTO) {
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        AuthoringUtil authoringUtil = new AuthoringUtil();
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("mcGeneralAuthoringDTO now: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        logger.debug((Object)("sessionMap: " + sessionMap));
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        logger.debug((Object)("mcGeneralAuthoringDTO.getMapQuestionContent(); " + mcGeneralAuthoringDTO.getMapQuestionContent()));
    }

    public ActionForward addSingleQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionMessage error;
        logger.debug((Object)"dispathcing addSingleQuestion");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setSbmtSuccess(new Integer(0).toString());
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        Object mcQuestionContentDTONew = null;
        int listSize = listQuestionContentDTO.size();
        logger.debug((Object)("listSize: " + listSize));
        logger.debug((Object)("listAddableQuestionContentDTO now: " + listAddableQuestionContentDTO));
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        String passmark = request.getParameter("passmark");
        logger.debug((Object)("passmark: " + passmark));
        mcGeneralAuthoringDTO.setPassMarkValue(passmark);
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        caList = AuthoringUtil.removeBlankEntries(caList);
        logger.debug((Object)("caList after removing blank entries: " + caList));
        boolean validateSingleCorrectCandidate = authoringUtil.validateSingleCorrectCandidate(caList);
        logger.debug((Object)("validateSingleCorrectCandidate: " + validateSingleCorrectCandidate));
        boolean validateOnlyOneCorrectCandidate = authoringUtil.validateOnlyOneCorrectCandidate(caList);
        logger.debug((Object)("validateOnlyOneCorrectCandidate: " + validateOnlyOneCorrectCandidate));
        ActionMessages errors = new ActionMessages();
        if (!validateSingleCorrectCandidate) {
            error = new ActionMessage("candidates.none.correct");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!validateOnlyOneCorrectCandidate) {
            error = new ActionMessage("candidates.duplicate.correct");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        logger.debug((Object)("errors: " + errors));
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        logger.debug((Object)("errors saved: " + errors));
        if (errors.isEmpty()) {
            if (newQuestion != null && newQuestion.length() > 0) {
                boolean duplicates = AuthoringUtil.checkDuplicateQuestions(listQuestionContentDTO, newQuestion);
                logger.debug((Object)("duplicates: " + duplicates));
                if (!duplicates) {
                    McQuestionContentDTO mcQuestionContentDTO = new McQuestionContentDTO();
                    mcQuestionContentDTO.setDisplayOrder(new Long(listSize + 1).toString());
                    mcQuestionContentDTO.setFeedback(feedback);
                    mcQuestionContentDTO.setQuestion(newQuestion);
                    mcQuestionContentDTO.setMark(mark);
                    mcQuestionContentDTO.setListCandidateAnswersDTO(caList);
                    logger.debug((Object)("caList size:" + mcQuestionContentDTO.getListCandidateAnswersDTO().size()));
                    mcQuestionContentDTO.setCaCount(new Integer(mcQuestionContentDTO.getListCandidateAnswersDTO().size()).toString());
                    listQuestionContentDTO.add(mcQuestionContentDTO);
                    logger.debug((Object)("updated listQuestionContentDTO: " + listQuestionContentDTO));
                } else {
                    logger.debug((Object)"entry duplicate, not adding");
                }
            } else {
                logger.debug((Object)"entry blank, not adding");
            }
        } else {
            logger.debug((Object)"errors, not adding");
            logger.debug((Object)("errors is not empty: " + errors));
            this.commonSaveCode(request, mcGeneralAuthoringDTO, mcAuthoringForm, sessionMap, activeModule, strToolContentID, defaultContentIdStr, mcService, httpSessionID, listQuestionContentDTO);
            logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
            Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
            logger.debug((Object)("passMarksMap: " + passMarksMap));
            mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
            String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
            logger.debug((Object)("totalMark: " + totalMark));
            mcAuthoringForm.setTotalMarks(totalMark);
            mcGeneralAuthoringDTO.setTotalMarks(totalMark);
            logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
            request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
            request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
            sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
            logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
            logger.debug((Object)"forwarding using newQuestionBox");
            return this.newQuestionBox(mapping, form, request, response);
        }
        logger.debug((Object)("entry using mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        this.commonSaveCode(request, mcGeneralAuthoringDTO, mcAuthoringForm, sessionMap, activeModule, strToolContentID, defaultContentIdStr, mcService, httpSessionID, listQuestionContentDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("before forwarding mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)"fwd LOAD_MONITORING");
        return mapping.findForward("refreshMonitoring");
    }

    public ActionForward newQuestionBox(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispathcing newQuestionBox");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(defaultContentIdStr));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        AuthoringUtil authoringUtil = new AuthoringUtil();
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("mcGeneralAuthoringDTO now: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        String requestType = request.getParameter("requestType");
        logger.debug((Object)("requestType: " + requestType));
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        if (requestType != null && requestType.equals("direct")) {
            logger.debug((Object)"requestType is direct");
            listAddableQuestionContentDTO = authoringUtil.buildDefaultQuestionContent(mcContent, mcService);
            logger.debug((Object)("listAddableQuestionContentDTO from db: " + listAddableQuestionContentDTO));
        }
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        sessionMap.put((Object)"newAddableQuestionContentKey", (Object)listAddableQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        logger.debug((Object)("final listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)"fwd ing to newQuestionBox: ");
        return mapping.findForward("newQuestionBox");
    }

    public ActionForward newEditableQuestionBox(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispathcing newEditableQuestionBox");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        request.setAttribute("currentEditableQuestionIndex", (Object)questionIndex);
        mcAuthoringForm.setEditableQuestionIndex(questionIndex);
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        String editableQuestion = "";
        String editableFeedback = "";
        String editableMark = "";
        for (McQuestionContentDTO mcQuestionContentDTO : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
            String question = mcQuestionContentDTO.getQuestion();
            String displayOrder = mcQuestionContentDTO.getDisplayOrder();
            if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
            editableFeedback = mcQuestionContentDTO.getFeedback();
            editableQuestion = mcQuestionContentDTO.getQuestion();
            editableMark = mcQuestionContentDTO.getMark();
            logger.debug((Object)("editableFeedback found :" + editableFeedback));
            List candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
            logger.debug((Object)("candidates found :" + candidates));
            break;
        }
        logger.debug((Object)("editableFeedback found :" + editableFeedback));
        logger.debug((Object)("editableQuestion found :" + editableQuestion));
        logger.debug((Object)("editableMark found :" + editableMark));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = (McGeneralAuthoringDTO)request.getAttribute("mcGeneralAuthoringDTO");
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        if (mcGeneralAuthoringDTO == null) {
            mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        }
        mcGeneralAuthoringDTO.setMarkValue(editableMark);
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setEditableQuestionText(editableQuestion);
        mcGeneralAuthoringDTO.setEditableQuestionFeedback(editableFeedback);
        mcAuthoringForm.setFeedback(editableFeedback);
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        AuthoringUtil authoringUtil = new AuthoringUtil();
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("mcGeneralAuthoringDTO now: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        String requestNewEditableQuestionBox = (String)request.getAttribute("requestNewEditableQuestionBox");
        logger.debug((Object)("requestNewEditableQuestionBox: " + requestNewEditableQuestionBox));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        if (requestNewEditableQuestionBox != null && requestNewEditableQuestionBox.equals("true")) {
            mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
            String feedback = request.getParameter("feedback");
            logger.debug((Object)("feedback: " + feedback));
            mcAuthoringForm.setFeedback(feedback);
        }
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        logger.debug((Object)("final listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)"fwd ing to editQuestionBox: ");
        return mapping.findForward("editQuestionBox");
    }

    public ActionForward removeQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching removeQuestion");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        McQuestionContentDTO mcQuestionContentDTO2 = null;
        for (McQuestionContentDTO mcQuestionContentDTO2 : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO2));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO2.getQuestion()));
            String question = mcQuestionContentDTO2.getQuestion();
            String displayOrder = mcQuestionContentDTO2.getDisplayOrder();
            logger.debug((Object)("displayOrder:" + displayOrder));
            if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
            break;
        }
        logger.debug((Object)("mcQuestionContentDTO found:" + mcQuestionContentDTO2));
        mcQuestionContentDTO2.setQuestion("");
        logger.debug((Object)("listQuestionContentDTO after remove:" + listQuestionContentDTO));
        listQuestionContentDTO = AuthoringUtil.reorderListQuestionContentDTO(listQuestionContentDTO, questionIndex);
        logger.debug((Object)("listQuestionContentDTO reordered:" + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        if (mcContent == null) {
            logger.debug((Object)("using defaultContentIdStr: " + defaultContentIdStr));
            mcContent = mcService.retrieveMc(new Long(defaultContentIdStr));
        }
        logger.debug((Object)("final mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        AuthoringUtil authoringUtil = new AuthoringUtil();
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("mcQuestionContentDTO now: " + mcQuestionContentDTO2));
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)"fwd ing to LOAD_MONITORING: refreshMonitoring");
        return mapping.findForward("refreshMonitoring");
    }

    public ActionForward moveQuestionDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveQuestionDown");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        listQuestionContentDTO = AuthoringUtil.swapNodes(listQuestionContentDTO, questionIndex, "down");
        logger.debug((Object)("listQuestionContentDTO after swap: " + listQuestionContentDTO));
        listQuestionContentDTO = AuthoringUtil.reorderSimpleListQuestionContentDTO(listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO after reordersimple: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        AuthoringUtil authoringUtil = new AuthoringUtil();
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)"fwd ing to LOAD_MONITORING: refreshMonitoring");
        return mapping.findForward("refreshMonitoring");
    }

    public ActionForward moveQuestionUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveQuestionUp");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        listQuestionContentDTO = AuthoringUtil.swapNodes(listQuestionContentDTO, questionIndex, "up");
        logger.debug((Object)("listQuestionContentDTO after swap: " + listQuestionContentDTO));
        listQuestionContentDTO = AuthoringUtil.reorderSimpleListQuestionContentDTO(listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO after reordersimple: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        AuthoringUtil authoringUtil = new AuthoringUtil();
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)"fwd ing to LOAD_MONITORING: refreshMonitoring");
        return mapping.findForward("refreshMonitoring");
    }

    public ActionForward moveCandidateDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveCandidateDown");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        boolean validateCandidateAnswersNotBlank = authoringUtil.validateCandidateAnswersNotBlank(request);
        logger.debug((Object)("validateCandidateAnswersNotBlank: " + validateCandidateAnswersNotBlank));
        ActionMessages errors = new ActionMessages();
        if (!validateCandidateAnswersNotBlank) {
            ActionMessage error = new ActionMessage("candidates.blank");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        if (errors.isEmpty()) {
            List candidates = new LinkedList();
            List listCandidates = new LinkedList();
            String editableQuestion = "";
            for (McQuestionContentDTO mcQuestionContentDTO : listQuestionContentDTO) {
                logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
                logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
                String question = mcQuestionContentDTO.getQuestion();
                String displayOrder = mcQuestionContentDTO.getDisplayOrder();
                if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
                logger.debug((Object)("displayOrder equals questionIndex :" + questionIndex));
                editableQuestion = mcQuestionContentDTO.getQuestion();
                candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
                logger.debug((Object)("candidates found :" + candidates));
                logger.debug((Object)("but we are using the repopulated caList here: " + caList));
                listCandidates = AuthoringUtil.swapCandidateNodes(caList, candidateIndex, "down");
                logger.debug((Object)("swapped candidates :" + listCandidates));
                mcQuestionContentDTO.setListCandidateAnswersDTO(listCandidates);
                break;
            }
            logger.debug((Object)("candidates found :" + candidates));
            logger.debug((Object)("swapped candidates is :" + listCandidates));
        }
        logger.debug((Object)("listQuestionContentDTO after swapped candidates :" + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        request.setAttribute("requestNewEditableQuestionBox", (Object)new Boolean(true).toString());
        return this.newEditableQuestionBox(mapping, form, request, response);
    }

    public ActionForward moveCandidateUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveCandidateUp");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        AuthoringUtil authoringUtil = new AuthoringUtil();
        boolean validateCandidateAnswersNotBlank = authoringUtil.validateCandidateAnswersNotBlank(request);
        logger.debug((Object)("validateCandidateAnswersNotBlank: " + validateCandidateAnswersNotBlank));
        ActionMessages errors = new ActionMessages();
        if (!validateCandidateAnswersNotBlank) {
            ActionMessage error = new ActionMessage("candidates.blank");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        if (errors.isEmpty()) {
            List candidates = new LinkedList();
            List listCandidates = new LinkedList();
            String editableQuestion = "";
            for (McQuestionContentDTO mcQuestionContentDTO : listQuestionContentDTO) {
                logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
                logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
                String question = mcQuestionContentDTO.getQuestion();
                String displayOrder = mcQuestionContentDTO.getDisplayOrder();
                if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
                logger.debug((Object)("displayOrder equals questionIndex :" + questionIndex));
                editableQuestion = mcQuestionContentDTO.getQuestion();
                candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
                logger.debug((Object)("candidates found :" + candidates));
                logger.debug((Object)("using repopulated caList:" + caList));
                listCandidates = AuthoringUtil.swapCandidateNodes(caList, candidateIndex, "up");
                logger.debug((Object)("swapped candidates :" + listCandidates));
                mcQuestionContentDTO.setListCandidateAnswersDTO(listCandidates);
                mcQuestionContentDTO.setCaCount(new Integer(listCandidates.size()).toString());
                break;
            }
            logger.debug((Object)("candidates found :" + candidates));
            logger.debug((Object)("swapped candidates is :" + listCandidates));
        }
        logger.debug((Object)("listQuestionContentDTO after swapped candidates :" + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        request.setAttribute("requestNewEditableQuestionBox", (Object)new Boolean(true).toString());
        return this.newEditableQuestionBox(mapping, form, request, response);
    }

    public ActionForward removeCandidate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching removeCandidate");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        McQuestionContentDTO mcQuestionContentDTO2 = null;
        for (McQuestionContentDTO mcQuestionContentDTO2 : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO2));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO2.getQuestion()));
            String question = mcQuestionContentDTO2.getQuestion();
            String displayOrder = mcQuestionContentDTO2.getDisplayOrder();
            logger.debug((Object)("displayOrder:" + displayOrder));
            if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
            break;
        }
        logger.debug((Object)("mcQuestionContentDTO found:" + mcQuestionContentDTO2));
        logger.debug((Object)"setting caList for the content:");
        mcQuestionContentDTO2.setListCandidateAnswersDTO(caList);
        List candidateAnswers = mcQuestionContentDTO2.getListCandidateAnswersDTO();
        logger.debug((Object)("candidateAnswers:" + candidateAnswers));
        McCandidateAnswersDTO mcCandidateAnswersDTO = null;
        Iterator listCaIterator = candidateAnswers.iterator();
        int caIndex = 0;
        while (listCaIterator.hasNext()) {
            logger.debug((Object)("caIndex:" + ++caIndex));
            mcCandidateAnswersDTO = (McCandidateAnswersDTO)listCaIterator.next();
            logger.debug((Object)("mcCandidateAnswersDTO:" + mcCandidateAnswersDTO));
            logger.debug((Object)("mcCandidateAnswersDTO question:" + mcCandidateAnswersDTO.getCandidateAnswer()));
            if (caIndex != new Integer(candidateIndex)) continue;
            logger.debug((Object)"candidateIndex found");
            mcCandidateAnswersDTO.setCandidateAnswer("");
            break;
        }
        logger.debug((Object)("candidateAnswers after resetting answer" + candidateAnswers));
        candidateAnswers = AuthoringUtil.reorderListCandidatesDTO(candidateAnswers);
        logger.debug((Object)("candidateAnswers after reordering candidate nodes" + candidateAnswers));
        mcQuestionContentDTO2.setListCandidateAnswersDTO(candidateAnswers);
        mcQuestionContentDTO2.setCaCount(new Integer(candidateAnswers.size()).toString());
        logger.debug((Object)("listQuestionContentDTO after remove: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        if (mcContent == null) {
            logger.debug((Object)("using defaultContentIdStr: " + defaultContentIdStr));
            mcContent = mcService.retrieveMc(new Long(defaultContentIdStr));
        }
        logger.debug((Object)("final mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("mcQuestionContentDTO now: " + mcQuestionContentDTO2));
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        request.setAttribute("requestNewEditableQuestionBox", (Object)new Boolean(true).toString());
        return this.newEditableQuestionBox(mapping, form, request, response);
    }

    public ActionForward newCandidateBox(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching newCandidateBox");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String questionIndex = request.getParameter("questionIndex");
        logger.debug((Object)("questionIndex: " + questionIndex));
        mcAuthoringForm.setQuestionIndex(questionIndex);
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, true);
        logger.debug((Object)("repopulated caList: " + caList));
        int caCount = caList.size();
        logger.debug((Object)("caCount: " + caCount));
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        String passmark = request.getParameter("passmark");
        logger.debug((Object)("passmark: " + passmark));
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        int currentQuestionCount = listQuestionContentDTO.size();
        logger.debug((Object)("currentQuestionCount: " + currentQuestionCount));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        McQuestionContentDTO mcQuestionContentDTOLocal2 = null;
        for (McQuestionContentDTO mcQuestionContentDTOLocal2 : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTOLocal:" + mcQuestionContentDTOLocal2));
            logger.debug((Object)("mcQuestionContentDTOLocal question:" + mcQuestionContentDTOLocal2.getQuestion()));
            String question = mcQuestionContentDTOLocal2.getQuestion();
            String displayOrder = mcQuestionContentDTOLocal2.getDisplayOrder();
            logger.debug((Object)("displayOrder:" + displayOrder));
            if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
            break;
        }
        logger.debug((Object)("mcQuestionContentDTOLocal found:" + mcQuestionContentDTOLocal2));
        if (mcQuestionContentDTOLocal2 != null) {
            mcQuestionContentDTOLocal2.setListCandidateAnswersDTO(caList);
            mcQuestionContentDTOLocal2.setCaCount(new Integer(caList.size()).toString());
        }
        logger.debug((Object)("listQuestionContentDTO after repopulating data: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("mcQuestionContentDTOLocal now: " + mcQuestionContentDTOLocal2));
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        request.setAttribute("requestNewEditableQuestionBox", (Object)new Boolean(true).toString());
        return this.newEditableQuestionBox(mapping, form, request, response);
    }

    public ActionForward moveAddedCandidateUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveAddedCandidateUp");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        AuthoringUtil authoringUtil = new AuthoringUtil();
        boolean validateCandidateAnswersNotBlank = authoringUtil.validateCandidateAnswersNotBlank(request);
        logger.debug((Object)("validateCandidateAnswersNotBlank: " + validateCandidateAnswersNotBlank));
        ActionMessages errors = new ActionMessages();
        if (!validateCandidateAnswersNotBlank) {
            ActionMessage error = new ActionMessage("candidates.blank");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        if (errors.isEmpty()) {
            List candidates = new LinkedList();
            List listCandidates = new LinkedList();
            for (McQuestionContentDTO mcQuestionContentDTO : listAddableQuestionContentDTO) {
                logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
                candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
                logger.debug((Object)("candidates found :" + candidates));
                logger.debug((Object)("but we are using the repopulated caList here: " + caList));
                listCandidates = AuthoringUtil.swapCandidateNodes(caList, candidateIndex, "up");
                logger.debug((Object)("swapped candidates :" + listCandidates));
                mcQuestionContentDTO.setListCandidateAnswersDTO(listCandidates);
            }
        }
        logger.debug((Object)("listAddableQuestionContentDTO after swapping (up) candidates: " + listAddableQuestionContentDTO));
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        sessionMap.put((Object)"newAddableQuestionContentKey", (Object)listAddableQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        return this.newQuestionBox(mapping, form, request, response);
    }

    public ActionForward moveAddedCandidateDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching moveAddedCandidateDown");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        boolean validateCandidateAnswersNotBlank = authoringUtil.validateCandidateAnswersNotBlank(request);
        logger.debug((Object)("validateCandidateAnswersNotBlank: " + validateCandidateAnswersNotBlank));
        ActionMessages errors = new ActionMessages();
        if (!validateCandidateAnswersNotBlank) {
            ActionMessage error = new ActionMessage("candidates.blank");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.debug((Object)("errors saved: " + errors));
        }
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        if (errors.isEmpty()) {
            List candidates = new LinkedList();
            List listCandidates = new LinkedList();
            for (McQuestionContentDTO mcQuestionContentDTO : listAddableQuestionContentDTO) {
                logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
                candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
                logger.debug((Object)("candidates found :" + candidates));
                logger.debug((Object)("but we are using the repopulated caList here: " + caList));
                listCandidates = AuthoringUtil.swapCandidateNodes(caList, candidateIndex, "down");
                logger.debug((Object)("swapped candidates :" + listCandidates));
                mcQuestionContentDTO.setListCandidateAnswersDTO(listCandidates);
            }
        }
        logger.debug((Object)"listAddableQuestionContentDTO after moving down candidates: ");
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        sessionMap.put((Object)"newAddableQuestionContentKey", (Object)listAddableQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        return this.newQuestionBox(mapping, form, request, response);
    }

    public ActionForward removeAddedCandidate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching removeAddedCandidate");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, false);
        logger.debug((Object)("repopulated caList: " + caList));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        List candidates = new LinkedList();
        LinkedList listCandidates = new LinkedList();
        for (McQuestionContentDTO mcQuestionContentDTO : listAddableQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            candidates = mcQuestionContentDTO.getListCandidateAnswersDTO();
            logger.debug((Object)("candidates found :" + candidates));
            logger.debug((Object)("mcQuestionContentDTO found:" + mcQuestionContentDTO));
            logger.debug((Object)"setting caList for the content:");
            mcQuestionContentDTO.setListCandidateAnswersDTO(caList);
            List candidateAnswers = mcQuestionContentDTO.getListCandidateAnswersDTO();
            logger.debug((Object)("candidateAnswers:" + candidateAnswers));
            McCandidateAnswersDTO mcCandidateAnswersDTO = null;
            Iterator listCaIterator = candidateAnswers.iterator();
            int caIndex = 0;
            while (listCaIterator.hasNext()) {
                logger.debug((Object)("caIndex:" + ++caIndex));
                mcCandidateAnswersDTO = (McCandidateAnswersDTO)listCaIterator.next();
                logger.debug((Object)("mcCandidateAnswersDTO:" + mcCandidateAnswersDTO));
                logger.debug((Object)("mcCandidateAnswersDTO question:" + mcCandidateAnswersDTO.getCandidateAnswer()));
                if (caIndex != new Integer(candidateIndex)) continue;
                logger.debug((Object)"candidateIndex found");
                mcCandidateAnswersDTO.setCandidateAnswer("");
                break;
            }
            logger.debug((Object)("candidateAnswers after resetting answer" + candidateAnswers));
            candidateAnswers = AuthoringUtil.reorderListCandidatesDTO(candidateAnswers);
            logger.debug((Object)("candidateAnswers after reordering candidate nodes" + candidateAnswers));
            mcQuestionContentDTO.setListCandidateAnswersDTO(candidateAnswers);
            mcQuestionContentDTO.setCaCount(new Integer(candidateAnswers.size()).toString());
            logger.debug((Object)("listQuestionContentDTO after remove: " + listQuestionContentDTO));
        }
        logger.debug((Object)("listAddableQuestionContentDTO : " + listAddableQuestionContentDTO));
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        sessionMap.put((Object)"newAddableQuestionContentKey", (Object)listAddableQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        if (mcContent == null) {
            logger.debug((Object)("using defaultContentIdStr: " + defaultContentIdStr));
            mcContent = mcService.retrieveMc(new Long(defaultContentIdStr));
        }
        logger.debug((Object)("final mcContent: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        mcAuthoringForm.setFeedback(feedback);
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        return this.newQuestionBox(mapping, form, request, response);
    }

    public ActionForward newAddedCandidateBox(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug((Object)"dispatching newAddedCandidateBox");
        McMonitoringForm mcAuthoringForm = (McMonitoringForm)form;
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String httpSessionID = mcAuthoringForm.getHttpSessionID();
        logger.debug((Object)("httpSessionID: " + httpSessionID));
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        logger.debug((Object)("sessionMap: " + sessionMap));
        String candidateIndex = request.getParameter("candidateIndex");
        logger.debug((Object)("candidateIndex: " + candidateIndex));
        mcAuthoringForm.setCandidateIndex(candidateIndex);
        String totalMarks = request.getParameter("totalMarks");
        logger.debug((Object)("totalMarks: " + totalMarks));
        List listQuestionContentDTO = (List)sessionMap.get((Object)"listQuestionContentDTOKey");
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List caList = authoringUtil.repopulateCandidateAnswersBox(request, true);
        logger.debug((Object)("repopulated caList: " + caList));
        int caCount = caList.size();
        logger.debug((Object)("caCount: " + caCount));
        String newQuestion = request.getParameter("newQuestion");
        logger.debug((Object)("newQuestion: " + newQuestion));
        String mark = request.getParameter("mark");
        logger.debug((Object)("mark: " + mark));
        String passmark = request.getParameter("passmark");
        logger.debug((Object)("passmark: " + passmark));
        String feedback = request.getParameter("feedback");
        logger.debug((Object)("feedback: " + feedback));
        int currentQuestionCount = listQuestionContentDTO.size();
        logger.debug((Object)("currentQuestionCount: " + currentQuestionCount));
        String editQuestionBoxRequest = request.getParameter("editQuestionBoxRequest");
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        List listAddableQuestionContentDTO = (List)sessionMap.get((Object)"newAddableQuestionContentKey");
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        LinkedList candidates = new LinkedList();
        LinkedList listCandidates = new LinkedList();
        for (McQuestionContentDTO mcQuestionContentDTO : listAddableQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("caList:" + caList));
            logger.debug((Object)("caList size:" + caList.size()));
            mcQuestionContentDTO.setListCandidateAnswersDTO(caList);
            mcQuestionContentDTO.setCaCount(new Integer(caList.size()).toString());
        }
        logger.debug((Object)"listAddableQuestionContentDTO after swapping (up) candidates: ");
        request.setAttribute("newAddableQuestionContentList", (Object)listAddableQuestionContentDTO);
        sessionMap.put((Object)"newAddableQuestionContentKey", (Object)listAddableQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO after repopulating data: " + listQuestionContentDTO));
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        String richTextTitle = request.getParameter("title");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        String defaultContentIdStr = new Long(mcService.getToolDefaultContentIdBySignature("lamc11")).toString();
        logger.debug((Object)("defaultContentIdStr: " + defaultContentIdStr));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        mcGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        mcAuthoringForm.setTitle(richTextTitle);
        mcGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        mcGeneralAuthoringDTO.setEditActivityEditMode(new Boolean(true).toString());
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        McUtils.setFormProperties(request, mcService, mcAuthoringForm, mcGeneralAuthoringDTO, strToolContentID, defaultContentIdStr, activeModule, sessionMap, httpSessionID);
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setToolContentID(strToolContentID);
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setActiveModule(activeModule);
        mcAuthoringForm.setDefaultContentIdStr(defaultContentIdStr);
        mcAuthoringForm.setCurrentTab("3");
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        logger.debug((Object)("listQuestionContentDTO now: " + listQuestionContentDTO));
        mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        logger.debug((Object)("generating dyn pass map using listQuestionContentDTO: " + listQuestionContentDTO));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTO, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        mcGeneralAuthoringDTO.setEditableQuestionText(newQuestion);
        mcAuthoringForm.setFeedback(feedback);
        mcGeneralAuthoringDTO.setMarkValue(mark);
        logger.debug((Object)("before saving final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("editQuestionBoxRequest: " + editQuestionBoxRequest));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        this.setupCommonScreenData(mcContent, mcService, request);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        return this.newQuestionBox(mapping, form, request, response);
    }

    public void prepareReflectionData(HttpServletRequest request, McContent mcContent, IMcService mcService, String userID, boolean exportMode) {
        logger.debug((Object)("starting prepareReflectionData: " + mcContent));
        logger.debug((Object)("exportMode: " + exportMode));
        LinkedList<ReflectionDTO> reflectionsContainerDTO = new LinkedList<ReflectionDTO>();
        if (userID == null) {
            logger.debug((Object)"all users mode");
            for (McSession mcSession : mcContent.getMcSessions()) {
                logger.debug((Object)("mcSession: " + mcSession));
                for (McQueUsr user : mcSession.getMcQueUsers()) {
                    logger.debug((Object)("user: " + user));
                    NotebookEntry notebookEntry = mcService.getEntry(mcSession.getMcSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(user.getQueUsrId().toString()));
                    logger.debug((Object)("notebookEntry: " + notebookEntry));
                    if (notebookEntry == null) continue;
                    ReflectionDTO reflectionDTO = new ReflectionDTO();
                    reflectionDTO.setUserId(user.getQueUsrId().toString());
                    reflectionDTO.setSessionId(mcSession.getMcSessionId().toString());
                    reflectionDTO.setUserName(user.getUsername());
                    reflectionDTO.setReflectionUid(notebookEntry.getUid().toString());
                    String notebookEntryPresentable = McUtils.replaceNewLines(notebookEntry.getEntry());
                    reflectionDTO.setEntry(notebookEntryPresentable);
                    reflectionsContainerDTO.add(reflectionDTO);
                }
            }
        } else {
            logger.debug((Object)"single user mode");
            for (McSession mcSession : mcContent.getMcSessions()) {
                logger.debug((Object)("mcSession: " + mcSession));
                for (McQueUsr user : mcSession.getMcQueUsers()) {
                    logger.debug((Object)("user: " + user));
                    if (!user.getQueUsrId().toString().equals(userID)) continue;
                    NotebookEntry notebookEntry = mcService.getEntry(mcSession.getMcSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(user.getQueUsrId().toString()));
                    logger.debug((Object)("notebookEntry: " + notebookEntry));
                    if (notebookEntry == null) continue;
                    ReflectionDTO reflectionDTO = new ReflectionDTO();
                    reflectionDTO.setUserId(user.getQueUsrId().toString());
                    reflectionDTO.setSessionId(mcSession.getMcSessionId().toString());
                    reflectionDTO.setUserName(user.getUsername());
                    reflectionDTO.setReflectionUid(notebookEntry.getUid().toString());
                    String notebookEntryPresentable = McUtils.replaceNewLines(notebookEntry.getEntry());
                    reflectionDTO.setEntry(notebookEntryPresentable);
                    reflectionsContainerDTO.add(reflectionDTO);
                }
            }
        }
        logger.debug((Object)("reflectionsContainerDTO: " + reflectionsContainerDTO));
        request.getSession().setAttribute("reflectionsContainerDTO", reflectionsContainerDTO);
        if (exportMode) {
            request.getSession().setAttribute("reflectionsContainerDTO", reflectionsContainerDTO);
        }
    }

    public ActionForward openNotebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException {
        logger.debug((Object)"dispatching openNotebook...");
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        String uid = request.getParameter("uid");
        logger.debug((Object)("uid: " + uid));
        String userId = request.getParameter("userId");
        logger.debug((Object)("userId: " + userId));
        String userName = request.getParameter("userName");
        logger.debug((Object)("userName: " + userName));
        String sessionId = request.getParameter("sessionId");
        logger.debug((Object)("sessionId: " + sessionId));
        NotebookEntry notebookEntry = mcService.getEntry(new Long(sessionId), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(userId));
        logger.debug((Object)("notebookEntry: " + notebookEntry));
        McGeneralLearnerFlowDTO mcGeneralLearnerFlowDTO = new McGeneralLearnerFlowDTO();
        if (notebookEntry != null) {
            String notebookEntryPresentable = McUtils.replaceNewLines(notebookEntry.getEntry());
            mcGeneralLearnerFlowDTO.setNotebookEntry(notebookEntryPresentable);
            mcGeneralLearnerFlowDTO.setUserName(userName);
        }
        logger.debug((Object)("mcGeneralLearnerFlowDTO: " + mcGeneralLearnerFlowDTO));
        request.setAttribute("mcGeneralLearnerFlowDTO", (Object)mcGeneralLearnerFlowDTO);
        return mapping.findForward("learnerNotebook");
    }

    public void prepareReflectionData(HttpServletRequest request, McContent mcContent, IMcService mcService, String userID, boolean exportMode, String currentSessionId) {
        logger.debug((Object)("starting prepareReflectionData: " + mcContent));
        logger.debug((Object)("currentSessionId: " + currentSessionId));
        logger.debug((Object)("userID: " + userID));
        logger.debug((Object)("exportMode: " + exportMode));
        List reflectionsContainerDTO = new LinkedList();
        reflectionsContainerDTO = this.getReflectionList(mcContent, userID, mcService);
        logger.debug((Object)("reflectionsContainerDTO: " + reflectionsContainerDTO));
        request.setAttribute("reflectionsContainerDTO", reflectionsContainerDTO);
        if (exportMode) {
            request.getSession().setAttribute("reflectionsContainerDTO", reflectionsContainerDTO);
        }
    }

    public List getReflectionList(McContent mcContent, String userID, IMcService mcService) {
        logger.debug((Object)"getting reflections for all sessions");
        LinkedList<ReflectionDTO> reflectionsContainerDTO = new LinkedList<ReflectionDTO>();
        if (userID == null) {
            logger.debug((Object)"all users mode");
            for (McSession mcSession : mcContent.getMcSessions()) {
                logger.debug((Object)("mcSession: " + mcSession));
                logger.debug((Object)("mcSession sessionId: " + mcSession.getMcSessionId()));
                for (McQueUsr user : mcSession.getMcQueUsers()) {
                    logger.debug((Object)("user: " + user));
                    NotebookEntry notebookEntry = mcService.getEntry(mcSession.getMcSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(user.getQueUsrId().toString()));
                    logger.debug((Object)("notebookEntry: " + notebookEntry));
                    if (notebookEntry == null) continue;
                    ReflectionDTO reflectionDTO = new ReflectionDTO();
                    reflectionDTO.setUserId(user.getQueUsrId().toString());
                    reflectionDTO.setSessionId(mcSession.getMcSessionId().toString());
                    reflectionDTO.setUserName(user.getFullname());
                    reflectionDTO.setReflectionUid(notebookEntry.getUid().toString());
                    String notebookEntryPresentable = McUtils.replaceNewLines(notebookEntry.getEntry());
                    reflectionDTO.setEntry(notebookEntryPresentable);
                    reflectionsContainerDTO.add(reflectionDTO);
                }
            }
        } else {
            logger.debug((Object)"single user mode");
            for (McSession mcSession : mcContent.getMcSessions()) {
                logger.debug((Object)("mcSession: " + mcSession));
                for (McQueUsr user : mcSession.getMcQueUsers()) {
                    logger.debug((Object)("user: " + user));
                    if (!user.getQueUsrId().toString().equals(userID)) continue;
                    logger.debug((Object)("getting reflection for user with  userID: " + userID));
                    NotebookEntry notebookEntry = mcService.getEntry(mcSession.getMcSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(user.getQueUsrId().toString()));
                    logger.debug((Object)("notebookEntry: " + notebookEntry));
                    if (notebookEntry == null) continue;
                    ReflectionDTO reflectionDTO = new ReflectionDTO();
                    reflectionDTO.setUserId(user.getQueUsrId().toString());
                    reflectionDTO.setSessionId(mcSession.getMcSessionId().toString());
                    reflectionDTO.setUserName(user.getFullname());
                    reflectionDTO.setReflectionUid(notebookEntry.getUid().toString());
                    String notebookEntryPresentable = McUtils.replaceNewLines(notebookEntry.getEntry());
                    reflectionDTO.setEntry(notebookEntryPresentable);
                    reflectionsContainerDTO.add(reflectionDTO);
                }
            }
        }
        return reflectionsContainerDTO;
    }

    public List getReflectionListForSession(McContent mcContent, String userID, IMcService mcService, String currentSessionId) {
        logger.debug((Object)"getting reflections for a specific session");
        logger.debug((Object)("currentSessionId: " + currentSessionId));
        LinkedList<ReflectionDTO> reflectionsContainerDTO = new LinkedList<ReflectionDTO>();
        if (userID == null) {
            logger.debug((Object)"all users mode");
            for (McSession mcSession : mcContent.getMcSessions()) {
                logger.debug((Object)("mcSession: " + mcSession));
                logger.debug((Object)("mcSession sessionId: " + mcSession.getMcSessionId()));
                if (!currentSessionId.equals(mcSession.getMcSessionId())) continue;
                for (McQueUsr user : mcSession.getMcQueUsers()) {
                    logger.debug((Object)("user: " + user));
                    NotebookEntry notebookEntry = mcService.getEntry(mcSession.getMcSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(user.getQueUsrId().toString()));
                    logger.debug((Object)("notebookEntry: " + notebookEntry));
                    if (notebookEntry == null) continue;
                    ReflectionDTO reflectionDTO = new ReflectionDTO();
                    reflectionDTO.setUserId(user.getQueUsrId().toString());
                    reflectionDTO.setSessionId(mcSession.getMcSessionId().toString());
                    reflectionDTO.setUserName(user.getFullname());
                    reflectionDTO.setReflectionUid(notebookEntry.getUid().toString());
                    String notebookEntryPresentable = McUtils.replaceNewLines(notebookEntry.getEntry());
                    reflectionDTO.setEntry(notebookEntryPresentable);
                    reflectionsContainerDTO.add(reflectionDTO);
                }
            }
        } else {
            logger.debug((Object)"single user mode");
            for (McSession mcSession : mcContent.getMcSessions()) {
                logger.debug((Object)("mcSession: " + mcSession));
                if (!currentSessionId.equals(mcSession.getMcSessionId())) continue;
                for (McQueUsr user : mcSession.getMcQueUsers()) {
                    logger.debug((Object)("user: " + user));
                    if (!user.getQueUsrId().toString().equals(userID)) continue;
                    logger.debug((Object)("getting reflection for user with  userID: " + userID));
                    NotebookEntry notebookEntry = mcService.getEntry(mcSession.getMcSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(user.getQueUsrId().toString()));
                    logger.debug((Object)("notebookEntry: " + notebookEntry));
                    if (notebookEntry == null) continue;
                    ReflectionDTO reflectionDTO = new ReflectionDTO();
                    reflectionDTO.setUserId(user.getQueUsrId().toString());
                    reflectionDTO.setSessionId(mcSession.getMcSessionId().toString());
                    reflectionDTO.setUserName(user.getFullname());
                    reflectionDTO.setReflectionUid(notebookEntry.getUid().toString());
                    String notebookEntryPresentable = McUtils.replaceNewLines(notebookEntry.getEntry());
                    reflectionDTO.setEntry(notebookEntryPresentable);
                    reflectionsContainerDTO.add(reflectionDTO);
                }
            }
        }
        return reflectionsContainerDTO;
    }

    public void prepareEditActivityScreenData(HttpServletRequest request, McContent mcContent) {
        logger.debug((Object)("starting prepareEditActivityScreenData: " + mcContent));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        mcGeneralAuthoringDTO.setActivityTitle(mcContent.getTitle());
        mcGeneralAuthoringDTO.setActivityInstructions(mcContent.getInstructions());
        logger.debug((Object)("final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
    }

    public void initSummaryContent(String toolContentID, HttpServletRequest request, IMcService mcService, McGeneralMonitoringDTO mcGeneralMonitoringDTO) throws IOException, ServletException {
        logger.debug((Object)("start  initSummaryContent...toolContentID: " + toolContentID));
        logger.debug((Object)("dispatching getSummary...mcGeneralMonitoringDTO:" + mcGeneralMonitoringDTO));
        logger.debug((Object)("mcService: " + mcService));
        logger.debug((Object)("toolContentID: " + toolContentID));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentID));
        logger.debug((Object)("existing mcContent:" + mcContent));
        Map summaryToolSessions = MonitoringUtil.populateToolSessions(request, mcContent, mcService);
        logger.debug((Object)("summaryToolSessions: " + summaryToolSessions));
        mcGeneralMonitoringDTO.setSummaryToolSessions(summaryToolSessions);
        Map summaryToolSessionsId = MonitoringUtil.populateToolSessionsId(request, mcContent, mcService);
        logger.debug((Object)("summaryToolSessionsId: " + summaryToolSessionsId));
        mcGeneralMonitoringDTO.setSummaryToolSessionsId(summaryToolSessionsId);
        if (mcService.studentActivityOccurredGlobal(mcContent)) {
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(false).toString());
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to false");
        } else {
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to true");
        }
        this.prepareReflectionData(request, mcContent, mcService, null, false, "All");
        EditActivityDTO editActivityDTO = new EditActivityDTO();
        boolean isContentInUse = McUtils.isContentInUse(mcContent);
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        if (isContentInUse) {
            editActivityDTO.setMonitoredContentInUse(new Boolean(true).toString());
        }
        request.setAttribute("editActivityDTO", (Object)editActivityDTO);
        mcGeneralMonitoringDTO.setOnlineInstructions(mcContent.getOnlineInstructions());
        mcGeneralMonitoringDTO.setOfflineInstructions(mcContent.getOfflineInstructions());
        List attachmentList = mcService.retrieveMcUploadedFiles(mcContent);
        logger.debug((Object)("attachmentList: " + attachmentList));
        mcGeneralMonitoringDTO.setAttachmentList(attachmentList);
        mcGeneralMonitoringDTO.setDeletedAttachmentList(new ArrayList());
        mcGeneralMonitoringDTO.setCurrentMonitoringTab("summary");
        logger.debug((Object)("end of refreshSummaryData, mcGeneralMonitoringDTO" + mcGeneralMonitoringDTO));
        request.setAttribute("mcGeneralMonitoringDTO", (Object)mcGeneralMonitoringDTO);
        boolean notebookEntriesExist = MonitoringUtil.notebookEntriesExist(mcService, mcContent);
        logger.debug((Object)("notebookEntriesExist : " + notebookEntriesExist));
        if (notebookEntriesExist) {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(true).toString());
            String userExceptionNoToolSessions = mcGeneralMonitoringDTO.getUserExceptionNoToolSessions();
            logger.debug((Object)("userExceptionNoToolSessions : " + userExceptionNoToolSessions));
            if (userExceptionNoToolSessions.equals("true")) {
                logger.debug((Object)"there are no online student activity but there are reflections : ");
                request.setAttribute("noSessionsNotebookEntriesExist", (Object)new Boolean(true).toString());
            }
        } else {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(false).toString());
        }
        MonitoringUtil.buildMcStatsDTO(request, mcService, mcContent);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)"end  initSummaryContent...");
    }

    public void initStatsContent(String toolContentID, HttpServletRequest request, IMcService mcService, McGeneralMonitoringDTO mcGeneralMonitoringDTO) throws IOException, ServletException {
        logger.debug((Object)("starting  initStatsContent...:" + toolContentID));
        logger.debug((Object)("dispatching getStats..." + request));
        logger.debug((Object)("mcService: " + mcService));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentID));
        logger.debug((Object)("existing mcContent:" + mcContent));
        if (mcService.studentActivityOccurredGlobal(mcContent)) {
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(false).toString());
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to false");
        } else {
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to true");
        }
        this.refreshStatsData(request, mcService, mcGeneralMonitoringDTO);
        logger.debug((Object)("post refreshStatsData, mcGeneralMonitoringDTO: " + mcGeneralMonitoringDTO));
        this.prepareReflectionData(request, mcContent, mcService, null, false, "All");
        EditActivityDTO editActivityDTO = new EditActivityDTO();
        boolean isContentInUse = McUtils.isContentInUse(mcContent);
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        if (isContentInUse) {
            editActivityDTO.setMonitoredContentInUse(new Boolean(true).toString());
        }
        request.setAttribute("editActivityDTO", (Object)editActivityDTO);
        mcGeneralMonitoringDTO.setOnlineInstructions(mcContent.getOnlineInstructions());
        mcGeneralMonitoringDTO.setOfflineInstructions(mcContent.getOfflineInstructions());
        List attachmentList = mcService.retrieveMcUploadedFiles(mcContent);
        logger.debug((Object)("attachmentList: " + attachmentList));
        mcGeneralMonitoringDTO.setAttachmentList(attachmentList);
        mcGeneralMonitoringDTO.setDeletedAttachmentList(new ArrayList());
        mcGeneralMonitoringDTO.setCurrentMonitoringTab("stats");
        logger.debug((Object)("end of refreshSummaryData, mcGeneralMonitoringDTO" + mcGeneralMonitoringDTO));
        request.setAttribute("mcGeneralMonitoringDTO", (Object)mcGeneralMonitoringDTO);
        boolean notebookEntriesExist = MonitoringUtil.notebookEntriesExist(mcService, mcContent);
        logger.debug((Object)("notebookEntriesExist : " + notebookEntriesExist));
        if (notebookEntriesExist) {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(true).toString());
            String userExceptionNoToolSessions = mcGeneralMonitoringDTO.getUserExceptionNoToolSessions();
            logger.debug((Object)("userExceptionNoToolSessions : " + userExceptionNoToolSessions));
            if (userExceptionNoToolSessions.equals("true")) {
                logger.debug((Object)"there are no online student activity but there are reflections : ");
                request.setAttribute("noSessionsNotebookEntriesExist", (Object)new Boolean(true).toString());
            }
        } else {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(false).toString());
        }
        MonitoringUtil.buildMcStatsDTO(request, mcService, mcContent);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)"ending  initStatsContent...");
    }

    public void refreshStatsData(HttpServletRequest request, IMcService mcService, McGeneralMonitoringDTO mcGeneralMonitoringDTO) {
        logger.debug((Object)("starting refreshStatsData: " + mcService));
        if (mcService == null) {
            logger.debug((Object)"will retrieve mcService");
            mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
            logger.debug((Object)("retrieving mcService from session: " + mcService));
        }
        int countAllUsers = mcService.getTotalNumberOfUsers();
        logger.debug((Object)("countAllUsers: " + countAllUsers));
        if (countAllUsers == 0) {
            logger.debug((Object)"error: countAllUsers is 0");
            mcGeneralMonitoringDTO.setUserExceptionNoStudentActivity(new Boolean(true).toString());
        }
        mcGeneralMonitoringDTO.setCountAllUsers(new Integer(countAllUsers).toString());
        int countSessionComplete = mcService.countSessionComplete();
        logger.debug((Object)("countSessionComplete: " + countSessionComplete));
        mcGeneralMonitoringDTO.setCountSessionComplete(new Integer(countSessionComplete).toString());
        logger.debug((Object)("end of refreshStatsData, mcGeneralMonitoringDTO" + mcGeneralMonitoringDTO));
        request.setAttribute("mcGeneralMonitoringDTO", (Object)mcGeneralMonitoringDTO);
    }

    protected void repopulateRequestParameters(HttpServletRequest request, McMonitoringForm mcMonitoringForm, McGeneralMonitoringDTO mcGeneralMonitoringDTO) {
        logger.debug((Object)"starting repopulateRequestParameters");
        String toolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("toolContentID: " + toolContentID));
        mcMonitoringForm.setToolContentID(toolContentID);
        mcGeneralMonitoringDTO.setToolContentID(toolContentID);
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        mcMonitoringForm.setActiveModule(activeModule);
        mcGeneralMonitoringDTO.setActiveModule(activeModule);
        String defineLaterInEditMode = request.getParameter("defineLaterInEditMode");
        logger.debug((Object)("defineLaterInEditMode: " + defineLaterInEditMode));
        mcMonitoringForm.setDefineLaterInEditMode(defineLaterInEditMode);
        mcGeneralMonitoringDTO.setDefineLaterInEditMode(defineLaterInEditMode);
        String isToolSessionChanged = request.getParameter("isToolSessionChanged");
        logger.debug((Object)("isToolSessionChanged: " + isToolSessionChanged));
        mcMonitoringForm.setIsToolSessionChanged(isToolSessionChanged);
        mcGeneralMonitoringDTO.setIsToolSessionChanged(isToolSessionChanged);
        String responseId = request.getParameter("responseId");
        logger.debug((Object)("responseId: " + responseId));
        mcMonitoringForm.setResponseId(responseId);
        mcGeneralMonitoringDTO.setResponseId(responseId);
        String currentUid = request.getParameter("currentUid");
        logger.debug((Object)("currentUid: " + currentUid));
        mcMonitoringForm.setCurrentUid(currentUid);
        mcGeneralMonitoringDTO.setCurrentUid(currentUid);
    }

    protected void setupCommonScreenData(McContent mcContent, IMcService mcService, HttpServletRequest request) {
        logger.debug((Object)("starting setupCommonScreenData, mcContent " + mcContent));
        McGeneralMonitoringDTO mcGeneralMonitoringDTO = new McGeneralMonitoringDTO();
        mcGeneralMonitoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
        if (mcService.studentActivityOccurredGlobal(mcContent)) {
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to false");
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(false).toString());
        } else {
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to true");
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
        }
        mcGeneralMonitoringDTO.setOnlineInstructions(mcContent.getOnlineInstructions());
        mcGeneralMonitoringDTO.setOfflineInstructions(mcContent.getOfflineInstructions());
        List attachmentList = mcService.retrieveMcUploadedFiles(mcContent);
        logger.debug((Object)("attachmentList: " + attachmentList));
        mcGeneralMonitoringDTO.setAttachmentList(attachmentList);
        mcGeneralMonitoringDTO.setDeletedAttachmentList(new ArrayList());
        logger.debug((Object)("end of refreshSummaryData, mcGeneralMonitoringDTO" + mcGeneralMonitoringDTO));
        request.setAttribute("mcGeneralMonitoringDTO", (Object)mcGeneralMonitoringDTO);
        boolean notebookEntriesExist = MonitoringUtil.notebookEntriesExist(mcService, mcContent);
        logger.debug((Object)("notebookEntriesExist : " + notebookEntriesExist));
        if (notebookEntriesExist) {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(true).toString());
            String userExceptionNoToolSessions = mcGeneralMonitoringDTO.getUserExceptionNoToolSessions();
            logger.debug((Object)(": " + userExceptionNoToolSessions));
            if (userExceptionNoToolSessions.equals("true")) {
                logger.debug((Object)"there are no online student activity but there are reflections : ");
                request.setAttribute("noSessionsNotebookEntriesExist", (Object)new Boolean(true).toString());
            }
        } else {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(false).toString());
        }
        MonitoringUtil.buildMcStatsDTO(request, mcService, mcContent);
        MonitoringUtil.generateGroupsSessionData(request, mcService, mcContent);
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        logger.debug((Object)("ending setupCommonScreenData, mcContent " + mcContent));
    }
}

