/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.tool.mc.EditActivityDTO;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McApplicationException;
import org.lamsfoundation.lams.tool.mc.McComparator;
import org.lamsfoundation.lams.tool.mc.McGeneralAuthoringDTO;
import org.lamsfoundation.lams.tool.mc.McGeneralMonitoringDTO;
import org.lamsfoundation.lams.tool.mc.McQuestionContentDTO;
import org.lamsfoundation.lams.tool.mc.McUtils;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueContent;
import org.lamsfoundation.lams.tool.mc.service.IMcService;
import org.lamsfoundation.lams.tool.mc.service.McServiceProxy;
import org.lamsfoundation.lams.tool.mc.web.McMonitoringAction;
import org.lamsfoundation.lams.tool.mc.web.McMonitoringForm;
import org.lamsfoundation.lams.tool.mc.web.MonitoringUtil;
import org.lamsfoundation.lams.web.util.SessionMap;

public class McMonitoringStarterAction
extends Action
implements McAppConstants {
    static Logger logger = Logger.getLogger((String)McMonitoringStarterAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, McApplicationException {
        logger.debug((Object)"init McMonitoringStarterAction...");
        McUtils.cleanUpSessionAbsolute(request);
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("mcService: " + mcService));
        McMonitoringForm mcMonitoringForm = (McMonitoringForm)form;
        logger.debug((Object)("mcMonitoringForm: " + mcMonitoringForm));
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        McGeneralMonitoringDTO mcGeneralMonitoringDTO = new McGeneralMonitoringDTO();
        ActionForward validateParameters = this.validateParameters(request, mapping, mcMonitoringForm);
        logger.debug((Object)("validateParamaters: " + validateParameters));
        if (validateParameters != null) {
            logger.debug((Object)"error validating monitoring parameters");
        }
        boolean initData = this.initialiseMonitoringData(mapping, form, request, response, mcService, mcGeneralMonitoringDTO);
        logger.debug((Object)("initData: " + initData));
        if (!initData) {
            logger.debug((Object)"error initialising monitoring parameters");
        }
        mcMonitoringForm.setCurrentTab("1");
        mcGeneralMonitoringDTO.setCurrentTab("1");
        logger.debug((Object)"setting current tab to 1: ");
        String toolContentID = mcMonitoringForm.getToolContentID();
        logger.debug((Object)("toolContentID: " + toolContentID));
        mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
        mcGeneralMonitoringDTO.setCountAllUsers(new Integer(0).toString());
        mcGeneralMonitoringDTO.setCountSessionComplete(new Integer(0).toString());
        McMonitoringAction mcMonitoringAction = new McMonitoringAction();
        logger.debug((Object)"calling initSummaryContent.");
        mcMonitoringAction.initSummaryContent(toolContentID, request, mcService, mcGeneralMonitoringDTO);
        logger.debug((Object)("post initSummaryContent, mcGeneralMonitoringDTO: " + mcGeneralMonitoringDTO));
        logger.debug((Object)"calling initInstructionsContent.");
        logger.debug((Object)("post initInstructionsContent, mcGeneralMonitoringDTO: " + mcGeneralMonitoringDTO));
        logger.debug((Object)"calling initStatsContent.");
        mcMonitoringAction.initStatsContent(toolContentID, request, mcService, mcGeneralMonitoringDTO);
        logger.debug((Object)("post initStatsContent, mcGeneralMonitoringDTO: " + mcGeneralMonitoringDTO));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        if (mcService.studentActivityOccurredGlobal(mcContent)) {
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(false).toString());
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to false");
        } else {
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to true");
        }
        mcMonitoringForm.setActiveModule("monitoring");
        mcGeneralMonitoringDTO.setActiveModule("monitoring");
        mcMonitoringForm.setSelectedToolSessionId("All");
        mcGeneralMonitoringDTO.setSelectedToolSessionId("All");
        mcGeneralMonitoringDTO.setRequestLearningReport(new Boolean(false).toString());
        mcGeneralMonitoringDTO.setIsPortfolioExport(new Boolean(false).toString());
        logger.debug((Object)("calling submitSession:" + toolContentID));
        request.setAttribute("mcGeneralMonitoringDTO", (Object)mcGeneralMonitoringDTO);
        logger.debug((Object)("for copy using mcGeneralMonitoringDTO: " + mcGeneralMonitoringDTO));
        mcGeneralAuthoringDTO.setActivityTitle(mcGeneralMonitoringDTO.getActivityTitle());
        mcGeneralAuthoringDTO.setActivityInstructions(mcGeneralMonitoringDTO.getActivityInstructions());
        mcGeneralAuthoringDTO.setActiveModule("monitoring");
        Map mapOptionsContent = mcGeneralMonitoringDTO.getMapOptionsContent();
        logger.debug((Object)("mapOptionsContent: " + mapOptionsContent));
        int maxIndex = mapOptionsContent.size();
        logger.debug((Object)("maxIndex: " + maxIndex));
        logger.debug((Object)("mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        logger.debug((Object)("calling submitSession with selectedToolSessionId" + mcMonitoringForm.getSelectedToolSessionId()));
        return mcMonitoringAction.submitSession(mapping, mcMonitoringForm, request, response, mcService, mcGeneralMonitoringDTO);
    }

    public boolean initialiseMonitoringData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, IMcService mcService, McGeneralMonitoringDTO mcGeneralMonitoringDTO) {
        logger.debug((Object)("start initializing  monitoring data...mcService: " + mcService));
        McMonitoringForm mcMonitoringForm = (McMonitoringForm)form;
        mcGeneralMonitoringDTO.setCurrentMonitoringTab("summary");
        mcGeneralMonitoringDTO.setSbmtSuccess(new Boolean(false).toString());
        mcGeneralMonitoringDTO.setDefineLaterInEditMode(new Boolean(false).toString());
        mcGeneralMonitoringDTO.setRequestLearningReport(new Boolean(false).toString());
        mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
        String toolContentID = mcMonitoringForm.getToolContentID();
        logger.debug((Object)("toolContentID: " + toolContentID));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentID));
        logger.debug((Object)("existing mcContent:" + mcContent));
        if (mcContent == null) {
            McUtils.cleanUpSessionAbsolute(request);
            mcGeneralMonitoringDTO.setUserExceptionContentDoesNotExist(new Boolean(true).toString());
            return false;
        }
        boolean isContentInUse = McUtils.isContentInUse(mcContent);
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        mcGeneralMonitoringDTO.setIsMonitoredContentInUse(new Boolean(false).toString());
        if (isContentInUse) {
            logger.debug((Object)"monitoring url does not allow editActivity since the content is in use.");
            mcGeneralMonitoringDTO.setIsMonitoredContentInUse(new Boolean(true).toString());
        }
        mcGeneralMonitoringDTO.setActivityTitle(mcContent.getTitle());
        mcGeneralMonitoringDTO.setActivityInstructions(mcContent.getInstructions());
        logger.debug((Object)("checking student activity on the standard Questions:" + mcContent));
        if (mcService.studentActivityOccurredGlobal(mcContent)) {
            McUtils.cleanUpSessionAbsolute(request);
            logger.debug((Object)("student activity occurred on this content:" + mcContent));
            mcGeneralMonitoringDTO.setUserExceptionContentInUse(new Boolean(true).toString());
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(false).toString());
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to false");
        } else {
            mcGeneralMonitoringDTO.setUserExceptionNoToolSessions(new Boolean(true).toString());
            logger.debug((Object)"USER_EXCEPTION_NO_TOOL_SESSIONS is set to true");
        }
        SessionMap sessionMap = new SessionMap();
        sessionMap.put((Object)"activityTitleKey", (Object)mcContent.getTitle());
        sessionMap.put((Object)"activityInstructionsKey", (Object)mcContent.getInstructions());
        mcMonitoringForm.setHttpSessionID(sessionMap.getSessionID());
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        LinkedList<McQuestionContentDTO> listQuestionContentDTO = new LinkedList<McQuestionContentDTO>();
        TreeMap<String, String> mapOptionsContent = new TreeMap<String, String>(new McComparator());
        logger.debug((Object)"setting existing content data from the db");
        mapOptionsContent.clear();
        Iterator queIterator = mcContent.getMcQueContents().iterator();
        Long mapIndex = new Long(1L);
        logger.debug((Object)("mapOptionsContent: " + mapOptionsContent));
        while (queIterator.hasNext()) {
            McQuestionContentDTO mcContentDTO = new McQuestionContentDTO();
            McQueContent mcQueContent = (McQueContent)queIterator.next();
            if (mcQueContent == null) continue;
            logger.debug((Object)("question: " + mcQueContent.getQuestion()));
            mapOptionsContent.put(mapIndex.toString(), mcQueContent.getQuestion());
            mcContentDTO.setQuestion(mcQueContent.getQuestion());
            mcContentDTO.setDisplayOrder(mcQueContent.getDisplayOrder().toString());
            listQuestionContentDTO.add(mcContentDTO);
            mapIndex = new Long(mapIndex + 1L);
        }
        logger.debug((Object)("Map initialized with existing contentid to: " + mapOptionsContent));
        mcGeneralMonitoringDTO.setMapOptionsContent(mapOptionsContent);
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("listQuestionContentDTO", listQuestionContentDTO);
        sessionMap.put((Object)"listQuestionContentDTOKey", listQuestionContentDTO);
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        McMonitoringAction mcMonitoringAction = new McMonitoringAction();
        logger.debug((Object)"refreshing summary data...");
        mcMonitoringAction.refreshSummaryData(request, mcContent, mcService, true, false, null, null, false, null, mcGeneralMonitoringDTO, null);
        logger.debug((Object)("post refreshSummaryData, mcGeneralMonitoringDTO: " + mcGeneralMonitoringDTO));
        logger.debug((Object)"end initializing  monitoring data...");
        mcGeneralMonitoringDTO.setExistsOpenMcs(new Boolean(false).toString());
        logger.debug((Object)("post refreshes, mcGeneralMonitoringDTO: " + mcGeneralMonitoringDTO));
        EditActivityDTO editActivityDTO = new EditActivityDTO();
        isContentInUse = McUtils.isContentInUse(mcContent);
        logger.debug((Object)("isContentInUse:" + isContentInUse));
        if (isContentInUse) {
            editActivityDTO.setMonitoredContentInUse(new Boolean(true).toString());
        }
        request.setAttribute("editActivityDTO", (Object)editActivityDTO);
        mcMonitoringAction.prepareReflectionData(request, mcContent, mcService, null, false, "All");
        boolean notebookEntriesExist = MonitoringUtil.notebookEntriesExist(mcService, mcContent);
        logger.debug((Object)("notebookEntriesExist : " + notebookEntriesExist));
        if (notebookEntriesExist) {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(true).toString());
            String userExceptionNoToolSessions = mcGeneralMonitoringDTO.getUserExceptionNoToolSessions();
            logger.debug((Object)("userExceptionNoToolSessions : " + userExceptionNoToolSessions));
            if (userExceptionNoToolSessions.equals("true")) {
                logger.debug((Object)"there are no online student activity but there are reflections : ");
                request.setAttribute("noSessionsNotebookEntriesExist", (Object)new Boolean(true).toString());
            }
        } else {
            request.setAttribute("notebookEntriesExist", (Object)new Boolean(false).toString());
        }
        request.setAttribute("selectionCase", (Object)new Long(2L));
        logger.debug((Object)("SELECTION_CASE: " + request.getAttribute("selectionCase")));
        request.setAttribute("currentMonitoredToolSession", (Object)"All");
        MonitoringUtil.setupAllSessionsData(request, mcContent, mcService);
        mcGeneralMonitoringDTO.setOnlineInstructions(mcContent.getOnlineInstructions());
        mcGeneralMonitoringDTO.setOfflineInstructions(mcContent.getOfflineInstructions());
        List attachmentList = mcService.retrieveMcUploadedFiles(mcContent);
        logger.debug((Object)("attachmentList: " + attachmentList));
        mcGeneralMonitoringDTO.setAttachmentList(attachmentList);
        mcGeneralMonitoringDTO.setDeletedAttachmentList(new ArrayList());
        MonitoringUtil.buildMcStatsDTO(request, mcService, mcContent);
        return true;
    }

    protected ActionForward validateParameters(HttpServletRequest request, ActionMapping mapping, McMonitoringForm mcMonitoringForm) {
        logger.debug((Object)"start validating monitoring parameters...");
        String strToolContentId = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentId: " + strToolContentId));
        if (strToolContentId == null || strToolContentId.length() == 0) {
            McUtils.cleanUpSessionAbsolute(request);
            return mapping.findForward("errorList");
        }
        try {
            long toolContentID = new Long(strToolContentId);
            logger.debug((Object)("passed TOOL_CONTENT_ID : " + new Long(toolContentID)));
            mcMonitoringForm.setToolContentID(strToolContentId);
        }
        catch (NumberFormatException e) {
            logger.debug((Object)"add error.numberFormatException");
            return mapping.findForward("errorList");
        }
        return null;
    }

    public void persistInRequestError(HttpServletRequest request, String message) {
        ActionMessages errors = new ActionMessages();
        errors.add("org.apache.struts.action.ERROR", new ActionMessage(message));
        logger.debug((Object)("add " + message + "  to ActionMessages:"));
        this.saveErrors(request, errors);
    }
}

