/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.web;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.mc.McAllGroupsDTO;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McMonitoredAnswersDTO;
import org.lamsfoundation.lams.tool.mc.McMonitoredUserDTO;
import org.lamsfoundation.lams.tool.mc.McSessionMarkDTO;
import org.lamsfoundation.lams.tool.mc.McStatsDTO;
import org.lamsfoundation.lams.tool.mc.McStringComparator;
import org.lamsfoundation.lams.tool.mc.McUserMarkDTO;
import org.lamsfoundation.lams.tool.mc.McUtils;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueUsr;
import org.lamsfoundation.lams.tool.mc.pojos.McSession;
import org.lamsfoundation.lams.tool.mc.pojos.McUsrAttempt;
import org.lamsfoundation.lams.tool.mc.service.IMcService;

public class MonitoringUtil
implements McAppConstants {
    static Logger logger = Logger.getLogger((String)MonitoringUtil.class.getName());

    public static Map populateToolSessions(HttpServletRequest request, McContent mcContent, IMcService mcService) {
        List sessionsList = mcService.getSessionNamesFromContent(mcContent);
        logger.debug((Object)("sessionsList size is:..." + sessionsList.size()));
        Map sessionsMap = McUtils.convertToStringMap(sessionsList, "String");
        logger.debug((Object)("generated sessionsMap:..." + sessionsMap));
        logger.debug((Object)("sessionsMap size:..." + sessionsMap.size()));
        if (sessionsMap.isEmpty()) {
            logger.debug((Object)"sessionsMap size is 0:");
            sessionsMap.put(new Long(1L).toString(), "None");
        } else {
            logger.debug((Object)("sessionsMap has some entries: " + sessionsMap.size()));
            sessionsMap.put(new Long(sessionsMap.size() + 1).toString(), "All");
        }
        logger.debug((Object)("final sessionsMap:" + sessionsMap));
        return sessionsMap;
    }

    public static List buildGroupsQuestionData(HttpServletRequest request, McContent mcContent, IMcService mcService) {
        logger.debug((Object)("will be building groups question data  for content:..." + mcContent));
        logger.debug((Object)("mcService: " + mcService));
        List listQuestions = mcService.getAllQuestionEntries(mcContent.getUid());
        logger.debug((Object)("listQuestions:..." + listQuestions));
        LinkedList<McMonitoredAnswersDTO> listMonitoredAnswersContainerDTO = new LinkedList<McMonitoredAnswersDTO>();
        for (McQueContent mcQueContent : listQuestions) {
            logger.debug((Object)("mcQueContent:..." + mcQueContent));
            if (mcQueContent == null) continue;
            McMonitoredAnswersDTO mcMonitoredAnswersDTO = new McMonitoredAnswersDTO();
            mcMonitoredAnswersDTO.setQuestionUid(mcQueContent.getUid().toString());
            mcMonitoredAnswersDTO.setQuestion(mcQueContent.getQuestion());
            mcMonitoredAnswersDTO.setMark(mcQueContent.getMark().toString());
            List listCandidateAnswers = mcService.findMcOptionNamesByQueId(mcQueContent.getUid());
            logger.debug((Object)("listCandidateAnswers:..." + listCandidateAnswers));
            mcMonitoredAnswersDTO.setCandidateAnswers(listCandidateAnswers);
            List listCandidateAnswersDTO = mcService.populateCandidateAnswersDTO(mcQueContent.getUid());
            logger.debug((Object)("listCandidateAnswersDTO:..." + listCandidateAnswersDTO));
            mcMonitoredAnswersDTO.setCandidateAnswersCorrect(listCandidateAnswersDTO);
            Map questionAttemptData = MonitoringUtil.buildGroupsAttemptData(request, mcContent, mcQueContent, mcQueContent.getUid().toString(), mcService, null);
            logger.debug((Object)("questionAttemptData:..." + questionAttemptData));
            mcMonitoredAnswersDTO.setQuestionAttempts(questionAttemptData);
            listMonitoredAnswersContainerDTO.add(mcMonitoredAnswersDTO);
        }
        logger.debug((Object)("final listMonitoredAnswersContainerDTO:..." + listMonitoredAnswersContainerDTO));
        return listMonitoredAnswersContainerDTO;
    }

    public static List buildGroupsQuestionDataForExportLearner(HttpServletRequest request, McContent mcContent, IMcService mcService, McSession mcSession, McQueUsr mcQueUsr) {
        logger.debug((Object)("will be building groups question data  for content:..." + mcContent));
        logger.debug((Object)("using mcSession:..." + mcSession));
        logger.debug((Object)("using mcQueUsr:..." + mcQueUsr));
        logger.debug((Object)("mcService: " + mcService));
        List listQuestions = mcService.getAllQuestionEntries(mcContent.getUid());
        logger.debug((Object)("listQuestions:..." + listQuestions));
        LinkedList<McMonitoredAnswersDTO> listMonitoredAnswersContainerDTO = new LinkedList<McMonitoredAnswersDTO>();
        for (McQueContent mcQueContent : listQuestions) {
            logger.debug((Object)("mcQueContent:..." + mcQueContent));
            if (mcQueContent == null) continue;
            McMonitoredAnswersDTO mcMonitoredAnswersDTO = new McMonitoredAnswersDTO();
            mcMonitoredAnswersDTO.setQuestionUid(mcQueContent.getUid().toString());
            mcMonitoredAnswersDTO.setQuestion(mcQueContent.getQuestion());
            mcMonitoredAnswersDTO.setMark(mcQueContent.getMark().toString());
            List listCandidateAnswers = mcService.findMcOptionNamesByQueId(mcQueContent.getUid());
            logger.debug((Object)("listCandidateAnswers:..." + listCandidateAnswers));
            mcMonitoredAnswersDTO.setCandidateAnswers(listCandidateAnswers);
            List listCandidateAnswersDTO = mcService.populateCandidateAnswersDTO(mcQueContent.getUid());
            logger.debug((Object)("listCandidateAnswersDTO:..." + listCandidateAnswersDTO));
            mcMonitoredAnswersDTO.setCandidateAnswersCorrect(listCandidateAnswersDTO);
            Map questionAttemptData = MonitoringUtil.buildGroupsAttemptData(request, mcContent, mcQueContent, mcQueContent.getUid().toString(), mcService, mcQueUsr);
            logger.debug((Object)("questionAttemptData:..." + questionAttemptData));
            mcMonitoredAnswersDTO.setQuestionAttempts(questionAttemptData);
            listMonitoredAnswersContainerDTO.add(mcMonitoredAnswersDTO);
        }
        logger.debug((Object)("final listMonitoredAnswersContainerDTO:..." + listMonitoredAnswersContainerDTO));
        return listMonitoredAnswersContainerDTO;
    }

    public static List buildGroupsMarkDataForExportLearner(HttpServletRequest request, McContent mcContent, IMcService mcService, McSession mcSession, Long learnerUid) {
        logger.debug((Object)("will be building export learner groups mark data  for content:..." + mcContent));
        logger.debug((Object)("mcSession: " + mcSession));
        logger.debug((Object)("learnerUid: " + learnerUid));
        LinkedList<McSessionMarkDTO> listMonitoredMarksContainerDTO = new LinkedList<McSessionMarkDTO>();
        McSessionMarkDTO mcSessionMarkDTO = new McSessionMarkDTO();
        mcSessionMarkDTO.setSessionId(mcSession.getMcSessionId().toString());
        mcSessionMarkDTO.setSessionName(mcSession.getSession_name().toString());
        LinkedList<McUserMarkDTO> sessionUsersData = new LinkedList<McUserMarkDTO>();
        Map mapSessionUsersData = new TreeMap(new McStringComparator());
        McUserMarkDTO mcUserMarkDTO = new McUserMarkDTO();
        mcUserMarkDTO.setSessionId(mcSession.getMcSessionId().toString());
        List listQuestions = mcService.getAllQuestionEntries(mcContent.getUid());
        logger.debug((Object)("listQuestions:..." + listQuestions));
        Iterator itListQuestions = listQuestions.iterator();
        LinkedList<String> userMarks = new LinkedList<String>();
        while (itListQuestions.hasNext()) {
            McQueContent mcQueContent = (McQueContent)itListQuestions.next();
            logger.debug((Object)("mcQueContent:..." + mcQueContent));
            if (mcQueContent == null) continue;
            String learnerMark = MonitoringUtil.getLearnerMarkForQuestionInSession(mcQueContent.getUid(), mcSession.getUid(), learnerUid, mcSession, mcService);
            logger.debug((Object)("learnerMark for queContent uid, mcSession uid, mcUser uid:..." + mcQueContent.getUid() + "--" + mcSession.getUid() + "--" + "is: " + learnerMark));
            userMarks.add(learnerMark);
        }
        logger.debug((Object)("final userMarks:..." + userMarks));
        mcUserMarkDTO.setMarks(userMarks);
        String totalMark = MonitoringUtil.getTotalUserMarkForQuestions(userMarks);
        logger.debug((Object)("totalMark: " + totalMark));
        mcUserMarkDTO.setTotalMark(totalMark);
        logger.debug((Object)("final mcUserMarkDTO:..." + mcUserMarkDTO));
        sessionUsersData.add(mcUserMarkDTO);
        logger.debug((Object)("final sessionUsersData: " + sessionUsersData));
        mapSessionUsersData = MonitoringUtil.convertToMcUserMarkDTOMap(sessionUsersData);
        logger.debug((Object)("final mapSessionUsersData: " + mapSessionUsersData));
        mcSessionMarkDTO.setUserMarks(mapSessionUsersData);
        listMonitoredMarksContainerDTO.add(mcSessionMarkDTO);
        logger.debug((Object)("final listMonitoredMarksContainerDTO:..." + listMonitoredMarksContainerDTO));
        return listMonitoredMarksContainerDTO;
    }

    public static List buildGroupsMarkData(HttpServletRequest request, McContent mcContent, IMcService mcService) {
        logger.debug((Object)("will be building groups mark data  for content:..." + mcContent));
        LinkedList<McSessionMarkDTO> listMonitoredMarksContainerDTO = new LinkedList<McSessionMarkDTO>();
        Set sessions = mcContent.getMcSessions();
        for (McSession mcSession : sessions) {
            logger.debug((Object)("iterating mcSession:..." + mcSession));
            McSessionMarkDTO mcSessionMarkDTO = new McSessionMarkDTO();
            mcSessionMarkDTO.setSessionId(mcSession.getMcSessionId().toString());
            mcSessionMarkDTO.setSessionName(mcSession.getSession_name().toString());
            Set sessionUsers = mcSession.getMcQueUsers();
            Iterator usersIterator = sessionUsers.iterator();
            LinkedList<McUserMarkDTO> sessionUsersData = new LinkedList<McUserMarkDTO>();
            Map mapSessionUsersData = new TreeMap(new McStringComparator());
            while (usersIterator.hasNext()) {
                McQueUsr mcQueUsr = (McQueUsr)usersIterator.next();
                logger.debug((Object)("iterating mcQueUsr:..." + mcQueUsr));
                McUserMarkDTO mcUserMarkDTO = new McUserMarkDTO();
                mcUserMarkDTO.setSessionId(mcSession.getMcSessionId().toString());
                mcUserMarkDTO.setSessionName(mcSession.getSession_name().toString());
                mcUserMarkDTO.setUserName(mcQueUsr.getFullname());
                mcUserMarkDTO.setQueUsrId(mcQueUsr.getQueUsrId().toString());
                List listQuestions = mcService.getAllQuestionEntries(mcContent.getUid());
                logger.debug((Object)("listQuestions:..." + listQuestions));
                Iterator itListQuestions = listQuestions.iterator();
                LinkedList<String> userMarks = new LinkedList<String>();
                while (itListQuestions.hasNext()) {
                    McQueContent mcQueContent = (McQueContent)itListQuestions.next();
                    logger.debug((Object)("mcQueContent:..." + mcQueContent));
                    if (mcQueContent == null) continue;
                    String learnerMark = MonitoringUtil.getLearnerMarkForQuestionInSession(mcQueContent.getUid(), mcSession.getUid(), mcQueUsr.getUid(), mcSession, mcService);
                    logger.debug((Object)("learnerMark for queContent uid, mcSession uid, mcUser uid:..." + mcQueContent.getUid() + "--" + mcSession.getUid() + "--" + mcQueUsr.getUid() + "is: " + learnerMark));
                    userMarks.add(learnerMark);
                }
                logger.debug((Object)("final userMarks:..." + userMarks));
                mcUserMarkDTO.setMarks(userMarks);
                String totalMark = MonitoringUtil.getTotalUserMarkForQuestions(userMarks);
                logger.debug((Object)("totalMark: " + totalMark));
                mcUserMarkDTO.setTotalMark(totalMark);
                logger.debug((Object)("final mcUserMarkDTO:..." + mcUserMarkDTO));
                sessionUsersData.add(mcUserMarkDTO);
            }
            logger.debug((Object)("final sessionUsersData: " + sessionUsersData));
            mapSessionUsersData = MonitoringUtil.convertToMcUserMarkDTOMap(sessionUsersData);
            logger.debug((Object)("final mapSessionUsersData: " + mapSessionUsersData));
            mcSessionMarkDTO.setUserMarks(mapSessionUsersData);
            listMonitoredMarksContainerDTO.add(mcSessionMarkDTO);
        }
        logger.debug((Object)("final listMonitoredMarksContainerDTO:..." + listMonitoredMarksContainerDTO));
        return listMonitoredMarksContainerDTO;
    }

    public static List buildGroupingBasedResponsesData(HttpServletRequest request, McContent mcContent, IMcService mcService) {
        logger.debug((Object)("will be building grouping data  for content:..." + mcContent));
        LinkedList<McSessionMarkDTO> listMonitoredMarksContainerDTO = new LinkedList<McSessionMarkDTO>();
        Set sessions = mcContent.getMcSessions();
        for (McSession mcSession : sessions) {
            logger.debug((Object)("iterating mcSession:..." + mcSession));
            McSessionMarkDTO mcSessionMarkDTO = new McSessionMarkDTO();
            mcSessionMarkDTO.setSessionId(mcSession.getMcSessionId().toString());
            mcSessionMarkDTO.setSessionName(mcSession.getSession_name().toString());
            Set sessionUsers = mcSession.getMcQueUsers();
            Iterator usersIterator = sessionUsers.iterator();
            LinkedList<McUserMarkDTO> sessionUsersData = new LinkedList<McUserMarkDTO>();
            Map mapSessionUsersData = new TreeMap(new McStringComparator());
            while (usersIterator.hasNext()) {
                McQueUsr mcQueUsr = (McQueUsr)usersIterator.next();
                logger.debug((Object)("iterating mcQueUsr:..." + mcQueUsr));
                McUserMarkDTO mcUserMarkDTO = new McUserMarkDTO();
                mcUserMarkDTO.setSessionId(mcSession.getMcSessionId().toString());
                mcUserMarkDTO.setUserName(mcQueUsr.getFullname());
                mcUserMarkDTO.setQueUsrId(mcQueUsr.getQueUsrId().toString());
                List listQuestions = mcService.getAllQuestionEntries(mcContent.getUid());
                logger.debug((Object)("listQuestions:..." + listQuestions));
                Iterator itListQuestions = listQuestions.iterator();
                LinkedList<String> userMarks = new LinkedList<String>();
                while (itListQuestions.hasNext()) {
                    McQueContent mcQueContent = (McQueContent)itListQuestions.next();
                    logger.debug((Object)("mcQueContent:..." + mcQueContent));
                    if (mcQueContent == null) continue;
                    String learnerMark = MonitoringUtil.getLearnerMarkForQuestionInSession(mcQueContent.getUid(), mcSession.getUid(), mcQueUsr.getUid(), mcSession, mcService);
                    logger.debug((Object)("learnerMark for queContent uid, mcSession uid, mcUser uid:..." + mcQueContent.getUid() + "--" + mcSession.getUid() + "--" + mcQueUsr.getUid() + "is: " + learnerMark));
                    userMarks.add(learnerMark);
                }
                logger.debug((Object)("final userMarks:..." + userMarks));
                mcUserMarkDTO.setMarks(userMarks);
                String totalMark = MonitoringUtil.getTotalUserMarkForQuestions(userMarks);
                logger.debug((Object)("totalMark: " + totalMark));
                mcUserMarkDTO.setTotalMark(totalMark);
                logger.debug((Object)("final mcUserMarkDTO:..." + mcUserMarkDTO));
                sessionUsersData.add(mcUserMarkDTO);
            }
            logger.debug((Object)("final sessionUsersData: " + sessionUsersData));
            mapSessionUsersData = MonitoringUtil.convertToMcUserMarkDTOMap(sessionUsersData);
            logger.debug((Object)("final mapSessionUsersData: " + mapSessionUsersData));
            mcSessionMarkDTO.setUserMarks(mapSessionUsersData);
            listMonitoredMarksContainerDTO.add(mcSessionMarkDTO);
        }
        logger.debug((Object)("final listMonitoredMarksContainerDTO:..." + listMonitoredMarksContainerDTO));
        return listMonitoredMarksContainerDTO;
    }

    public static String getLearnerMarkForQuestionInSession(Long mcQueContentUid, Long mcSessionUid, Long mcQueUsrUid, McSession mcSession, IMcService mcService) {
        logger.debug((Object)("starting getLearnerMarkForQuestionInSession: mcQueContentUid" + mcQueContentUid));
        logger.debug((Object)("using getLearnerMarkForQuestionInSession: mcSessionUid" + mcSessionUid));
        logger.debug((Object)("using getLearnerMarkForQuestionInSession: mcQueUsrUid" + mcQueUsrUid));
        McUsrAttempt mcUsrAttempt = mcService.getAttemptWithLastAttemptOrderForUserInSession(mcQueUsrUid, mcSessionUid);
        logger.debug((Object)("mcUsrAttempt with highest attempt order: " + mcUsrAttempt));
        String highestAttemptOrder = "";
        List listUserAttempts = null;
        if (mcUsrAttempt == null) {
            return "0";
        }
        highestAttemptOrder = mcUsrAttempt.getAttemptOrder().toString();
        logger.debug((Object)("highestAttemptOrder: " + highestAttemptOrder));
        listUserAttempts = mcService.getAttemptsOnHighestAttemptOrder(mcQueUsrUid, mcQueContentUid, mcSessionUid, new Integer(highestAttemptOrder));
        logger.debug((Object)("listUserAttempts: " + listUserAttempts));
        if (listUserAttempts.size() == 0) {
            return "0";
        }
        Iterator itAttempts = listUserAttempts.iterator();
        if (!mcSession.getMcContent().isRetries()) {
            logger.debug((Object)"retries is OFF.");
            boolean isAttemptCorrect = false;
            McUsrAttempt mcUsrAttemptUser = null;
            mcUsrAttempt = (McUsrAttempt)itAttempts.next();
            logger.debug((Object)("mcUsrAttempt: " + mcUsrAttempt));
            mcUsrAttemptUser = mcUsrAttempt;
            if (mcUsrAttempt != null && mcUsrAttempt.isAttemptCorrect()) {
                isAttemptCorrect = true;
            }
            logger.debug((Object)("final isAttemptCorrect: " + isAttemptCorrect));
            logger.debug((Object)("mcUsrAttemptUser: " + mcUsrAttemptUser));
            if (isAttemptCorrect) {
                return mcUsrAttemptUser.getMcQueContent().getMark().toString();
            }
            return "0";
        }
        logger.debug((Object)"retries is ON. User had to PASS. Print the final attempt's data");
        McMonitoredUserDTO mcMonitoredUserDTO = new McMonitoredUserDTO();
        boolean isAttemptCorrect = false;
        McUsrAttempt mcUsrAttemptGeneral = null;
        while (itAttempts.hasNext()) {
            mcUsrAttempt = (McUsrAttempt)itAttempts.next();
            logger.debug((Object)("mcUsrAttempt: " + mcUsrAttempt));
            mcUsrAttemptGeneral = mcUsrAttempt;
            if (mcUsrAttempt == null || !mcUsrAttempt.isFinished() || !mcUsrAttempt.isPassed()) continue;
            logger.debug((Object)("this is a individual question attempt that is finished and passed: " + mcUsrAttempt));
            isAttemptCorrect = mcService.getUserAttemptCorrectForQuestionContentAndSessionUid(mcQueUsrUid, mcQueContentUid, mcSession.getUid(), new Integer(highestAttemptOrder));
            logger.debug((Object)("isAttemptCorrect: " + isAttemptCorrect));
            break;
        }
        logger.debug((Object)("final isAttemptCorrect: " + isAttemptCorrect));
        if (isAttemptCorrect) {
            return mcUsrAttemptGeneral.getMcQueContent().getMark().toString();
        }
        return "0";
    }

    public static String getTotalUserMarkForQuestions(LinkedList userMarks) {
        Iterator itAttempts = userMarks.iterator();
        int totalMark = 0;
        while (itAttempts.hasNext()) {
            String mark = (String)itAttempts.next();
            int intMark = new Integer(mark);
            totalMark += intMark;
        }
        return new Integer(totalMark).toString();
    }

    public static List buildSessionQuestionData(HttpServletRequest request, McContent mcContent, Long sessionId, Long userID, IMcService mcService) {
        logger.debug((Object)("doing buildSessionQuestionData with sessionId: " + sessionId));
        logger.debug((Object)("doing buildSessionQuestionData with userID: " + userID));
        logger.debug((Object)("will be building groups question data  for content:..." + mcContent));
        List listQuestions = mcService.getAllQuestionEntries(mcContent.getUid());
        logger.debug((Object)("listQuestions:..." + listQuestions));
        LinkedList<McMonitoredAnswersDTO> listMonitoredAnswersContainerDTO = new LinkedList<McMonitoredAnswersDTO>();
        for (McQueContent mcQueContent : listQuestions) {
            logger.debug((Object)("mcQueContent:..." + mcQueContent));
            if (mcQueContent == null) continue;
            McMonitoredAnswersDTO mcMonitoredAnswersDTO = new McMonitoredAnswersDTO();
            mcMonitoredAnswersDTO.setQuestionUid(mcQueContent.getUid().toString());
            mcMonitoredAnswersDTO.setQuestion(mcQueContent.getQuestion());
            List listCandidateAnswers = mcService.findMcOptionNamesByQueId(mcQueContent.getUid());
            logger.debug((Object)("listCandidateAnswers:..." + listCandidateAnswers));
            mcMonitoredAnswersDTO.setCandidateAnswers(listCandidateAnswers);
            Map questionAttemptData = MonitoringUtil.buildSessionAttemptData(request, mcContent, mcQueContent, mcQueContent.getUid().toString(), sessionId, userID, mcService);
            logger.debug((Object)("questionAttemptData:..." + questionAttemptData));
            mcMonitoredAnswersDTO.setQuestionAttempts(questionAttemptData);
            listMonitoredAnswersContainerDTO.add(mcMonitoredAnswersDTO);
        }
        logger.debug((Object)("final listMonitoredAnswersContainerDTO:..." + listMonitoredAnswersContainerDTO));
        return listMonitoredAnswersContainerDTO;
    }

    public static Map buildGroupsAttemptData(HttpServletRequest request, McContent mcContent, McQueContent mcQueContent, String questionUid, IMcService mcService, McQueUsr mcQueUsr) {
        logger.debug((Object)("will be building groups attempt data  for mcQueContent:..." + mcQueContent + " questionUid:" + questionUid));
        Map mapMonitoredAttemptsContainerDTO = new TreeMap(new McStringComparator());
        LinkedList<Map> listMonitoredAttemptsContainerDTO = new LinkedList<Map>();
        Map summaryToolSessions = MonitoringUtil.populateToolSessionsId(request, mcContent, mcService);
        logger.debug((Object)("summaryToolSessions: " + summaryToolSessions));
        if (mcQueUsr == null) {
            for (Map.Entry pairs : summaryToolSessions.entrySet()) {
                logger.debug((Object)("using the  summary tool sessions pair: " + pairs.getKey() + " = " + pairs.getValue()));
                if (pairs.getValue().toString().equals("None") || pairs.getValue().toString().equals("All")) continue;
                logger.debug((Object)("using the  numerical summary tool sessions pair:  = " + pairs.getValue()));
                McSession mcSession = mcService.findMcSessionById(new Long(pairs.getValue().toString()));
                logger.debug((Object)("mcSession:  = " + mcSession));
                if (mcSession == null) continue;
                List listMcUsers = mcService.getMcUserBySessionOnly(mcSession);
                logger.debug((Object)("listMcUsers for session id:" + mcSession.getMcSessionId() + " = " + listMcUsers));
                Map sessionUsersAttempts = MonitoringUtil.populateSessionUsersAttempts(request, mcSession.getMcSessionId(), listMcUsers, questionUid, null, mcService);
                listMonitoredAttemptsContainerDTO.add(sessionUsersAttempts);
            }
        } else {
            for (Map.Entry pairs : summaryToolSessions.entrySet()) {
                logger.debug((Object)("using the  summary tool sessions pair: " + pairs.getKey() + " = " + pairs.getValue()));
                if (pairs.getValue().toString().equals("None") || pairs.getValue().toString().equals("All")) continue;
                logger.debug((Object)("using the  numerical summary tool sessions pair:  = " + pairs.getValue()));
                McSession mcSession = mcService.findMcSessionById(new Long(pairs.getValue().toString()));
                logger.debug((Object)("mcSession:  = " + mcSession));
                if (mcSession == null) continue;
                List listMcUsers = mcService.getMcUserBySessionOnly(mcSession);
                logger.debug((Object)("listMcUsers for session id:" + mcSession.getMcSessionId() + " = " + listMcUsers));
                Map sessionUsersAttempts = MonitoringUtil.populateSessionUsersAttempts(request, mcSession.getMcSessionId(), listMcUsers, questionUid, mcQueUsr.getQueUsrId(), mcService);
                listMonitoredAttemptsContainerDTO.add(sessionUsersAttempts);
            }
        }
        logger.debug((Object)("final listMonitoredAttemptsContainerDTO:..." + listMonitoredAttemptsContainerDTO));
        mapMonitoredAttemptsContainerDTO = MonitoringUtil.convertToMap(listMonitoredAttemptsContainerDTO);
        logger.debug((Object)("final mapMonitoredAttemptsContainerDTO:..." + mapMonitoredAttemptsContainerDTO));
        return mapMonitoredAttemptsContainerDTO;
    }

    public static Map buildGroupsAttemptDataForExportLearner(HttpServletRequest request, McContent mcContent, McQueContent mcQueContent, String questionUid, IMcService mcService, McSession mcSession, McQueUsr mcQueUsr) {
        logger.debug((Object)("will be building groups attempt data  for mcQueContent:..." + mcQueContent + " questionUid:" + questionUid));
        logger.debug((Object)("using mcSession: " + mcSession));
        logger.debug((Object)("using mcQueUsr: " + mcQueUsr));
        Map mapMonitoredAttemptsContainerDTO = new TreeMap(new McStringComparator());
        LinkedList<Map> listMonitoredAttemptsContainerDTO = new LinkedList<Map>();
        logger.debug((Object)("mcSession:  = " + mcSession));
        if (mcSession != null) {
            List listMcUsers = mcService.getMcUserBySessionOnly(mcSession);
            logger.debug((Object)("listMcUsers for session id:" + mcSession.getMcSessionId() + " = " + listMcUsers));
            Map sessionUsersAttempts = MonitoringUtil.populateSessionUsersAttempts(request, mcSession.getMcSessionId(), listMcUsers, questionUid, mcQueUsr.getQueUsrId(), mcService);
            listMonitoredAttemptsContainerDTO.add(sessionUsersAttempts);
        }
        logger.debug((Object)("final listMonitoredAttemptsContainerDTO:..." + listMonitoredAttemptsContainerDTO));
        mapMonitoredAttemptsContainerDTO = MonitoringUtil.convertToMap(listMonitoredAttemptsContainerDTO);
        logger.debug((Object)("final mapMonitoredAttemptsContainerDTO:..." + mapMonitoredAttemptsContainerDTO));
        return mapMonitoredAttemptsContainerDTO;
    }

    public static Map buildSessionAttemptData(HttpServletRequest request, McContent mcContent, McQueContent mcQueContent, String questionUid, Long sessionId, Long userID, IMcService mcService) {
        logger.debug((Object)("doing buildSessionAttemptData with sessionId: " + sessionId));
        logger.debug((Object)("doing buildSessionAttemptData with userID: " + userID));
        logger.debug((Object)("will be building groups attempt data  for mcQueContent:..." + mcQueContent + " questionUid:" + questionUid));
        Map mapMonitoredAttemptsContainerDTO = new TreeMap(new McStringComparator());
        LinkedList<Map> listMonitoredAttemptsContainerDTO = new LinkedList<Map>();
        McSession mcSession = mcService.findMcSessionById(sessionId);
        logger.debug((Object)("mcSession:  = " + mcSession));
        if (mcSession != null) {
            List listMcUsers = mcService.getMcUserBySessionOnly(mcSession);
            logger.debug((Object)("listMcUsers for session id:" + mcSession.getMcSessionId() + " = " + listMcUsers));
            Map sessionUsersAttempts = MonitoringUtil.populateSessionUsersAttempts(request, mcSession.getMcSessionId(), listMcUsers, questionUid, userID, mcService);
            listMonitoredAttemptsContainerDTO.add(sessionUsersAttempts);
            logger.debug((Object)("final listMonitoredAttemptsContainerDTO:..." + listMonitoredAttemptsContainerDTO));
            mapMonitoredAttemptsContainerDTO = MonitoringUtil.convertToMap(listMonitoredAttemptsContainerDTO);
            logger.debug((Object)("final mapMonitoredAttemptsContainerDTO:..." + mapMonitoredAttemptsContainerDTO));
        }
        return mapMonitoredAttemptsContainerDTO;
    }

    public static int getTotalAttemptCount(HttpServletRequest request, IMcService mcService) {
        List listMarks = mcService.getMarks();
        logger.debug((Object)("total attempt count: " + listMarks.size()));
        return listMarks.size();
    }

    public static Map populateSessionUsersAttempts(HttpServletRequest request, Long sessionId, List listMcUsers, String questionUid, Long userID, IMcService mcService) {
        logger.debug((Object)"starting populateSessionUsersAttempts");
        logger.debug((Object)("will be populating users marks for session id: " + sessionId));
        McSession mcSession = mcService.retrieveMcSession(sessionId);
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        logger.debug((Object)("userID: " + userID));
        Map mapMonitoredUserContainerDTO = new TreeMap(new McStringComparator());
        LinkedList listMonitoredUserContainerDTO = new LinkedList();
        logger.debug((Object)"generating standard summary page");
        for (McQueUsr mcQueUsr : listMcUsers) {
            logger.debug((Object)("current User is: " + mcQueUsr));
            if (mcQueUsr == null) continue;
            if (userID != null) {
                logger.debug((Object)("request is export portfolio " + userID));
                logger.debug((Object)("mcQueUsr: " + mcQueUsr));
                logger.debug((Object)("local mcQueUsr userID: " + mcQueUsr.getQueUsrId()));
                logger.debug((Object)("mcQueUsr.getQueUsrId().toString versus userID.toString(): " + mcQueUsr.getQueUsrId().toString() + " versus " + userID.toString()));
                if (!mcQueUsr.getQueUsrId().toString().equals(userID.toString())) continue;
                logger.debug((Object)("returning attempt entries for : " + mcQueUsr));
                mapMonitoredUserContainerDTO = MonitoringUtil.getAttemptEntries(request, mcService, mcQueUsr, mcSession, questionUid, listMonitoredUserContainerDTO, mapMonitoredUserContainerDTO);
                continue;
            }
            logger.debug((Object)"request is standard summary page.");
            mapMonitoredUserContainerDTO = MonitoringUtil.getAttemptEntries(request, mcService, mcQueUsr, mcSession, questionUid, listMonitoredUserContainerDTO, mapMonitoredUserContainerDTO);
        }
        logger.debug((Object)("returning: " + mapMonitoredUserContainerDTO));
        return mapMonitoredUserContainerDTO;
    }

    public static Map getAttemptEntries(HttpServletRequest request, IMcService mcService, McQueUsr mcQueUsr, McSession mcSession, String questionUid, List listMonitoredUserContainerDTO, Map mapMonitoredUserContainerDTO) {
        logger.debug((Object)"starting getAttemptEntries.");
        logger.debug((Object)("mcQueUsr: " + mcQueUsr));
        logger.debug((Object)("mcSession: " + mcSession));
        if (mcQueUsr != null) {
            logger.debug((Object)("getting listUserAttempts for user id: " + mcQueUsr.getUid() + " and que content id: " + questionUid));
            McUsrAttempt mcUsrAttempt = mcService.getAttemptWithLastAttemptOrderForUserInSession(mcQueUsr.getUid(), mcSession.getUid());
            logger.debug((Object)("mcUsrAttempt with highest attempt order: " + mcUsrAttempt));
            String highestAttemptOrder = "";
            List listUserAttempts = null;
            boolean attempExists = true;
            if (mcUsrAttempt != null) {
                highestAttemptOrder = mcUsrAttempt.getAttemptOrder().toString();
                logger.debug((Object)("highestAttemptOrder: " + highestAttemptOrder));
                listUserAttempts = mcService.getAttemptsOnHighestAttemptOrder(mcQueUsr.getUid(), new Long(questionUid), mcSession.getUid(), new Integer(highestAttemptOrder));
                logger.debug((Object)("listUserAttempts: " + listUserAttempts));
            } else {
                attempExists = false;
                McMonitoredUserDTO mcMonitoredUserDTO = new McMonitoredUserDTO();
                mcMonitoredUserDTO.setUserName(mcQueUsr.getFullname());
                mcMonitoredUserDTO.setSessionId(mcSession.getMcSessionId().toString());
                mcMonitoredUserDTO.setQuestionUid(questionUid);
                mcMonitoredUserDTO.setMark("0");
                logger.debug((Object)("final constructed mcMonitoredUserDTO: " + mcMonitoredUserDTO));
                listMonitoredUserContainerDTO.add(mcMonitoredUserDTO);
            }
            logger.debug((Object)("attempExists: " + attempExists));
            if (attempExists) {
                Iterator itAttempts = listUserAttempts.iterator();
                if (!mcSession.getMcContent().isRetries()) {
                    logger.debug((Object)"retries is OFF.");
                    boolean isAttemptCorrect = false;
                    McUsrAttempt mcUsrAttemptUser = null;
                    while (itAttempts.hasNext()) {
                        mcUsrAttempt = (McUsrAttempt)itAttempts.next();
                        logger.debug((Object)("mcUsrAttempt: " + mcUsrAttempt));
                        mcUsrAttemptUser = mcUsrAttempt;
                        if (mcUsrAttempt == null || !mcUsrAttempt.isAttemptCorrect()) continue;
                        isAttemptCorrect = true;
                    }
                    logger.debug((Object)("final isAttemptCorrect: " + isAttemptCorrect));
                    logger.debug((Object)("mcUsrAttemptUser: " + mcUsrAttemptUser));
                    McMonitoredUserDTO mcMonitoredUserDTO = new McMonitoredUserDTO();
                    mcMonitoredUserDTO.setUserName(mcQueUsr.getFullname());
                    mcMonitoredUserDTO.setSessionId(mcSession.getMcSessionId().toString());
                    mcMonitoredUserDTO.setQuestionUid(questionUid);
                    if (isAttemptCorrect) {
                        mcMonitoredUserDTO.setMark(mcUsrAttemptUser.getMcQueContent().getMark().toString());
                    } else {
                        mcMonitoredUserDTO.setMark("0");
                    }
                    logger.debug((Object)("final constructed mcMonitoredUserDTO: " + mcMonitoredUserDTO));
                    listMonitoredUserContainerDTO.add(mcMonitoredUserDTO);
                } else {
                    logger.debug((Object)"retries is ON. User had to PASS. Print the final attempt's data");
                    McMonitoredUserDTO mcMonitoredUserDTO = new McMonitoredUserDTO();
                    boolean isAttemptCorrect = false;
                    McUsrAttempt mcUsrAttemptGeneral = null;
                    while (itAttempts.hasNext()) {
                        mcUsrAttempt = (McUsrAttempt)itAttempts.next();
                        logger.debug((Object)("mcUsrAttempt: " + mcUsrAttempt));
                        mcUsrAttemptGeneral = mcUsrAttempt;
                        if (mcUsrAttempt == null || !mcUsrAttempt.isFinished() || !mcUsrAttempt.isPassed()) continue;
                        logger.debug((Object)("this is a individual question attempt that is finished and passed: " + mcUsrAttempt));
                        isAttemptCorrect = mcService.getUserAttemptCorrectForQuestionContentAndSessionUid(mcQueUsr.getUid(), new Long(questionUid), mcSession.getUid(), new Integer(highestAttemptOrder));
                        logger.debug((Object)("isAttemptCorrect: " + isAttemptCorrect));
                        break;
                    }
                    logger.debug((Object)("final isAttemptCorrect: " + isAttemptCorrect));
                    if (isAttemptCorrect) {
                        mcMonitoredUserDTO.setMark(mcUsrAttemptGeneral.getMcQueContent().getMark().toString());
                    } else {
                        mcMonitoredUserDTO.setMark("0");
                    }
                    mcMonitoredUserDTO.setUserName(mcQueUsr.getFullname());
                    mcMonitoredUserDTO.setSessionId(mcSession.getMcSessionId().toString());
                    mcMonitoredUserDTO.setQuestionUid(questionUid);
                    logger.debug((Object)("final constructed mcMonitoredUserDTO: " + mcMonitoredUserDTO));
                    listMonitoredUserContainerDTO.add(mcMonitoredUserDTO);
                }
            }
        }
        logger.debug((Object)("returning : " + listMonitoredUserContainerDTO));
        logger.debug((Object)("final listMonitoredUserContainerDTO: " + listMonitoredUserContainerDTO));
        mapMonitoredUserContainerDTO = MonitoringUtil.convertToMcMonitoredUserDTOMap(listMonitoredUserContainerDTO);
        logger.debug((Object)("final mapMonitoredUserContainerDTO:..." + mapMonitoredUserContainerDTO));
        return mapMonitoredUserContainerDTO;
    }

    public static McUsrAttempt getAttemptWithHighestOrder(List listUserAttempts) {
        logger.debug((Object)("starting getAttemptWithHighestOrder: " + listUserAttempts));
        Iterator itAttempts = listUserAttempts.iterator();
        int highestOrder = 0;
        McUsrAttempt mcHighestUsrAttempt = null;
        while (itAttempts.hasNext()) {
            McUsrAttempt mcUsrAttempt = (McUsrAttempt)itAttempts.next();
            logger.debug((Object)("mcUsrAttempt: " + mcUsrAttempt));
            int currentOrder = mcUsrAttempt.getAttemptOrder();
            logger.debug((Object)("currentOrder: " + currentOrder));
            if (currentOrder <= highestOrder) continue;
            mcHighestUsrAttempt = mcUsrAttempt;
            highestOrder = currentOrder;
            logger.debug((Object)("highestOrder is updated to: " + highestOrder));
        }
        logger.debug((Object)("returning mcHighestUsrAttempt: " + mcHighestUsrAttempt));
        logger.debug((Object)("highestOrder has become: " + highestOrder));
        return mcHighestUsrAttempt;
    }

    public static Map populateToolSessionsId(HttpServletRequest request, McContent mcContent, IMcService mcService) {
        List sessionsList = mcService.getSessionsFromContent(mcContent);
        logger.debug((Object)("sessionsList size is:..." + sessionsList.size()));
        Map sessionsMap = McUtils.convertToStringMap(sessionsList, "Long");
        logger.debug((Object)("generated sessionsMap:..." + sessionsMap));
        logger.debug((Object)("sessionsMap size:..." + sessionsMap.size()));
        if (sessionsMap.isEmpty()) {
            logger.debug((Object)"sessionsMap size is 0:");
            sessionsMap.put(new Long(1L).toString(), "None");
        } else {
            logger.debug((Object)("sessionsMap has some entries: " + sessionsMap.size()));
            sessionsMap.put(new Long(sessionsMap.size() + 1).toString(), "All");
        }
        logger.debug((Object)("final sessionsMap:" + sessionsMap));
        return sessionsMap;
    }

    public static Map convertToMap(List list) {
        logger.debug((Object)("using convertToMap: " + list));
        TreeMap<String, Map> map = new TreeMap<String, Map>(new McStringComparator());
        Iterator listIterator = list.iterator();
        Long mapIndex = new Long(1L);
        while (listIterator.hasNext()) {
            Map data = (Map)listIterator.next();
            map.put(mapIndex.toString(), data);
            mapIndex = new Long(mapIndex + 1L);
        }
        return map;
    }

    public static Map convertToMcUserMarkDTOMap(List list) {
        logger.debug((Object)("using McUserMarkDTOMap: " + list));
        TreeMap<String, McUserMarkDTO> map = new TreeMap<String, McUserMarkDTO>(new McStringComparator());
        Iterator listIterator = list.iterator();
        Long mapIndex = new Long(1L);
        while (listIterator.hasNext()) {
            McUserMarkDTO data = (McUserMarkDTO)listIterator.next();
            map.put(mapIndex.toString(), data);
            mapIndex = new Long(mapIndex + 1L);
        }
        return map;
    }

    public static Map convertToMcMonitoredUserDTOMap(List list) {
        logger.debug((Object)("using convertToMcMonitoredUserDTOMap: " + list));
        TreeMap<String, McMonitoredUserDTO> map = new TreeMap<String, McMonitoredUserDTO>(new McStringComparator());
        Iterator listIterator = list.iterator();
        Long mapIndex = new Long(1L);
        while (listIterator.hasNext()) {
            McMonitoredUserDTO data = (McMonitoredUserDTO)listIterator.next();
            map.put(mapIndex.toString(), data);
            mapIndex = new Long(mapIndex + 1L);
        }
        return map;
    }

    public static void buildMcStatsDTO(HttpServletRequest request, IMcService mcService, McContent mcContent) {
        logger.debug((Object)("building mcStatsDTO: " + mcContent));
        McStatsDTO mcStatsDTO = new McStatsDTO();
        int countSessionComplete = 0;
        int countAllUsers = 0;
        logger.debug((Object)("finding out about content level notebook entries: " + mcContent));
        for (McSession mcSession : mcContent.getMcSessions()) {
            logger.debug((Object)("mcSession: " + mcSession));
            if (mcSession == null) continue;
            logger.debug((Object)("mcSession id: " + mcSession.getMcSessionId()));
            if (mcSession.getSessionStatus().equals("COMPLETED")) {
                ++countSessionComplete;
            }
            for (McQueUsr mcQueUsr : mcSession.getMcQueUsers()) {
                logger.debug((Object)("mcQueUsr: " + mcQueUsr));
                if (mcQueUsr == null) continue;
                logger.debug((Object)"mcQueUsr foundid");
                ++countAllUsers;
            }
        }
        logger.debug((Object)("countAllUsers: " + countAllUsers));
        logger.debug((Object)("countSessionComplete: " + countSessionComplete));
        mcStatsDTO.setCountAllUsers(new Integer(countAllUsers).toString());
        mcStatsDTO.setCountSessionComplete(new Integer(countSessionComplete).toString());
        logger.debug((Object)("mcStatsDTO: " + mcStatsDTO));
        request.setAttribute("mcStatsDTO", (Object)mcStatsDTO);
    }

    public static boolean notebookEntriesExist(IMcService mcService, McContent mcContent) {
        logger.debug((Object)("finding out about content level notebook entries: " + mcContent));
        for (McSession mcSession : mcContent.getMcSessions()) {
            logger.debug((Object)("mcSession: " + mcSession));
            if (mcSession == null) continue;
            logger.debug((Object)("mcSession id: " + mcSession.getMcSessionId()));
            for (McQueUsr mcQueUsr : mcSession.getMcQueUsers()) {
                logger.debug((Object)("mcQueUsr: " + mcQueUsr));
                if (mcQueUsr == null) continue;
                logger.debug((Object)("mcQueUsr id: " + mcQueUsr.getQueUsrId()));
                logger.debug((Object)"attempt getting notebookEntry: ");
                NotebookEntry notebookEntry = mcService.getEntry(mcSession.getMcSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(mcQueUsr.getQueUsrId().intValue()));
                logger.debug((Object)("notebookEntry: " + notebookEntry));
                if (notebookEntry == null) continue;
                logger.debug((Object)("found at least one notebookEntry: " + notebookEntry.getEntry()));
                return true;
            }
        }
        return false;
    }

    public static void generateGroupsSessionData(HttpServletRequest request, IMcService mcService, McContent mcContent) {
        logger.debug((Object)("generateGroupsSessionData: " + mcContent));
        List listAllGroupsDTO = MonitoringUtil.buildGroupBasedSessionData(request, mcContent, mcService);
        logger.debug((Object)("listAllGroupsDTO: " + listAllGroupsDTO));
        request.setAttribute("listAllGroupsDTO", (Object)listAllGroupsDTO);
    }

    public static List buildGroupBasedSessionData(HttpServletRequest request, McContent mcContent, IMcService mcService) {
        logger.debug((Object)("buildGroupBasedSessionData" + mcContent));
        logger.debug((Object)("will be building groups question data  for content:..." + mcContent));
        List listQuestions = mcService.getAllQuestionEntries(mcContent.getUid());
        logger.debug((Object)("listQuestions:..." + listQuestions));
        LinkedList<McAllGroupsDTO> listAllGroupsContainerDTO = new LinkedList<McAllGroupsDTO>();
        for (McSession mcSession : mcContent.getMcSessions()) {
            logger.debug((Object)("iteration for group based session data: " + mcSession));
            String currentSessionId = mcSession.getMcSessionId().toString();
            logger.debug((Object)("currentSessionId: " + currentSessionId));
            String currentSessionName = mcSession.getSession_name();
            logger.debug((Object)("currentSessionName: " + currentSessionName));
            McAllGroupsDTO mcAllGroupsDTO = new McAllGroupsDTO();
            LinkedList<McMonitoredAnswersDTO> listMonitoredAnswersContainerDTO = new LinkedList<McMonitoredAnswersDTO>();
            if (mcSession != null) {
                for (McQueContent mcQueContent : listQuestions) {
                    logger.debug((Object)("mcQueContent:..." + mcQueContent));
                    if (mcQueContent == null) continue;
                    logger.debug((Object)("populating McMonitoredAnswersDTO for : " + mcQueContent));
                    McMonitoredAnswersDTO mcMonitoredAnswersDTO = new McMonitoredAnswersDTO();
                    mcMonitoredAnswersDTO.setQuestionUid(mcQueContent.getUid().toString());
                    mcMonitoredAnswersDTO.setQuestion(mcQueContent.getQuestion());
                    mcMonitoredAnswersDTO.setSessionId(currentSessionId);
                    mcMonitoredAnswersDTO.setSessionName(currentSessionName);
                    TreeMap questionAttemptData = new TreeMap();
                    logger.debug((Object)("generated  questionAttemptData: " + questionAttemptData));
                    mcMonitoredAnswersDTO.setQuestionAttempts(questionAttemptData);
                    logger.debug((Object)("adding mcMonitoredAnswersDTO to the listMonitoredAnswersContainerDTO: " + mcMonitoredAnswersDTO));
                    listMonitoredAnswersContainerDTO.add(mcMonitoredAnswersDTO);
                }
            }
            logger.debug((Object)("listMonitoredAnswersContainerDTO:" + listMonitoredAnswersContainerDTO));
            logger.debug((Object)("adding listMonitoredAnswersContainerDTO to the mcAllGroupsDTO:" + listMonitoredAnswersContainerDTO));
            mcAllGroupsDTO.setGroupData(listMonitoredAnswersContainerDTO);
            mcAllGroupsDTO.setSessionName(currentSessionName);
            mcAllGroupsDTO.setSessionId(currentSessionId);
            logger.debug((Object)("built mcAllGroupsDTO:" + mcAllGroupsDTO));
            listAllGroupsContainerDTO.add(mcAllGroupsDTO);
        }
        logger.debug((Object)("final listAllGroupsContainerDTO:..." + listAllGroupsContainerDTO));
        return listAllGroupsContainerDTO;
    }

    protected static void setupAllSessionsData(HttpServletRequest request, McContent mcContent, IMcService mcService) {
        logger.debug((Object)("starting setupAllSessionsData, mcContent: " + mcContent));
        logger.debug((Object)("CURRENT_MONITORED_TOOL_SESSION: " + request.getAttribute("currentMonitoredToolSession")));
        List listMonitoredAnswersContainerDTO = MonitoringUtil.buildGroupsQuestionData(request, mcContent, mcService);
        request.setAttribute("listMonitoredAnswersContainerDto", (Object)listMonitoredAnswersContainerDTO);
        logger.debug((Object)("LIST_MONITORED_ANSWERS_CONTAINER_DTO: " + request.getAttribute("listMonitoredAnswersContainerDto")));
        List listMonitoredMarksContainerDTO = MonitoringUtil.buildGroupsMarkData(request, mcContent, mcService);
        request.setAttribute("listMonitoredMarksContainerDto", (Object)listMonitoredMarksContainerDTO);
        logger.debug((Object)("LIST_MONITORED_MARKS_CONTAINER_DTO: " + request.getAttribute("listMonitoredMarksContainerDto")));
        logger.debug((Object)"ending setupAllSessionsData, mcContent: ");
        request.setAttribute("hrColumnCount", (Object)new Integer(mcContent.getMcQueContents().size() + 2).toString());
        String strPassMark = "";
        Integer passMark = mcContent.getPassMark();
        logger.debug((Object)("passMark: " + passMark));
        strPassMark = passMark == null ? " " : (passMark != null && passMark.equals("0") ? " " : passMark.toString());
        logger.debug((Object)("strPassMark: " + strPassMark));
        if (strPassMark.trim().equals("0")) {
            strPassMark = " ";
        }
        logger.debug((Object)("strPassMark: " + strPassMark));
        request.setAttribute("passMark", (Object)strPassMark);
    }
}

