/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardAttachment;

public class NoticeboardContent
implements Serializable {
    private Long uid;
    private Long nbContentId;
    private String title;
    private String content;
    private String onlineInstructions;
    private String offlineInstructions;
    private boolean defineLater;
    private boolean forceOffline;
    private Boolean reflectOnActivity;
    private String reflectInstructions;
    private boolean contentInUse;
    private Long creatorUserId;
    private Date dateCreated;
    private Date dateUpdated;
    private Set nbSessions = new HashSet();
    private Set nbAttachments = new HashSet();

    public NoticeboardContent() {
    }

    public NoticeboardContent(Long nbContentId, String title, String content, String onlineInstructions, String offlineInstructions, boolean defineLater, boolean forceOffline, boolean reflectOnActivity, String reflectInstructions, boolean contentInUse, Long creatorUserId, Date dateCreated, Date dateUpdated) {
        this.nbContentId = nbContentId;
        this.title = title;
        this.content = content;
        this.onlineInstructions = onlineInstructions;
        this.offlineInstructions = offlineInstructions;
        this.defineLater = defineLater;
        this.forceOffline = forceOffline;
        this.reflectOnActivity = reflectOnActivity;
        this.reflectInstructions = reflectInstructions;
        this.contentInUse = contentInUse;
        this.creatorUserId = creatorUserId;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
    }

    public NoticeboardContent(Long nbContentId, String title, String content, String onlineInstructions, String offlineInstructions, Date dateCreated) {
        this.nbContentId = nbContentId;
        this.title = title;
        this.content = content;
        this.onlineInstructions = onlineInstructions;
        this.offlineInstructions = offlineInstructions;
        this.defineLater = false;
        this.forceOffline = false;
        this.reflectOnActivity = false;
        this.contentInUse = false;
        this.creatorUserId = null;
        this.dateCreated = dateCreated;
        this.dateUpdated = null;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Long getCreatorUserId() {
        return this.creatorUserId;
    }

    public void setCreatorUserId(Long creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public boolean isForceOffline() {
        return this.forceOffline;
    }

    public void setForceOffline(boolean forceOffline) {
        this.forceOffline = forceOffline;
    }

    public boolean getReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public Long getNbContentId() {
        return this.nbContentId;
    }

    public void setNbContentId(Long nbContentId) {
        this.nbContentId = nbContentId;
    }

    public Set getNbSessions() {
        if (this.nbSessions == null) {
            this.setNbSessions(new HashSet());
        }
        return this.nbSessions;
    }

    public void setNbSessions(Set nbSessions) {
        this.nbSessions = nbSessions;
    }

    public Set getNbAttachments() {
        return this.nbAttachments;
    }

    public void setNbAttachments(Set nbAttachments) {
        this.nbAttachments = nbAttachments;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public static NoticeboardContent newInstance(NoticeboardContent nb, Long toContentId, IToolContentHandler toolContentHandler) throws ItemNotFoundException, RepositoryCheckedException {
        NoticeboardContent newContent = new NoticeboardContent(toContentId, nb.getTitle(), nb.getContent(), nb.getOnlineInstructions(), nb.getOfflineInstructions(), nb.isDefineLater(), nb.isForceOffline(), nb.getReflectOnActivity(), nb.getReflectInstructions(), nb.isContentInUse(), nb.getCreatorUserId(), nb.getDateCreated(), nb.getDateUpdated());
        if (nb.getNbAttachments() != null && nb.getNbAttachments().size() > 0) {
            HashSet<NoticeboardAttachment> newAttachmentSet = new HashSet<NoticeboardAttachment>();
            for (NoticeboardAttachment element : nb.getNbAttachments()) {
                NoticeboardAttachment newAttachment = new NoticeboardAttachment(newContent, element.getFilename(), element.isOnlineFile());
                newAttachment.setUuid(element.getUuid());
                newAttachment.setVersionId(element.getVersionId());
                newAttachmentSet.add(newAttachment);
            }
            newContent.setNbAttachments(newAttachmentSet);
        }
        return newContent;
    }
}

