/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;

public class NoticeboardSession
implements Serializable {
    public static final String NOT_ATTEMPTED = "NOT_ATTEMPTED";
    public static final String INCOMPLETE = "INCOMPLETE";
    public static final String COMPLETED = "COMPLETED";
    private Long uid;
    private Long nbSessionId;
    private String nbSessionName;
    private Date sessionStartDate;
    private Date sessionEndDate;
    private String sessionStatus;
    private NoticeboardContent nbContent;
    private Set nbUsers = new HashSet();

    public NoticeboardSession() {
    }

    public NoticeboardSession(Long nbSessionId, String nbSessionName, NoticeboardContent nbContent, Date sessionStartDate, Date sessionEndDate, String sessionStatus) {
        this.nbSessionId = nbSessionId;
        this.nbSessionName = nbSessionName;
        this.nbContent = nbContent;
        this.sessionStartDate = sessionStartDate;
        this.sessionEndDate = sessionEndDate;
        this.sessionStatus = sessionStatus;
    }

    public NoticeboardSession(Long nbSessionId, String nbSessionName, NoticeboardContent nbContent, Date sessionStartDate, String sessionStatus) {
        this.nbSessionId = nbSessionId;
        this.nbSessionName = nbSessionName;
        this.nbContent = nbContent;
        this.sessionStartDate = sessionStartDate;
        this.sessionEndDate = null;
        this.sessionStatus = sessionStatus;
    }

    public NoticeboardSession(Long nbSessionId, String nbSessionName, NoticeboardContent nbContent) {
        this.nbSessionId = nbSessionId;
        this.nbSessionName = nbSessionName;
        this.nbContent = nbContent;
        this.sessionStartDate = new Date(System.currentTimeMillis());
        this.sessionStatus = INCOMPLETE;
    }

    public NoticeboardSession(Long nbSessionId, String nbSessionName) {
        this.nbSessionId = nbSessionId;
        this.nbSessionName = nbSessionName;
        this.sessionStartDate = new Date(System.currentTimeMillis());
        this.sessionStatus = INCOMPLETE;
    }

    public NoticeboardSession(Long nbSessionId) {
        this.nbSessionId = nbSessionId;
        this.sessionStartDate = new Date(System.currentTimeMillis());
        this.sessionStatus = INCOMPLETE;
    }

    public NoticeboardContent getNbContent() {
        return this.nbContent;
    }

    public void setNbContent(NoticeboardContent nbContent) {
        this.nbContent = nbContent;
    }

    public Long getNbSessionId() {
        return this.nbSessionId;
    }

    public void setNbSessionId(Long nbSessionId) {
        this.nbSessionId = nbSessionId;
    }

    public String getNbSessionName() {
        return this.nbSessionName;
    }

    public void setNbSessionName(String nbSessionName) {
        this.nbSessionName = nbSessionName;
    }

    public Date getSessionEndDate() {
        return this.sessionEndDate;
    }

    public void setSessionEndDate(Date sessionEndDate) {
        this.sessionEndDate = sessionEndDate;
    }

    public Date getSessionStartDate() {
        return this.sessionStartDate;
    }

    public void setSessionStartDate(Date sessionStartDate) {
        this.sessionStartDate = sessionStartDate;
    }

    public String getSessionStatus() {
        return this.sessionStatus;
    }

    public void setSessionStatus(String sessionStatus) {
        this.sessionStatus = sessionStatus;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Set getNbUsers() {
        if (this.nbUsers == null) {
            this.setNbUsers(new HashSet());
        }
        return this.nbUsers;
    }

    public void setNbUsers(Set nbUsers) {
        this.nbUsers = nbUsers;
    }
}

