/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.dao.hibernate;

import java.util.Collection;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardSession;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardUser;
import org.lamsfoundation.lams.tool.noticeboard.dao.INoticeboardSessionDAO;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class NoticeboardSessionDAO
extends HibernateDaoSupport
implements INoticeboardSessionDAO {
    private static final String FIND_NB_SESSION = "from " + NoticeboardSession.class.getName() + " as nb where nb.nbSessionId=?";
    private static final String LOAD_NBSESSION_BY_USER = "select ns from NoticeboardSession ns left join fetch ns.nbUsers user where user.userId=:userId";
    private static final String GET_SESSIONS_FROM_CONTENT = "select ns.nbSessionId from NoticeboardSession ns where ns.nbContent= :nbContent";

    @Override
    public NoticeboardSession findNbSessionById(Long nbSessionId) {
        String query = "from NoticeboardSession nbS where nbS.nbSessionId=?";
        List session = this.getHibernateTemplate().find(query, (Object)nbSessionId);
        if (session != null && session.size() == 0) {
            return null;
        }
        return (NoticeboardSession)session.get(0);
    }

    @Override
    public void saveNbSession(NoticeboardSession nbSession) {
        this.getHibernateTemplate().save((Object)nbSession);
    }

    @Override
    public void updateNbSession(NoticeboardSession nbSession) {
        this.getHibernateTemplate().update((Object)nbSession);
    }

    @Override
    public void removeNbSession(Long nbSessionId) {
        List list;
        HibernateTemplate templ = this.getHibernateTemplate();
        if (nbSessionId != null && (list = this.getSession().createQuery(FIND_NB_SESSION).setLong(0, nbSessionId.longValue()).list()) != null && list.size() > 0) {
            NoticeboardSession nb = (NoticeboardSession)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            templ.delete((Object)nb);
            templ.flush();
        }
    }

    @Override
    public void removeNbSession(NoticeboardSession nbSession) {
        this.removeNbSession(nbSession.getNbSessionId());
    }

    @Override
    public NoticeboardSession getNbSessionByUser(final Long userId) {
        return (NoticeboardSession)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(NoticeboardSessionDAO.LOAD_NBSESSION_BY_USER).setLong("userId", userId.longValue()).uniqueResult();
            }
        });
    }

    @Override
    public void removeNbUsers(NoticeboardSession nbSession) {
        this.getHibernateTemplate().deleteAll((Collection)nbSession.getNbUsers());
    }

    @Override
    public void addNbUsers(Long nbSessionId, NoticeboardUser user) {
        NoticeboardSession session = this.findNbSessionById(nbSessionId);
        user.setNbSession(session);
        session.getNbUsers().add(user);
        this.getHibernateTemplate().saveOrUpdate((Object)user);
        this.getHibernateTemplate().merge((Object)session);
    }

    @Override
    public List getSessionsFromContent(NoticeboardContent nbContent) {
        return this.getHibernateTemplate().findByNamedParam(GET_SESSIONS_FROM_CONTENT, "nbContent", (Object)nbContent);
    }
}

