/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.dao.hibernate;

import java.util.List;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardSession;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardUser;
import org.lamsfoundation.lams.tool.noticeboard.dao.INoticeboardUserDAO;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class NoticeboardUserDAO
extends HibernateDaoSupport
implements INoticeboardUserDAO {
    private static final String FIND_NB_USER = "from " + NoticeboardUser.class.getName() + " as nb where nb.userId=?";
    private static final String FIND_NB_USER_BY_SESSION = "from " + NoticeboardUser.class.getName() + " as nb where nb.userId=? and nb.nbSession.nbSessionId=?";
    private static final String COUNT_USERS_IN_SESSION = "select nu.userId from NoticeboardUser nu where nu.nbSession= :nbSession";

    @Override
    public NoticeboardUser getNbUser(Long userId, Long sessionId) {
        String query = "from NoticeboardUser user where user.userId=? and user.nbSession.nbSessionId=?";
        Object[] values = new Object[]{userId, sessionId};
        List users = this.getHibernateTemplate().find(query, values);
        if (users != null && users.size() == 0) {
            return null;
        }
        return (NoticeboardUser)users.get(0);
    }

    @Override
    public NoticeboardUser getNbUserBySession(Long userId, Long sessionId) {
        List usersReturned = this.getSession().createQuery(FIND_NB_USER_BY_SESSION).setLong(0, userId.longValue()).setLong(1, sessionId.longValue()).list();
        if (usersReturned != null && usersReturned.size() > 0) {
            NoticeboardUser nb = (NoticeboardUser)usersReturned.get(0);
            return nb;
        }
        return null;
    }

    @Override
    public void saveNbUser(NoticeboardUser nbUser) {
        this.getHibernateTemplate().save((Object)nbUser);
    }

    @Override
    public void updateNbUser(NoticeboardUser nbUser) {
        this.getHibernateTemplate().update((Object)nbUser);
    }

    @Override
    public void removeNbUser(Long userId) {
        List list;
        if (userId != null && (list = this.getSession().createQuery(FIND_NB_USER).setLong(0, userId.longValue()).list()) != null && list.size() > 0) {
            NoticeboardUser nb = (NoticeboardUser)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            this.getHibernateTemplate().delete((Object)nb);
            this.getHibernateTemplate().flush();
        }
    }

    @Override
    public void removeNbUser(NoticeboardUser nbUser) {
        this.removeNbUser(nbUser.getUserId());
    }

    @Override
    public int getNumberOfUsers(NoticeboardSession nbSession) {
        return this.getHibernateTemplate().findByNamedParam(COUNT_USERS_IN_SESSION, "nbSession", (Object)nbSession).size();
    }

    @Override
    public List getNbUsersBySession(Long sessionId) {
        String query = "from NoticeboardUser user where user.nbSession.nbSessionId=?";
        return this.getHibernateTemplate().find(query, (Object)sessionId);
    }
}

