/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.service;

import java.io.InputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.noticeboard.NbApplicationException;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardAttachment;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardSession;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardUser;
import org.lamsfoundation.lams.tool.noticeboard.dao.INoticeboardAttachmentDAO;
import org.lamsfoundation.lams.tool.noticeboard.dao.INoticeboardContentDAO;
import org.lamsfoundation.lams.tool.noticeboard.dao.INoticeboardSessionDAO;
import org.lamsfoundation.lams.tool.noticeboard.dao.INoticeboardUserDAO;
import org.lamsfoundation.lams.tool.noticeboard.service.INoticeboardService;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.dao.DataAccessException;

public class NoticeboardServicePOJO
implements INoticeboardService,
ToolContentManager,
ToolSessionManager,
ToolContentImport102Manager {
    private NoticeboardContent nbContent;
    private INoticeboardContentDAO nbContentDAO = null;
    private NoticeboardSession nbSession;
    private INoticeboardSessionDAO nbSessionDAO = null;
    private ILearnerService learnerService;
    private ILamsToolService toolService;
    private NoticeboardUser nbUser;
    private INoticeboardUserDAO nbUserDAO = null;
    private INoticeboardAttachmentDAO nbAttachmentDAO = null;
    private IToolContentHandler nbToolContentHandler = null;
    private IExportToolContentService exportContentService;
    private static Logger log = Logger.getLogger(NoticeboardServicePOJO.class);
    private ICoreNotebookService coreNotebookService;

    @Override
    public NoticeboardContent retrieveNoticeboard(Long nbContentId) throws NbApplicationException {
        if (nbContentId == null) {
            String error = "Unable to continue. The tool content id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            this.nbContent = this.nbContentDAO.findNbContentById(nbContentId);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("An exception has occured when trying to retrieve noticeboard content: " + e.getMessage(), e);
        }
        return this.nbContent;
    }

    @Override
    public NoticeboardContent retrieveNoticeboardBySessionID(Long nbSessionId) {
        if (nbSessionId == null) {
            String error = "Unable to continue. The tool session id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            this.nbContent = this.nbContentDAO.getNbContentBySession(nbSessionId);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("An exception has occured when trying to retrieve noticeboard content: " + e.getMessage(), e);
        }
        return this.nbContent;
    }

    @Override
    public void saveNoticeboard(NoticeboardContent nbContent) {
        try {
            if (nbContent.getUid() == null) {
                this.nbContentDAO.saveNbContent(nbContent);
            } else {
                this.nbContentDAO.updateNbContent(nbContent);
            }
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to save the noticeboard content object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeNoticeboardSessionsFromContent(NoticeboardContent nbContent) {
        try {
            nbContent.getNbSessions().clear();
            this.nbContentDAO.removeNbSessions(nbContent);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to remove the sessions associated with this noticeboard content object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeNoticeboard(Long nbContentId) {
        if (nbContentId == null) {
            String error = "Unable to continue. The tool content id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            this.nbContentDAO.removeNoticeboard(nbContentId);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to remove this noticeboard content object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeNoticeboard(NoticeboardContent nbContent) {
        try {
            this.nbContentDAO.removeNoticeboard(nbContent);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to remove this noticeboard content object: " + e.getMessage(), e);
        }
    }

    @Override
    public NoticeboardSession retrieveNoticeboardSession(Long nbSessionId) {
        if (nbSessionId == null) {
            String error = "Unable to continue. The tool session id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            this.nbSession = this.nbSessionDAO.findNbSessionById(nbSessionId);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("An exception has occured when trying to retrieve noticeboard session object: " + e.getMessage(), e);
        }
        return this.nbSession;
    }

    @Override
    public void saveNoticeboardSession(NoticeboardSession nbSession) {
        try {
            NoticeboardContent content = nbSession.getNbContent();
            this.nbSessionDAO.saveNbSession(nbSession);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to save this noticeboard session: " + e.getMessage(), e);
        }
    }

    @Override
    public void updateNoticeboardSession(NoticeboardSession nbSession) {
        try {
            this.nbSessionDAO.updateNbSession(nbSession);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to update this noticeboard session: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeSession(Long nbSessionId) {
        if (nbSessionId == null) {
            String error = "Unable to continue. The tool session id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            NoticeboardSession sessionToDelete = this.retrieveNoticeboardSession(nbSessionId);
            NoticeboardContent contentReferredBySession = sessionToDelete.getNbContent();
            contentReferredBySession.getNbSessions().remove(sessionToDelete);
            this.nbSessionDAO.removeNbSession(nbSessionId);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to remove this noticeboard session object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeSession(NoticeboardSession nbSession) {
        try {
            NoticeboardContent contentReferredBySession = nbSession.getNbContent();
            contentReferredBySession.getNbSessions().remove(nbSession);
            this.nbSessionDAO.removeNbSession(nbSession);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to remove this noticeboard session object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeNoticeboardUsersFromSession(NoticeboardSession nbSession) {
        try {
            nbSession.getNbUsers().clear();
            this.nbSessionDAO.removeNbUsers(nbSession);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to remove the users associated with this noticeboard session instance: " + e.getMessage(), e);
        }
    }

    @Override
    public NoticeboardSession retrieveNbSessionByUserID(Long userId) {
        if (userId == null) {
            String error = "Unable to continue. The tool session id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            this.nbSession = this.nbSessionDAO.getNbSessionByUser(userId);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to retrieve noticeboard session instance " + e.getMessage(), e);
        }
        return this.nbSession;
    }

    @Override
    public List getSessionIdsFromContent(NoticeboardContent content) {
        List list = null;
        try {
            list = this.nbSessionDAO.getSessionsFromContent(content);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to the list of session ids from content " + e.getMessage(), e);
        }
        return list;
    }

    @Override
    public NoticeboardUser retrieveNoticeboardUser(Long nbUserId, Long nbSessionId) {
        if (nbUserId == null) {
            String error = "Unable to continue. The user id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            this.nbUser = this.nbUserDAO.getNbUser(nbUserId, nbSessionId);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("An exception has occured when trying to retrieve noticeboard user: " + e.getMessage(), e);
        }
        return this.nbUser;
    }

    @Override
    public void saveNoticeboardUser(NoticeboardUser nbUser) {
        try {
            NoticeboardSession session = nbUser.getNbSession();
            session.getNbUsers().add(nbUser);
            this.nbUserDAO.saveNbUser(nbUser);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to save the noticeboard user object: " + e.getMessage(), e);
        }
    }

    @Override
    public NoticeboardUser retrieveNbUserBySession(Long userId, Long sessionId) {
        try {
            this.nbUser = this.nbUserDAO.getNbUserBySession(userId, sessionId);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to retrive the noticeboard user object: " + e.getMessage(), e);
        }
        return this.nbUser;
    }

    @Override
    public void updateNoticeboardUser(NoticeboardUser nbUser) {
        try {
            this.nbUserDAO.updateNbUser(nbUser);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to update the noticeboard user object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeUser(NoticeboardUser nbUser) {
        try {
            NoticeboardSession session = nbUser.getNbSession();
            session.getNbUsers().remove(nbUser);
            this.nbUserDAO.removeNbUser(nbUser);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to remove the noticeboard user object: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeUser(Long nbUserId, Long toolSessionId) {
        if (nbUserId == null) {
            String error = "Unable to continue. The user id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            NoticeboardUser user = this.retrieveNoticeboardUser(nbUserId, toolSessionId);
            NoticeboardSession session = user.getNbSession();
            session.getNbUsers().remove(user);
            this.nbUserDAO.removeNbUser(nbUserId);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to remove the noticeboard user object: " + e.getMessage(), e);
        }
    }

    @Override
    public void addSession(Long nbContentId, NoticeboardSession session) {
        if (nbContentId == null || session == null) {
            String error = "Unable to continue. The tool content id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            this.nbContentDAO.addNbSession(nbContentId, session);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to create session: " + e.getMessage(), e);
        }
    }

    @Override
    public void addUser(Long nbSessionId, NoticeboardUser user) {
        if (nbSessionId == null) {
            String error = "Unable to continue. The tool session id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            this.nbSessionDAO.addNbUsers(nbSessionId, user);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to create user: " + e.getMessage(), e);
        }
    }

    @Override
    public int getNumberOfUsersInSession(NoticeboardSession session) {
        int numberOfUsers;
        try {
            numberOfUsers = this.nbUserDAO.getNumberOfUsers(session);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to get the number of users in the session: " + e.getMessage(), e);
        }
        return numberOfUsers;
    }

    @Override
    public int calculateTotalNumberOfUsers(Long toolContentId) {
        if (toolContentId == null) {
            String error = "Unable to continue. The tool content id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        int totalNumberOfUsers = 0;
        try {
            this.nbContent = this.retrieveNoticeboard(toolContentId);
            List listOfSessionIds = this.getSessionIdsFromContent(this.nbContent);
            for (Long sessionId : listOfSessionIds) {
                int usersInThisSession = this.getNumberOfUsersInSession(this.retrieveNoticeboardSession(sessionId));
                totalNumberOfUsers += usersInThisSession;
            }
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while calculating the total number of users in tool activity " + e.getMessage(), e);
        }
        return totalNumberOfUsers;
    }

    @Override
    public List getUsersBySession(Long sessionId) {
        if (sessionId != null) {
            try {
                return this.nbUserDAO.getNbUsersBySession(sessionId);
            }
            catch (DataAccessException e) {
                throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to get the list of users in the session: " + e.getMessage(), e);
            }
        }
        log.error((Object)"Unable to continue. Session id is missing");
        return null;
    }

    @Override
    public NoticeboardAttachment retrieveAttachment(Long attachmentId) {
        if (attachmentId == null) {
            String error = "Unable to continue. The attachment id is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            return this.nbAttachmentDAO.retrieveAttachment(attachmentId);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to retrieve the attachment " + e.getMessage(), e);
        }
    }

    @Override
    public NoticeboardAttachment retrieveAttachmentByUuid(Long uuid) {
        if (uuid == null) {
            String error = "Unable to continue. The uuid is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            return this.nbAttachmentDAO.retrieveAttachmentByUuid(uuid);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to retrieve the attachment " + e.getMessage(), e);
        }
    }

    @Override
    public NoticeboardAttachment retrieveAttachmentByFilename(String filename) {
        if (filename == null || filename.trim().length() == 0) {
            String error = "Unable to continue. The filename is missing";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        try {
            return this.nbAttachmentDAO.retrieveAttachmentByFilename(filename);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to retrieve the attachment with filename " + filename + " " + e.getMessage(), e);
        }
    }

    @Override
    public List getAttachmentIdsFromContent(NoticeboardContent nbContent) {
        try {
            return this.nbAttachmentDAO.getAttachmentIdsFromContent(nbContent);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to retrieve the list of attachment ids " + e.getMessage(), e);
        }
    }

    @Override
    public void saveAttachment(NoticeboardContent content, NoticeboardAttachment attachment) {
        try {
            content.getNbAttachments().add(attachment);
            attachment.setNbContent(content);
            this.saveNoticeboard(content);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to save the attachment " + e.getMessage(), e);
        }
    }

    @Override
    public void removeAttachment(NoticeboardContent content, NoticeboardAttachment attachment) throws RepositoryCheckedException {
        try {
            attachment.setNbContent(null);
            content.getNbAttachments().remove(attachment);
            this.saveNoticeboard(content);
        }
        catch (DataAccessException e) {
            throw new NbApplicationException("EXCEPTION: An exception has occurred while trying to remove this attachment" + e.getMessage(), e);
        }
    }

    @Override
    public NodeKey uploadFile(InputStream istream, String filename, String contentType, String fileType) throws RepositoryCheckedException {
        return this.nbToolContentHandler.uploadFile(istream, filename, contentType, fileType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (toContentId == null) {
            throw new ToolException("Failed to copy Noticeboard tool content. Missing parameter: toContentId");
        }
        if (fromContentId == null) {
            fromContentId = this.getToolDefaultContentIdBySignature("lanb11");
        }
        NoticeboardContent originalNb = null;
        try {
            originalNb = this.retrieveNoticeboard(fromContentId);
            if (originalNb == null) {
                NoticeboardContent defaultContent = this.retrieveNoticeboard(this.getToolDefaultContentIdBySignature("lanb11"));
                if (defaultContent == null) throw new ToolException("Default content is missing. Unable to copy tool content");
                NoticeboardContent newContent = NoticeboardContent.newInstance(defaultContent, toContentId, this.nbToolContentHandler);
                this.saveNoticeboard(newContent);
                return;
            } else {
                NoticeboardContent newNbContent = NoticeboardContent.newInstance(originalNb, toContentId, this.nbToolContentHandler);
                this.saveNoticeboard(newNbContent);
            }
            return;
        }
        catch (RepositoryCheckedException e) {
            log.error((Object)("Unable to copy the tool content due to a content repository error. fromContentId " + fromContentId + " toContentId " + toContentId));
            throw new ToolException((Throwable)e);
        }
    }

    public void setAsDefineLater(Long toolContentId) throws DataMissingException, ToolException {
        NoticeboardContent nbContent = this.getAndCheckIDandObject(toolContentId);
        nbContent.setDefineLater(true);
        this.saveNoticeboard(nbContent);
    }

    public void setAsRunOffline(Long toolContentId) throws DataMissingException, ToolException {
        NoticeboardContent nbContent = this.getAndCheckIDandObject(toolContentId);
        nbContent.setForceOffline(true);
        this.saveNoticeboard(nbContent);
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
        NoticeboardContent nbContent = this.getAndCheckIDandObject(toolContentId);
        if (!nbContent.getNbSessions().isEmpty() && !removeSessionData) {
            throw new SessionDataExistsException("Delete failed: There is session data that belongs to this tool content id");
        }
        Set attachments = nbContent.getNbAttachments();
        Iterator i = attachments.iterator();
        while (i.hasNext()) {
            try {
                this.removeAttachment(nbContent, (NoticeboardAttachment)i.next());
            }
            catch (RepositoryCheckedException e) {}
        }
        this.removeNoticeboard(toolContentId);
    }

    private NoticeboardContent getAndCheckIDandObject(Long toolContentId) throws ToolException, DataMissingException {
        if (toolContentId == null) {
            throw new ToolException("Tool content ID is missing. Unable to continue");
        }
        NoticeboardContent nbContent = this.retrieveNoticeboard(toolContentId);
        if (nbContent == null) {
            throw new DataMissingException("No tool content matches this tool content id");
        }
        return nbContent;
    }

    private NoticeboardSession getAndCheckSessionIDandObject(Long toolSessionId) throws ToolException, DataMissingException {
        if (toolSessionId == null) {
            throw new ToolException("Tool session ID is missing. Unable to continue");
        }
        NoticeboardSession nbSession = this.retrieveNoticeboardSession(toolSessionId);
        if (nbSession == null) {
            throw new DataMissingException("No tool session matches this tool session id");
        }
        return nbSession;
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        NoticeboardContent toolContentObj = this.nbContentDAO.findNbContentById(toolContentId);
        if (toolContentObj == null) {
            Long defaultContentId = this.getToolDefaultContentIdBySignature("lanb11");
            toolContentObj = this.retrieveNoticeboard(defaultContentId);
        }
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to find default content for the noticeboard tool");
        }
        try {
            toolContentObj = NoticeboardContent.newInstance(toolContentObj, toolContentId, null);
            toolContentObj.setNbSessions(null);
            this.exportContentService.registerFileClassForExport(NoticeboardAttachment.class.getName(), "uuid", "versionId");
            this.exportContentService.exportToolContent(toolContentId, (Object)toolContentObj, this.nbToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new ToolException((Throwable)e);
        }
        catch (RepositoryCheckedException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(NoticeboardAttachment.class.getName(), "uuid", "versionId", "filename", "fileProperty", null, null);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, this.nbToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof NoticeboardContent)) {
                throw new ImportToolContentException("Import Noteice board tool content failed. Deserialized object is " + toolPOJO);
            }
            NoticeboardContent toolContentObj = (NoticeboardContent)toolPOJO;
            toolContentObj.setNbContentId(toolContentId);
            this.nbContentDAO.saveNbContent(toolContentObj);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        if (toolSessionId == null || toolContentId == null) {
            String error = "Failed to create tool session. The tool session id or tool content id is invalid";
            throw new ToolException(error);
        }
        this.nbContent = this.retrieveNoticeboard(toolContentId);
        if (this.nbContent == null) {
            NoticeboardContent defaultContent = this.retrieveNoticeboard(this.getToolDefaultContentIdBySignature("lanb11"));
            if (defaultContent == null) throw new ToolException("Default content is missing. Unable to create tool session");
            NoticeboardSession newSession = new NoticeboardSession(toolSessionId, toolSessionName, defaultContent, new Date(System.currentTimeMillis()), "NOT_ATTEMPTED");
            defaultContent.getNbSessions().add(newSession);
            this.saveNoticeboard(defaultContent);
            return;
        } else {
            NoticeboardSession nbSession = new NoticeboardSession(toolSessionId, toolSessionName, this.nbContent, new Date(System.currentTimeMillis()), "NOT_ATTEMPTED");
            this.nbContent.getNbSessions().add(nbSession);
            this.saveNoticeboard(this.nbContent);
        }
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        this.getAndCheckSessionIDandObject(toolSessionId);
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws ToolException, DataMissingException {
        this.getAndCheckSessionIDandObject(toolSessionId);
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws ToolException, DataMissingException {
        Iterator i = toolSessionIds.iterator();
        if (i.hasNext()) {
            Long id = (Long)i.next();
            this.getAndCheckSessionIDandObject(id);
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        NoticeboardSession session = this.getAndCheckSessionIDandObject(toolSessionId);
        this.removeSession(session);
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        NoticeboardContent toolContentObj = new NoticeboardContent();
        String content = WebUtil.convertNewlines((String)((String)importValues.get("body")));
        toolContentObj.setContent(content);
        toolContentObj.setContentInUse(false);
        toolContentObj.setCreatorUserId(user.getUserID().longValue());
        toolContentObj.setDateCreated(now);
        toolContentObj.setDateUpdated(now);
        toolContentObj.setDefineLater(false);
        toolContentObj.setForceOffline(false);
        toolContentObj.setNbContentId(toolContentId);
        toolContentObj.setOfflineInstructions(null);
        toolContentObj.setOnlineInstructions(null);
        toolContentObj.setTitle((String)importValues.get("title"));
        toolContentObj.setReflectOnActivity(false);
        this.nbContentDAO.saveNbContent(toolContentObj);
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        NoticeboardContent toolContentObj = this.retrieveNoticeboard(toolContentId);
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        toolContentObj.setReflectOnActivity(Boolean.TRUE);
        toolContentObj.setReflectInstructions(description);
    }

    @Override
    public Long getToolDefaultContentIdBySignature(String toolSignature) {
        Long contentId = null;
        contentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (contentId == null) {
            String error = "Could not retrieve default content id for this tool";
            log.error((Object)error);
            throw new NbApplicationException(error);
        }
        return contentId;
    }

    public void setNbContentDAO(INoticeboardContentDAO nbContentDAO) {
        this.nbContentDAO = nbContentDAO;
    }

    public void setNbSessionDAO(INoticeboardSessionDAO nbSessionDAO) {
        this.nbSessionDAO = nbSessionDAO;
    }

    public void setNbUserDAO(INoticeboardUserDAO nbUserDAO) {
        this.nbUserDAO = nbUserDAO;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public void setNbAttachmentDAO(INoticeboardAttachmentDAO nbAttachmentDAO) {
        this.nbAttachmentDAO = nbAttachmentDAO;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public IToolContentHandler getNbToolContentHandler() {
        return this.nbToolContentHandler;
    }

    public void setNbToolContentHandler(IToolContentHandler nbToolContentHandler) {
        this.nbToolContentHandler = nbToolContentHandler;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    @Override
    public Long createNotebookEntry(Long id, Integer idType, String signature, Integer userID, String entry) {
        return this.coreNotebookService.createNotebookEntry(id, idType, signature, userID, "", entry);
    }

    @Override
    public NotebookEntry getEntry(Long id, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(id, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }
}

