/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.util;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.lamsfoundation.lams.tool.noticeboard.NbApplicationException;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardAttachment;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;
import org.lamsfoundation.lams.tool.noticeboard.service.INoticeboardService;
import org.lamsfoundation.lams.web.util.SessionMap;

public class NbWebUtil {
    private NbWebUtil() {
    }

    public static Long convertToLong(String id) {
        try {
            return new Long(id);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isContentEditable(NoticeboardContent content) throws NbApplicationException {
        if (content.isDefineLater() && content.isContentInUse()) {
            throw new NbApplicationException("An exception has occurred: There is a bug in this tool, conflicting flags are set");
        }
        if (content.isDefineLater() && !content.isContentInUse()) {
            return true;
        }
        return !content.isDefineLater() && !content.isContentInUse();
    }

    public static SessionMap addUploadsToSession(SessionMap sessionMap, HttpServletRequest request, List attachmentList, List deletedAttachmentList) {
        SessionMap map = sessionMap != null ? sessionMap : new SessionMap();
        map.put((Object)"attachmentList", (Object)(attachmentList != null ? attachmentList : new ArrayList()));
        map.put((Object)"deletedAttachmentList", (Object)(deletedAttachmentList != null ? deletedAttachmentList : new ArrayList()));
        request.getSession().setAttribute(map.getSessionID(), (Object)map);
        return map;
    }

    public static List setupAttachmentList(INoticeboardService nbService, NoticeboardContent nb) {
        ArrayList<NoticeboardAttachment> attachmentList = new ArrayList<NoticeboardAttachment>();
        if (nbService != null && nb != null) {
            List attachmentIdList = nbService.getAttachmentIdsFromContent(nb);
            for (int i = 0; i < attachmentIdList.size(); ++i) {
                NoticeboardAttachment file = nbService.retrieveAttachment((Long)attachmentIdList.get(i));
                attachmentList.add(file);
            }
        }
        return attachmentList;
    }

    public static List setupDeletedAttachmentList() {
        return new ArrayList();
    }
}

