/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.noticeboard.NbApplicationException;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardUser;
import org.lamsfoundation.lams.tool.noticeboard.service.INoticeboardService;
import org.lamsfoundation.lams.tool.noticeboard.service.NoticeboardServiceProxy;
import org.lamsfoundation.lams.tool.noticeboard.util.NbWebUtil;
import org.lamsfoundation.lams.tool.noticeboard.web.NbLearnerForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class NbLearnerStarterAction
extends LamsDispatchAction {
    static Logger logger = Logger.getLogger((String)NbLearnerStarterAction.class.getName());

    private UserDTO getUserDTO(HttpServletRequest request) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (user == null) {
            MessageResources resources = this.getResources(request);
            String error = resources.getMessage("error.missingParam", (Object)"User");
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        return user;
    }

    public Long getUserID(HttpServletRequest request) {
        UserDTO user = this.getUserDTO(request);
        return new Long(user.getUserID().longValue());
    }

    public Long getUserIDFromURLCall(HttpServletRequest request) {
        return WebUtil.readLongParam((HttpServletRequest)request, (String)"userID", (boolean)false);
    }

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.learner(mapping, form, request, response);
    }

    public ActionForward learner(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws NbApplicationException {
        NoticeboardContent nbContent = null;
        NoticeboardUser nbUser = null;
        this.saveMessages(request, null);
        NbLearnerForm learnerForm = (NbLearnerForm)form;
        ActionMessages message = new ActionMessages();
        INoticeboardService nbService = NoticeboardServiceProxy.getNbService(this.getServlet().getServletContext());
        Long toolSessionID = NbWebUtil.convertToLong(learnerForm.getToolSessionID());
        if (toolSessionID == null) {
            String error = "Unable to continue. The parameters tool session id is missing";
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        nbContent = nbService.retrieveNoticeboardBySessionID(toolSessionID);
        if (nbContent == null) {
            String error = "An Internal error has occurred. Please exit and retry this sequence";
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        if (this.isFlagSet(nbContent, 1)) {
            return mapping.findForward("defineLater");
        }
        boolean readOnly = false;
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)false);
        Long userID = null;
        if (mode == ToolAccessMode.LEARNER || mode == ToolAccessMode.AUTHOR) {
            userID = this.getUserID(request);
            nbUser = nbService.retrieveNbUserBySession(userID, toolSessionID);
            if (!nbContent.isContentInUse()) {
                nbContent.setContentInUse(true);
                nbService.saveNoticeboard(nbContent);
            }
            if (nbUser == null) {
                nbUser = new NoticeboardUser(userID);
                UserDTO user = this.getUserDTO(request);
                nbUser.setUsername(user.getLogin());
                nbUser.setFullname(user.getFirstName() + " " + user.getLastName());
                nbService.addUser(toolSessionID, nbUser);
            }
        } else {
            userID = this.getUserIDFromURLCall(request);
            nbUser = nbService.retrieveNbUserBySession(userID, toolSessionID);
            readOnly = true;
        }
        learnerForm.copyValuesIntoForm(nbContent, readOnly, mode.toString());
        NotebookEntry notebookEntry = nbService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lanb11", userID.intValue());
        if (notebookEntry != null) {
            request.setAttribute("reflectEntry", (Object)notebookEntry.getEntry());
        }
        request.setAttribute("reflectInstructions", (Object)nbContent.getReflectInstructions());
        request.setAttribute("reflectOnActivity", (Object)nbContent.getReflectOnActivity());
        Boolean userFinished = nbUser != null && "COMPLETED".equals(nbUser.getUserStatus());
        request.setAttribute("userFinished", (Object)userFinished);
        if (this.displayMessageToUser(nbContent, message)) {
            this.saveMessages(request, message);
            return mapping.findForward("displayMessage");
        }
        return mapping.findForward("displayLearnerContent");
    }

    public ActionForward teacher(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws NbApplicationException {
        return this.learner(mapping, form, request, response);
    }

    public ActionForward author(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws NbApplicationException {
        return this.learner(mapping, form, request, response);
    }

    private boolean isFlagSet(NoticeboardContent content, int flag) throws NbApplicationException {
        switch (flag) {
            case 1: {
                return content.isDefineLater();
            }
            case 2: {
                return content.isContentInUse();
            }
            case 3: {
                return content.isForceOffline();
            }
        }
        throw new NbApplicationException("Invalid flag");
    }

    private boolean displayMessageToUser(NoticeboardContent content, ActionMessages message) {
        boolean isDefineLaterSet = this.isFlagSet(content, 1);
        boolean isRunOfflineSet = this.isFlagSet(content, 3);
        if (isDefineLaterSet || isRunOfflineSet) {
            if (isDefineLaterSet) {
                message.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("message.defineLaterSet"));
            }
            if (isRunOfflineSet) {
                message.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("message.runOfflineSet"));
            }
            return true;
        }
        return false;
    }
}

