/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.noticeboard.NbApplicationException;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardSession;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardUser;
import org.lamsfoundation.lams.tool.noticeboard.dto.ReflectionDTO;
import org.lamsfoundation.lams.tool.noticeboard.service.INoticeboardService;
import org.lamsfoundation.lams.tool.noticeboard.service.NoticeboardServiceProxy;
import org.lamsfoundation.lams.tool.noticeboard.util.NbWebUtil;
import org.lamsfoundation.lams.tool.noticeboard.web.NbMonitoringForm;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class NbMonitoringAction
extends LamsDispatchAction {
    static Logger logger = Logger.getLogger((String)NbMonitoringAction.class.getName());
    public static final String FORM = "NbMonitoringForm";
    public static final String SUMMARY_TABID = "1";
    public static final String INSTRUCTIONS_TABID = "2";
    public static final String EDITACTIVITY_TABID = "3";
    public static final String STATISTICS_TABID = "4";

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws NbApplicationException {
        Long toolContentId = NbWebUtil.convertToLong(request.getParameter("toolContentID"));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        if (toolContentId == null) {
            String error = "Unable to continue. Tool content id missing";
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        NbMonitoringForm monitorForm = new NbMonitoringForm();
        INoticeboardService nbService = NoticeboardServiceProxy.getNbService(this.getServlet().getServletContext());
        NoticeboardContent content = nbService.retrieveNoticeboard(toolContentId);
        monitorForm.setTitle(content.getTitle());
        monitorForm.setContent(content.getContent());
        monitorForm.setOnlineInstructions(content.getOnlineInstructions());
        monitorForm.setOfflineInstructions(content.getOfflineInstructions());
        monitorForm.setAttachmentsList(NbWebUtil.setupAttachmentList(nbService, content));
        if (NbWebUtil.isContentEditable(content)) {
            monitorForm.setContentEditable("true");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("toolContentID", toolContentId.toString());
            map.put("defineLater", "true");
            map.put("contentFolderID", contentFolderID);
            monitorForm.setParametersToAppend(map);
        } else {
            monitorForm.setContentEditable("false");
        }
        monitorForm.setTotalLearners(nbService.calculateTotalNumberOfUsers(toolContentId));
        Set sessions = content.getNbSessions();
        Iterator i = sessions.iterator();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<ReflectionDTO> reflections = new ArrayList<ReflectionDTO>();
        while (i.hasNext()) {
            NoticeboardSession session = (NoticeboardSession)i.next();
            int numUsersInSession = nbService.getNumberOfUsersInSession(session);
            map.put(session.getNbSessionName(), new Integer(numUsersInSession));
            if (!content.getReflectOnActivity()) continue;
            List sessionUsers = nbService.getUsersBySession(session.getNbSessionId());
            for (int j = 0; j < sessionUsers.size(); ++j) {
                NoticeboardUser nbUser = (NoticeboardUser)sessionUsers.get(j);
                NotebookEntry nbEntry = nbService.getEntry(session.getNbSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lanb11", nbUser.getUserId().intValue());
                if (nbEntry == null) continue;
                ReflectionDTO dto = new ReflectionDTO(nbEntry);
                dto.setExternalId(session.getNbSessionId());
                dto.setUserId(nbUser.getUserId());
                dto.setUsername(nbUser.getUsername());
                reflections.add(dto);
            }
        }
        monitorForm.setGroupStatsMap(map);
        request.setAttribute("reflectOnActivity", (Object)content.getReflectOnActivity());
        request.setAttribute("reflections", reflections);
        monitorForm.setCurrentTab(SUMMARY_TABID);
        request.setAttribute(FORM, (Object)monitorForm);
        return mapping.findForward("monitorPage");
    }

    public ActionForward viewReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws NbApplicationException {
        NoticeboardUser nbUser;
        Long userId = NbWebUtil.convertToLong(request.getParameter("userID"));
        Long toolSessionId = NbWebUtil.convertToLong(request.getParameter("toolSessionID"));
        INoticeboardService nbService = NoticeboardServiceProxy.getNbService(this.getServlet().getServletContext());
        NotebookEntry nbEntry = nbService.getEntry((nbUser = nbService.retrieveNoticeboardUser(userId, toolSessionId)).getNbSession().getNbSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lanb11", userId.intValue());
        if (nbEntry != null) {
            request.setAttribute("nbEntry", (Object)nbEntry.getEntry());
            request.setAttribute("name", (Object)nbUser.getFullname());
        }
        return mapping.findForward("monitorReflectionPage");
    }
}

