/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.rsrc.service;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.rsrc.dao.ResourceAttachmentDAO;
import org.lamsfoundation.lams.tool.rsrc.dao.ResourceDAO;
import org.lamsfoundation.lams.tool.rsrc.dao.ResourceItemDAO;
import org.lamsfoundation.lams.tool.rsrc.dao.ResourceItemVisitDAO;
import org.lamsfoundation.lams.tool.rsrc.dao.ResourceSessionDAO;
import org.lamsfoundation.lams.tool.rsrc.dao.ResourceUserDAO;
import org.lamsfoundation.lams.tool.rsrc.dto.ReflectDTO;
import org.lamsfoundation.lams.tool.rsrc.dto.Summary;
import org.lamsfoundation.lams.tool.rsrc.ims.IMSManifestException;
import org.lamsfoundation.lams.tool.rsrc.ims.ImscpApplicationException;
import org.lamsfoundation.lams.tool.rsrc.ims.SimpleContentPackageConverter;
import org.lamsfoundation.lams.tool.rsrc.model.Resource;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceAttachment;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceItem;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceItemInstruction;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceItemVisitLog;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceSession;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceUser;
import org.lamsfoundation.lams.tool.rsrc.service.IResourceService;
import org.lamsfoundation.lams.tool.rsrc.service.ResourceApplicationException;
import org.lamsfoundation.lams.tool.rsrc.service.UploadResourceFileException;
import org.lamsfoundation.lams.tool.rsrc.util.ResourceToolContentHandler;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtilException;

public class ResourceServiceImpl
implements IResourceService,
ToolContentManager,
ToolSessionManager,
ToolContentImport102Manager {
    static Logger log = Logger.getLogger((String)ResourceServiceImpl.class.getName());
    private ResourceDAO resourceDao;
    private ResourceItemDAO resourceItemDao;
    private ResourceAttachmentDAO resourceAttachmentDao;
    private ResourceUserDAO resourceUserDao;
    private ResourceSessionDAO resourceSessionDao;
    private ResourceItemVisitDAO resourceItemVisitDao;
    private ResourceToolContentHandler resourceToolContentHandler;
    private MessageService messageService;
    private IRepositoryService repositoryService;
    private ILamsToolService toolService;
    private ILearnerService learnerService;
    private IAuditService auditService;
    private IUserManagementService userManagementService;
    private IExportToolContentService exportContentService;
    private ICoreNotebookService coreNotebookService;

    @Override
    public IVersionedNode getFileNode(Long itemUid, String relPathString) throws ResourceApplicationException {
        ResourceItem item = (ResourceItem)this.resourceItemDao.getObject(ResourceItem.class, itemUid);
        if (item == null) {
            throw new ResourceApplicationException("Reource item " + itemUid + " not found.");
        }
        return this.getFile(item.getFileUuid(), item.getFileVersionId(), relPathString);
    }

    private IVersionedNode getFile(Long uuid, Long versionId, String relativePath) throws ResourceApplicationException {
        ITicket tic = this.getRepositoryLoginTicket();
        try {
            return this.repositoryService.getFileItem(tic, uuid, versionId, relativePath);
        }
        catch (AccessDeniedException e) {
            String error = "Unable to access repository to get file uuid " + uuid + " version id " + versionId + " path " + relativePath + ".";
            error = error + "AccessDeniedException: " + e.getMessage() + " Unable to retry further.";
            log.error((Object)error);
            throw new ResourceApplicationException(error, e);
        }
        catch (Exception e) {
            String error = "Unable to access repository to get file uuid " + uuid + " version id " + versionId + " path " + relativePath + "." + " Exception: " + e.getMessage();
            log.error((Object)error);
            throw new ResourceApplicationException(error, e);
        }
    }

    private ITicket getRepositoryLoginTicket() throws ResourceApplicationException {
        SimpleCredentials credentials = new SimpleCredentials(this.resourceToolContentHandler.getRepositoryUser(), this.resourceToolContentHandler.getRepositoryId());
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, this.resourceToolContentHandler.getRepositoryWorkspaceName());
            return ticket;
        }
        catch (AccessDeniedException ae) {
            throw new ResourceApplicationException("Access Denied to repository." + ae.getMessage());
        }
        catch (WorkspaceNotFoundException we) {
            throw new ResourceApplicationException("Workspace not found." + we.getMessage());
        }
        catch (LoginException e) {
            throw new ResourceApplicationException("Login failed." + e.getMessage());
        }
    }

    @Override
    public Resource getResourceByContentId(Long contentId) {
        Resource rs = this.resourceDao.getByContentId(contentId);
        if (rs == null) {
            log.error((Object)("Could not find the content by given ID:" + contentId));
        }
        return rs;
    }

    @Override
    public Resource getDefaultContent(Long contentId) throws ResourceApplicationException {
        if (contentId == null) {
            String error = this.messageService.getMessage("error.msg.default.content.not.find");
            log.error((Object)error);
            throw new ResourceApplicationException(error);
        }
        Resource defaultContent = this.getDefaultResource();
        Resource content = new Resource();
        content = Resource.newInstance(defaultContent, contentId, this.resourceToolContentHandler);
        return content;
    }

    @Override
    public List getAuthoredItems(Long resourceUid) {
        return this.resourceItemDao.getAuthoringItems(resourceUid);
    }

    @Override
    public ResourceAttachment uploadInstructionFile(FormFile uploadFile, String fileType) throws UploadResourceFileException {
        if (uploadFile == null || StringUtils.isEmpty((String)uploadFile.getFileName())) {
            throw new UploadResourceFileException(this.messageService.getMessage("error.msg.upload.file.not.found", new Object[]{uploadFile}));
        }
        NodeKey nodeKey = this.processFile(uploadFile, fileType);
        ResourceAttachment file = new ResourceAttachment();
        file.setFileType(fileType);
        file.setFileUuid(nodeKey.getUuid());
        file.setFileVersionId(nodeKey.getVersion());
        file.setFileName(uploadFile.getFileName());
        return file;
    }

    @Override
    public void createUser(ResourceUser resourceUser) {
        this.resourceUserDao.saveObject(resourceUser);
    }

    @Override
    public ResourceUser getUserByIDAndContent(Long userId, Long contentId) {
        return this.resourceUserDao.getUserByUserIDAndContentID(userId, contentId);
    }

    @Override
    public ResourceUser getUserByIDAndSession(Long userId, Long sessionId) {
        return this.resourceUserDao.getUserByUserIDAndSessionID(userId, sessionId);
    }

    @Override
    public void deleteFromRepository(Long fileUuid, Long fileVersionId) throws ResourceApplicationException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            this.repositoryService.deleteVersion(ticket, fileUuid, fileVersionId);
        }
        catch (Exception e) {
            throw new ResourceApplicationException("Exception occured while deleting files from the repository " + e.getMessage());
        }
    }

    @Override
    public void saveOrUpdateResource(Resource resource) {
        this.resourceDao.saveObject(resource);
    }

    @Override
    public void deleteResourceAttachment(Long attachmentUid) {
        this.resourceAttachmentDao.removeObject(ResourceAttachment.class, attachmentUid);
    }

    public void saveOrUpdateResourceItem(ResourceItem item) {
        this.resourceItemDao.saveObject(item);
    }

    @Override
    public void deleteResourceItem(Long uid) {
        this.resourceItemDao.removeObject(ResourceItem.class, uid);
    }

    @Override
    public List<ResourceItem> getResourceItemsBySessionId(Long sessionId) {
        ResourceSession session = this.resourceSessionDao.getSessionBySessionId(sessionId);
        if (session == null) {
            log.error((Object)("Failed get ResourceSession by ID [" + sessionId + "]"));
            return null;
        }
        Resource resource = session.getResource();
        ArrayList<ResourceItem> items = new ArrayList<ResourceItem>();
        items.addAll(resource.getResourceItems());
        items.addAll(session.getResourceItems());
        return items;
    }

    @Override
    public List<Summary> exportBySessionId(Long sessionId, boolean skipHide) {
        ResourceSession session = this.resourceSessionDao.getSessionBySessionId(sessionId);
        if (session == null) {
            log.error((Object)("Failed get ResourceSession by ID [" + sessionId + "]"));
            return null;
        }
        ArrayList<Summary> itemList = new ArrayList<Summary>();
        Set resList = session.getResource().getResourceItems();
        for (ResourceItem item : resList) {
            if (skipHide && item.isHide() || !item.isCreateByAuthor()) continue;
            Summary sum = new Summary(session.getSessionName(), item, false);
            itemList.add(sum);
        }
        Set sessList = session.getResourceItems();
        for (ResourceItem item : sessList) {
            if (skipHide && item.isHide() || item.isCreateByAuthor()) continue;
            Summary sum = new Summary(session.getSessionName(), item, false);
            itemList.add(sum);
        }
        return itemList;
    }

    @Override
    public List<List<Summary>> exportByContentId(Long contentId) {
        Resource resource = this.resourceDao.getByContentId(contentId);
        ArrayList<List<Summary>> groupList = new ArrayList<List<Summary>>();
        ArrayList<Summary> initList = new ArrayList<Summary>();
        groupList.add(initList);
        Set resList = resource.getResourceItems();
        for (ResourceItem item : resList) {
            if (!item.isCreateByAuthor()) continue;
            Summary sum = new Summary(null, item, true);
            initList.add(sum);
        }
        List<ResourceSession> sessionList = this.resourceSessionDao.getByContentId(contentId);
        for (ResourceSession session : sessionList) {
            ArrayList<Summary> group = new ArrayList<Summary>();
            Set sessList = session.getResourceItems();
            for (ResourceItem item : sessList) {
                if (item.isCreateByAuthor()) continue;
                Summary sum = new Summary(session.getSessionName(), item, false);
                group.add(sum);
            }
            if (group.size() == 0) {
                group.add(new Summary(session.getSessionName(), null, false));
            }
            groupList.add(group);
        }
        return groupList;
    }

    @Override
    public Resource getResourceBySessionId(Long sessionId) {
        ResourceSession session = this.resourceSessionDao.getSessionBySessionId(sessionId);
        Long contentId = session.getResource().getContentId();
        Resource res = this.resourceDao.getByContentId(contentId);
        int miniView = res.getMiniViewResourceNumber();
        res.setMiniViewNumberStr(this.messageService.getMessage("label.learning.minimum.review", new Object[]{new Integer(miniView)}));
        return res;
    }

    @Override
    public ResourceSession getResourceSessionBySessionId(Long sessionId) {
        return this.resourceSessionDao.getSessionBySessionId(sessionId);
    }

    @Override
    public void saveOrUpdateResourceSession(ResourceSession resSession) {
        this.resourceSessionDao.saveObject(resSession);
    }

    @Override
    public void retrieveComplete(SortedSet<ResourceItem> resourceItemList, ResourceUser user) {
        for (ResourceItem item : resourceItemList) {
            ResourceItemVisitLog log = this.resourceItemVisitDao.getResourceItemLog(item.getUid(), user.getUserId());
            if (log == null) {
                item.setComplete(false);
                continue;
            }
            item.setComplete(log.isComplete());
        }
    }

    @Override
    public void setItemComplete(Long resourceItemUid, Long userId, Long sessionId) {
        ResourceItemVisitLog log = this.resourceItemVisitDao.getResourceItemLog(resourceItemUid, userId);
        if (log == null) {
            log = new ResourceItemVisitLog();
            ResourceItem item = this.resourceItemDao.getByUid(resourceItemUid);
            log.setResourceItem(item);
            ResourceUser user = this.resourceUserDao.getUserByUserIDAndSessionID(userId, sessionId);
            log.setUser(user);
            log.setSessionId(sessionId);
            log.setAccessDate(new Timestamp(new Date().getTime()));
        }
        log.setComplete(true);
        this.resourceItemVisitDao.saveObject(log);
    }

    @Override
    public void setItemAccess(Long resourceItemUid, Long userId, Long sessionId) {
        ResourceItemVisitLog log = this.resourceItemVisitDao.getResourceItemLog(resourceItemUid, userId);
        if (log == null) {
            log = new ResourceItemVisitLog();
            ResourceItem item = this.resourceItemDao.getByUid(resourceItemUid);
            log.setResourceItem(item);
            ResourceUser user = this.resourceUserDao.getUserByUserIDAndSessionID(userId, sessionId);
            log.setUser(user);
            log.setComplete(false);
            log.setSessionId(sessionId);
            log.setAccessDate(new Timestamp(new Date().getTime()));
            this.resourceItemVisitDao.saveObject(log);
        }
    }

    @Override
    public String finishToolSession(Long toolSessionId, Long userId) throws ResourceApplicationException {
        ResourceUser user = this.resourceUserDao.getUserByUserIDAndSessionID(userId, toolSessionId);
        user.setSessionFinished(true);
        this.resourceUserDao.saveObject(user);
        String nextUrl = null;
        try {
            nextUrl = this.leaveToolSession(toolSessionId, userId);
        }
        catch (DataMissingException e) {
            throw new ResourceApplicationException(e);
        }
        catch (ToolException e) {
            throw new ResourceApplicationException(e);
        }
        return nextUrl;
    }

    @Override
    public int checkMiniView(Long toolSessionId, Long userUid) {
        int miniView = this.resourceItemVisitDao.getUserViewLogCount(toolSessionId, userUid);
        ResourceSession session = this.resourceSessionDao.getSessionBySessionId(toolSessionId);
        if (session == null) {
            log.error((Object)("Failed get session by ID [" + toolSessionId + "]"));
            return 0;
        }
        int reqView = session.getResource().getMiniViewResourceNumber();
        return reqView - miniView;
    }

    @Override
    public ResourceItem getResourceItemByUid(Long itemUid) {
        return this.resourceItemDao.getByUid(itemUid);
    }

    @Override
    public List<List<Summary>> getSummary(Long contentId) {
        ArrayList<List<Summary>> groupList = new ArrayList<List<Summary>>();
        ArrayList<Summary> group = new ArrayList<Summary>();
        Map<Long, Integer> visitCountMap = this.resourceItemVisitDao.getSummary(contentId);
        Resource resource = this.resourceDao.getByContentId(contentId);
        Set resItemList = resource.getResourceItems();
        List<ResourceSession> sessionList = this.resourceSessionDao.getByContentId(contentId);
        for (ResourceSession session : sessionList) {
            group = new ArrayList();
            for (ResourceItem item : resItemList) {
                Summary sum = new Summary(session.getSessionId(), session.getSessionName(), item);
                if (visitCountMap.containsKey(item.getUid())) {
                    sum.setViewNumber(visitCountMap.get(item.getUid()));
                }
                group.add(sum);
            }
            Set sessItemList = session.getResourceItems();
            for (ResourceItem item : sessItemList) {
                if (item.isCreateByAuthor()) continue;
                Summary sum = new Summary(session.getSessionId(), session.getSessionName(), item);
                if (visitCountMap.containsKey(item.getUid())) {
                    sum.setViewNumber(visitCountMap.get(item.getUid()));
                }
                group.add(sum);
            }
            if (group.size() == 0) {
                group.add(new Summary(session.getSessionId(), session.getSessionName(), null));
            }
            groupList.add(group);
        }
        return groupList;
    }

    @Override
    public Map<Long, Set<ReflectDTO>> getReflectList(Long contentId) {
        HashMap<Long, Set<ReflectDTO>> map = new HashMap<Long, Set<ReflectDTO>>();
        List<ResourceSession> sessionList = this.resourceSessionDao.getByContentId(contentId);
        for (ResourceSession session : sessionList) {
            Long sessionId = session.getSessionId();
            boolean hasRefection = session.getResource().isReflectOnActivity();
            TreeSet<ReflectDTO> list = new TreeSet<ReflectDTO>(new ReflectDTOComparator());
            List<ResourceUser> users = this.resourceUserDao.getBySessionID(sessionId);
            for (ResourceUser user : users) {
                ReflectDTO ref = new ReflectDTO(user);
                ref.setHasRefection(hasRefection);
                list.add(ref);
            }
            map.put(sessionId, list);
        }
        return map;
    }

    @Override
    public List<ResourceUser> getUserListBySessionItem(Long sessionId, Long itemUid) {
        List<ResourceItemVisitLog> logList = this.resourceItemVisitDao.getResourceItemLogBySession(sessionId, itemUid);
        ArrayList<ResourceUser> userList = new ArrayList<ResourceUser>(logList.size());
        for (ResourceItemVisitLog visit : logList) {
            ResourceUser user = visit.getUser();
            user.setAccessDate(visit.getAccessDate());
            userList.add(user);
        }
        return userList;
    }

    @Override
    public void setItemVisible(Long itemUid, boolean visible) {
        ResourceItem item = this.resourceItemDao.getByUid(itemUid);
        if (item != null) {
            Long userId = 0L;
            String loginName = "No user";
            if (item.getCreateBy() != null) {
                userId = item.getCreateBy().getUserId();
                loginName = item.getCreateBy().getLoginName();
            }
            if (visible) {
                this.auditService.logShowEntry("larsrc11", userId, loginName, item.toString());
            } else {
                this.auditService.logHideEntry("larsrc11", userId, loginName, item.toString());
            }
            item.setHide(!visible);
            this.resourceItemDao.saveObject(item);
        }
    }

    @Override
    public Long createNotebookEntry(Long sessionId, Integer notebookToolType, String toolSignature, Integer userId, String entryText) {
        return this.coreNotebookService.createNotebookEntry(sessionId, notebookToolType, toolSignature, userId, "", entryText);
    }

    @Override
    public NotebookEntry getEntry(Long sessionId, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(sessionId, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }

    @Override
    public ResourceUser getUser(Long uid) {
        return (ResourceUser)this.resourceUserDao.getObject(ResourceUser.class, uid);
    }

    private Resource getDefaultResource() throws ResourceApplicationException {
        Long defaultResourceId = this.getToolDefaultContentIdBySignature("larsrc11");
        Resource defaultResource = this.getResourceByContentId(defaultResourceId);
        if (defaultResource == null) {
            String error = this.messageService.getMessage("error.msg.default.content.not.find");
            log.error((Object)error);
            throw new ResourceApplicationException(error);
        }
        return defaultResource;
    }

    private Long getToolDefaultContentIdBySignature(String toolSignature) throws ResourceApplicationException {
        Long contentId = null;
        contentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (contentId == null) {
            String error = this.messageService.getMessage("error.msg.default.content.not.find");
            log.error((Object)error);
            throw new ResourceApplicationException(error);
        }
        return contentId;
    }

    private NodeKey processFile(FormFile file, String fileType) throws UploadResourceFileException {
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)file.getFileName())) {
            String fileName = file.getFileName();
            try {
                node = this.resourceToolContentHandler.uploadFile(file.getInputStream(), fileName, file.getContentType(), fileType);
            }
            catch (InvalidParameterException e) {
                throw new UploadResourceFileException(this.messageService.getMessage("error.msg.invaid.param.upload"));
            }
            catch (FileNotFoundException e) {
                throw new UploadResourceFileException(this.messageService.getMessage("error.msg.file.not.found"));
            }
            catch (RepositoryCheckedException e) {
                throw new UploadResourceFileException(this.messageService.getMessage("error.msg.repository"));
            }
            catch (IOException e) {
                throw new UploadResourceFileException(this.messageService.getMessage("error.msg.io.exception"));
            }
        }
        return node;
    }

    private NodeKey processPackage(String packageDirectory, String initFile) throws UploadResourceFileException {
        NodeKey node = null;
        try {
            node = this.resourceToolContentHandler.uploadPackage(packageDirectory, initFile);
        }
        catch (InvalidParameterException e) {
            throw new UploadResourceFileException(this.messageService.getMessage("error.msg.invaid.param.upload"));
        }
        catch (RepositoryCheckedException e) {
            throw new UploadResourceFileException(this.messageService.getMessage("error.msg.repository"));
        }
        return node;
    }

    @Override
    public void uploadResourceItemFile(ResourceItem item, FormFile file) throws UploadResourceFileException {
        try {
            String packageDirectory;
            InputStream is = file.getInputStream();
            String fileName = file.getFileName();
            String fileType = file.getContentType();
            if (item.getType() == 2) {
                NodeKey nodeKey = this.processFile(file, "ONLINE");
                item.setFileUuid(nodeKey.getUuid());
                item.setFileVersionId(nodeKey.getVersion());
            }
            if (item.getType() == 3) {
                packageDirectory = ZipFileUtil.expandZip((InputStream)is, (String)fileName);
                String initFile = this.findWebsiteInitialItem(packageDirectory);
                if (initFile == null) {
                    throw new UploadResourceFileException(this.messageService.getMessage("error.msg.website.no.initial.file"));
                }
                item.setInitialItem(initFile);
                NodeKey nodeKey = this.processPackage(packageDirectory, initFile);
                item.setFileUuid(nodeKey.getUuid());
                item.setFileVersionId(nodeKey.getVersion());
            }
            if (item.getType() == 4) {
                packageDirectory = ZipFileUtil.expandZip((InputStream)is, (String)fileName);
                SimpleContentPackageConverter cpConverter = new SimpleContentPackageConverter(packageDirectory);
                String initFile = cpConverter.getDefaultItem();
                item.setInitialItem(initFile);
                item.setImsSchema(cpConverter.getSchema());
                item.setOrganizationXml(cpConverter.getOrganzationXML());
                NodeKey nodeKey = this.processPackage(packageDirectory, initFile);
                item.setFileUuid(nodeKey.getUuid());
                item.setFileVersionId(nodeKey.getVersion());
            }
            item.setFileType(fileType);
            item.setFileName(fileName);
        }
        catch (ZipFileUtilException e) {
            log.error((Object)(this.messageService.getMessage("error.msg.zip.file.exception") + " : " + e.toString()));
            throw new UploadResourceFileException(this.messageService.getMessage("error.msg.zip.file.exception"));
        }
        catch (FileNotFoundException e) {
            log.error((Object)(this.messageService.getMessage("error.msg.file.not.found") + ":" + e.toString()));
            throw new UploadResourceFileException(this.messageService.getMessage("error.msg.file.not.found"));
        }
        catch (IOException e) {
            log.error((Object)(this.messageService.getMessage("error.msg.io.exception") + ":" + e.toString()));
            throw new UploadResourceFileException(this.messageService.getMessage("error.msg.io.exception"));
        }
        catch (IMSManifestException e) {
            log.error((Object)(this.messageService.getMessage("error.msg.ims.package") + ":" + e.toString()));
            throw new UploadResourceFileException(this.messageService.getMessage("error.msg.ims.package"));
        }
        catch (ImscpApplicationException e) {
            log.error((Object)(this.messageService.getMessage("error.msg.ims.application") + ":" + e.toString()));
            throw new UploadResourceFileException(this.messageService.getMessage("error.msg.ims.application"));
        }
    }

    private String findWebsiteInitialItem(String packageDirectory) {
        File file = new File(packageDirectory);
        if (!file.isDirectory()) {
            return null;
        }
        File[] initFiles = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname == null || pathname.getName() == null) {
                    return false;
                }
                String name = pathname.getName();
                return name.endsWith("default.html") || name.endsWith("default.htm") || name.endsWith("index.html") || name.endsWith("index.htm");
            }
        });
        if (initFiles != null && initFiles.length > 0) {
            return initFiles[0].getName();
        }
        return null;
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setRepositoryService(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setResourceAttachmentDao(ResourceAttachmentDAO resourceAttachmentDao) {
        this.resourceAttachmentDao = resourceAttachmentDao;
    }

    public void setResourceDao(ResourceDAO resourceDao) {
        this.resourceDao = resourceDao;
    }

    public void setResourceItemDao(ResourceItemDAO resourceItemDao) {
        this.resourceItemDao = resourceItemDao;
    }

    public void setResourceSessionDao(ResourceSessionDAO resourceSessionDao) {
        this.resourceSessionDao = resourceSessionDao;
    }

    public void setResourceToolContentHandler(ResourceToolContentHandler resourceToolContentHandler) {
        this.resourceToolContentHandler = resourceToolContentHandler;
    }

    public void setResourceUserDao(ResourceUserDAO resourceUserDao) {
        this.resourceUserDao = resourceUserDao;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public ResourceItemVisitDAO getResourceItemVisitDao() {
        return this.resourceItemVisitDao;
    }

    public void setResourceItemVisitDao(ResourceItemVisitDAO resourceItemVisitDao) {
        this.resourceItemVisitDao = resourceItemVisitDao;
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        Resource toolContentObj = this.resourceDao.getByContentId(toolContentId);
        if (toolContentObj == null) {
            try {
                toolContentObj = this.getDefaultResource();
            }
            catch (ResourceApplicationException e) {
                throw new DataMissingException(e.getMessage());
            }
        }
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to find default content for the share resources tool");
        }
        toolContentObj = Resource.newInstance(toolContentObj, toolContentId, null);
        toolContentObj.setToolContentHandler(null);
        toolContentObj.setOfflineFileList(null);
        toolContentObj.setOnlineFileList(null);
        toolContentObj.setMiniViewNumberStr(null);
        try {
            this.exportContentService.registerFileClassForExport(ResourceAttachment.class.getName(), "fileUuid", "fileVersionId");
            this.exportContentService.registerFileClassForExport(ResourceItem.class.getName(), "fileUuid", "fileVersionId");
            this.exportContentService.exportToolContent(toolContentId, (Object)toolContentObj, (IToolContentHandler)this.resourceToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(ResourceAttachment.class.getName(), "fileUuid", "fileVersionId", "fileName", "fileType", null, null);
            this.exportContentService.registerFileClassForImport(ResourceItem.class.getName(), "fileUuid", "fileVersionId", "fileName", "fileType", null, "initialItem");
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, (IToolContentHandler)this.resourceToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof Resource)) {
                throw new ImportToolContentException("Import Share resources tool content failed. Deserialized object is " + toolPOJO);
            }
            Resource toolContentObj = (Resource)toolPOJO;
            toolContentObj.setContentId(toolContentId);
            ResourceUser user = this.resourceUserDao.getUserByUserIDAndContentID(new Long(newUserUid.longValue()), toolContentId);
            if (user == null) {
                user = new ResourceUser();
                UserDTO sysUser = ((User)this.userManagementService.findById(User.class, (Serializable)newUserUid)).getUserDTO();
                user.setFirstName(sysUser.getFirstName());
                user.setLastName(sysUser.getLastName());
                user.setLoginName(sysUser.getLogin());
                user.setUserId(new Long(newUserUid.longValue()));
                user.setResource(toolContentObj);
            }
            toolContentObj.setCreatedBy(user);
            Set items = toolContentObj.getResourceItems();
            for (ResourceItem item : items) {
                item.setCreateBy(user);
            }
            this.resourceDao.saveObject(toolContentObj);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (toContentId == null) {
            throw new ToolException("Failed to create the SharedResourceFiles tool seession");
        }
        Resource resource = null;
        if (fromContentId != null) {
            resource = this.resourceDao.getByContentId(fromContentId);
        }
        if (resource == null) {
            try {
                resource = this.getDefaultResource();
            }
            catch (ResourceApplicationException e) {
                throw new ToolException((Throwable)e);
            }
        }
        Resource toContent = Resource.newInstance(resource, toContentId, this.resourceToolContentHandler);
        this.resourceDao.saveObject(toContent);
        Set items = toContent.getResourceItems();
        if (items != null) {
            for (ResourceItem item : items) {
            }
        }
    }

    public void setAsDefineLater(Long toolContentId) throws DataMissingException, ToolException {
        Resource resource = this.resourceDao.getByContentId(toolContentId);
        if (resource == null) {
            throw new ToolException("No found tool content by given content ID:" + toolContentId);
        }
        resource.setDefineLater(true);
    }

    public void setAsRunOffline(Long toolContentId) throws DataMissingException, ToolException {
        Resource resource = this.resourceDao.getByContentId(toolContentId);
        if (resource == null) {
            throw new ToolException("No found tool content by given content ID:" + toolContentId);
        }
        resource.setRunOffline(true);
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
        Resource resource = this.resourceDao.getByContentId(toolContentId);
        if (removeSessionData) {
            List<ResourceSession> list = this.resourceSessionDao.getByContentId(toolContentId);
            for (ResourceSession session : list) {
                this.resourceSessionDao.delete(session);
            }
        }
        this.resourceDao.delete(resource);
    }

    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        ResourceSession session = new ResourceSession();
        session.setSessionId(toolSessionId);
        session.setSessionName(toolSessionName);
        Resource resource = this.resourceDao.getByContentId(toolContentId);
        session.setResource(resource);
        this.resourceSessionDao.saveObject(session);
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        if (toolSessionId == null) {
            log.error((Object)"Fail to leave tool Session based on null tool session id.");
            throw new ToolException("Fail to remove tool Session based on null tool session id.");
        }
        if (learnerId == null) {
            log.error((Object)"Fail to leave tool Session based on null learner.");
            throw new ToolException("Fail to remove tool Session based on null learner.");
        }
        ResourceSession session = this.resourceSessionDao.getSessionBySessionId(toolSessionId);
        if (session == null) {
            log.error((Object)("Fail to leave tool Session.Could not find shared resources session by given session id: " + toolSessionId));
            throw new DataMissingException("Fail to leave tool Session.Could not find shared resource session by given session id: " + toolSessionId);
        }
        session.setStatus(1);
        this.resourceSessionDao.saveObject(session);
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        return null;
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws DataMissingException, ToolException {
        return null;
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        this.resourceSessionDao.deleteBySessionId(toolSessionId);
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        Resource toolContentObj = new Resource();
        try {
            toolContentObj.setTitle((String)importValues.get("title"));
            toolContentObj.setContentId(toolContentId);
            toolContentObj.setContentInUse(Boolean.FALSE);
            toolContentObj.setCreated(now);
            toolContentObj.setDefineLater(Boolean.FALSE);
            toolContentObj.setInstructions(WebUtil.convertNewlines((String)((String)importValues.get("body"))));
            toolContentObj.setOfflineInstructions(null);
            toolContentObj.setOnlineInstructions(null);
            toolContentObj.setRunOffline(Boolean.FALSE);
            toolContentObj.setUpdated(now);
            toolContentObj.setReflectOnActivity(Boolean.FALSE);
            toolContentObj.setReflectInstructions(null);
            toolContentObj.setRunAuto(Boolean.FALSE);
            Boolean bool = WDDXProcessor.convertToBoolean((Hashtable)importValues, (String)"runtimeSubmissionLearnerFile");
            toolContentObj.setAllowAddFiles(bool != null ? bool : Boolean.TRUE);
            bool = WDDXProcessor.convertToBoolean((Hashtable)importValues, (String)"runtimeSubmissionLearnerURL");
            toolContentObj.setAllowAddUrls(bool != null ? bool : Boolean.TRUE);
            Integer minToComplete = WDDXProcessor.convertToInteger((Hashtable)importValues, (String)"minNumberComplete");
            toolContentObj.setMiniViewResourceNumber(minToComplete != null ? minToComplete : 0);
            bool = WDDXProcessor.convertToBoolean((Hashtable)importValues, (String)"runtimeSubmissionLearnerURL");
            toolContentObj.setLockWhenFinished(Boolean.FALSE);
            toolContentObj.setRunAuto(Boolean.FALSE);
            ResourceUser ruser = new ResourceUser();
            ruser.setUserId(new Long(user.getUserID().longValue()));
            ruser.setFirstName(user.getFirstName());
            ruser.setLastName(user.getLastName());
            ruser.setLoginName(user.getLogin());
            this.createUser(ruser);
            toolContentObj.setCreatedBy(ruser);
            Vector urls = (Vector)importValues.get("urls");
            TreeMap<Integer, ResourceItem> items = new TreeMap<Integer, ResourceItem>();
            if (urls != null) {
                for (Hashtable urlMap : urls) {
                    String resourceType;
                    Integer itemOrder = WDDXProcessor.convertToInteger((Hashtable)urlMap, (String)"order");
                    ResourceItem item = new ResourceItem();
                    item.setTitle((String)urlMap.get("title"));
                    item.setCreateBy(ruser);
                    item.setCreateByAuthor(true);
                    item.setHide(false);
                    Vector instructions = (Vector)urlMap.get("instructions");
                    if (instructions != null && instructions.size() > 0) {
                        item.setItemInstructions(new HashSet());
                        Iterator insIter = instructions.iterator();
                        while (insIter.hasNext()) {
                            item.getItemInstructions().add(this.createInstruction((Hashtable)insIter.next()));
                        }
                    }
                    if ("externalurl".equals(resourceType = (String)urlMap.get("resourcetype"))) {
                        item.setType((short)1);
                        item.setUrl((String)urlMap.get("url"));
                        item.setOpenUrlNewWindow(false);
                    } else if ("internalurl".equals(resourceType)) {
                        item.setType((short)3);
                    } else if ("file".equals(resourceType)) {
                        item.setType((short)2);
                    } else {
                        throw new ToolException("Invalid shared resources type. Type was " + resourceType);
                    }
                    items.put(itemOrder, item);
                }
            }
            Iterator<Object> iter = items.values().iterator();
            Date itemDate = null;
            while (iter.hasNext()) {
                if (itemDate != null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                itemDate = new Date();
                ResourceItem item = (ResourceItem)iter.next();
                item.setCreateDate(itemDate);
                toolContentObj.getResourceItems().add(item);
            }
        }
        catch (WDDXProcessorConversionException e) {
            log.error((Object)("Unable to content for activity " + toolContentObj.getTitle() + "properly due to a WDDXProcessorConversionException."), (Throwable)e);
            throw new ToolException("Invalid import data format for activity " + toolContentObj.getTitle() + "- WDDX caused an exception. Some data from the design will have been lost. See log for more details.");
        }
        this.resourceDao.saveObject(toolContentObj);
    }

    private ResourceItemInstruction createInstruction(Hashtable instructionEntry) throws WDDXProcessorConversionException {
        Integer instructionOrder = WDDXProcessor.convertToInteger((Hashtable)instructionEntry, (String)"order");
        String instructionText = (String)instructionEntry.get("instruction");
        if (instructionText != null && instructionText.length() > 255) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("1.0.2 Import truncating Item Instruction to 255 characters. Original text was'" + instructionText + "'"));
            }
            instructionText = instructionText.substring(0, 255);
        }
        ResourceItemInstruction instruction = new ResourceItemInstruction();
        instruction.setDescription(instructionText);
        instruction.setSequenceId(instructionOrder);
        return instruction;
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        Resource toolContentObj = this.getResourceByContentId(toolContentId);
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        toolContentObj.setReflectOnActivity(Boolean.TRUE);
        toolContentObj.setReflectInstructions(description);
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public IUserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    private class ReflectDTOComparator
    implements Comparator<ReflectDTO> {
        private ReflectDTOComparator() {
        }

        @Override
        public int compare(ReflectDTO o1, ReflectDTO o2) {
            if (o1 != null && o2 != null) {
                return o1.getFullName().compareTo(o2.getFullName());
            }
            if (o1 != null) {
                return 1;
            }
            return -1;
        }
    }
}

