/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.rsrc.web.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.rsrc.dto.ReflectDTO;
import org.lamsfoundation.lams.tool.rsrc.dto.Summary;
import org.lamsfoundation.lams.tool.rsrc.model.Resource;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceSession;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceUser;
import org.lamsfoundation.lams.tool.rsrc.service.IResourceService;
import org.lamsfoundation.lams.tool.rsrc.util.ResourceWebUtils;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class MonitoringAction
extends Action {
    public static Logger log = Logger.getLogger(MonitoringAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String param = mapping.getParameter();
        if (param.equals("summary")) {
            return this.summary(mapping, form, request, response);
        }
        if (param.equals("listuser")) {
            return this.listuser(mapping, form, request, response);
        }
        if (param.equals("showitem")) {
            return this.showitem(mapping, form, request, response);
        }
        if (param.equals("hideitem")) {
            return this.hideitem(mapping, form, request, response);
        }
        if (param.equals("viewReflection")) {
            return this.viewReflection(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward hideitem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long itemUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"itemUid");
        IResourceService service = this.getResourceService();
        service.setItemVisible(itemUid, false);
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        List groupList = (List)sessionMap.get((Object)"summaryList");
        if (groupList != null) {
            block0: for (List group : groupList) {
                for (Summary sum : group) {
                    if (!itemUid.equals(sum.getItemUid())) continue;
                    sum.setItemHide(true);
                    continue block0;
                }
            }
        }
        return mapping.findForward("success");
    }

    private ActionForward showitem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long itemUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"itemUid");
        IResourceService service = this.getResourceService();
        service.setItemVisible(itemUid, true);
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        List groupList = (List)sessionMap.get((Object)"summaryList");
        if (groupList != null) {
            block0: for (List group : groupList) {
                for (Summary sum : group) {
                    if (!itemUid.equals(sum.getItemUid())) continue;
                    sum.setItemHide(false);
                    continue block0;
                }
            }
        }
        return mapping.findForward("success");
    }

    private ActionForward summary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        sessionMap.put((Object)"contentFolderID", (Object)WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID"));
        Long contentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        IResourceService service = this.getResourceService();
        List<List<Summary>> groupList = service.getSummary(contentId);
        Resource resource = service.getResourceByContentId(contentId);
        resource.toDTO();
        Map<Long, Set<ReflectDTO>> relectList = service.getReflectList(contentId);
        sessionMap.put((Object)"summaryList", groupList);
        sessionMap.put((Object)"isPageEditable", (Object)new Boolean(ResourceWebUtils.isResourceEditable(resource)));
        sessionMap.put((Object)"resource", (Object)resource);
        sessionMap.put((Object)"toolContentID", (Object)contentId);
        sessionMap.put((Object)"reflectList", relectList);
        return mapping.findForward("success");
    }

    private ActionForward listuser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long sessionId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        Long itemUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"itemUid");
        IResourceService service = this.getResourceService();
        List<ResourceUser> list = service.getUserListBySessionItem(sessionId, itemUid);
        request.setAttribute("userList", list);
        return mapping.findForward("success");
    }

    private ActionForward viewReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long uid = WebUtil.readLongParam((HttpServletRequest)request, (String)"userUid");
        Long sessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        IResourceService service = this.getResourceService();
        ResourceUser user = service.getUser(uid);
        NotebookEntry notebookEntry = service.getEntry(sessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "larsrc11", user.getUserId().intValue());
        ResourceSession session = service.getResourceSessionBySessionId(sessionID);
        ReflectDTO refDTO = new ReflectDTO(user);
        if (notebookEntry == null) {
            refDTO.setFinishReflection(false);
            refDTO.setReflect(null);
        } else {
            refDTO.setFinishReflection(true);
            refDTO.setReflect(notebookEntry.getEntry());
        }
        refDTO.setReflectInstrctions(session.getResource().getReflectInstructions());
        request.setAttribute("userDTO", (Object)refDTO);
        return mapping.findForward("success");
    }

    private IResourceService getResourceService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IResourceService)wac.getBean("resourceService");
    }
}

