/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.rsrc.web.servlet;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.rsrc.dto.Summary;
import org.lamsfoundation.lams.tool.rsrc.model.Resource;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceUser;
import org.lamsfoundation.lams.tool.rsrc.service.IResourceService;
import org.lamsfoundation.lams.tool.rsrc.service.ResourceApplicationException;
import org.lamsfoundation.lams.tool.rsrc.service.ResourceServiceProxy;
import org.lamsfoundation.lams.tool.rsrc.util.ResourceToolContentHandler;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ExportServlet
extends AbstractExportPortfolioServlet {
    private static final long serialVersionUID = -4529093489007108143L;
    private static Logger logger = Logger.getLogger(ExportServlet.class);
    private final String FILENAME = "shared_resources_main.html";
    private ResourceToolContentHandler handler;

    public String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        try {
            if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
                sessionMap.put((Object)"mode", (Object)ToolAccessMode.LEARNER);
                this.learner(request, response, directoryName, cookies, (HashMap)sessionMap);
            } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
                sessionMap.put((Object)"mode", (Object)ToolAccessMode.TEACHER);
                this.teacher(request, response, directoryName, cookies, (HashMap)sessionMap);
            }
        }
        catch (ResourceApplicationException e) {
            logger.error((Object)"Cannot perform export for share resource tool.");
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        this.writeResponseToFile(basePath + "/pages/export/exportportfolio.jsp?sessionMapID=" + sessionMap.getSessionID(), directoryName, "shared_resources_main.html", cookies);
        return "shared_resources_main.html";
    }

    public void learner(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies, HashMap sessionMap) throws ResourceApplicationException {
        IResourceService service = ResourceServiceProxy.getResourceService(this.getServletContext());
        if (this.userID == null || this.toolSessionID == null) {
            String error = "Tool session Id or user Id is null. Unable to continue";
            logger.error((Object)error);
            throw new ResourceApplicationException(error);
        }
        ResourceUser learner = service.getUserByIDAndSession(this.userID, this.toolSessionID);
        if (learner == null) {
            String error = "The user with user id " + this.userID + " does not exist.";
            logger.error((Object)error);
            throw new ResourceApplicationException(error);
        }
        Resource content = service.getResourceBySessionId(this.toolSessionID);
        if (content == null) {
            String error = "The content for this activity has not been defined yet.";
            logger.error((Object)error);
            throw new ResourceApplicationException(error);
        }
        List<Summary> group = service.exportBySessionId(this.toolSessionID, true);
        this.saveFileToLocal(group, directoryName);
        ArrayList<List<Summary>> groupList = new ArrayList<List<Summary>>();
        if (group.size() > 0) {
            groupList.add(group);
        }
        sessionMap.put("title", content.getTitle());
        sessionMap.put("summaryList", groupList);
    }

    public void teacher(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies, HashMap sessionMap) throws ResourceApplicationException {
        IResourceService service = ResourceServiceProxy.getResourceService(this.getServletContext());
        if (this.toolContentID == null) {
            String error = "Tool Content Id is missing. Unable to continue";
            logger.error((Object)error);
            throw new ResourceApplicationException(error);
        }
        Resource content = service.getResourceByContentId(this.toolContentID);
        if (content == null) {
            String error = "Data is missing from the database. Unable to Continue";
            logger.error((Object)error);
            throw new ResourceApplicationException(error);
        }
        List<List<Summary>> groupList = service.exportByContentId(this.toolContentID);
        if (groupList != null) {
            for (List<Summary> list : groupList) {
                this.saveFileToLocal(list, directoryName);
            }
        }
        sessionMap.put("title", content.getTitle());
        sessionMap.put("summaryList", groupList);
    }

    private void saveFileToLocal(List<Summary> list, String directoryName) {
        this.handler = this.getToolContentHandler();
        for (Summary summary : list) {
            if (summary.getItemType() == 4 || summary.getItemType() == 1) continue;
            try {
                File local;
                int idx = 1;
                String userName = summary.getUsername();
                while (true) {
                    String localDir;
                    if (!(local = new File(localDir = FileUtil.getFullPath((String)directoryName, (String)(userName + "/" + idx)))).exists()) break;
                    ++idx;
                }
                local.mkdirs();
                summary.setAttachmentLocalUrl(userName + "/" + idx + "/" + summary.getFileName());
                this.handler.saveFile(summary.getFileUuid(), FileUtil.getFullPath((String)directoryName, (String)summary.getAttachmentLocalUrl()));
            }
            catch (Exception e) {
                logger.error((Object)("Export forum topic attachment failed: " + e.toString()));
            }
        }
    }

    private ResourceToolContentHandler getToolContentHandler() {
        if (this.handler == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            this.handler = (ResourceToolContentHandler)((Object)wac.getBean("resourceToolContentHandler"));
        }
        return this.handler;
    }
}

