/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouper;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.exception.GroupingException;
import org.lamsfoundation.lams.usermanagement.User;

public class RandomGrouper
extends Grouper
implements Serializable {
    private static final long serialVersionUID = -3696368461795411181L;
    private static Logger log = Logger.getLogger(RandomGrouper.class);

    @Override
    public void doGrouping(Grouping randomGrouping, String groupName, User learner) {
        ArrayList<User> learners = new ArrayList<User>();
        learners.add(learner);
        this.doGrouping(randomGrouping, groupName, learners);
    }

    @Override
    public void doGrouping(Grouping randomGrouping, String groupName, List learners) {
        int numOfGroupsTobeCreated = 0;
        numOfGroupsTobeCreated = randomGrouping.getGroups().size() == 0 ? this.calculateNumOfNewGroups((RandomGrouping)randomGrouping, learners, true) : this.calculateNumOfNewGroups((RandomGrouping)randomGrouping, learners, false);
        this.createGroups((RandomGrouping)randomGrouping, numOfGroupsTobeCreated);
        this.joinGroups(randomGrouping, learners);
    }

    @Override
    public void doGrouping(Grouping randomGrouping, Long groupId, List learners) throws GroupingException {
        this.doGrouping(randomGrouping, (String)null, learners);
    }

    private int calculateNumOfNewGroups(RandomGrouping randomGrouping, List learners, boolean isInitialization) {
        if (randomGrouping.getNumberOfGroups() != null) {
            return this.getNewGroupsByNumberOfGroups(randomGrouping, randomGrouping.getNumberOfGroups(), isInitialization);
        }
        if (randomGrouping.getLearnersPerGroup() != null) {
            return this.getNewGroupsByLearnerPerGroup(randomGrouping, learners);
        }
        log.warn((Object)("Random Grouping id=" + randomGrouping.getGroupingId() + " is missing both the number of groups and learners per group. Defaulting to two groups."));
        return this.getNewGroupsByNumberOfGroups(randomGrouping, 2, isInitialization);
    }

    private void createGroups(RandomGrouping randomGrouping, int numOfGroupsTobeCreated) {
        String prefix = this.getPrefix();
        int size = randomGrouping.getGroups().size();
        for (int i = 1; i <= numOfGroupsTobeCreated; ++i) {
            String groupName = prefix + " " + new Integer(size + i).toString();
            randomGrouping.getGroups().add(Group.createLearnerGroup(randomGrouping, groupName, new HashSet()));
        }
    }

    private void joinGroups(Grouping randomGrouping, List learners) {
        for (User learner : learners) {
            if (randomGrouping.doesLearnerExist(learner)) continue;
            Group selectedGroup = this.selectGroupToJoin((RandomGrouping)randomGrouping);
            selectedGroup.getUsers().add(learner);
        }
    }

    private Group selectGroupToJoin(RandomGrouping randomGrouping) {
        return randomGrouping.getGroupWithLeastMember();
    }

    private int getNewGroupsByLearnerPerGroup(RandomGrouping randomGrouping, List learners) {
        int newLearners = 0;
        for (User learner : learners) {
            if (randomGrouping.doesLearnerExist(learner)) continue;
            ++newLearners;
        }
        double totalRequiredGroups = Math.ceil((double)(randomGrouping.getLearners().size() + newLearners) / randomGrouping.getLearnersPerGroup().doubleValue());
        int existingGroups = randomGrouping.getGroups().size();
        return (int)totalRequiredGroups - existingGroups;
    }

    private int getNewGroupsByNumberOfGroups(RandomGrouping randomGrouping, int numberOfGroups, boolean isInitialization) {
        if (isInitialization) {
            return numberOfGroups;
        }
        int numberOfNewGroups = numberOfGroups - randomGrouping.getGroups().size();
        return numberOfNewGroups > 0 ? numberOfNewGroups : 0;
    }
}

