/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.dao.IGroupDAO;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class GroupDAO
extends BaseDAO
implements IGroupDAO {
    private static final String NUM_GROUPS = "select count(*) from " + Group.class.getName() + " group " + " where group.users.userId = :userID";

    @Override
    public Group getGroupById(Long groupID) {
        return (Group)super.find(Group.class, groupID);
    }

    @Override
    public void saveGroup(Group group) {
        this.getHibernateTemplate().save((Object)group);
    }

    @Override
    public void deleteGroup(Group group) {
        this.getHibernateTemplate().delete((Object)group);
    }

    @Override
    public Integer getCountGroupsForUser(final Integer userID) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(NUM_GROUPS);
                query.setInteger("userID", userID.intValue());
                Object value = query.uniqueResult();
                return new Integer(((Number)value).intValue());
            }
        });
    }
}

