/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.strategy;

import java.util.Iterator;
import java.util.TreeSet;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.NullActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.strategy.ComplexActivityStrategy;

public class SequenceActivityStrategy
extends ComplexActivityStrategy {
    protected SequenceActivity sequenceActivity = null;

    public SequenceActivityStrategy(SequenceActivity sequenceActivity) {
        this.sequenceActivity = sequenceActivity;
    }

    @Override
    public Activity getNextActivityByParent(ComplexActivity parent, Activity currentChild) {
        TreeSet children = new TreeSet(new ActivityOrderComparator());
        children.addAll(parent.getActivities());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Activity curChild = (Activity)i.next();
            if (currentChild == null || currentChild.isNull()) {
                return curChild;
            }
            if (curChild.getActivityId().longValue() != currentChild.getActivityId().longValue()) continue;
            return (Activity)i.next();
        }
        return new NullActivity();
    }

    @Override
    protected boolean isComplete(int numOfCompletedActivities) {
        if (this.sequenceActivity != null) {
            return numOfCompletedActivities == this.sequenceActivity.getActivities().size();
        }
        return true;
    }

    @Override
    protected ComplexActivity getComplexActivity() {
        return this.sequenceActivity;
    }
}

