/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao.hibernate;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class LearnerProgressDAO
extends HibernateDaoSupport
implements ILearnerProgressDAO {
    private static final String LOAD_PROGRESS_BY_LEARNER = "from LearnerProgress p where p.user.id = :learnerId and p.lesson.id = :lessonId";

    @Override
    public LearnerProgress getLearnerProgress(Long learnerProgressId) {
        return (LearnerProgress)this.getHibernateTemplate().get(LearnerProgress.class, (Serializable)learnerProgressId);
    }

    @Override
    public void saveLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().save((Object)learnerProgress);
    }

    @Override
    public void deleteLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().delete((Object)learnerProgress);
    }

    @Override
    public LearnerProgress getLearnerProgressByLearner(final Integer learnerId, final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (LearnerProgress)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_PROGRESS_BY_LEARNER).setInteger("learnerId", learnerId.intValue()).setLong("lessonId", lessonId.longValue()).uniqueResult();
            }
        });
    }

    @Override
    public void updateLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().update((Object)learnerProgress);
    }
}

