/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.notebook.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.notebook.dao.INotebookEntryDAO;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;

public class NotebookEntryDAO
extends BaseDAO
implements INotebookEntryDAO {
    private static final String SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_SIG = "from " + NotebookEntry.class.getName() + " where external_id=? and external_id_type=? and external_signature=? and user_id=?" + " order by create_date desc";
    private static final String SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_SIG_ALL = "from " + NotebookEntry.class.getName() + " where external_id=? and external_id_type=? and external_signature=?" + " order by user_id asc, create_date desc";
    private static final String SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID = "from " + NotebookEntry.class.getName() + " where external_id=? and external_id_type=? and user_id=?" + " order by create_date desc";
    private static final String SQL_QUERY_FIND_ENTRY_BY_USER_ID = "from " + NotebookEntry.class.getName() + " where user_id=?";
    private static final String SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_TYPE = "from " + NotebookEntry.class.getName() + " where user_id=? and external_id_type=?" + " order by external_signature desc, create_date desc";

    @Override
    public void saveOrUpdate(NotebookEntry notebookEntry) {
        this.getHibernateTemplate().saveOrUpdate((Object)notebookEntry);
        this.getHibernateTemplate().flush();
    }

    @Override
    public List<NotebookEntry> get(Long id, Integer idType, String signature, Integer userID) {
        return this.getHibernateTemplate().find(SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_SIG, new Object[]{id, idType, signature, userID});
    }

    @Override
    public List<NotebookEntry> get(Long id, Integer idType, String signature) {
        return this.getHibernateTemplate().find(SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_SIG_ALL, new Object[]{id, idType, signature});
    }

    @Override
    public List<NotebookEntry> get(Long id, Integer idType, Integer userID) {
        return this.getHibernateTemplate().find(SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID, new Object[]{id, idType, userID});
    }

    @Override
    public NotebookEntry get(Long uid) {
        if (uid != null) {
            Object o = this.getHibernateTemplate().get(NotebookEntry.class, (Serializable)uid);
            return (NotebookEntry)o;
        }
        return null;
    }

    @Override
    public List<NotebookEntry> get(Integer userID) {
        return this.getHibernateTemplate().find(SQL_QUERY_FIND_ENTRY_BY_USER_ID, (Object)userID);
    }

    @Override
    public List<NotebookEntry> get(Integer userID, Integer idType) {
        return this.getHibernateTemplate().find(SQL_QUERY_FIND_ENTRY_BY_EXTERNAL_ID_TYPE, new Object[]{userID, idType});
    }

    @Override
    public List<NotebookEntry> get(Integer userID, Long lessonID) {
        return null;
    }
}

