/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.test;

import com.allaire.wddx.WddxDeserializationException;
import java.util.Map;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractLamsTestCase
extends TestCase {
    protected ApplicationContext context;
    private boolean shouldFlush = true;

    public AbstractLamsTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.context = new ClassPathXmlApplicationContext(this.getContextConfigLocation());
        this.initializeHibernateSession();
    }

    protected abstract String[] getContextConfigLocation();

    protected abstract String getHibernateSessionFactoryName();

    protected void tearDown() throws Exception {
        super.tearDown();
        this.finalizeHibernateSession();
    }

    protected void initializeHibernateSession() throws HibernateException {
        SessionFactory sessionFactory = (SessionFactory)this.context.getBean(this.getHibernateSessionFactoryName());
        Session s = sessionFactory.openSession();
        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)new SessionHolder((org.hibernate.Session)s));
    }

    protected void finalizeHibernateSession() throws HibernateException {
        SessionFactory sessionFactory = (SessionFactory)this.context.getBean(this.getHibernateSessionFactoryName());
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (holder != null && this.shouldFlush) {
            org.hibernate.Session s = holder.getSession();
            s.flush();
            TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            SessionFactoryUtils.releaseSession((org.hibernate.Session)s, (SessionFactory)sessionFactory);
        }
    }

    protected org.hibernate.Session getSession() {
        SessionFactory sessionFactory = (SessionFactory)this.context.getBean(this.getHibernateSessionFactoryName());
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (holder != null) {
            return holder.getSession();
        }
        return null;
    }

    public void setShouldFlush(boolean shouldFlush) {
        this.shouldFlush = shouldFlush;
    }

    public Map extractIdMapFromWDDXPacket(String wddxPacket) {
        Object obj = null;
        try {
            obj = WDDXProcessor.deserialize(wddxPacket);
        }
        catch (WddxDeserializationException e1) {
            AbstractLamsTestCase.fail((String)("WddxDeserializationException " + e1.getMessage()));
            e1.printStackTrace();
        }
        Map map = (Map)obj;
        Object messageValueObj = map.get("messageValue");
        AbstractLamsTestCase.assertNotNull((String)"messageValue object found", messageValueObj);
        if (!Map.class.isInstance(messageValueObj)) {
            AbstractLamsTestCase.fail((String)"messageValue is not a Map - try extractIdFromWDDXPacket(packet)");
        }
        return (Map)messageValueObj;
    }

    public Long extractIdFromWDDXPacket(String wddxPacket) {
        int indexMessageValue = wddxPacket.indexOf("<var name='messageValue'><number>");
        AbstractLamsTestCase.assertTrue((String)"<var name='messageValue'><number> string found", (indexMessageValue > 0 ? 1 : 0) != 0);
        int endIndexMessageValue = wddxPacket.indexOf(".0</number></var>", indexMessageValue);
        String idString = wddxPacket.substring(indexMessageValue + 33, endIndexMessageValue);
        try {
            long id = Long.parseLong(idString);
            return new Long(id);
        }
        catch (NumberFormatException e) {
            AbstractLamsTestCase.fail((String)("Unable to get id number from WDDX packet. Format exception. String was " + idString));
            return null;
        }
    }

    protected long getMaxId(String tablename, String idname, DataSource dataSource) {
        JdbcTemplate jt = new JdbcTemplate(dataSource);
        return jt.queryForLong("SELECT max(" + idname + ") FROM " + tablename);
    }
}

