/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.themes.dao.hibernate;

import java.util.List;
import org.lamsfoundation.lams.themes.CSSThemeVisualElement;
import org.lamsfoundation.lams.themes.dao.ICSSThemeDAO;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class CSSThemeDAO
extends HibernateDaoSupport
implements ICSSThemeDAO {
    @Override
    public List getAllThemes() {
        return this.getHibernateTemplate().find("from CSSThemeVisualElement c where c.theme=true");
    }

    @Override
    public CSSThemeVisualElement getThemeById(Long themeId) {
        String queryString = "from CSSThemeVisualElement c where c.id=?";
        List list = this.getHibernateTemplate().find(queryString, (Object)themeId);
        if (list != null && list.size() > 0) {
            return (CSSThemeVisualElement)list.get(0);
        }
        return null;
    }

    @Override
    public List getThemeByName(String name) {
        String queryString = "from CSSThemeVisualElement c where c.name=? and c.theme=true";
        return this.getHibernateTemplate().find(queryString, (Object)name);
    }

    @Override
    public void saveOrUpdateTheme(CSSThemeVisualElement theme) {
        this.getHibernateTemplate().saveOrUpdate((Object)theme);
    }

    @Override
    public void deleteTheme(CSSThemeVisualElement theme) {
        this.getHibernateTemplate().delete((Object)theme);
    }

    @Override
    public void deleteThemeById(Long themeId) {
        this.getHibernateTemplate().delete((Object)this.getThemeById(themeId));
    }
}

