/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolContent;
import org.lamsfoundation.lams.tool.ToolContentIDGenerator;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.dao.ISystemToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LamsCoreToolService
implements ILamsCoreToolService,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger(LamsCoreToolService.class);
    private ApplicationContext context;
    private IToolSessionDAO toolSessionDAO;
    private ISystemToolDAO systemToolDAO;
    private ToolContentIDGenerator contentIDGenerator;
    protected IToolContentDAO toolContentDAO;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public ISystemToolDAO getSystemToolDAO() {
        return this.systemToolDAO;
    }

    public void setSystemToolDAO(ISystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public void setContentIDGenerator(ToolContentIDGenerator contentIDGenerator) {
        this.contentIDGenerator = contentIDGenerator;
    }

    @Override
    public ToolSession createToolSession(User learner, ToolActivity activity, Lesson lesson) throws LamsToolServiceException {
        ToolSession toolSession = this.toolSessionDAO.getToolSessionByLearner(learner, activity);
        if (toolSession == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating tool session for [" + activity.getActivityId() + "," + activity.getTitle() + "] for learner [" + learner.getLogin() + "] lesson [" + lesson.getLessonId() + "," + lesson.getLessonName() + "]."));
            }
            toolSession = activity.createToolSessionForActivity(learner, lesson);
            this.toolSessionDAO.saveToolSession(toolSession);
            return toolSession;
        }
        return null;
    }

    @Override
    public Set createToolSessions(Set learners, ToolActivity activity, Lesson lesson) throws LamsToolServiceException {
        Iterator iter = learners.iterator();
        HashSet<ToolSession> newToolSessions = new HashSet<ToolSession>();
        while (iter.hasNext()) {
            User learner = (User)iter.next();
            ToolSession toolSession = this.createToolSession(learner, activity, lesson);
            if (toolSession == null) continue;
            newToolSessions.add(toolSession);
        }
        return newToolSessions;
    }

    @Override
    public ToolSession getToolSessionByLearner(User learner, Activity activity) throws LamsToolServiceException {
        return this.toolSessionDAO.getToolSessionByLearner(learner, activity);
    }

    @Override
    public ToolSession getToolSessionById(Long toolSessionId) {
        return this.toolSessionDAO.getToolSession(toolSessionId);
    }

    @Override
    public ToolSession getToolSessionByActivity(User learner, ToolActivity toolActivity) throws LamsToolServiceException {
        return this.toolSessionDAO.getToolSessionByLearner(learner, toolActivity);
    }

    @Override
    public void notifyToolsToCreateSession(ToolSession toolSession, ToolActivity activity) throws ToolException {
        try {
            ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(activity.getTool());
            sessionManager.createToolSession(toolSession.getToolSessionId(), toolSession.getToolSessionName(), activity.getToolContentId());
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to create tool session. ToolActivity " + activity;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public Long notifyToolToCopyContent(ToolActivity toolActivity, boolean setDefineLater) throws DataMissingException, ToolException {
        Long newToolcontentID = this.contentIDGenerator.getNextToolContentIDFor(toolActivity.getTool());
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(toolActivity.getTool());
            contentManager.copyToolContent(toolActivity.getToolContentId(), newToolcontentID);
            if (setDefineLater && toolActivity.getDefineLater() != null && toolActivity.getDefineLater().booleanValue()) {
                contentManager.setAsDefineLater(newToolcontentID);
            }
            if (toolActivity.getRunOffline() != null && toolActivity.getRunOffline().booleanValue()) {
                contentManager.setAsRunOffline(newToolcontentID);
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to copy the tool content. ToolActivity " + toolActivity;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        return newToolcontentID;
    }

    @Override
    public Long notifyToolToCopyContent(Long toolContentId) throws DataMissingException, ToolException {
        ToolContent toolContent = (ToolContent)this.toolContentDAO.find(ToolContent.class, toolContentId);
        if (toolContent == null) {
            String error = "The toolContentID " + toolContentId + " is not valid. No such record exists on the database.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Tool tool = toolContent.getTool();
        if (tool == null) {
            String error = "The tool for toolContentId " + toolContentId + " is missing.";
            log.error((Object)error);
            throw new DataMissingException(error);
        }
        Long newToolcontentID = this.contentIDGenerator.getNextToolContentIDFor(tool);
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(tool);
            contentManager.copyToolContent(toolContentId, newToolcontentID);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to copy the tool content. ToolContentId " + toolContentId;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
        return newToolcontentID;
    }

    @Override
    public void notifyToolToDeleteContent(ToolActivity toolActivity) throws ToolException {
        try {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(toolActivity.getTool());
            contentManager.removeToolContent(toolActivity.getToolContentId(), true);
        }
        catch (NoSuchBeanDefinitionException e) {
            String message = "A tool which is defined in the database appears to missing from the classpath. Unable to delete the tool content. ToolActivity " + toolActivity;
            log.error((Object)message, (Throwable)e);
            throw new ToolException(message, e);
        }
    }

    @Override
    public void updateToolSession(ToolSession toolSession) {
        this.toolSessionDAO.updateToolSession(toolSession);
    }

    @Override
    public List getToolSessionsByLesson(Lesson lesson) {
        return this.toolSessionDAO.getToolSessionsByLesson(lesson);
    }

    @Override
    public void deleteToolSession(ToolSession toolSession) {
        if (toolSession == null) {
            log.error((Object)"deleteToolSession: unable to delete tool session as tool session is null.");
            return;
        }
        ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(toolSession.getToolActivity().getTool());
        try {
            sessionManager.removeToolSession(toolSession.getToolSessionId());
        }
        catch (DataMissingException e) {
            log.error((Object)("Unable to delete tool data for tool session " + toolSession.getToolSessionId() + " as toolSession does not exist"), (Throwable)e);
        }
        catch (ToolException e) {
            log.error((Object)("Unable to delete tool data for tool session " + toolSession.getToolSessionId() + " as tool threw an exception"), (Throwable)e);
        }
        this.toolSessionDAO.removeToolSession(toolSession);
    }

    @Override
    public String getToolLearnerURL(Long lessonID, Activity activity, User learner) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String toolURL = toolActivity.getTool().getLearnerUrl();
            return this.setupToolURLWithToolSession(toolActivity, learner, toolURL);
        }
        if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getLearnerUrl());
        }
        return null;
    }

    @Override
    public String getToolLearnerPreviewURL(Long lessonID, Activity activity, User authorLearner) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String toolURL = toolActivity.getTool().getLearnerPreviewUrl();
            return this.setupToolURLWithToolSession(toolActivity, authorLearner, toolURL);
        }
        if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getLearnerPreviewUrl());
        }
        return null;
    }

    @Override
    public String getToolLearnerProgressURL(Long lessonID, Activity activity, User learner) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String toolURL = toolActivity.getTool().getLearnerProgressUrl();
            toolURL = this.appendUserIDToURL(learner, toolURL);
            return this.setupToolURLWithToolSession(toolActivity, learner, toolURL);
        }
        if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getLearnerProgressUrl());
        }
        return null;
    }

    @Override
    public String getToolMonitoringURL(Long lessonID, Activity activity) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String url = toolActivity.getTool().getMonitorUrl();
            if (url != null) {
                return this.setupToolURLWithToolContent(toolActivity, url);
            }
        } else if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getMonitorUrl());
        }
        return null;
    }

    @Override
    public String getToolContributionURL(Long lessonID, Activity activity) throws LamsToolServiceException {
        SystemTool sysTool;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String url = toolActivity.getTool().getContributeUrl();
            if (url != null) {
                return this.setupToolURLWithToolContent(toolActivity, url);
            }
        } else if (activity.isSystemToolActivity() && (sysTool = this.systemToolDAO.getSystemToolByActivityTypeId(activity.getActivityTypeId())) != null) {
            return this.setupURLWithActivityLessonID(activity, lessonID, sysTool.getContributeUrl());
        }
        return null;
    }

    @Override
    public String getToolDefineLaterURL(ToolActivity activity) throws LamsToolServiceException {
        ToolActivity toolActivity;
        String url;
        if (activity.isToolActivity() && (url = (toolActivity = activity).getTool().getDefineLaterUrl()) != null) {
            return this.setupToolURLWithToolContent(toolActivity, url);
        }
        return null;
    }

    @Override
    public String getToolModerateURL(ToolActivity activity) throws LamsToolServiceException {
        ToolActivity toolActivity;
        String url;
        if (activity.isToolActivity() && (url = (toolActivity = activity).getTool().getModerationUrl()) != null) {
            return this.setupToolURLWithToolContent(toolActivity, url);
        }
        return null;
    }

    private String appendUserIDToURL(User user, String toolURL) {
        return WebUtil.appendParameterToURL(toolURL, "userID", user.getUserId().toString());
    }

    @Override
    public String setupToolURLWithToolSession(ToolActivity activity, User learner, String toolURL) throws LamsToolServiceException {
        ToolSession toolSession = this.getToolSessionByActivity(learner, activity);
        if (toolSession == null) {
            String error = "Unable to set up url as session does not exist. Activity " + (activity != null ? activity.getActivityId() + ":" + activity.getTitle() : "null") + " learner " + (learner != null ? learner.getUserId() + ":" + learner.getLogin() : "null");
            log.error((Object)error);
            throw new LamsToolServiceException(error);
        }
        return WebUtil.appendParameterToURL(toolURL, "toolSessionID", toolSession.getToolSessionId().toString());
    }

    public String setupURLWithActivityLessonID(Activity activity, Long lessonID, String learnerURL) {
        String url = learnerURL;
        if (url != null && activity != null) {
            url = WebUtil.appendParameterToURL(url, "activityID", activity.getActivityId().toString());
        }
        if (url != null && lessonID != null) {
            url = WebUtil.appendParameterToURL(url, "lessonID", lessonID.toString());
        }
        return url;
    }

    @Override
    public String setupToolURLWithToolContent(ToolActivity activity, String toolURL) {
        return WebUtil.appendParameterToURL(toolURL, "toolContentID", activity.getToolContentId().toString());
    }

    private Object findToolService(Tool tool) throws NoSuchBeanDefinitionException {
        return this.context.getBean(tool.getServiceName());
    }

    public void setToolContentDAO(IToolContentDAO toolContentDAO) {
        this.toolContentDAO = toolContentDAO;
    }
}

