/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.lamsfoundation.lams.themes.dto.CSSThemeBriefDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.web.session.SessionManager;

public class CSSThemeUtil {
    private static String DEFAULT_HTML_THEME = "defaultHTML";

    public static List<String> getAllUserThemes() {
        String serverDefaultTheme;
        CSSThemeBriefDTO theme;
        UserDTO user;
        ArrayList<String> themeList = new ArrayList<String>();
        themeList.add(DEFAULT_HTML_THEME);
        boolean userThemeFound = false;
        HttpSession ss = SessionManager.getSession();
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null && (theme = user.getHtmlTheme()) != null) {
            userThemeFound = true;
            String themeName = theme.getName();
            if (themeName != null && !CSSThemeUtil.isLAMSDefaultTheme(themeName)) {
                themeList.add(theme.getName());
            }
        }
        if (!userThemeFound && (serverDefaultTheme = Configuration.get(ConfigurationKeys.DEFAULT_HTML_THEME)) != null && !serverDefaultTheme.equals(DEFAULT_HTML_THEME)) {
            themeList.add(serverDefaultTheme);
        }
        return themeList;
    }

    public static CSSThemeBriefDTO getUserTheme() {
        UserDTO user;
        CSSThemeBriefDTO theme = null;
        HttpSession ss = SessionManager.getSession();
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null) {
            theme = user.getHtmlTheme();
        }
        return theme;
    }

    public static boolean isLAMSDefaultTheme(String themeName) {
        return themeName.equals(DEFAULT_HTML_THEME);
    }
}

