/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

public class DynamicProxyConverter
implements Converter {
    private ClassLoader classLoader;
    private ClassMapper classMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter;
    static /* synthetic */ Class class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy;

    public DynamicProxyConverter(ClassMapper classMapper) {
        this(classMapper, (class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter == null ? (class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter = DynamicProxyConverter.class$("com.thoughtworks.xstream.converters.extended.DynamicProxyConverter")) : class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter).getClassLoader());
    }

    public DynamicProxyConverter(ClassMapper classMapper, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.classMapper = classMapper;
    }

    public boolean canConvert(Class type) {
        return type.equals(class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy == null ? (class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy = DynamicProxyConverter.class$("com.thoughtworks.xstream.alias.ClassMapper$DynamicProxy")) : class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy) || Proxy.isProxyClass(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(source);
        this.addInterfacesToXml(source, writer);
        writer.startNode("handler");
        writer.addAttribute("class", this.classMapper.lookupName(invocationHandler.getClass()));
        context.convertAnother(invocationHandler);
        writer.endNode();
    }

    private void addInterfacesToXml(Object source, HierarchicalStreamWriter writer) {
        Class<?>[] interfaces = source.getClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> currentInterface = interfaces[i];
            writer.startNode("interface");
            writer.setValue(this.classMapper.lookupName(currentInterface));
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        InvocationHandler handler = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String elementName = reader.getNodeName();
            if (elementName.equals("interface")) {
                interfaces.add(this.classMapper.lookupType(reader.getValue()));
            } else if (elementName.equals("handler")) {
                Class handlerType = this.classMapper.lookupType(reader.getAttribute("class"));
                handler = (InvocationHandler)context.convertAnother(null, handlerType);
            }
            reader.moveUp();
        }
        if (handler == null) {
            throw new ConversionException("No InvocationHandler specified for dynamic proxy");
        }
        Class[] interfacesAsArray = new Class[interfaces.size()];
        interfaces.toArray(interfacesAsArray);
        return Proxy.newProxyInstance(this.classLoader, interfacesAsArray, handler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

