/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.util.FastStack;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class CustomObjectOutputStream
extends ObjectOutputStream {
    private StreamCallback callback;
    private FastStack customFields = new FastStack(1);
    private static final String DATA_HOLDER_KEY = (class$com$thoughtworks$xstream$core$util$CustomObjectOutputStream == null ? (class$com$thoughtworks$xstream$core$util$CustomObjectOutputStream = CustomObjectOutputStream.class$("com.thoughtworks.xstream.core.util.CustomObjectOutputStream")) : class$com$thoughtworks$xstream$core$util$CustomObjectOutputStream).getName();
    static /* synthetic */ Class class$com$thoughtworks$xstream$core$util$CustomObjectOutputStream;

    public static synchronized CustomObjectOutputStream getInstance(DataHolder whereFrom, StreamCallback callback) {
        try {
            CustomObjectOutputStream result = (CustomObjectOutputStream)whereFrom.get(DATA_HOLDER_KEY);
            if (result == null) {
                result = new CustomObjectOutputStream(callback);
                whereFrom.put(DATA_HOLDER_KEY, result);
            } else {
                result.setCallback(callback);
            }
            return result;
        }
        catch (IOException e) {
            throw new ConversionException("Cannot create CustomObjectStream", e);
        }
    }

    public CustomObjectOutputStream(StreamCallback callback) throws IOException, SecurityException {
        this.callback = callback;
    }

    public void setCallback(StreamCallback callback) {
        this.callback = callback;
    }

    public void defaultWriteObject() throws IOException {
        this.callback.defaultWriteObject();
    }

    protected void writeObjectOverride(Object obj) throws IOException {
        this.callback.writeToStream(obj);
    }

    public void writeBoolean(boolean val) throws IOException {
        this.callback.writeToStream(new Boolean(val));
    }

    public void writeByte(int val) throws IOException {
        this.callback.writeToStream(new Byte((byte)val));
    }

    public void writeInt(int val) throws IOException {
        this.callback.writeToStream(new Integer(val));
    }

    public void writeChar(int val) throws IOException {
        this.callback.writeToStream(new Character((char)val));
    }

    public void writeDouble(double val) throws IOException {
        this.callback.writeToStream(new Double(val));
    }

    public void writeFloat(float val) throws IOException {
        this.callback.writeToStream(new Float(val));
    }

    public void writeLong(long val) throws IOException {
        this.callback.writeToStream(new Long(val));
    }

    public void writeShort(int val) throws IOException {
        this.callback.writeToStream(new Short((short)val));
    }

    public void write(byte[] buf) throws IOException {
        this.callback.writeToStream(buf);
    }

    public void writeChars(String str) throws IOException {
        this.callback.writeToStream(str.toCharArray());
    }

    public void writeUTF(String str) throws IOException {
        this.callback.writeToStream(str);
    }

    public void write(int val) throws IOException {
        this.callback.writeToStream(new Byte((byte)val));
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = buf[i + off];
        }
        this.callback.writeToStream(b);
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.callback.close();
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        CustomPutField result = new CustomPutField();
        this.customFields.push(result);
        return result;
    }

    public void writeFields() throws IOException {
        CustomPutField customPutField = (CustomPutField)this.customFields.pop();
        this.callback.writeFieldsToStream(customPutField.asMap());
    }

    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void useProtocolVersion(int version) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBytes(String str) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeUnshared(Object obj) throws IOException {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CustomPutField
    extends ObjectOutputStream.PutField {
        private final Map fields = new HashMap();

        private CustomPutField() {
        }

        public Map asMap() {
            return this.fields;
        }

        public void write(ObjectOutput out) throws IOException {
            CustomObjectOutputStream.this.callback.writeToStream(this.asMap());
        }

        public void put(String name, Object val) {
            this.fields.put(name, val);
        }

        public void put(String name, byte val) {
            this.put(name, new Byte(val));
        }

        public void put(String name, char val) {
            this.put(name, new Character(val));
        }

        public void put(String name, double val) {
            this.put(name, new Double(val));
        }

        public void put(String name, float val) {
            this.put(name, new Float(val));
        }

        public void put(String name, int val) {
            this.put(name, new Integer(val));
        }

        public void put(String name, long val) {
            this.put(name, new Long(val));
        }

        public void put(String name, short val) {
            this.put(name, new Short(val));
        }

        public void put(String name, boolean val) {
            this.put(name, new Boolean(val));
        }
    }

    public static interface StreamCallback {
        public void writeToStream(Object var1) throws IOException;

        public void writeFieldsToStream(Map var1) throws IOException;

        public void defaultWriteObject() throws IOException;

        public void close() throws IOException;
    }
}

