/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.path;

import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.path.PathTracker;

public class PathTrackingReader
implements HierarchicalStreamReader {
    private HierarchicalStreamReader reader;
    private PathTracker pathTracker;

    public PathTrackingReader(HierarchicalStreamReader reader, PathTracker pathTracker) {
        this.reader = reader;
        this.pathTracker = pathTracker;
        pathTracker.pushElement(this.getNodeName());
    }

    public boolean hasMoreChildren() {
        return this.reader.hasMoreChildren();
    }

    public void moveDown() {
        this.reader.moveDown();
        this.pathTracker.pushElement(this.getNodeName());
    }

    public void moveUp() {
        this.reader.moveUp();
        this.pathTracker.popElement();
    }

    public String getNodeName() {
        return this.reader.getNodeName();
    }

    public String getValue() {
        return this.reader.getValue();
    }

    public String getAttribute(String name) {
        return this.reader.getAttribute(name);
    }

    public Object peekUnderlyingNode() {
        return this.reader.peekUnderlyingNode();
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("path", this.pathTracker.getCurrentPath());
        this.reader.appendErrors(errorWriter);
    }
}

