/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.dynamic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import junit.framework.AssertionFailedError;
import org.jmock.Constraint;
import org.jmock.constraint.IsAnything;
import org.jmock.dynamic.DynamicMock;
import org.jmock.dynamic.DynamicMockError;
import org.jmock.dynamic.DynamicUtil;
import org.jmock.dynamic.Invocation;
import org.jmock.dynamic.InvocationDispatcher;
import org.jmock.dynamic.InvocationMatcher;
import org.jmock.dynamic.InvocationMocker;
import org.jmock.dynamic.Invokable;
import org.jmock.dynamic.Stub;
import org.jmock.dynamic.matcher.ArgumentsMatcher;
import org.jmock.dynamic.matcher.NoArgumentsMatcher;
import org.jmock.dynamic.stub.CustomStub;
import org.jmock.dynamic.stub.ReturnStub;

public class CoreMock
implements DynamicMock,
InvocationHandler {
    private InvocationDispatcher invocationDispatcher;
    private Class mockedType;
    private Object proxy;
    private String name;

    public CoreMock(Class mockedType, String name, InvocationDispatcher invocationDispatcher) {
        this.mockedType = mockedType;
        this.proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{mockedType}, (InvocationHandler)this);
        this.name = name;
        this.invocationDispatcher = invocationDispatcher;
        this.setupDefaultBehaviour();
    }

    public Class getMockedType() {
        return this.mockedType;
    }

    public Object proxy() {
        return this.proxy;
    }

    public Object invoke(Object invokedProxy, Method method, Object[] args) throws Throwable {
        Invocation invocation = new Invocation(invokedProxy, method, args);
        try {
            return this.invocationDispatcher.dispatch(invocation);
        }
        catch (AssertionFailedError failure) {
            DynamicMockError mockFailure = new DynamicMockError(this, invocation, this.invocationDispatcher, failure.getMessage());
            mockFailure.fillInStackTrace();
            throw mockFailure;
        }
    }

    public void verify() {
        try {
            this.invocationDispatcher.verify();
        }
        catch (AssertionFailedError ex) {
            throw new AssertionFailedError(this.name + ": " + ex.getMessage());
        }
    }

    public String toString() {
        return this.name;
    }

    public String getMockName() {
        return this.name;
    }

    public void setDefaultStub(Stub newDefaultStub) {
        this.invocationDispatcher.setDefaultStub(newDefaultStub);
    }

    public void add(Invokable invokable) {
        this.invocationDispatcher.add(invokable);
    }

    public void reset() {
        this.invocationDispatcher.clear();
        this.setupDefaultBehaviour();
    }

    public static String mockNameFromClass(Class c) {
        return "mock" + DynamicUtil.classShortName(c);
    }

    private void setupDefaultBehaviour() {
        this.add(new SilentInvocationMocker("toString", NoArgumentsMatcher.INSTANCE, new ReturnStub(this.name)));
        this.add(new SilentInvocationMocker("equals", new ArgumentsMatcher(new Constraint[]{new IsAnything()}), new IsSameAsProxyStub()));
        this.add(new SilentInvocationMocker("hashCode", NoArgumentsMatcher.INSTANCE, new HashCodeStub()));
    }

    private class HashCodeStub
    extends CustomStub {
        private HashCodeStub() {
            super("returns hashCode for proxy");
        }

        public Object invoke(Invocation invocation) throws Throwable {
            return new Integer(CoreMock.this.hashCode());
        }
    }

    private class IsSameAsProxyStub
    extends CustomStub {
        private IsSameAsProxyStub() {
            super("returns whether equal to proxy");
        }

        public Object invoke(Invocation invocation) throws Throwable {
            return new Boolean(invocation.getParameterValues().get(0) == CoreMock.this.proxy);
        }
    }

    private static class SilentInvocationMocker
    extends InvocationMocker {
        public SilentInvocationMocker(String methodName, InvocationMatcher arguments, Stub stub) {
            super(methodName, arguments, stub);
        }

        public StringBuffer writeTo(StringBuffer buffer) {
            return buffer;
        }
    }
}

