/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.dynamic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.jmock.dynamic.BuildableInvokable;
import org.jmock.dynamic.Invocation;
import org.jmock.dynamic.InvocationMatcher;
import org.jmock.dynamic.Stub;
import org.jmock.dynamic.matcher.MethodNameMatcher;
import org.jmock.dynamic.stub.VoidStub;

public class InvocationMocker
implements BuildableInvokable {
    private String name;
    private List matchers = new ArrayList();
    private Stub stub;

    public InvocationMocker(String methodName, InvocationMatcher arguments, Stub stub) {
        this(stub);
        this.addMatcher(new MethodNameMatcher(methodName));
        this.addMatcher(arguments);
    }

    public InvocationMocker(InvocationMatcher[] matchers, Stub stub) {
        this(stub);
        for (int i = 0; i < matchers.length; ++i) {
            this.addMatcher(matchers[i]);
        }
    }

    public InvocationMocker(Stub stub) {
        this.stub = stub;
    }

    public InvocationMocker() {
        this(VoidStub.INSTANCE);
    }

    public boolean matches(Invocation invocation) {
        Iterator i = this.matchers.iterator();
        while (i.hasNext()) {
            if (((InvocationMatcher)i.next()).matches(invocation)) continue;
            return false;
        }
        return true;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Iterator i = this.matchers.iterator();
        while (i.hasNext()) {
            ((InvocationMatcher)i.next()).invoked(invocation);
        }
        return this.stub.invoke(invocation);
    }

    public void verify() {
        try {
            Iterator i = this.matchers.iterator();
            while (i.hasNext()) {
                ((InvocationMatcher)i.next()).verify();
            }
        }
        catch (AssertionFailedError error) {
            AssertionFailedError newError = new AssertionFailedError(error.getMessage() + " " + this.toString());
            newError.fillInStackTrace();
            throw newError;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addMatcher(InvocationMatcher matcher) {
        this.matchers.add(matcher);
    }

    public void setStub(Stub stub) {
        this.stub = stub;
    }

    public StringBuffer writeTo(StringBuffer buffer) {
        Iterator it = this.matchers.iterator();
        while (it.hasNext()) {
            int oldLength = buffer.length();
            ((InvocationMatcher)it.next()).writeTo(buffer);
            if (buffer.length() == oldLength) continue;
            buffer.append(", ");
        }
        this.stub.writeTo(buffer);
        if (this.name != null) {
            buffer.append(" [").append(this.name).append("]");
        }
        return buffer.append("\n");
    }

    public String toString() {
        return this.writeTo(new StringBuffer()).toString();
    }
}

