/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.examples.calculator;

import org.jmock.examples.calculator.CalculatorException;
import org.jmock.examples.calculator.Environment;
import org.jmock.examples.calculator.Expression;
import org.jmock.examples.calculator.InfixParser;
import org.jmock.examples.calculator.Parser;
import org.jmock.examples.calculator.SimpleEnvironment;

public class Calculator {
    private Parser parser;
    private Environment environment;

    public double calculate(String expressionString) throws CalculatorException {
        Expression expression = this.parser.parse(expressionString);
        return expression.evaluate(this.environment);
    }

    public void setVariable(String name, String valueString) throws CalculatorException {
        this.environment.setVariable(name, this.parser.parse(valueString));
    }

    public Calculator() {
        this.environment = new SimpleEnvironment();
        this.parser = new InfixParser();
    }

    public Calculator(Parser parser, Environment environment) {
        this.parser = parser;
        this.environment = environment;
    }
}

