/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.IObjectExtractor;
import org.lamsfoundation.lams.authoring.ObjectExtractorException;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.TransitionDAO;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.dao.hibernate.SystemToolDAO;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;
import org.lamsfoundation.lams.web.session.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectExtractor
implements IObjectExtractor {
    protected BaseDAO baseDAO = null;
    protected LearningDesignDAO learningDesignDAO = null;
    protected ActivityDAO activityDAO = null;
    protected TransitionDAO transitionDAO = null;
    protected LearningLibraryDAO learningLibraryDAO = null;
    protected LicenseDAO licenseDAO = null;
    protected GroupingDAO groupingDAO = null;
    protected ToolDAO toolDAO = null;
    protected SystemToolDAO systemToolDAO = null;
    protected GroupDAO groupDAO = null;
    private Integer mode = null;
    protected HashMap<Integer, Activity> newActivityMap = new HashMap();
    protected HashMap<Integer, Grouping> groupings = new HashMap();
    protected Set<Grouping> groupingsToDelete = new HashSet<Grouping>();
    protected LearningDesign learningDesign = null;
    protected Logger log = Logger.getLogger(ObjectExtractor.class);

    public ObjectExtractor() {
    }

    public ObjectExtractor(BaseDAO baseDAO, LearningDesignDAO learningDesignDAO, ActivityDAO activityDAO, LearningLibraryDAO learningLibraryDAO, LicenseDAO licenseDAO, GroupingDAO groupingDAO, ToolDAO toolDAO, SystemToolDAO systemToolDAO, GroupDAO groupDAO, TransitionDAO transitionDAO) {
        this.baseDAO = baseDAO;
        this.learningDesignDAO = learningDesignDAO;
        this.activityDAO = activityDAO;
        this.learningLibraryDAO = learningLibraryDAO;
        this.licenseDAO = licenseDAO;
        this.groupingDAO = groupingDAO;
        this.toolDAO = toolDAO;
        this.systemToolDAO = systemToolDAO;
        this.groupDAO = groupDAO;
        this.transitionDAO = transitionDAO;
    }

    public ActivityDAO getActivityDAO() {
        return this.activityDAO;
    }

    public void setActivityDAO(ActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public GroupDAO getGroupDAO() {
        return this.groupDAO;
    }

    public void setGroupDAO(GroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public GroupingDAO getGroupingDAO() {
        return this.groupingDAO;
    }

    public void setGroupingDAO(GroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public LearningDesignDAO getLearningDesignDAO() {
        return this.learningDesignDAO;
    }

    public void setLearningDesignDAO(LearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public LearningLibraryDAO getLearningLibraryDAO() {
        return this.learningLibraryDAO;
    }

    public void setLearningLibraryDAO(LearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public LicenseDAO getLicenseDAO() {
        return this.licenseDAO;
    }

    public void setLicenseDAO(LicenseDAO licenseDAO) {
        this.licenseDAO = licenseDAO;
    }

    public HashMap<Integer, Activity> getNewActivityMap() {
        return this.newActivityMap;
    }

    public void setNewActivityMap(HashMap<Integer, Activity> newActivityMap) {
        this.newActivityMap = newActivityMap;
    }

    public ToolDAO getToolDAO() {
        return this.toolDAO;
    }

    public void setToolDAO(ToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public SystemToolDAO getSystemToolDAO() {
        return this.systemToolDAO;
    }

    public void setSystemToolDAO(SystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public TransitionDAO getTransitionDAO() {
        return this.transitionDAO;
    }

    public void setTransitionDAO(TransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public BaseDAO getBaseDAO() {
        return this.baseDAO;
    }

    public void setBaseDAO(BaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    @Override
    public LearningDesign extractSaveLearningDesign(Hashtable table) throws WDDXProcessorConversionException, ObjectExtractorException {
        Integer userId;
        this.learningDesign = null;
        Long learningDesignId = WDDXProcessor.convertToLong((Hashtable)table, (String)"learningDesignID");
        this.learningDesign = learningDesignId != null ? this.learningDesignDAO.getLearningDesignById(learningDesignId) : new LearningDesign();
        Integer copyTypeID = WDDXProcessor.convertToInteger((Hashtable)table, (String)"copyTypeID");
        if (copyTypeID == null) {
            copyTypeID = 1;
        }
        if (this.learningDesign != null && this.learningDesign.getCopyTypeID() != null && !this.learningDesign.getCopyTypeID().equals(copyTypeID)) {
            throw new ObjectExtractorException("Unable to save learning design.  Cannot change copy type on existing design.");
        }
        if (!copyTypeID.equals(1)) {
            throw new ObjectExtractorException("Unable to save learning design.  Learning design is read-only");
        }
        this.learningDesign.setCopyTypeID(copyTypeID);
        this.initialiseGroupings();
        this.learningDesign.setValidDesign(Boolean.FALSE);
        if (this.keyExists(table, "learningDesignUIID")) {
            this.learningDesign.setLearningDesignUIID(WDDXProcessor.convertToInteger((Hashtable)table, (String)"learningDesignUIID"));
        }
        if (this.keyExists(table, "description")) {
            this.learningDesign.setDescription(WDDXProcessor.convertToString((Hashtable)table, (String)"description"));
        }
        if (this.keyExists(table, "title")) {
            this.learningDesign.setTitle(WDDXProcessor.convertToString((Hashtable)table, (String)"title"));
        }
        if (this.keyExists(table, "maxID")) {
            this.learningDesign.setMaxID(WDDXProcessor.convertToInteger((Hashtable)table, (String)"maxID"));
        }
        if (this.keyExists(table, "validDesign")) {
            this.learningDesign.setValidDesign(WDDXProcessor.convertToBoolean((Hashtable)table, (String)"validDesign"));
        }
        if (this.keyExists(table, "readOnly")) {
            this.learningDesign.setReadOnly(WDDXProcessor.convertToBoolean((Hashtable)table, (String)"readOnly"));
        }
        if (this.keyExists(table, "dateReadOnly")) {
            this.learningDesign.setDateReadOnly(WDDXProcessor.convertToDate((Hashtable)table, (String)"dateReadOnly"));
        }
        if (this.keyExists(table, "offlineInstructions")) {
            this.learningDesign.setOfflineInstructions(WDDXProcessor.convertToString((Hashtable)table, (String)"offlineInstructions"));
        }
        if (this.keyExists(table, "onlineInstructions")) {
            this.learningDesign.setOnlineInstructions(WDDXProcessor.convertToString((Hashtable)table, (String)"onlineInstructions"));
        }
        if (this.keyExists(table, "helpText")) {
            this.learningDesign.setHelpText(WDDXProcessor.convertToString((Hashtable)table, (String)"helpText"));
        }
        if (this.keyExists(table, "createDateTime")) {
            this.learningDesign.setCreateDateTime(WDDXProcessor.convertToDate((Hashtable)table, (String)"createDateTime"));
        }
        this.learningDesign.setVersion(Configuration.get((String)ConfigurationKeys.VERSION));
        if (this.keyExists(table, "duration")) {
            this.learningDesign.setDuration(WDDXProcessor.convertToLong((Hashtable)table, (String)"duration"));
        }
        if (this.keyExists(table, "lastModifiedDateTime")) {
            this.learningDesign.setLastModifiedDateTime(WDDXProcessor.convertToDate((Hashtable)table, (String)"lastModifiedDateTime"));
        }
        if (this.keyExists(table, "duration")) {
            this.learningDesign.setDuration(WDDXProcessor.convertToLong((Hashtable)table, (String)"duration"));
        }
        if (this.keyExists(table, "contentFolderID")) {
            this.learningDesign.setContentFolderID(WDDXProcessor.convertToString((Hashtable)table, (String)"contentFolderID"));
        }
        if (this.keyExists(table, "saveMode")) {
            this.mode = WDDXProcessor.convertToInteger((Hashtable)table, (String)"saveMode");
        }
        if ((userId = ObjectExtractor.getUserId()) != null) {
            User user = (User)this.baseDAO.find(User.class, (Serializable)userId);
            if (user != null) {
                this.learningDesign.setUser(user);
            } else {
                throw new ObjectExtractorException("userID missing");
            }
        }
        if (this.keyExists(table, "licenseID")) {
            Long licenseID = WDDXProcessor.convertToLong((Hashtable)table, (String)"licenseID");
            if (licenseID != null) {
                License license = this.licenseDAO.getLicenseByID(licenseID);
                this.learningDesign.setLicense(license);
            } else {
                this.learningDesign.setLicense(null);
            }
        }
        if (this.keyExists(table, "licenseText")) {
            this.learningDesign.setLicenseText(WDDXProcessor.convertToString((Hashtable)table, (String)"licenseText"));
        }
        if (this.keyExists(table, "workspaceFolderID")) {
            Integer workspaceFolderID = WDDXProcessor.convertToInteger((Hashtable)table, (String)"workspaceFolderID");
            if (workspaceFolderID != null) {
                WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
                this.learningDesign.setWorkspaceFolder(workspaceFolder);
            } else {
                this.learningDesign.setWorkspaceFolder(null);
            }
        }
        if (this.keyExists(table, "originalLearningDesignID")) {
            Long parentLearningDesignID = WDDXProcessor.convertToLong((Hashtable)table, (String)"originalLearningDesignID");
            if (parentLearningDesignID != null) {
                LearningDesign parent = this.learningDesignDAO.getLearningDesignById(parentLearningDesignID);
                this.learningDesign.setOriginalLearningDesign(parent);
            } else {
                this.learningDesign.setOriginalLearningDesign(null);
            }
        }
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
        this.parseGroupings((Vector)table.get("groupings"));
        this.parseActivities((Vector)table.get("activities"));
        this.parseActivitiesToMatchUpParentActivityByParentUIID((Vector)table.get("activities"));
        this.parseTransitions((Vector)table.get("transitions"));
        this.learningDesign.setFirstActivity(this.learningDesign.calculateFirstActivity());
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
        this.deleteUnwantedGroupings();
        return this.learningDesign;
    }

    private void initialiseGroupings() {
        List dbGroupings = this.groupingDAO.getGroupingsByLearningDesign(this.learningDesign.getLearningDesignId());
        for (Grouping grouping : dbGroupings) {
            this.groupings.put(grouping.getGroupingUIID(), grouping);
        }
    }

    private void deleteUnwantedGroupings() {
        for (Grouping grouping : this.groupingsToDelete) {
            this.groupingDAO.delete((Object)grouping);
        }
    }

    private void parseGroupings(List groupingsList) throws WDDXProcessorConversionException {
        if (groupingsList != null) {
            for (Hashtable groupingDetails : groupingsList) {
                if (groupingDetails == null) continue;
                Grouping grouping = this.extractGroupingObject(groupingDetails);
                this.groupingDAO.insertOrUpdate((Object)grouping);
                this.groupings.put(grouping.getGroupingUIID(), grouping);
            }
        }
    }

    public Grouping extractGroupingObject(Hashtable groupingDetails) throws WDDXProcessorConversionException {
        Integer groupingUUID = WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"groupingUIID");
        Integer groupingTypeID = WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"groupingTypeID");
        if (groupingTypeID == null) {
            throw new WDDXProcessorConversionException("groupingTypeID is missing");
        }
        Grouping grouping = this.groupings.get(groupingUUID);
        if (grouping != null && !grouping.getGroupingTypeId().equals(groupingTypeID)) {
            this.groupings.remove(grouping.getGroupingUIID());
            this.groupingsToDelete.add(grouping);
            grouping = null;
        }
        if (grouping == null) {
            Object object = Grouping.getGroupingInstance((Integer)groupingTypeID);
            grouping = (Grouping)object;
            if (this.keyExists(groupingDetails, "groupingID")) {
                grouping.setGroupingId(WDDXProcessor.convertToLong((Hashtable)groupingDetails, (String)"groupingID"));
            }
            if (this.keyExists(groupingDetails, "groupingUIID")) {
                grouping.setGroupingUIID(WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"groupingUIID"));
            }
        }
        if (grouping.isRandomGrouping()) {
            this.createRandomGrouping((RandomGrouping)grouping, groupingDetails);
        } else if (grouping.isChosenGrouping()) {
            this.createChosenGrouping((ChosenGrouping)grouping, groupingDetails);
        } else {
            this.createLessonClass((LessonClass)grouping, groupingDetails);
        }
        if (this.keyExists(groupingDetails, "maxNumberOfGroups")) {
            grouping.setMaxNumberOfGroups(WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"maxNumberOfGroups"));
        }
        return grouping;
    }

    private void createRandomGrouping(RandomGrouping randomGrouping, Hashtable groupingDetails) throws WDDXProcessorConversionException {
        if (this.keyExists(groupingDetails, "learnersPerGroup")) {
            randomGrouping.setLearnersPerGroup(WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"learnersPerGroup"));
        }
        if (this.keyExists(groupingDetails, "numberOfGroups")) {
            randomGrouping.setNumberOfGroups(WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"numberOfGroups"));
        }
    }

    private void createChosenGrouping(ChosenGrouping chosenGrouping, Hashtable groupingDetails) throws WDDXProcessorConversionException {
    }

    private void parseActivities(List activitiesList) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (activitiesList != null) {
            for (Hashtable activityDetails : activitiesList) {
                Activity activity = this.extractActivityObject(activityDetails);
                this.activityDAO.insertOrUpdate((Object)activity);
                this.newActivityMap.put(activity.getActivityUIID(), activity);
            }
        }
        this.learningDesign.getActivities().clear();
        this.learningDesign.getActivities().addAll(this.newActivityMap.values());
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
    }

    private void parseActivitiesToMatchUpParentActivityByParentUIID(List activitiesList) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (activitiesList != null) {
            for (Hashtable activityDetails : activitiesList) {
                Integer activityUUID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityUIID");
                Activity existingActivity = this.newActivityMap.get(activityUUID);
                if (this.keyExists(activityDetails, "parentUIID")) {
                    Integer parentUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"parentUIID");
                    if (parentUIID != null) {
                        Activity parentActivity = this.newActivityMap.get(parentUIID);
                        if (parentActivity == null) {
                            throw new ObjectExtractorException("Parent activity " + parentUIID + " missing for activity " + existingActivity.getTitle() + ": " + existingActivity.getActivityUIID());
                        }
                        existingActivity.setParentActivity(parentActivity);
                        existingActivity.setParentUIID(parentUIID);
                        if (parentActivity.isComplexActivity()) {
                            ((ComplexActivity)parentActivity).addActivity(existingActivity);
                            this.activityDAO.update((Object)parentActivity);
                        }
                    } else {
                        existingActivity.setParentActivity(null);
                        existingActivity.setParentUIID(null);
                        existingActivity.setOrderId(null);
                    }
                }
                this.activityDAO.update((Object)existingActivity);
            }
        }
    }

    private void parseTransitions(List transitionsList) throws WDDXProcessorConversionException {
        HashMap<Integer, Transition> newMap = new HashMap<Integer, Transition>();
        if (transitionsList != null) {
            for (Hashtable transitionDetails : transitionsList) {
                Transition transition = this.extractTransitionObject(transitionDetails);
                if (transition == null) continue;
                this.transitionDAO.insertOrUpdate((Object)transition);
                newMap.put(transition.getTransitionUIID(), transition);
            }
        }
        for (Transition element : this.learningDesign.getTransitions()) {
            Integer uiID = element.getTransitionUIID();
            Transition match = (Transition)newMap.get(uiID);
            if (match != null) continue;
            this.cleanupTransition(element);
        }
        this.learningDesign.getTransitions().clear();
        this.learningDesign.getTransitions().addAll(newMap.values());
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
    }

    public Activity extractActivityObject(Hashtable activityDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        Integer activityUUID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityUIID");
        Activity activity = null;
        Integer activityTypeID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityTypeID");
        if (activityTypeID == null) {
            throw new ObjectExtractorException("activityTypeID missing");
        }
        Activity existingActivity = this.activityDAO.getActivityByUIID(activityUUID, this.learningDesign);
        if (existingActivity != null && !existingActivity.getActivityTypeId().equals(activityTypeID)) {
            existingActivity = null;
        }
        activity = existingActivity != null ? existingActivity : Activity.getActivityInstance((int)activityTypeID);
        this.processActivityType(activity, activityDetails);
        if (this.keyExists(activityDetails, "activityTypeID")) {
            activity.setActivityTypeId(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityTypeID"));
        }
        if (this.keyExists(activityDetails, "activityUIID")) {
            activity.setActivityUIID(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityUIID"));
        }
        if (this.keyExists(activityDetails, "description")) {
            activity.setDescription(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"description"));
        }
        if (this.keyExists(activityDetails, "activityTitle")) {
            activity.setTitle(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"activityTitle"));
        }
        if (this.keyExists(activityDetails, "helpText")) {
            activity.setHelpText(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"helpText"));
        }
        if (this.keyExists(activityDetails, "xCoord")) {
            activity.setXcoord(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"xCoord"));
        }
        if (this.keyExists(activityDetails, "yCoord")) {
            activity.setYcoord(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"yCoord"));
        }
        if (this.keyExists(activityDetails, "groupingUIID")) {
            Integer groupingUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"groupingUIID");
            if (groupingUIID != null) {
                Grouping grouping = this.groupings.get(groupingUIID);
                if (grouping != null) {
                    this.setGrouping(activity, grouping, groupingUIID);
                } else {
                    this.log.warn((Object)("Unable to find matching grouping for groupingUIID" + groupingUIID + ". Activity UUID" + activityUUID + " will not be grouped."));
                    this.clearGrouping(activity);
                }
            } else {
                this.clearGrouping(activity);
            }
        } else {
            this.clearGrouping(activity);
        }
        if (this.keyExists(activityDetails, "orderID")) {
            activity.setOrderId(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"orderID"));
        }
        if (this.keyExists(activityDetails, "defineLater")) {
            activity.setDefineLater(WDDXProcessor.convertToBoolean((Hashtable)activityDetails, (String)"defineLater"));
        }
        activity.setLearningDesign(this.learningDesign);
        if (this.keyExists(activityDetails, "learningLibraryID")) {
            Long learningLibraryID = WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"learningLibraryID");
            if (learningLibraryID != null) {
                LearningLibrary library = this.learningLibraryDAO.getLearningLibraryById(learningLibraryID);
                activity.setLearningLibrary(library);
            } else {
                activity.setLearningLibrary(null);
            }
        }
        if (this.keyExists(activityDetails, "createDateTime")) {
            activity.setCreateDateTime(WDDXProcessor.convertToDate((Hashtable)activityDetails, (String)"createDateTime"));
        }
        if (this.keyExists(activityDetails, "runOffline")) {
            activity.setRunOffline(WDDXProcessor.convertToBoolean((Hashtable)activityDetails, (String)"runOffline"));
        }
        if (this.keyExists(activityDetails, "activityCategoryID")) {
            activity.setActivityCategoryID(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityCategoryID"));
        }
        if (this.keyExists(activityDetails, "libraryActivityUIImage")) {
            activity.setLibraryActivityUiImage(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"libraryActivityUIImage"));
        }
        if (this.keyExists(activityDetails, "groupingSupportType")) {
            activity.setGroupingSupportType(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"groupingSupportType"));
        }
        return activity;
    }

    private void clearGrouping(Activity activity) {
        activity.setGrouping(null);
        activity.setGroupingUIID(null);
        activity.setApplyGrouping(Boolean.valueOf(false));
    }

    private void setGrouping(Activity activity, Grouping grouping, Integer groupingUIID) {
        activity.setGrouping(grouping);
        activity.setGroupingUIID(groupingUIID);
        activity.setApplyGrouping(Boolean.valueOf(true));
    }

    private void processActivityType(Activity activity, Hashtable activityDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (activity.isGroupingActivity()) {
            this.buildGroupingActivity((GroupingActivity)activity, activityDetails);
        } else if (activity.isToolActivity()) {
            this.buildToolActivity((ToolActivity)activity, activityDetails);
        } else if (activity.isGateActivity()) {
            this.buildGateActivity(activity, activityDetails);
        } else {
            this.buildComplexActivity((ComplexActivity)activity, activityDetails);
        }
    }

    private void buildComplexActivity(ComplexActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        activity.getActivities().clear();
        if (activity instanceof OptionsActivity) {
            this.buildOptionsActivity((OptionsActivity)activity, activityDetails);
        } else if (activity instanceof ParallelActivity) {
            this.buildParallelActivity((ParallelActivity)activity, activityDetails);
        } else {
            this.buildSequenceActivity((SequenceActivity)activity, activityDetails);
        }
    }

    private void buildGroupingActivity(GroupingActivity groupingActivity, Hashtable activityDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        Integer createGroupingUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"createGroupingUIID");
        Grouping grouping = this.groupings.get(createGroupingUIID);
        if (grouping != null) {
            groupingActivity.setCreateGrouping(grouping);
            groupingActivity.setCreateGroupingUIID(createGroupingUIID);
        }
        SystemTool systemTool = this.systemToolDAO.getSystemToolByID(SystemTool.GROUPING);
        groupingActivity.setSystemTool(systemTool);
    }

    private void buildOptionsActivity(OptionsActivity optionsActivity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        if (this.keyExists(activityDetails, "maxOptions")) {
            optionsActivity.setMaxNumberOfOptions(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"maxOptions"));
        }
        if (this.keyExists(activityDetails, "minOptions")) {
            optionsActivity.setMinNumberOfOptions(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"minOptions"));
        }
        if (this.keyExists(activityDetails, "optionsInstructions")) {
            optionsActivity.setOptionsInstructions(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"optionsInstructions"));
        }
    }

    private void buildParallelActivity(ParallelActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
    }

    private void buildSequenceActivity(SequenceActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
    }

    private void buildToolActivity(ToolActivity toolActivity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("In tool activity UUID" + activityDetails.get("activityUIID") + " tool content id=" + activityDetails.get("toolContentID")));
        }
        if (this.keyExists(activityDetails, "toolContentID")) {
            toolActivity.setToolContentId(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"toolContentID"));
        }
        if (this.keyExists(activityDetails, "toolID")) {
            Tool tool = this.toolDAO.getToolByID(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"toolID"));
            toolActivity.setTool(tool);
        }
    }

    private void buildGateActivity(Object activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        if (activity instanceof SynchGateActivity) {
            this.buildSynchGateActivity((SynchGateActivity)activity, activityDetails);
        } else if (activity instanceof PermissionGateActivity) {
            this.buildPermissionGateActivity((PermissionGateActivity)activity, activityDetails);
        } else {
            this.buildScheduleGateActivity((ScheduleGateActivity)activity, activityDetails);
        }
        GateActivity gateActivity = (GateActivity)activity;
        gateActivity.setGateActivityLevelId(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"gateActivityLevelID"));
        gateActivity.setGateOpen(WDDXProcessor.convertToBoolean((Hashtable)activityDetails, (String)"gateOpen"));
    }

    private void buildSynchGateActivity(SynchGateActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        SystemTool systemTool = this.systemToolDAO.getSystemToolByID(SystemTool.SYNC_GATE);
        activity.setSystemTool(systemTool);
    }

    private void buildPermissionGateActivity(PermissionGateActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        SystemTool systemTool = this.systemToolDAO.getSystemToolByID(SystemTool.PERMISSION_GATE);
        activity.setSystemTool(systemTool);
    }

    private void buildScheduleGateActivity(ScheduleGateActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        activity.setGateStartTimeOffset(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"gateStartTimeOffset"));
        activity.setGateEndTimeOffset(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"gateEndTimeOffset"));
        SystemTool systemTool = this.systemToolDAO.getSystemToolByID(SystemTool.SCHEDULE_GATE);
        activity.setSystemTool(systemTool);
    }

    private void createLessonClass(LessonClass lessonClass, Hashtable groupingDetails) throws WDDXProcessorConversionException {
        Group group;
        if (this.keyExists(groupingDetails, "staffGroupID") && (group = this.groupDAO.getGroupById(WDDXProcessor.convertToLong((Hashtable)groupingDetails, (String)"staffGroupID"))) != null) {
            lessonClass.setStaffGroup(group);
        }
    }

    private Transition extractTransitionObject(Hashtable transitionDetails) throws WDDXProcessorConversionException {
        Integer fromUIID;
        Integer toUIID;
        Integer transitionUUID = WDDXProcessor.convertToInteger((Hashtable)transitionDetails, (String)"transitionUIID");
        if (transitionUUID == null) {
            throw new WDDXProcessorConversionException("Transition is missing its UUID");
        }
        Transition transition = null;
        Transition existingTransition = this.findTransition(transitionUUID);
        if (existingTransition == null) {
            transition = new Transition();
            transition.setTransitionUIID(transitionUUID);
        } else {
            transition = existingTransition;
        }
        if (this.keyExists(transitionDetails, "toUIID") && (toUIID = WDDXProcessor.convertToInteger((Hashtable)transitionDetails, (String)"toUIID")) != null) {
            Activity toActivity = this.newActivityMap.get(toUIID);
            if (toActivity != null) {
                transition.setToActivity(toActivity);
                transition.setToUIID(toUIID);
                toActivity.setTransitionTo(transition);
            } else {
                transition.setToActivity(null);
                transition.setToUIID(null);
            }
        }
        if (this.keyExists(transitionDetails, "fromUIID") && (fromUIID = WDDXProcessor.convertToInteger((Hashtable)transitionDetails, (String)"fromUIID")) != null) {
            Activity fromActivity = this.newActivityMap.get(fromUIID);
            if (fromActivity != null) {
                transition.setFromActivity(fromActivity);
                transition.setFromUIID(fromUIID);
                fromActivity.setTransitionFrom(transition);
            } else {
                transition.setFromActivity(null);
                transition.setFromUIID(null);
            }
        }
        if (this.keyExists(transitionDetails, "description")) {
            transition.setDescription(WDDXProcessor.convertToString((Hashtable)transitionDetails, (String)"description"));
        }
        if (this.keyExists(transitionDetails, "title")) {
            transition.setTitle(WDDXProcessor.convertToString((Hashtable)transitionDetails, (String)"title"));
        }
        if (this.keyExists(transitionDetails, "createDateTime")) {
            transition.setCreateDateTime(WDDXProcessor.convertToDate((Hashtable)transitionDetails, (String)"createDateTime"));
        }
        if (transition.getToActivity() != null && transition.getFromActivity() != null) {
            transition.setLearningDesign(this.learningDesign);
            return transition;
        }
        this.cleanupTransition(transition);
        transition.setLearningDesign(null);
        return null;
    }

    private void cleanupTransition(Transition transition) {
        if (transition.getFromActivity().getTransitionFrom().equals((Object)transition)) {
            transition.getFromActivity().setTransitionFrom(null);
        }
        if (transition.getToActivity().getTransitionTo().equals((Object)transition)) {
            transition.getToActivity().setTransitionTo(null);
        }
    }

    private Transition findTransition(Integer transitionUUID) {
        Transition existingTransition = null;
        Set transitions = this.learningDesign.getTransitions();
        Iterator iter = transitions.iterator();
        while (existingTransition == null && iter.hasNext()) {
            Transition element = (Transition)iter.next();
            if (!transitionUUID.equals(element.getTransitionUIID())) continue;
            existingTransition = element;
        }
        return existingTransition;
    }

    private boolean keyExists(Hashtable table, String key) {
        return table.containsKey(key);
    }

    private void clearTransition(Activity activityToDelete) {
        Transition transitionTo;
        Transition transitionFrom = activityToDelete.getTransitionFrom();
        if (transitionFrom != null) {
            this.deleteTransition(transitionFrom);
        }
        if ((transitionTo = activityToDelete.getTransitionTo()) != null) {
            this.deleteTransition(transitionTo);
        }
    }

    private void deleteTransition(Transition transition) {
        Activity fromActivity = transition.getFromActivity();
        fromActivity.setTransitionFrom(null);
        Activity toActivity = transition.getToActivity();
        toActivity.setTransitionTo(null);
        this.learningDesign.getTransitions().remove(transition);
    }

    @Override
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Override
    public Integer getMode() {
        return this.mode;
    }

    public static Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO learner = (UserDTO)ss.getAttribute("user");
        return learner != null ? learner.getUserID() : null;
    }
}

