/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.id.Configurable;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.type.Type;
import org.lamsfoundation.lams.authoring.IObjectExtractor;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.TransitionDAO;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.DesignDetailDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.LicenseDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignException;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolContentIDGenerator;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolDAO;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringService
implements IAuthoringService,
BeanFactoryAware {
    protected Logger log = Logger.getLogger(AuthoringService.class);
    protected LearningDesignDAO learningDesignDAO;
    protected LearningLibraryDAO learningLibraryDAO;
    protected ActivityDAO activityDAO;
    protected BaseDAO baseDAO;
    protected TransitionDAO transitionDAO;
    protected ToolDAO toolDAO;
    protected LicenseDAO licenseDAO;
    protected GroupingDAO groupingDAO;
    protected GroupDAO groupDAO;
    protected ILamsCoreToolService lamsCoreToolService;
    protected ILearningDesignService learningDesignService;
    protected MessageService messageService;
    protected ToolContentIDGenerator contentIDGenerator;
    protected BeanFactory beanFactory;

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setGroupDAO(GroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setGroupingDAO(GroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public void setTransitionDAO(TransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public void setLearningDesignDAO(LearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setLearningLibraryDAO(LearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setBaseDAO(BaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setActivityDAO(ActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setToolDAO(ToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public void setLicenseDAO(LicenseDAO licenseDAO) {
        this.licenseDAO = licenseDAO;
    }

    public ILamsCoreToolService getLamsCoreToolService() {
        return this.lamsCoreToolService;
    }

    public void setLamsCoreToolService(ILamsCoreToolService lamsCoreToolService) {
        this.lamsCoreToolService = lamsCoreToolService;
    }

    public ILearningDesignService getLearningDesignService() {
        return this.learningDesignService;
    }

    public void setLearningDesignService(ILearningDesignService learningDesignService) {
        this.learningDesignService = learningDesignService;
    }

    public void setContentIDGenerator(ToolContentIDGenerator contentIDGenerator) {
        this.contentIDGenerator = contentIDGenerator;
    }

    @Override
    public LearningDesign getLearningDesign(Long learningDesignID) {
        return this.learningDesignDAO.getLearningDesignById(learningDesignID);
    }

    @Override
    public void saveLearningDesign(LearningDesign learningDesign) {
        this.learningDesignDAO.insertOrUpdate((Object)learningDesign);
    }

    @Override
    public List getAllLearningDesigns() {
        return this.learningDesignDAO.getAllLearningDesigns();
    }

    @Override
    public List getAllLearningLibraries() {
        return this.learningLibraryDAO.getAllLearningLibraries();
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public String getLearningDesignDetails(Long learningDesignID) throws IOException {
        FlashMessage flashMessage = null;
        LearningDesignDTO learningDesignDTO = this.learningDesignService.getLearningDesignDTO(learningDesignID);
        flashMessage = learningDesignDTO == null ? FlashMessage.getNoSuchLearningDesignExists((String)"getLearningDesignDetails", (Long)learningDesignID) : new FlashMessage("getLearningDesignDetails", (Object)learningDesignDTO);
        return flashMessage.serializeMessage();
    }

    @Override
    public LearningDesign copyLearningDesign(Long originalDesignID, Integer copyType, Integer userID, Integer workspaceFolderID, boolean setOriginalDesign) throws UserException, LearningDesignException, WorkspaceFolderException, IOException {
        LearningDesign originalDesign = this.learningDesignDAO.getLearningDesignById(originalDesignID);
        if (originalDesign == null) {
            throw new LearningDesignException(this.messageService.getMessage("no.such.learningdesign.exist", new Object[]{originalDesignID}));
        }
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            throw new UserException(this.messageService.getMessage("no.such.user.exist", new Object[]{userID}));
        }
        WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
        if (workspaceFolder == null) {
            throw new WorkspaceFolderException(this.messageService.getMessage("no.such.workspace.exist", new Object[]{workspaceFolderID}));
        }
        return this.copyLearningDesign(originalDesign, copyType, user, workspaceFolder, setOriginalDesign);
    }

    @Override
    public LearningDesign copyLearningDesign(LearningDesign originalLearningDesign, Integer copyType, User user, WorkspaceFolder workspaceFolder, boolean setOriginalDesign) throws LearningDesignException {
        LearningDesign newLearningDesign = LearningDesign.createLearningDesignCopy((LearningDesign)originalLearningDesign, (Integer)copyType, (boolean)setOriginalDesign);
        newLearningDesign.setUser(user);
        newLearningDesign.setWorkspaceFolder(workspaceFolder);
        this.learningDesignDAO.insert((Object)newLearningDesign);
        this.updateDesignActivities(originalLearningDesign, newLearningDesign);
        this.updateDesignTransitions(originalLearningDesign, newLearningDesign);
        newLearningDesign.setFirstActivity(newLearningDesign.calculateFirstActivity());
        newLearningDesign.setLearningDesignUIID(originalLearningDesign.getLearningDesignUIID());
        this.copyLearningDesignToolContent(newLearningDesign, originalLearningDesign, copyType);
        return newLearningDesign;
    }

    @Override
    public LearningDesign copyLearningDesignToolContent(LearningDesign design, LearningDesign originalLearningDesign, Integer copyType) throws LearningDesignException {
        for (Activity currentActivity : design.getActivities()) {
            String error;
            if (!currentActivity.isToolActivity()) continue;
            try {
                ToolActivity toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(currentActivity.getActivityId());
                Long newContentId = this.lamsCoreToolService.notifyToolToCopyContent(toolActivity, copyType != 3);
                toolActivity.setToolContentId(newContentId);
            }
            catch (DataMissingException e) {
                error = "Unable to initialise the lesson. Data is missing for activity " + currentActivity.getActivityUIID() + " in learning design " + originalLearningDesign.getLearningDesignId() + " default content may be missing for the tool. Error was " + e.getMessage();
                this.log.error((Object)error, (Throwable)e);
                throw new LearningDesignException(error, (Throwable)e);
            }
            catch (ToolException e) {
                error = "Unable to initialise the lesson. Tool encountered an error copying the data is missing for activity " + currentActivity.getActivityUIID() + " in learning design " + originalLearningDesign.getLearningDesignId() + " default content may be missing for the tool. Error was " + e.getMessage();
                this.log.error((Object)error, (Throwable)e);
                throw new LearningDesignException(error, (Throwable)e);
            }
        }
        return design;
    }

    private void updateDesignActivities(LearningDesign originalLearningDesign, LearningDesign newLearningDesign) {
        TreeSet<Activity> newActivities = new TreeSet<Activity>((Comparator<Activity>)new ActivityOrderComparator());
        HashMap<Integer, Grouping> newGroupings = new HashMap<Integer, Grouping>();
        HashSet oldParentActivities = originalLearningDesign.getParentActivities();
        if (oldParentActivities != null) {
            Iterator iterator = oldParentActivities.iterator();
            while (iterator.hasNext()) {
                this.processActivity((Activity)iterator.next(), newLearningDesign, newActivities, newGroupings, null);
            }
        }
        for (Activity activity : newActivities) {
            Integer groupingUIID = activity.getGroupingUIID();
            if (groupingUIID == null) continue;
            activity.setGrouping(newGroupings.get(groupingUIID));
        }
        if (newLearningDesign.getActivities() != null) {
            newLearningDesign.getActivities().clear();
            newLearningDesign.getActivities().addAll(newActivities);
        } else {
            newLearningDesign.setActivities(newActivities);
        }
    }

    private void processActivity(Activity activity, LearningDesign newLearningDesign, Set<Activity> newActivities, Map<Integer, Grouping> newGroupings, Activity parentActivity) {
        Activity newActivity = this.getActivityCopy(activity, newGroupings);
        newActivity.setLearningDesign(newLearningDesign);
        if (parentActivity != null) {
            newActivity.setParentActivity(parentActivity);
            newActivity.setParentUIID(parentActivity.getActivityUIID());
        }
        this.activityDAO.insert((Object)newActivity);
        newActivities.add(newActivity);
        HashSet oldChildActivities = this.getChildActivities(activity);
        if (oldChildActivities != null) {
            Iterator childIterator = oldChildActivities.iterator();
            while (childIterator.hasNext()) {
                this.processActivity((Activity)childIterator.next(), newLearningDesign, newActivities, newGroupings, newActivity);
            }
        }
    }

    public void updateDesignTransitions(LearningDesign originalLearningDesign, LearningDesign newLearningDesign) {
        HashSet<Transition> newTransitions = new HashSet<Transition>();
        Set oldTransitions = originalLearningDesign.getTransitions();
        for (Transition transition : oldTransitions) {
            Transition newTransition = Transition.createCopy((Transition)transition);
            Activity toActivity = null;
            Activity fromActivity = null;
            if (newTransition.getToUIID() != null) {
                toActivity = this.activityDAO.getActivityByUIID(newTransition.getToUIID(), newLearningDesign);
                toActivity.setTransitionTo(newTransition);
            }
            if (newTransition.getFromUIID() != null) {
                fromActivity = this.activityDAO.getActivityByUIID(newTransition.getFromUIID(), newLearningDesign);
                fromActivity.setTransitionFrom(newTransition);
            }
            newTransition.setToActivity(toActivity);
            newTransition.setFromActivity(fromActivity);
            newTransition.setLearningDesign(newLearningDesign);
            this.transitionDAO.insert((Object)newTransition);
            newTransitions.add(newTransition);
        }
        if (newLearningDesign.getTransitions() != null) {
            newLearningDesign.getTransitions().clear();
            newLearningDesign.getTransitions().addAll(newTransitions);
        } else {
            newLearningDesign.setTransitions(newTransitions);
        }
    }

    private Activity getActivityCopy(Activity activity, Map<Integer, Grouping> newGroupings) {
        if (2 == activity.getActivityTypeId()) {
            GroupingActivity newGroupingActivity = (GroupingActivity)activity.createCopy();
            Grouping grouping = newGroupingActivity.getCreateGrouping();
            if (grouping != null) {
                this.groupingDAO.insert((Object)grouping);
                newGroupings.put(grouping.getGroupingUIID(), grouping);
            }
            return newGroupingActivity;
        }
        return activity.createCopy();
    }

    private HashSet getChildActivities(Activity parentActivity) {
        HashSet childActivities = new HashSet();
        List list = this.activityDAO.getActivitiesByParentActivityId(parentActivity.getActivityId());
        if (list != null) {
            childActivities.addAll(list);
        }
        return childActivities;
    }

    @Override
    public Long storeLearningDesignDetails(String wddxPacket) throws Exception {
        Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)wddxPacket);
        IObjectExtractor extractor = (IObjectExtractor)this.beanFactory.getBean("ObjectExtractor");
        LearningDesign design = extractor.extractSaveLearningDesign(table);
        if (extractor.getMode() == 1) {
            this.copyLearningDesignToolContent(design, design, design.getCopyTypeID());
        }
        return design.getLearningDesignId();
    }

    @Override
    public Vector<ValidationErrorDTO> validateLearningDesign(Long learningDesignId) {
        LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignId);
        Vector listOfValidationErrorDTOs = this.learningDesignService.validateLearningDesign(learningDesign);
        Boolean valid = listOfValidationErrorDTOs.size() > 0 ? Boolean.FALSE : Boolean.TRUE;
        learningDesign.setValidDesign(valid);
        this.learningDesignDAO.insertOrUpdate((Object)learningDesign);
        return listOfValidationErrorDTOs;
    }

    @Override
    public Vector<AuthoringActivityDTO> getToolActivities(Long learningDesignId) {
        LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignId);
        Vector<AuthoringActivityDTO> listOfAuthoringActivityDTOs = new Vector<AuthoringActivityDTO>();
        for (Activity currentActivity : learningDesign.getActivities()) {
            if (!currentActivity.isToolActivity()) continue;
            try {
                ToolActivity toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(currentActivity.getActivityId());
                AuthoringActivityDTO activityDTO = new AuthoringActivityDTO(toolActivity);
                listOfAuthoringActivityDTOs.add(activityDTO);
            }
            catch (ToolException e) {
                String error = "" + e.getMessage();
                this.log.error((Object)error, (Throwable)e);
                throw new LearningDesignException(error, (Throwable)e);
            }
        }
        return listOfAuthoringActivityDTOs;
    }

    @Override
    public String getAllLearningDesignDetails() throws IOException {
        Iterator iterator = this.getAllLearningDesigns().iterator();
        ArrayList arrayList = this.createDesignDetailsPacket(iterator);
        FlashMessage flashMessage = new FlashMessage("getAllLearningDesignDetails", (Object)arrayList);
        return flashMessage.serializeMessage();
    }

    private ArrayList createDesignDetailsPacket(Iterator iterator) {
        ArrayList<DesignDetailDTO> arrayList = new ArrayList<DesignDetailDTO>();
        while (iterator.hasNext()) {
            LearningDesign learningDesign = (LearningDesign)iterator.next();
            DesignDetailDTO designDetailDTO = learningDesign.getDesignDetailDTO();
            arrayList.add(designDetailDTO);
        }
        return arrayList;
    }

    @Override
    public String getLearningDesignsForUser(Long userID) throws IOException {
        List list = this.learningDesignDAO.getLearningDesignByUserId(userID);
        ArrayList arrayList = this.createDesignDetailsPacket(list.iterator());
        FlashMessage flashMessage = new FlashMessage("getLearningDesignsForUser", (Object)arrayList);
        return flashMessage.serializeMessage();
    }

    @Override
    public String getAllLearningLibraryDetails() throws IOException {
        FlashMessage flashMessage = new FlashMessage("getAllLearningLibraryDetails", (Object)this.learningDesignService.getAllLearningLibraryDetails());
        return flashMessage.serializeMessage();
    }

    @Override
    public String getToolContentID(Long toolID) throws IOException {
        Tool tool = this.toolDAO.getToolByID(toolID);
        if (tool == null) {
            this.log.error((Object)("The toolID " + toolID + " is not valid. A Tool with tool id " + toolID + " does not exist on the database."));
            return FlashMessage.getNoSuchTool((String)"getToolContentID", (Long)toolID).serializeMessage();
        }
        Long newContentID = this.contentIDGenerator.getNextToolContentIDFor(tool);
        FlashMessage flashMessage = new FlashMessage("getToolContentID", (Object)newContentID);
        return flashMessage.serializeMessage();
    }

    @Override
    public String copyToolContent(Long toolContentID) throws IOException {
        Long newContentID = this.lamsCoreToolService.notifyToolToCopyContent(toolContentID);
        FlashMessage flashMessage = new FlashMessage("copyToolContent", (Object)newContentID);
        return flashMessage.serializeMessage();
    }

    @Override
    public Vector getAvailableLicenses() {
        List licenses = this.licenseDAO.findAll(License.class);
        Vector<LicenseDTO> licenseDTOList = new Vector<LicenseDTO>(licenses.size());
        for (License element : licenses) {
            licenseDTOList.add(element.getLicenseDTO(Configuration.get((String)ConfigurationKeys.SERVER_URL)));
        }
        return licenseDTOList;
    }

    @Override
    public void deleteLearningDesign(LearningDesign design) {
        if (design == null) {
            this.log.error((Object)"deleteLearningDesign: unable to delete learning design as design is null.");
            return;
        }
        Set acts = design.getActivities();
        for (Activity activity : acts) {
            if (!activity.isToolActivity()) continue;
            try {
                ToolActivity toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId());
                this.lamsCoreToolService.notifyToolToDeleteContent(toolActivity);
            }
            catch (ToolException e) {
                this.log.error((Object)("Unable to delete tool content for activity" + activity + " as activity threw an exception"), (Throwable)e);
            }
        }
        this.learningDesignDAO.delete((Object)design);
    }

    @Override
    public String generateUniqueContentFolder() throws FileUtilException, IOException {
        String newUniqueContentFolderID = null;
        Properties props = new Properties();
        UUIDHexGenerator uuidGen = new UUIDHexGenerator();
        ((Configurable)uuidGen).configure((Type)Hibernate.STRING, props, null);
        newUniqueContentFolderID = ((String)((Object)uuidGen.generate(null, null))).toLowerCase();
        FlashMessage flashMessage = new FlashMessage("createUniqueContentFolder", (Object)newUniqueContentFolderID);
        return flashMessage.serializeMessage();
    }

    @Override
    public String getHelpURL() throws Exception {
        FlashMessage flashMessage = null;
        String helpURL = Configuration.get((String)ConfigurationKeys.HELP_URL);
        if (helpURL == null) {
            throw new Exception();
        }
        flashMessage = new FlashMessage("getHelpURL", (Object)helpURL);
        return flashMessage.serializeMessage();
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }
}

