/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsAction;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ExportToolContentAction
extends LamsAction {
    private static final long serialVersionUID = 1L;
    public static final String EXPORT_TOOLCONTENT_SERVICE_BEAN_NAME = "exportToolContentService";
    public static final String PARAM_LEARING_DESIGN_ID = "learningDesignID";
    public static final String ATTR_TOOLS_ERROR_MESSAGE = "toolsErrorMessages";
    public static final String ATTR_LD_ERROR_MESSAGE = "ldErrorMessages";
    private static final String PARAM_EXPORT_FORMAT = "format";
    private static final String IMS_XSLT_NAME = "learning-design-ims.xslt";
    private static final String IMS_XSLT_PATH = "/toolcontent";
    private Logger log = Logger.getLogger(ExportToolContentAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = request.getParameter("method");
        if (StringUtils.equals((String)param, (String)"loading")) {
            Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_LEARING_DESIGN_ID);
            request.setAttribute(PARAM_LEARING_DESIGN_ID, (Object)learningDesignId);
            int format = WebUtil.readIntParam((HttpServletRequest)request, (String)PARAM_EXPORT_FORMAT);
            request.setAttribute(PARAM_EXPORT_FORMAT, (Object)format);
            return mapping.findForward("loading");
        }
        if (StringUtils.equals((String)param, (String)"export")) {
            return this.exportLD(mapping, request, response);
        }
        Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_LEARING_DESIGN_ID);
        request.setAttribute(PARAM_LEARING_DESIGN_ID, (Object)learningDesignId);
        return mapping.findForward("choice");
    }

    private ActionForward exportLD(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response) {
        Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_LEARING_DESIGN_ID);
        int format = WebUtil.readIntParam((HttpServletRequest)request, (String)PARAM_EXPORT_FORMAT);
        IExportToolContentService service = this.getExportService();
        ArrayList<String> ldErrorMsgs = new ArrayList<String>();
        ArrayList toolsErrorMsgs = new ArrayList();
        try {
            File xslt = new File(this.getServlet().getServletContext().getRealPath(IMS_XSLT_PATH) + File.separator + IMS_XSLT_NAME);
            String zipFilename = service.exportLearningDesign(learningDesignId, toolsErrorMsgs, format, xslt);
            response.setContentType("application/zip");
            response.setHeader("Content-Disposition", "attachment;filename=" + FileUtil.getFileName((String)zipFilename));
            InputStream in = null;
            OutputStream out = null;
            try {
                int ch;
                in = new BufferedInputStream(new FileInputStream(zipFilename));
                out = response.getOutputStream();
                int count = 0;
                while ((ch = in.read()) != -1) {
                    out.write((char)ch);
                    ++count;
                }
                this.log.debug((Object)("Wrote out " + count + " bytes"));
                response.setContentLength(count);
                out.flush();
            }
            catch (Exception e) {
                this.log.error((Object)("Exception occured writing out file:" + e.getMessage()));
                throw new ExportToolContentException((Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Error Closing file. File already written out - no exception being thrown.", (Throwable)e);
                }
            }
            return null;
        }
        catch (Exception e1) {
            this.log.error((Object)("Unable to export tool content: " + e1.toString()));
            ldErrorMsgs.add(0, e1.getClass().getName());
            request.setAttribute(ATTR_LD_ERROR_MESSAGE, ldErrorMsgs);
            request.setAttribute(ATTR_TOOLS_ERROR_MESSAGE, toolsErrorMsgs);
            return mapping.findForward("result");
        }
    }

    private IExportToolContentService getExportService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IExportToolContentService)webContext.getBean(EXPORT_TOOLCONTENT_SERVICE_BEAN_NAME);
    }
}

