/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtil;
import org.lamsfoundation.lams.web.action.LamsAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ImportToolContentAction
extends LamsAction {
    public static final String EXPORT_TOOLCONTENT_SERVICE_BEAN_NAME = "exportToolContentService";
    public static final String USER_SERVICE_BEAN_NAME = "userManagementService";
    public static final String MESSAGE_SERVICE_BEAN_NAME = "authoringMessageService";
    public static final String PARAM_LEARING_DESIGN_ID = "learningDesignID";
    public static final String ATTR_TOOLS_ERROR_MESSAGE = "toolsErrorMessages";
    public static final String ATTR_LD_ERROR_MESSAGE = "ldErrorMessages";
    public static final String ATTR_LD_ID = "learningDesignID";
    private static final String KEY_MSG_IMPORT_FILE_NOT_FOUND = "msg.import.file.not.found";
    private static final String KEY_MSG_IMPORT_FILE_FORMAT = "msg.import.file.format";
    private static final String KEY_MSG_IMPORT_FAILED_UNKNOWN_REASON = "msg.import.failed.unknown.reason";
    private Logger log = Logger.getLogger(ImportToolContentAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = request.getParameter("method");
        if (StringUtils.equals((String)param, (String)"import")) {
            return mapping.findForward("upload");
        }
        this.importLD(request);
        return mapping.findForward("success");
    }

    private void importLD(HttpServletRequest request) {
        ArrayList<String> ldErrorMsgs = new ArrayList<String>();
        ArrayList toolsErrorMsgs = new ArrayList();
        Long ldId = null;
        try {
            Integer workspaceFolderUid = null;
            HttpSession ss = SessionManager.getSession();
            UserDTO userDto = (UserDTO)ss.getAttribute("user");
            User user = (User)this.getUserService().findById(User.class, (Serializable)userDto.getUserID());
            FileItem file = null;
            HashMap<String, String> params = new HashMap<String, String>();
            String filename = null;
            String uploadPath = FileUtil.createTempDirectory((String)"_uploaded_learningdesign");
            DiskFileUpload fu = new DiskFileUpload();
            fu.setSizeThreshold(4096);
            fu.setRepositoryPath(uploadPath);
            List fileItems = fu.parseRequest(request);
            for (FileItem fi : fileItems) {
                if (!fi.getFieldName().equalsIgnoreCase("UPLOAD_FILE")) {
                    params.put(fi.getFieldName(), fi.getString());
                } else {
                    filename = FileUtil.getFileName((String)fi.getName());
                    file = fi;
                }
                workspaceFolderUid = NumberUtils.createInteger((String)((String)params.get("WORKSPACE_FOLDER_UID")));
            }
            if (file == null) {
                MessageService msgService = this.getMessageService();
                this.log.error((Object)("Upload file missing. Filename was " + filename));
                String msg = msgService.getMessage(KEY_MSG_IMPORT_FILE_NOT_FOUND);
                ldErrorMsgs.add(msg != null ? msg : "Upload file missing");
            } else {
                String extension;
                String string = extension = filename != null && filename.length() >= 4 ? filename.substring(filename.length() - 4) : "";
                if (extension.equalsIgnoreCase(".las")) {
                    String wddxPacket = this.getPacket(file.getInputStream());
                    IExportToolContentService service = this.getExportService();
                    ldId = service.importLearningDesign102(wddxPacket, user, workspaceFolderUid, toolsErrorMsgs);
                } else if (extension.equalsIgnoreCase(".zip")) {
                    String ldPath = ZipFileUtil.expandZip((InputStream)file.getInputStream(), (String)filename);
                    IExportToolContentService service = this.getExportService();
                    ldId = service.importLearningDesign(ldPath, user, workspaceFolderUid, toolsErrorMsgs);
                } else {
                    this.log.error((Object)("Uploaded file not an expected type. Filename was " + filename));
                    MessageService msgService = this.getMessageService();
                    String msg = msgService.getMessage(KEY_MSG_IMPORT_FILE_FORMAT);
                    ldErrorMsgs.add(msg != null ? msg : "Uploaded file not an expected type.");
                }
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            this.log.error((Object)"Error occured during import", (Throwable)e);
            ldErrorMsgs.add(e.getClass().getName());
        }
        request.setAttribute("learningDesignID", ldId);
        if ((ldId == null || ldId == -1L) && ldErrorMsgs.size() == 0) {
            MessageService msgService = this.getMessageService();
            ldErrorMsgs.add(msgService.getMessage(KEY_MSG_IMPORT_FAILED_UNKNOWN_REASON));
        }
        if (ldErrorMsgs.size() > 0) {
            request.setAttribute(ATTR_LD_ERROR_MESSAGE, ldErrorMsgs);
        }
        if (toolsErrorMsgs.size() > 0) {
            request.setAttribute(ATTR_TOOLS_ERROR_MESSAGE, toolsErrorMsgs);
        }
    }

    private IUserManagementService getUserService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IUserManagementService)webContext.getBean(USER_SERVICE_BEAN_NAME);
    }

    private IExportToolContentService getExportService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IExportToolContentService)webContext.getBean(EXPORT_TOOLCONTENT_SERVICE_BEAN_NAME);
    }

    private MessageService getMessageService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (MessageService)webContext.getBean(MESSAGE_SERVICE_BEAN_NAME);
    }

    protected String getPacket(InputStream sis) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader(sis));
        StringBuffer tempStrBuf = new StringBuffer(200);
        String tempStr = buff.readLine();
        while (tempStr != null) {
            tempStrBuf.append(tempStr);
            tempStr = buff.readLine();
        }
        return tempStrBuf.toString();
    }
}

