/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.web.filter.LocaleFilter;

public class JspRedirectStrategy {
    public static final String AUTH_OBJECT_NAME = "authorizationObjectName";
    public static final String SECURITY_CHECK_NOT_PASSED = "SecurityCheckNotPassed";
    public static final String SECURITY_CHECK_PASSED = "securityCheckPassed";
    public static final String WELCOME_PAGE = "index.jsp";
    private static Logger log = Logger.getLogger(JspRedirectStrategy.class);

    public static boolean loginPageRedirected(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            log.debug((Object)"===>LOGIN PAGE: session not found, simply stop here.");
            return true;
        }
        String checkStatus = (String)session.getAttribute(AUTH_OBJECT_NAME);
        String id = session.getId();
        if (checkStatus == null || checkStatus.equals(SECURITY_CHECK_NOT_PASSED)) {
            log.debug((Object)("===>LOGIN PAGE: there is no auth obj in session or accessing login page before login succeed, auth obj created. session id: " + id));
            session.setAttribute(AUTH_OBJECT_NAME, (Object)SECURITY_CHECK_NOT_PASSED);
            try {
                LocaleFilter filter = new LocaleFilter();
                filter.doFilter((ServletRequest)request, (ServletResponse)response, null);
                log.debug((Object)("Set locale information for login page:" + request.getLocale()));
            }
            catch (ServletException e) {
                log.error((Object)"Failed set Locale to request.");
            }
            return false;
        }
        if (checkStatus.equals(SECURITY_CHECK_PASSED)) {
            log.debug((Object)("===>LOGIN PAGE: accessing login after login succeed. Invalidate the session: " + id + " and redirect to " + WELCOME_PAGE));
            session.invalidate();
            response.sendRedirect(WELCOME_PAGE);
            return true;
        }
        log.debug((Object)("===>LOGIN PAGE: logically impossible to be here, no valid status found : " + id));
        session.invalidate();
        response.sendRedirect(WELCOME_PAGE);
        return true;
    }

    public static void welcomePageStatusUpdate(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            log.debug((Object)"===>INDEX PAGE: session not found, simply stop here.");
            return;
        }
        if (!SECURITY_CHECK_PASSED.equals(session.getAttribute(AUTH_OBJECT_NAME))) {
            session.setAttribute(AUTH_OBJECT_NAME, (Object)new String(SECURITY_CHECK_PASSED));
        }
    }
}

