/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.themes.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.themes.exception.ThemeException;
import org.lamsfoundation.lams.themes.service.IThemeService;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ThemeAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(ThemeAction.class);
    public static final String THEME_ID_PARAMETER = "themeID";
    public static final String USER_ID_PARAMETER = "userID";
    public static final String TYPE_PARAMETER = "type";
    public static final String HTML_TYPE = "html";
    public static final String FLASH_TYPE = "flash";

    public IThemeService getThemeService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IThemeService)webContext.getBean("themeService");
    }

    private ActionForward outputPacket(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, String wddxPacket, String parameterName) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getTheme(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        Long themeId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)THEME_ID_PARAMETER));
        IThemeService themeService = this.getThemeService();
        String message = themeService.getThemeWDDX(themeId);
        return this.outputPacket(mapping, request, response, message, "message");
    }

    public ActionForward getThemes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        IThemeService themeService = this.getThemeService();
        String message = themeService.getThemes();
        return this.outputPacket(mapping, request, response, message, "message");
    }

    public ActionForward setTheme(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        FlashMessage flashMessage;
        block7: {
            Long themeId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)THEME_ID_PARAMETER));
            Integer userId = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)USER_ID_PARAMETER));
            String type = WebUtil.readStrParam((HttpServletRequest)request, (String)TYPE_PARAMETER, (boolean)true);
            IThemeService themeService = this.getThemeService();
            MessageService messageService = themeService.getMessageService();
            flashMessage = null;
            try {
                if (type == null) {
                    flashMessage = themeService.setTheme(userId, themeId);
                    break block7;
                }
                if (type.equals(FLASH_TYPE)) {
                    flashMessage = themeService.setFlashTheme(userId, themeId);
                    break block7;
                }
                if (type.equals(HTML_TYPE)) {
                    flashMessage = themeService.setHtmlTheme(userId, themeId);
                    break block7;
                }
                throw new ThemeException(messageService.getMessage("theme.service.setTheme.type.invalid"));
            }
            catch (ThemeException e) {
                flashMessage = new FlashMessage("wddxPacket", (Object)e.getMessage(), 1);
            }
            catch (UserException e) {
                flashMessage = new FlashMessage("wddxPacket", (Object)e.getMessage(), 1);
            }
            catch (Exception e) {
                flashMessage = FlashMessage.getExceptionOccured((String)"setTheme", (String)e.getMessage());
            }
        }
        return this.outputPacket(mapping, request, response, flashMessage.serializeMessage(), "message");
    }
}

