/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class PortraitUtils {
    private static Logger log = Logger.getLogger(PortraitUtils.class);

    public static ByteArrayInputStream resizePicture(InputStream is, int width, int height, String formatName) {
        ByteArrayOutputStream os = null;
        try {
            BufferedImage bsrc = ImageIO.read(is);
            log.debug((Object)("old width: " + bsrc.getWidth() + ", old height: " + bsrc.getHeight()));
            double widthScale = (double)width / (double)bsrc.getWidth();
            double heightScale = (double)height / (double)bsrc.getHeight();
            double minScale = Math.min(widthScale, heightScale);
            double newWidth = minScale * (double)bsrc.getWidth();
            double newHeight = minScale * (double)bsrc.getHeight();
            log.debug((Object)("scaling picture by " + minScale + "... new width: " + newWidth + ", new height: " + newHeight));
            BufferedImage bdest = new BufferedImage((int)newWidth, (int)newHeight, 1);
            Graphics2D g = bdest.createGraphics();
            AffineTransform at = AffineTransform.getScaleInstance(minScale, minScale);
            g.drawRenderedImage(bsrc, at);
            os = new ByteArrayOutputStream();
            if (formatName.equals("gif")) {
                formatName = "jpg";
            }
            log.debug((Object)("using format: " + formatName));
            ImageIO.write((RenderedImage)bdest, formatName, os);
        }
        catch (IOException e) {
            log.error((Object)e.getStackTrace());
            return null;
        }
        return new ByteArrayInputStream(os.toByteArray());
    }
}

