/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.IndexLessonBean;
import org.lamsfoundation.lams.web.IndexLinkBean;
import org.lamsfoundation.lams.web.IndexOrgBean;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexAction
extends Action {
    private static Logger log = Logger.getLogger(IndexAction.class);
    private static IUserManagementService service;
    private Integer state;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User loggedInUser;
        String stateParam = WebUtil.readStrParam((HttpServletRequest)request, (String)"state");
        this.state = stateParam.equals("active") ? OrganisationState.ACTIVE : OrganisationState.ARCHIVED;
        log.debug((Object)("User:" + request.getRemoteUser()));
        if (this.state.equals(OrganisationState.ACTIVE)) {
            this.setHeaderLinks(request);
            this.setAdminLinks(request);
        }
        if ((loggedInUser = this.getService().getUserByLogin(request.getRemoteUser())).getChangePassword() != null && loggedInUser.getChangePassword().booleanValue()) {
            return mapping.findForward("password");
        }
        String tab = WebUtil.readStrParam((HttpServletRequest)request, (String)"tab", (boolean)true);
        if (StringUtils.equals((String)tab, (String)"profile")) {
            return mapping.findForward("profile");
        }
        if (StringUtils.equals((String)tab, (String)"editprofile")) {
            return mapping.findForward("editprofile");
        }
        if (StringUtils.equals((String)tab, (String)"password")) {
            return mapping.findForward("password");
        }
        if (StringUtils.equals((String)tab, (String)"passwordChanged")) {
            request.setAttribute("tab", (Object)"profile");
            return mapping.findForward("passwordChanged");
        }
        if (StringUtils.equals((String)tab, (String)"portrait")) {
            return mapping.findForward("portrait");
        }
        if (StringUtils.equals((String)tab, (String)"community")) {
            request.setAttribute("tab", (Object)tab);
            return mapping.findForward("community");
        }
        ArrayList<IndexOrgBean> orgBeans = new ArrayList<IndexOrgBean>();
        if (request.isUserInRole("SYSADMIN")) {
            List organisations = this.getService().getOrganisationsByTypeAndStatus(OrganisationType.COURSE_TYPE, this.state);
            if (this.state.equals(OrganisationState.ARCHIVED)) {
                organisations.addAll(this.getService().getOrganisationsByTypeAndStatus(OrganisationType.COURSE_TYPE, OrganisationState.ACTIVE));
            }
            for (Organisation org : organisations) {
                ArrayList<Integer> roles = new ArrayList<Integer>();
                roles.add(Role.ROLE_SYSADMIN);
                List userOrganisationRoles = this.getService().getUserOrganisationRoles(org.getOrganisationId(), request.getRemoteUser());
                for (UserOrganisationRole userOrganisationRole : userOrganisationRoles) {
                    roles.add(userOrganisationRole.getRole().getRoleId());
                }
                IndexOrgBean iob = this.createOrgBean(org, roles, request.getRemoteUser(), true);
                if (this.state.equals(OrganisationState.ARCHIVED) && org.getOrganisationState().getOrganisationStateId().equals(OrganisationState.ACTIVE) && iob.getChildIndexOrgBeans().isEmpty()) continue;
                orgBeans.add(iob);
            }
        } else {
            List userOrganisations = this.getService().getUserOrganisationsForUserByTypeAndStatus(request.getRemoteUser(), OrganisationType.COURSE_TYPE, this.state);
            if (this.state.equals(OrganisationState.ARCHIVED)) {
                userOrganisations.addAll(this.getService().getUserOrganisationsForUserByTypeAndStatus(request.getRemoteUser(), OrganisationType.COURSE_TYPE, OrganisationState.ACTIVE));
            }
            for (UserOrganisation userOrganisation : userOrganisations) {
                ArrayList<Integer> roles = new ArrayList<Integer>();
                for (Object userOrganisationRole : userOrganisation.getUserOrganisationRoles()) {
                    roles.add(((UserOrganisationRole)userOrganisationRole).getRole().getRoleId());
                }
                IndexOrgBean iob = this.createOrgBean(userOrganisation.getOrganisation(), roles, request.getRemoteUser(), false);
                if (this.state.equals(OrganisationState.ARCHIVED) && userOrganisation.getOrganisation().getOrganisationState().getOrganisationStateId().equals(OrganisationState.ACTIVE) && iob.getChildIndexOrgBeans().isEmpty()) continue;
                orgBeans.add(iob);
            }
        }
        Collections.sort(orgBeans);
        request.setAttribute("orgBeans", orgBeans);
        if (this.state.equals(OrganisationState.ACTIVE)) {
            return mapping.findForward("main");
        }
        return mapping.findForward("content");
    }

    private void setHeaderLinks(HttpServletRequest request) {
        ArrayList<IndexLinkBean> headerLinks = new ArrayList<IndexLinkBean>();
        if (request.isUserInRole("AUTHOR") || request.isUserInRole("AUTHOR ADMIN")) {
            log.debug((Object)"user is author");
            headerLinks.add(new IndexLinkBean("index.author", "javascript:openAuthor()"));
        }
        headerLinks.add(new IndexLinkBean("index.myprofile", "index.do?state=active&tab=profile"));
        if (Configuration.getAsBoolean((String)ConfigurationKeys.LAMS_COMMUNITY_ENABLE) && (request.isUserInRole("SYSADMIN") || request.isUserInRole("GROUP ADMIN") || request.isUserInRole("GROUP MANAGER") || request.isUserInRole("AUTHOR") || request.isUserInRole("AUTHOR ADMIN") || request.isUserInRole("MONITOR"))) {
            headerLinks.add(new IndexLinkBean("index.community", "index.do?state=active&tab=community"));
        }
        log.debug((Object)"set headerLinks in request");
        request.setAttribute("headerLinks", headerLinks);
    }

    private void setAdminLinks(HttpServletRequest request) {
        ArrayList<IndexLinkBean> adminLinks = new ArrayList<IndexLinkBean>();
        if (request.isUserInRole("SYSADMIN") || request.isUserInRole("GROUP ADMIN") || request.isUserInRole("GROUP MANAGER")) {
            adminLinks.add(new IndexLinkBean("index.courseman", "javascript:openOrgManagement(" + this.getService().getRootOrganisation().getOrganisationId() + ')'));
        }
        if (request.isUserInRole("SYSADMIN") || request.isUserInRole("AUTHOR ADMIN") || this.getService().isUserGlobalGroupAdmin()) {
            adminLinks.add(new IndexLinkBean("index.sysadmin", "javascript:openSysadmin()"));
        }
        request.setAttribute("adminLinks", adminLinks);
    }

    private IndexOrgBean createOrgBean(Organisation org, List<Integer> roles, String username, boolean isSysAdmin) {
        User user = (User)this.getService().findByProperty(User.class, "login", (Object)username).get(0);
        IndexOrgBean orgBean = new IndexOrgBean(org.getName(), org.getOrganisationType().getOrganisationTypeId());
        ArrayList<IndexLinkBean> links = new ArrayList<IndexLinkBean>();
        if (isSysAdmin && this.state.equals(OrganisationState.ACTIVE) && orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
            links.add(new IndexLinkBean("index.classman", "javascript:openOrgManagement(" + org.getOrganisationId() + ")", "manage-group-button"));
        }
        if ((this.contains(roles, Role.ROLE_GROUP_ADMIN) || this.contains(roles, Role.ROLE_GROUP_MANAGER) || this.contains(roles, Role.ROLE_MONITOR)) && this.state.equals(OrganisationState.ACTIVE)) {
            if (orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
                if (!isSysAdmin && (this.contains(roles, Role.ROLE_GROUP_ADMIN) || this.contains(roles, Role.ROLE_GROUP_MANAGER))) {
                    links.add(new IndexLinkBean("index.classman", "javascript:openOrgManagement(" + org.getOrganisationId() + ")", "manage-group-button"));
                }
                if (this.contains(roles, Role.ROLE_GROUP_MANAGER) || this.contains(roles, Role.ROLE_MONITOR)) {
                    links.add(new IndexLinkBean("index.addlesson", "javascript:openAddLesson(" + org.getOrganisationId() + ",'')", "add-lesson-button"));
                }
            } else if (this.contains(roles, Role.ROLE_GROUP_MANAGER) || this.contains(roles, Role.ROLE_MONITOR)) {
                links.add(new IndexLinkBean("index.addlesson", "javascript:openAddLesson(" + org.getParentOrganisation().getOrganisationId() + "," + org.getOrganisationId() + ")", "add-lesson-button"));
            }
        }
        orgBean.setLinks(links);
        if (this.state.equals(OrganisationState.ARCHIVED) && org.getOrganisationState().getOrganisationStateId().equals(OrganisationState.ARCHIVED)) {
            orgBean.setArchivedDate(org.getArchivedDate());
        }
        ArrayList<IndexLessonBean> lessonBeans = new ArrayList<IndexLessonBean>();
        Set lessons = org.getLessons();
        for (Lesson lesson : lessons) {
            String url;
            ArrayList<IndexLinkBean> lessonLinks;
            block25: {
                block27: {
                    block24: {
                        block26: {
                            if (!this.isInLesson(user, lesson) || lesson.isPreviewLesson()) continue;
                            lessonLinks = new ArrayList<IndexLinkBean>();
                            url = null;
                            if (!this.state.equals(OrganisationState.ACTIVE)) break block24;
                            if (this.contains(roles, Role.ROLE_GROUP_MANAGER) || this.contains(roles, Role.ROLE_MONITOR)) {
                                if (!lesson.getLessonStateId().equals(Lesson.REMOVED_STATE)) {
                                    lessonLinks.add(new IndexLinkBean("index.monitor", "javascript:openMonitorLesson(" + lesson.getLessonId() + ")"));
                                }
                            }
                            if (!this.contains(roles, Role.ROLE_LEARNER)) break block25;
                            log.debug((Object)("Lesson State:" + lesson.getLessonStateId()));
                            if (lesson.getLessonStateId().equals(Lesson.STARTED_STATE)) break block26;
                            if (!lesson.getLessonStateId().equals(Lesson.FINISHED_STATE)) break block25;
                        }
                        url = "javascript:openLearner(" + lesson.getLessonId() + ")";
                        break block25;
                    }
                    if (!this.state.equals(OrganisationState.ARCHIVED)) break block25;
                    if (this.contains(roles, Role.ROLE_GROUP_MANAGER)) {
                        if (!lesson.getLessonStateId().equals(Lesson.REMOVED_STATE)) {
                            lessonLinks.add(new IndexLinkBean("index.monitor", "javascript:openMonitorLesson(" + lesson.getLessonId() + ")"));
                        }
                    }
                    if (!this.contains(roles, Role.ROLE_LEARNER)) break block25;
                    log.debug((Object)("Lesson State:" + lesson.getLessonStateId()));
                    if (lesson.getLessonStateId().equals(Lesson.STARTED_STATE)) break block27;
                    if (!lesson.getLessonStateId().equals(Lesson.FINISHED_STATE)) break block25;
                }
                lessonLinks.add(new IndexLinkBean("label.export.portfolio", "javascript:openExportPortfolio(" + lesson.getLessonId() + ")"));
            }
            if (lessonLinks.size() <= 0 && url == null) continue;
            IndexLessonBean lessonBean = new IndexLessonBean(lesson.getLessonName(), lessonLinks);
            lessonBean.setUrl(url);
            lessonBean.setState(lesson.getLessonStateId());
            lessonBeans.add(lessonBean);
        }
        Collections.sort(lessonBeans);
        orgBean.setLessons(lessonBeans);
        if (orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
            Set children = org.getChildOrganisations();
            ArrayList<IndexOrgBean> childOrgBeans = new ArrayList<IndexOrgBean>();
            for (Organisation organisation : children) {
                if (!organisation.getOrganisationState().getOrganisationStateId().equals(this.state)) continue;
                ArrayList<Integer> classRoles = new ArrayList<Integer>();
                List userOrganisationRoles = this.getService().getUserOrganisationRoles(organisation.getOrganisationId(), username);
                if ((userOrganisationRoles == null || userOrganisationRoles.isEmpty()) && !this.contains(roles, Role.ROLE_GROUP_ADMIN) && !this.contains(roles, Role.ROLE_GROUP_MANAGER) && !this.contains(roles, Role.ROLE_SYSADMIN)) continue;
                for (UserOrganisationRole userOrganisationRole : userOrganisationRoles) {
                    classRoles.add(userOrganisationRole.getRole().getRoleId());
                }
                if (this.contains(roles, Role.ROLE_GROUP_MANAGER)) {
                    classRoles.add(Role.ROLE_GROUP_MANAGER);
                }
                childOrgBeans.add(this.createOrgBean(organisation, classRoles, username, isSysAdmin));
            }
            Collections.sort(childOrgBeans);
            orgBean.setChildIndexOrgBeans(childOrgBeans);
        }
        return orgBean;
    }

    private boolean isInLesson(User user, Lesson lesson) {
        return lesson.getLessonClass().isStaffMember(user) || lesson.getLessonClass().getLearners().contains(user);
    }

    private boolean contains(List<Integer> roles, Integer roleId) {
        for (int i = 0; i < roles.size(); ++i) {
            if (!roleId.equals(roles.get(i))) continue;
            return true;
        }
        return false;
    }

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementServiceTarget");
        }
        return service;
    }
}

