/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.FailedLoginException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.integration.util.LoginRequestDispatcher;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LoginRequestServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(LoginRequestServlet.class);
    private static IntegrationService integrationService = null;
    private static final String JNDI_DATASOURCE = "java:/jdbc/lams-ds";
    private static final String PASSWORD_QUERY = "select password from lams_user where login=?";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession hses = request.getSession(true);
        String extUsername = request.getParameter("uid");
        String serverId = request.getParameter("sid");
        String extCourseId = request.getParameter("courseid");
        String timestamp = request.getParameter("ts");
        String hash = request.getParameter("hash");
        String method = request.getParameter("method");
        String countryIsoCode = request.getParameter("country");
        String langIsoCode = request.getParameter("lang");
        if (extUsername == null || method == null || serverId == null || timestamp == null || hash == null || extCourseId == null) {
            response.sendError(400, "Login Failed - login parameters missing");
            return;
        }
        ExtServerOrgMap serverMap = this.getService().getExtServerOrgMap(serverId);
        try {
            ExtUserUseridMap userMap = this.getService().getExtUserUseridMap(serverMap, extUsername);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)timestamp, (String)extUsername, (String)method, (String)hash);
            ExtCourseClassMap orgMap = this.getService().getExtCourseClassMap(serverMap, userMap, extCourseId, countryIsoCode, langIsoCode);
            User user = userMap.getUser();
            String login = user.getLogin();
            String loginRequestUsername = (String)hses.getAttribute("extUser");
            if (loginRequestUsername != null && loginRequestUsername.equals(login)) {
                String url = LoginRequestDispatcher.getRequestURL((HttpServletRequest)request);
                log.debug((Object)("redirect url - " + url));
                response.sendRedirect(response.encodeRedirectURL(url));
                return;
            }
            if (loginRequestUsername != null && !loginRequestUsername.equals(login)) {
                hses.invalidate();
                hses = request.getSession(true);
            } else if (request.getRemoteUser() != null && loginRequestUsername == null) {
                hses.invalidate();
                hses = request.getSession(true);
            }
            Organisation org = orgMap.getOrganisation();
            IUserManagementService userManagementService = integrationService.getService();
            UserOrganisation uo = userManagementService.getUserOrganisation(user.getUserId(), org.getOrganisationId());
            Integer[] roleIds = new Integer[]{Role.ROLE_LEARNER};
            HashMap<String, Integer> properties = new HashMap<String, Integer>();
            properties.put("userOrganisation.userOrganisationId", uo.getUserOrganisationId());
            for (Integer roleId : roleIds) {
                properties.put("role.roleId", roleId);
                List list = userManagementService.findByProperties(UserOrganisationRole.class, properties);
                if (list != null && list.size() != 0) continue;
                UserOrganisationRole uor = new UserOrganisationRole(uo, (Role)userManagementService.findById(Role.class, (Serializable)roleId));
                userManagementService.save((Object)uor);
            }
            log.debug((Object)("Session Id - " + hses.getId()));
            String pass = this.getUserPassword(userMap.getUser().getLogin());
            hses.setAttribute("extUser", (Object)login);
            hses.setAttribute("user", (Object)user.getUserDTO());
            response.sendRedirect("j_security_check?j_username=" + login + "&j_password=" + pass);
        }
        catch (AuthenticationException e) {
            response.sendError(401, "Login Failed - authentication error");
        }
        catch (UserInfoFetchException e) {
            response.sendError(502, "Login Failed - failed to fetch user info from the third party server");
        }
        catch (FailedLoginException e) {
            response.sendError(401, "Login Failed - user was not found");
        }
        catch (NamingException e) {
            response.sendError(500, e.getMessage());
        }
        catch (SQLException e) {
            response.sendError(500, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserPassword(String username) throws FailedLoginException, NamingException, SQLException {
        InitialContext ctx = new InitialContext();
        DataSource ds = (DataSource)ctx.lookup(JNDI_DATASOURCE);
        Connection conn = null;
        String password = null;
        try {
            conn = ds.getConnection();
            PreparedStatement ps = conn.prepareStatement(PASSWORD_QUERY);
            ps.setString(1, username);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                throw new FailedLoginException("invalid username");
            }
            password = rs.getString(1);
            rs.close();
        }
        finally {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        return password;
    }

    private IntegrationService getService() {
        if (integrationService == null) {
            integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        }
        return integrationService;
    }
}

