/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.web.PasswordChangeActionForm;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PasswordChangeAction
extends Action {
    private static Logger log = Logger.getLogger(PasswordChangeAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            request.getSession().removeAttribute("PasswordChangeActionForm");
            return mapping.findForward("cancelled");
        }
        ActionMessages errors = new ActionMessages();
        PasswordChangeActionForm passwordChangeForm = (PasswordChangeActionForm)form;
        if (errors.isEmpty()) {
            try {
                String loggedInUser = request.getRemoteUser();
                String login = passwordChangeForm.getLogin();
                String oldPassword = passwordChangeForm.getOldPassword();
                String password = passwordChangeForm.getPassword();
                String passwordConfirm = passwordChangeForm.getPasswordConfirm();
                if (loggedInUser == null || !loggedInUser.equals(login)) {
                    errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.authorisation"));
                } else {
                    WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServlet().getServletContext());
                    UserManagementService service = (UserManagementService)ctx.getBean("userManagementServiceTarget");
                    User user = service.getUserByLogin(login);
                    if (!user.getPassword().equals(HashUtil.sha1((String)oldPassword))) {
                        errors.add("oldPassword", new ActionMessage("error.oldpassword.mismatch"));
                        log.debug((Object)"old pass wrong");
                    }
                    if (password == null || password.length() == 0 || !password.equals(passwordConfirm)) {
                        errors.add("password", new ActionMessage("error.newpassword.mismatch"));
                        log.debug((Object)"new pass wrong");
                    }
                    if (errors.isEmpty()) {
                        user.setPassword(HashUtil.sha1((String)password));
                        user.setChangePassword(Boolean.valueOf(false));
                        service.save((Object)user);
                        IAuditService auditService = (IAuditService)ctx.getBean("auditService");
                        MessageService messageService = (MessageService)ctx.getBean("centralMessageService");
                        Object[] args = new String[]{user.getLogin() + "(" + user.getUserId() + ")"};
                        String message = messageService.getMessage("audit.user.password.change", args);
                        auditService.log("central", message);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getMessage()));
            }
        }
        if (!errors.isEmpty()) {
            this.saveMessages(request, errors);
            if (mapping.getInput() != null) {
                passwordChangeForm.reset(mapping, request);
                return mapping.findForward("errors");
            }
            return mapping.findForward("error.system");
        }
        request.setAttribute("tab", (Object)"password");
        return mapping.findForward("okay");
    }
}

