/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.ByteArrayInputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.CentralToolContentHandler;
import org.lamsfoundation.lams.util.PortraitUtils;
import org.lamsfoundation.lams.web.PortraitActionForm;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PortraitSaveAction
extends Action {
    private static Logger log = Logger.getLogger(PortraitSaveAction.class);
    private static IUserManagementService service;
    private static CentralToolContentHandler centralToolContentHandler;
    private static int THUMBNAIL_WIDTH;
    private static int THUMBNAIL_HEIGHT;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            return mapping.findForward("profile");
        }
        ActionMessages errors = new ActionMessages();
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        centralToolContentHandler = (CentralToolContentHandler)((Object)wac.getBean("centralToolContentHandler"));
        PortraitActionForm portraitForm = (PortraitActionForm)form;
        FormFile file = portraitForm.getFile();
        String fileName = file.getFileName();
        log.debug((Object)("got file: " + fileName + " of type: " + file.getContentType() + " with size: " + file.getFileSize()));
        User user = this.getService().getUserByLogin(request.getRemoteUser());
        String mediaType = file.getContentType().split("/", 2)[0];
        if (!mediaType.equals("image")) {
            errors.add("file", new ActionMessage("error.portrait.not.image"));
            this.saveErrors(request, errors);
            return mapping.findForward("errors");
        }
        String fileType = fileName.substring(fileName.lastIndexOf(46) + 1);
        log.debug((Object)("fileType: " + fileType));
        ByteArrayInputStream is = PortraitUtils.resizePicture(file.getInputStream(), THUMBNAIL_WIDTH, THUMBNAIL_HEIGHT, fileType);
        if (is == null) {
            errors.add("file", new ActionMessage("error.general.1"));
            this.saveErrors(request, errors);
            return mapping.findForward("errors");
        }
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)fileName)) {
            try {
                node = centralToolContentHandler.uploadFile(is, fileName, file.getContentType(), "ONLINE");
                is.close();
            }
            catch (Exception e) {
                request.setAttribute("errorMessage", (Object)e.getMessage());
                return mapping.findForward("error.system");
            }
        }
        log.debug((Object)("saved file with uuid: " + node.getUuid() + " and version: " + node.getVersion()));
        if (user.getPortraitUuid() != null) {
            centralToolContentHandler.deleteFile(user.getPortraitUuid());
        }
        user.setPortraitUuid(node.getUuid());
        this.getService().save((Object)user);
        return mapping.findForward("profile");
    }

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementServiceTarget");
        }
        return service;
    }

    static {
        THUMBNAIL_WIDTH = 120;
        THUMBNAIL_HEIGHT = 120;
    }
}

