/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ProfileAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(ProfileAction.class);
    private static IUserManagementService service;
    private static List<SupportedLocale> locales;

    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User requestor = this.getService().getUserByLogin(request.getRemoteUser());
        String fullName = (requestor.getTitle() != null ? requestor.getTitle() + " " : "") + requestor.getFirstName() + " " + requestor.getLastName();
        String email = requestor.getEmail();
        request.setAttribute("fullName", (Object)fullName);
        request.setAttribute("email", (Object)(email != null ? email : ""));
        request.setAttribute("portraitUuid", (Object)(requestor.getPortraitUuid() == null ? 0L : requestor.getPortraitUuid()));
        request.setAttribute("tab", (Object)"profile");
        return mapping.findForward("view");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User requestor = this.getService().getUserByLogin(request.getRemoteUser());
        log.debug((Object)("editing profile of userId: " + requestor.getUserId()));
        DynaActionForm userForm = (DynaActionForm)form;
        BeanUtils.copyProperties((Object)userForm, (Object)requestor);
        SupportedLocale locale = requestor.getLocale();
        userForm.set("localeId", (Object)locale.getLocaleId());
        request.setAttribute("locales", locales);
        request.setAttribute("tab", (Object)"profile");
        return mapping.findForward("edit");
    }

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementServiceTarget");
            locales = this.getService().findAll(SupportedLocale.class);
            Collections.sort(locales);
        }
        return service;
    }
}

