/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.CSSThemeUtil;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class CssTag
extends TagSupport {
    private static final Logger log = Logger.getLogger(CssTag.class);
    private static final String IE_STYLESHEET_NAME = "ie-styles";
    private static final String IE_STYLESHEET_NAME_RTL = "ie-styles_rtl";
    private static final String IE7_STYLESHEET_NAME = "ie7-styles";
    private static final String IE7_STYLESHEET_NAME_RTL = "ie7-styles_rtl";
    private String localLinkPath = null;
    private String style = null;
    private static final String LEARNER_STYLE = "learner";
    private static final String TABBED_STYLE = "tabbed";
    private static final String RTL_DIR = "rtl";

    public int doStartTag() throws JspException {
        HttpSession session = ((HttpServletRequest)this.pageContext.getRequest()).getSession();
        String customStylesheetLink = null;
        boolean rtl = false;
        String pageDirection = (String)session.getAttribute("page_direction");
        String serverURL = Configuration.get((String)ConfigurationKeys.SERVER_URL);
        serverURL = serverURL != null ? serverURL.trim() : null;
        try {
            JspWriter writer = this.pageContext.getOut();
            if (serverURL != null) {
                if (pageDirection != null && pageDirection.toLowerCase().equals(RTL_DIR)) {
                    rtl = true;
                }
                List themeList = CSSThemeUtil.getAllUserThemes();
                for (String theme : themeList) {
                    if (theme != null) {
                        theme = this.appendStyle(theme, rtl);
                        customStylesheetLink = this.localLinkPath != null ? this.generateLocalLink(theme) : this.generateLink(theme, serverURL);
                    }
                    if (customStylesheetLink == null) continue;
                    writer.println(customStylesheetLink);
                }
            } else {
                log.warn((Object)"CSSTag unable to write out CSS entries as the server url is missing from the configuration file.");
            }
            String ieStylesheetName = !rtl ? IE_STYLESHEET_NAME : IE_STYLESHEET_NAME_RTL;
            String ie7StylesheetName = !rtl ? IE7_STYLESHEET_NAME : IE7_STYLESHEET_NAME_RTL;
            String ieLink = this.localLinkPath != null ? this.generateLocalURL(ieStylesheetName) : this.generateURL(ieStylesheetName, serverURL);
            writer.println("<!--[if IE]>");
            writer.println("<style type=\"text/css\">");
            writer.println("@import url (" + ieLink + ");");
            writer.println("</style>");
            writer.println("<![endif]-->");
            String ie7Link = this.localLinkPath != null ? this.generateLocalURL(ie7StylesheetName) : this.generateURL(ie7StylesheetName, serverURL);
            writer.println("<!--[if IE 7]>");
            writer.println("<style type=\"text/css\">");
            writer.println("@import url (" + ie7Link + ");");
            writer.println("</style>");
            writer.println("<![endif]-->");
        }
        catch (IOException e) {
            log.error((Object)"CssTag unable to write out CSS details due to IOException.", (Throwable)e);
        }
        return 0;
    }

    private String generateLocalLink(String stylesheetName) {
        if (this.localLinkPath.endsWith("/")) {
            return "<link href=\"" + this.localLinkPath + "css/" + stylesheetName + ".css\" rel=\"stylesheet\" type=\"text/css\">";
        }
        return "<link href=\"" + this.localLinkPath + "/css/" + stylesheetName + ".css\" rel=\"stylesheet\" type=\"text/css\">";
    }

    private String appendStyle(String stylesheetName, boolean rtl) {
        String ssName = stylesheetName;
        ssName = ssName != null && (this.getStyle() == null || this.getStyle().equals(LEARNER_STYLE)) ? (!rtl ? ssName + "_" + LEARNER_STYLE : ssName + "_" + RTL_DIR + "_" + LEARNER_STYLE) : (!rtl ? ssName : ssName + "_" + RTL_DIR);
        return ssName;
    }

    private String generateLocalURL(String stylesheetName) {
        if (this.localLinkPath.endsWith("/")) {
            return "\"" + this.localLinkPath + "css/" + stylesheetName + ".css\"";
        }
        return "\"" + this.localLinkPath + "/css/" + stylesheetName + ".css\"";
    }

    private String generateLink(String stylesheetName, String serverURL) {
        if (serverURL.endsWith("/")) {
            return "<link href=\"" + serverURL + "css/" + stylesheetName + ".css\" rel=\"stylesheet\" type=\"text/css\">";
        }
        return "<link href=\"" + serverURL + "/css/" + stylesheetName + ".css\" rel=\"stylesheet\" type=\"text/css\">";
    }

    private String generateURL(String stylesheetName, String serverURL) {
        if (serverURL.endsWith("/")) {
            return "\"" + serverURL + "css/" + stylesheetName + ".css\"";
        }
        return "\"" + serverURL + "/css/" + stylesheetName + ".css\"";
    }

    public int doEndTag() {
        return 6;
    }

    public String getLocalLinkPath() {
        return this.localLinkPath;
    }

    public void setLocalLinkPath(String localLinkPath) {
        this.localLinkPath = localLinkPath;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

